/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import oracle.jdevimpl.xml.schema.diagram.AttrRow;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.Grid;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class TitledGridComponent
extends HierarchalSchemaComponent {
    private TextComponent text;
    private Grid grid;

    public TitledGridComponent(Diagram diagram, Element element, String title) {
        super(diagram, element);
        this.text = new TextComponent(diagram);
        this.text.setText(title);
        this.text.setInsets(new Insets(3, 10, 3, 10));
        this.text.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
        this.add(this.text);
        this.grid = new Grid(diagram);
        this.add(this.grid);
        this.update();
    }

    public Shape getShape() {
        int[] xpoints = new int[]{0, this.width - 6, this.width - 1, this.width - 1, 0, 0};
        int[] ypoints = new int[]{0, 0, 5, this.height - 1, this.height - 1, 0};
        return new Polygon(xpoints, ypoints, xpoints.length);
    }

    public int getPreferredWidth() {
        int width = this.text.getPreferredWidth() + 5;
        if (this.grid.getRowCount() > 0) {
            width = Math.max(width, this.grid.getPreferredWidth());
        }
        return width += this.insets.left + this.insets.right;
    }

    public int getPreferredHeight() {
        int height = this.text.getPreferredHeight() + this.insets.top + this.insets.bottom;
        if (this.grid.getRowCount() > 0) {
            height += this.grid.getPreferredHeight() + 1;
        }
        return height;
    }

    public void layout() {
        int textHeight = this.text.getPreferredHeight();
        this.text.setBounds(this.insets.left, this.insets.top, this.width - this.insets.left - this.insets.right - 5, textHeight);
        this.grid.setBounds(this.insets.left, this.insets.top + textHeight + 1, this.width - this.insets.left - this.insets.right, this.grid.getPreferredHeight());
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.grid.getRowCount() > 0) {
            int y = this.insets.top + this.text.getHeight();
            g.drawLine(0, y, this.width - 1, y);
        }
        g.drawLine(this.width - 6, 0, this.width - 6, 6);
        g.drawLine(this.width - 6, 6, this.width - 1, 6);
    }

    public void update() {
        super.update();
        if (this.text != null) {
            this.grid.removeAllRows();
            String[] atts = this.getDisplayAttributes();
            if (atts != null) {
                int i = 0;
                while (i < atts.length) {
                    Attr attr = this.element.getAttributeNodeNS(null, atts[i]);
                    if (attr != null) {
                        this.grid.addRow(new AttrRow(this.diagram, attr, true));
                    }
                    ++i;
                }
            }
        }
    }

    protected Attr getTitleAttr() {
        return null;
    }

    protected String[] getDisplayAttributes() {
        return null;
    }
}

