/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.diagram.CardinalityComponent;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.Expandable;
import oracle.jdevimpl.xml.schema.diagram.Expander;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.Hierarchal;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.Subtree;
import org.w3c.dom.Node;

public class TopLevelComponent
extends DiagramComponent
implements Hierarchal,
Expandable,
NodeListener {
    private HierarchalSchemaComponent schemaComponent;
    private Expander expander;
    private CardinalityComponent cardinality;
    private int minOccurs;
    private int maxOccurs;

    public TopLevelComponent(Diagram diagram, HierarchalSchemaComponent schemaComponent) {
        super(diagram);
        this.expander = new Expander(diagram, this);
        this.add(this.expander);
        this.cardinality = new CardinalityComponent(diagram);
        this.cardinality.setInsets(new Insets(0, 0, 0, 3));
        this.add(this.cardinality);
        this.schemaComponent = schemaComponent;
        this.add(schemaComponent);
        diagram.getView().addNodeListener(schemaComponent.getDomElement(), this);
        this.update();
    }

    public void destroy() {
        super.destroy();
        this.diagram.getView().removeNodeListener(this.schemaComponent.getDomElement(), this);
    }

    public void nodeChanged(Node node) {
        this.update();
    }

    public void referenceChanged(Node node) {
        this.update();
    }

    public void update() {
        boolean canExpand = this.isExpandable();
        if (canExpand != this.expander.isVisible()) {
            this.expander.setVisible(canExpand);
            this.invalidate();
        }
        String min = ModelUtils.getAttribute(this.schemaComponent.getDomElement(), "minOccurs");
        int oldMinOccurs = this.minOccurs;
        try {
            this.minOccurs = Integer.parseInt(min);
        }
        catch (NumberFormatException nfe) {
            this.minOccurs = 1;
        }
        this.cardinality.setMinimum(this.minOccurs);
        if (this.minOccurs == 0) {
            this.schemaComponent.setStroke(GraphicsUtils.getOptionalStroke());
        } else {
            this.schemaComponent.setStroke(null);
        }
        if (this.minOccurs != oldMinOccurs) {
            this.invalidate();
            if (this.parent != null) {
                if (this.parent.getParent() != null) {
                    this.parent.getParent().repaint();
                } else {
                    this.parent.repaint();
                }
            } else {
                this.repaint();
            }
        }
        String max = ModelUtils.getAttribute(this.schemaComponent.getDomElement(), "maxOccurs");
        int oldMaxOccurs = this.maxOccurs;
        if ("unbounded".equals(max)) {
            this.maxOccurs = -1;
        } else {
            try {
                this.maxOccurs = Integer.parseInt(max);
            }
            catch (NumberFormatException nfe) {
                this.maxOccurs = 1;
            }
        }
        this.cardinality.setMaximum(this.maxOccurs);
        if (this.maxOccurs != oldMaxOccurs) {
            this.invalidate();
        }
    }

    public Stroke getStroke() {
        return this.schemaComponent.getStroke();
    }

    public Subtree getTree() {
        return (Subtree)this.getParent();
    }

    public HierarchalSchemaComponent getComponent() {
        return this.schemaComponent;
    }

    public int getPreferredWidth() {
        int width = this.schemaComponent.getPreferredWidth() + this.cardinality.getPreferredWidth();
        width = this.expander.isVisible() ? (width += this.expander.getPreferredWidth()) : (width += 5);
        if (this.maxOccurs > 1 || this.maxOccurs == -1) {
            width += 3;
        }
        return width;
    }

    public int getPreferredHeight() {
        int height = this.schemaComponent.getPreferredHeight() + 5;
        if (this.expander.isVisible()) {
            height = Math.max(height, this.expander.getPreferredHeight());
        }
        if (this.maxOccurs > 1 || this.maxOccurs == -1) {
            height += 3;
        }
        int yOffset = this.schemaComponent.getParentConnectionYOffset();
        height = Math.max(height, yOffset + this.cardinality.getPreferredHeight());
        return height;
    }

    public void layout() {
        this.schemaComponent.setBounds(this.cardinality.getPreferredWidth(), 0, this.schemaComponent.getPreferredWidth(), this.schemaComponent.getPreferredHeight());
        this.expander.setBounds(this.cardinality.getPreferredWidth() + this.schemaComponent.getWidth() - this.expander.getPreferredWidth() / 2, (this.schemaComponent.getHeight() - this.expander.getPreferredHeight()) / 2, this.expander.getPreferredWidth(), this.expander.getPreferredHeight());
        this.cardinality.setBounds(0, this.schemaComponent.getParentConnectionYOffset(), this.cardinality.getPreferredWidth(), this.cardinality.getPreferredHeight());
    }

    public void paintComponent(Graphics g) {
        Shape shape = this.schemaComponent.getShape();
        Graphics2D graphics = (Graphics2D)g;
        graphics.translate(this.schemaComponent.getX(), this.schemaComponent.getY());
        if (this.maxOccurs > 1 || this.maxOccurs == -1) {
            graphics.translate(3, 3);
            GraphicsUtils.drawDropShadow(g, shape);
            this.schemaComponent.paint(g);
            graphics.translate(-3, -3);
        } else {
            GraphicsUtils.drawDropShadow(g, shape);
        }
        graphics.translate(-this.schemaComponent.getX(), -this.schemaComponent.getY());
    }

    public int getParentConnectionXOffset() {
        return this.schemaComponent.getX() + this.schemaComponent.getParentConnectionXOffset();
    }

    public int getParentConnectionYOffset() {
        return this.schemaComponent.getY() + this.schemaComponent.getParentConnectionYOffset();
    }

    public int getChildConnectionXOffset() {
        if (this.expander.isVisible()) {
            return this.cardinality.getPreferredWidth() + this.schemaComponent.getPreferredWidth() + this.expander.getPreferredWidth() / 2;
        }
        int offset = this.schemaComponent.getX() + this.schemaComponent.getChildConnectionXOffset();
        if (this.maxOccurs > 1 || this.maxOccurs == -1) {
            offset += 3;
        }
        return offset;
    }

    public int getChildConnectionYOffset() {
        if (this.expander.isVisible()) {
            return this.schemaComponent.getPreferredHeight() / 2;
        }
        return this.schemaComponent.getY() + this.schemaComponent.getChildConnectionYOffset();
    }

    public boolean isExpanded() {
        return this.getTree().isExpanded();
    }

    public void setExpanded(boolean expanded) {
        this.getTree().setExpanded(expanded);
    }

    private boolean isExpandable() {
        if (!this.schemaComponent.isExpandable()) {
            return false;
        }
        return ModelUtils.hasContent(this.diagram.getGui().getView(), this.schemaComponent.getDomElement());
    }

    public Shape getDomPositionShape(DiagramComponent component, int relativePosition) {
        return this.getTree().getDomPositionShape(component, relativePosition);
    }

    public DomPosition getDomPosition(Point p) {
        DomPosition position = super.getDomPosition(p);
        if (position == null) {
            position = this.diagram.getRootComponent() == this.schemaComponent ? DomPositionFactory.createDomPosition((Node)this.schemaComponent.getDomElement(), (int)0) : DomPositionFactory.createDomPosition((Node)this.schemaComponent.getDomElement(), (int)2);
        }
        return position;
    }
}

