/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.util.List;
import oracle.jdevimpl.xml.schema.ProxyAttr;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class TypeEditor
extends ListComponent {
    private Element owner;
    private Attr attr;
    private int type;

    public TypeEditor(Diagram diagram, Element owner, int type) {
        this(diagram, (Attr)null, type);
        this.owner = owner;
    }

    public TypeEditor(Diagram diagram, Attr attr, int type) {
        super(diagram);
        this.type = type;
        if (attr != null) {
            this.owner = attr.getOwnerElement();
        }
        this.setAttr(attr);
    }

    public int getPreferredWidth() {
        if (this.attr != null) {
            return super.getPreferredWidth();
        }
        return 0;
    }

    public int getPreferredHeight() {
        if (this.attr != null) {
            return super.getPreferredHeight();
        }
        return 0;
    }

    public void setReference(ReferenceNode reference) {
        this.setForeground(null);
        if (reference != null) {
            if (reference.getReferee() == null && !reference.getReference().isBuiltInType()) {
                this.setForeground(GraphicsUtils.UNRESOLVED_REFERENCE_COLOR);
            }
            this.setAttr(reference.getReference().getAttr());
        } else {
            this.setAttr(null);
        }
    }

    public void setAttr(Attr attr) {
        this.attr = attr;
        if (attr != null) {
            this.setText(attr.getValue());
        } else {
            this.setText(null);
        }
    }

    public Attr getAttr() {
        return this.attr;
    }

    protected void startEditing() {
        List list = this.diagram.getView().getGlobals(this.owner, this.type);
        this.setItems(list.toArray(new String[0]));
        if (!(this.attr instanceof ProxyAttr) || !((ProxyAttr)this.attr).isExternal()) {
            super.startEditing();
        }
    }

    protected void cancelEditing() {
        super.cancelEditing();
        if (this.attr != null) {
            String value = this.attr.getValue();
            if (value.trim().length() == 0) {
                this.setAttr(null);
            } else {
                this.setText(value);
                this.invalidate();
                this.diagram.revalidate();
                this.fireTextChanged();
            }
        }
    }
}

