/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Window;
import oracle.bali.xml.model.XmlCommitException;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.FacetContainer;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ListChangeListener;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import oracle.jdevimpl.xml.schema.diagram.TypeEditor;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class Union
extends HierarchalSchemaComponent
implements ListChangeListener {
    private TextComponent label;
    private TypeEditor type;
    private FacetContainer facets;
    private static final Color COLOR = new Color(255, 255, 128);

    public Union(Diagram diagram, Element element) {
        super(diagram, element);
        this.setBackground(COLOR);
        this.setForeground(Color.BLACK);
        this.label = new TextComponent(diagram);
        this.label.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
        this.label.setText("<union>");
        this.label.setInsets(new Insets(3, 5, 0, 5));
        this.add(this.label);
        this.type = new TypeEditor(diagram, element, 3);
        this.type.setInsets(new Insets(0, 10, 3, 10));
        this.type.addListChangeListener(this);
        this.add(this.type);
        this.facets = new FacetContainer(diagram, element);
        this.add(this.facets);
        this.update();
    }

    public void destroy() {
        super.destroy();
        this.type.removeListChangeListener(this);
    }

    public int getPreferredWidth() {
        int w = Math.max(this.label.getPreferredWidth() + 10, this.type.getPreferredWidth());
        w = Math.max(w, this.facets.getPreferredWidth());
        return this.insets.left + w + this.insets.right;
    }

    public int getPreferredHeight() {
        int typeHeight = this.type.getPreferredHeight();
        if (typeHeight == 0) {
            typeHeight = 2;
        }
        int facetHeight = this.facets.getPreferredHeight();
        return this.insets.top + this.label.getPreferredHeight() + typeHeight + facetHeight + (facetHeight > 0 ? 1 : 0) + this.insets.bottom;
    }

    public void layout() {
        int w = this.width - this.insets.left - this.insets.right;
        int y = this.insets.top;
        this.label.setBounds(this.insets.left + 5, y, w - 10, this.label.getPreferredHeight());
        this.type.setBounds(this.insets.left, y += this.label.getHeight(), w, this.type.getPreferredHeight());
        y += this.type.getHeight();
        if (this.type.getHeight() == 0) {
            y += 2;
        }
        if (this.facets.getPreferredHeight() > 0) {
            ++y;
        }
        this.facets.setBounds(this.insets.left, y, w, this.facets.getPreferredHeight());
    }

    public Shape getShape() {
        int width = this.getWidth();
        int height = this.getHeight();
        int[] xpoints = new int[]{0, 1, 1, 2, 3, 4, 5, 6, width - 7, width - 6, width - 5, width - 4, width - 3, width - 2, width - 2, width - 1, width - 1, 0, 0};
        int[] ypoints = new int[]{6, 5, 4, 3, 2, 1, 1, 0, 0, 1, 1, 2, 3, 4, 5, 6, height - 1, height - 1, 6};
        return new Polygon(xpoints, ypoints, xpoints.length);
    }

    public void update() {
    }

    public void valueChanged(ListComponent component) {
        if (component == this.type) {
            this.handleTypeChange();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    private void handleTypeChange() {
        String value = this.type.getText().trim();
        if (value.length() == 0) {
            this.removeType();
        } else {
            this.setType(value);
        }
    }

    private void removeType() {
        Attr attr = this.type.getAttr();
        Element owner = attr.getOwnerElement();
        if (owner != null) {
            this.diagram.getModel().startTransaction(XmlSchemaArb.getString(28));
            try {
                owner.removeAttributeNode(attr);
                if (owner != this.element) {
                    ModelUtils.removePath(this.element, owner);
                }
                this.diagram.getModel().commitTransaction();
            }
            catch (XmlCommitException xce) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
            }
            catch (ThreadDeath td) {
                this.diagram.getModel().rollbackTransaction();
                throw td;
            }
            catch (Throwable t) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)t);
            }
        } else {
            this.type.setAttr(null);
        }
    }

    private void setType(String type) {
        this.diagram.getModel().startTransaction(XmlSchemaArb.getString(28));
        try {
            Attr attr = this.type.getAttr();
            Element owner = attr.getOwnerElement();
            if (owner != null) {
                attr.setValue(type);
            } else {
                this.element.setAttributeNS(null, "type", type);
            }
            this.diagram.getModel().commitTransaction();
        }
        catch (XmlCommitException xce) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xce));
        }
        catch (ThreadDeath td) {
            this.diagram.getModel().rollbackTransaction();
            throw td;
        }
        catch (Throwable t) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)t);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.facets.getHeight() > 0) {
            int y = this.insets.top + this.label.getHeight() + this.type.getHeight();
            if (this.type.getHeight() == 0) {
                y += 2;
            }
            g.drawLine(this.insets.left, y, this.width - 1, y);
        }
    }
}

