/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.Subtree;
import oracle.jdevimpl.xml.schema.diagram.TopLevelComponent;

public class VerticalTree
extends Subtree {
    private static final int INDENT = 15;

    public VerticalTree(Diagram diagram, HierarchalSchemaComponent root) {
        super(diagram, new TopLevelComponent(diagram, root));
    }

    public void layout() {
        if (this.layoutWidth == -1) {
            this.computeSizes();
        }
        this.root.setBounds(this.insets.top, this.insets.left, this.root.getPreferredWidth(), this.root.getPreferredHeight());
        if (this.expanded && this.subtrees.length > 0) {
            int x = this.insets.left + this.root.getChildConnectionXOffset() + 15;
            int y = this.insets.top + this.root.getHeight() + 5;
            int i = 0;
            while (i < this.subtrees.length) {
                this.subtrees[i].setBounds(x, y, this.subtrees[i].getPreferredWidth(), this.subtrees[i].getPreferredHeight());
                y += this.subtrees[i].getHeight() + 5;
                ++i;
            }
        }
    }

    protected void computeSizes() {
        this.layoutWidth = this.insets.left + this.root.getPreferredWidth() + this.insets.right;
        this.layoutHeight = this.insets.top + this.root.getPreferredHeight() + this.insets.bottom;
        if (this.expanded && this.subtrees.length > 0) {
            int maxSubtreeWidth = 0;
            int i = 0;
            while (i < this.subtrees.length) {
                this.layoutHeight += this.subtrees[i].getPreferredHeight();
                maxSubtreeWidth = Math.max(maxSubtreeWidth, this.subtrees[i].getPreferredWidth());
                ++i;
            }
            this.layoutHeight += 5 * this.subtrees.length;
            this.layoutWidth = Math.max(this.layoutWidth, this.root.getX() + this.root.getChildConnectionXOffset() + 15 + maxSubtreeWidth + this.insets.right);
        }
    }

    protected void paintEdges(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        int x = this.root.getX() + this.root.getChildConnectionXOffset();
        int y = this.root.getY() + this.root.getChildConnectionYOffset();
        int i = 0;
        while (i < this.subtrees.length) {
            Subtree subtree = this.subtrees[i];
            Stroke stroke = subtree.getRoot().getStroke();
            Stroke originalStroke = null;
            if (stroke != null) {
                originalStroke = graphics.getStroke();
                graphics.setStroke(stroke);
            }
            int x1 = x;
            int y1 = y;
            int x2 = x1;
            int y2 = subtree.getY() + subtree.getConnectionYOffset();
            g.drawLine(x1, y1, x2, y2);
            y1 = y2;
            x2 = subtree.getX() + subtree.getConnectionXOffset();
            g.drawLine(x1, y1, x2, y2);
            if (originalStroke != null) {
                graphics.setStroke(originalStroke);
            }
            ++i;
        }
    }
}

