/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.wizard;

import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XmlSchemaWizardModel
extends FileBuilderModel {
    private static final String EXTENSION = ".xsd";
    private static final String TARGET_NAMESPACE = "http://www.example.org";
    private static final String SCHEMA_PREFIX = "xsd";
    private Project project;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XmlSchemaWizardModel(Context context) {
        super(context, EXTENSION);
        this.project = context.getProject();
    }

    public String getFileType() {
        return XmlSchemaArb.getString(40);
    }

    public String getBuilderType() {
        return "XML Schema";
    }

    protected String getBaseName() {
        return "untitled";
    }

    protected boolean buildFile(Node node) {
        if (super.buildFile(node)) {
            this.writeSchema(node);
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = XmlSchemaWizardModel.class.desiredAssertionStatus() ^ true;
    }

    private void writeSchema(Node node) {
        if (!$assertionsDisabled && !(node instanceof XMLSourceNode)) {
            throw new AssertionError();
        }
        XmlModel model = ((XMLSourceNode)node).getModel(this.project);
        model.getDomModel().setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, IdeUtil.getIdeIanaEncoding(), null));
        try {
            model.startTransaction("New XML Schema");
            Document document = model.getDocument();
            Element schema = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
            schema.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            schema.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", TARGET_NAMESPACE);
            schema.setAttributeNS(null, "targetNamespace", TARGET_NAMESPACE);
            schema.setAttributeNS(null, "elementFormDefault", "qualified");
            Element element = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
            element.setAttributeNS(null, "name", XmlSchemaArb.getString(16));
            Element annotation = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:annotation");
            Element documentation = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:documentation");
            Text text = document.createTextNode(XmlSchemaArb.getString(33));
            documentation.appendChild(text);
            annotation.appendChild(documentation);
            element.appendChild(annotation);
            schema.appendChild(element);
            document.appendChild(schema);
        }
        finally {
            try {
                model.commitTransaction();
            }
            catch (XmlCommitException xce) {
                model.rollbackTransaction();
            }
            CommandProcessor.getInstance().flush((Object)node);
        }
    }
}

