/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xdk.xpath;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.log.LogManager;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.jdevimpl.xml.xdk.NameSpaceResolver;
import oracle.jdevimpl.xml.xdk.XdkExtensionsArb;
import oracle.jdevimpl.xml.xdk.xpath.XPathPanel;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.NodeList;

public final class XPath
implements Addin,
Controller {
    public static final int XML_GREP_CMD_ID = Ide.findOrCreateCmdID((String)"xml.XML_GREP_CMD_ID");
    XPathPanel xpathPanel;
    protected static IdeAction eiAction;

    private void $init$() {
        this.xpathPanel = null;
    }

    public XPath() {
        this.$init$();
    }

    public Controller supervisor() {
        return null;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        String msg;
        block28: {
            int cmdId = action.getCommandId();
            msg = "";
            if (cmdId == XML_GREP_CMD_ID) {
                Editor editor;
                Element element;
                Element element2 = element = context == null ? null : context.getElement();
                if ((element == null || !(element instanceof XMLSourceNode)) && (editor = EditorManager.getEditorManager().getCurrentEditor()) != null && editor.getContext().getNode() instanceof XMLSourceNode) {
                    element = (XMLSourceNode)editor.getContext().getNode();
                }
                if (element != null && element instanceof XMLSourceNode) {
                    XMLSourceNode node = (XMLSourceNode)element;
                    try {
                        Project project = context.getProject();
                        JDevXmlContext xmlContext = node.getXmlContext(project);
                        XmlModel model = xmlContext.getSourceModel();
                        XMLDocument doc = null;
                        if (model != null) {
                            model.acquireReadLock();
                            doc = (XMLDocument)model.getDocument();
                        } else {
                            Reader nr = null;
                            nr = node.getReader();
                            DOMParser parser = new DOMParser();
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            PrintWriter pw = new PrintWriter(baos);
                            parser.setDoctype(new DTD());
                            parser.parse(nr);
                            doc = parser.getDocument();
                        }
                        try {
                            try {
                                if (this.xpathPanel == null) {
                                    this.xpathPanel = new XPathPanel();
                                }
                                JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this.xpathPanel, null, (String)(XdkExtensionsArb.getString(25) + element.getShortLabel()));
                                dlg.setDefaultButton(1);
                                dlg.setOKButtonEnabled(true);
                                String topic = "f1_xmlxpathexpression_html";
                                HelpSystem.getHelpSystem().registerTopic((JComponent)dlg.getContent(), topic);
                                boolean go = WizardLauncher.runDialog((JDialog)dlg);
                                if (go) {
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    PrintWriter pw = new PrintWriter(baos);
                                    String xpath = this.xpathPanel.getXpathFld().getText();
                                    String[] nsuri = this.xpathPanel.getNsURI();
                                    String[] nsprefix = this.xpathPanel.getNsPrefix();
                                    msg = msg + XdkExtensionsArb.getString(4);
                                    String str = XdkExtensionsArb.getString(35);
                                    MessageFormat mf = new MessageFormat(str);
                                    Object[] args = new Object[]{xpath, node.getLongLabel()};
                                    msg = msg + " " + mf.format(args);
                                    if (nsuri != null) {
                                        mf = new MessageFormat(XdkExtensionsArb.getString(53));
                                        int i = 0;
                                        while (i < nsuri.length) {
                                            if (nsuri[i].trim().length() > 0) {
                                                args = new String[]{nsuri[i], nsprefix[i]};
                                                msg = msg + " " + mf.format(args);
                                            }
                                            ++i;
                                        }
                                    }
                                    try {
                                        if (xpath.equals("/")) {
                                            doc.print(pw);
                                            msg = msg + baos.toString();
                                            break block28;
                                        }
                                        NameSpaceResolver nsr = null;
                                        NodeList nodeList = null;
                                        long before = System.currentTimeMillis();
                                        if (nsuri != null && nsuri.length > 0) {
                                            nsr = new NameSpaceResolver();
                                            nsr.addNamespacePrefix(nsprefix, nsuri);
                                            nodeList = doc.selectNodes(xpath, (NSResolver)nsr);
                                        } else {
                                            nodeList = doc.selectNodes(xpath);
                                        }
                                        long after = System.currentTimeMillis();
                                        mf = new MessageFormat(XdkExtensionsArb.getString(17));
                                        args = new String[]{Integer.toString(nodeList.getLength()), Long.toString(after - before)};
                                        String elapsed = mf.format(args);
                                        if (nodeList.getLength() > 0) {
                                            int i = 0;
                                            while (i < nodeList.getLength()) {
                                                XMLNode elmt = (XMLNode)nodeList.item(i);
                                                baos.reset();
                                                elmt.print(pw);
                                                short nodeType = elmt.getNodeType();
                                                String eol = "";
                                                if (nodeType == 2 || nodeType == 3 || nodeType == 4) {
                                                    eol = "\n";
                                                }
                                                msg = msg + "  " + baos.toString() + eol;
                                                ++i;
                                            }
                                        }
                                        msg = msg + " " + elapsed;
                                    }
                                    catch (XSLException xsle) {
                                        JOptionPane.showMessageDialog(null, xsle.toString(), "XPath Exception", 0);
                                        msg = msg + " " + xsle.toString();
                                    }
                                    break block28;
                                }
                                msg = "";
                            }
                            catch (Exception exc) {
                                JOptionPane.showMessageDialog(null, exc.toString(), "Exception - 1", 0);
                                msg = msg + " " + exc.toString();
                            }
                        }
                        finally {
                            if (model != null) {
                                model.releaseReadLock();
                            }
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, e.toString(), "Exception - 2", 0);
                        msg = msg + " " + e.toString();
                    }
                } else {
                    msg = "No xml document currently selected";
                    msg = element != null ? msg + "\nCurrently selected Element is a " + element.getClass().getName() : msg + "\nElement is null";
                }
            }
        }
        if (msg.trim().length() > 0) {
            XPath.logMessage(msg);
        }
        return true;
    }

    private static final void logMessage(String msg) {
        LogManager.getLogManager().showLog();
        LogManager.getLogManager().getMsgPage().log((Object)(msg + "\n"));
    }

    static boolean enableXPath(Context context) {
        Editor editor;
        boolean bEnable;
        Element element = context != null ? context.getElement() : null;
        boolean bl = bEnable = element != null;
        if (bEnable) {
            bEnable = element instanceof XMLSourceNode;
        }
        if (!bEnable && (editor = EditorManager.getEditorManager().getCurrentEditor()) != null && editor.getContext().getNode() instanceof XMLSourceNode) {
            bEnable = true;
        }
        return bEnable;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == XML_GREP_CMD_ID) {
            action.setEnabled(XPath.enableXPath(context));
            return true;
        }
        return false;
    }

    public void initialize() {
        XPath ctrlr = this;
        JMenuItem mi = XPath.doCreateMenuItem(ctrlr, XdkExtensionsArb.getString(0), new Integer(88));
        JMenu mainMenu = MenuManager.getJMenu((String)"Search");
        mainMenu.add(mi);
    }

    private static JMenuItem doCreateMenuItem(Controller ctrlr, String menuLabel, Integer mnemonic) {
        eiAction = IdeAction.get((int)XML_GREP_CMD_ID, null, (String)menuLabel, null, (Integer)mnemonic, null, null, (boolean)true);
        eiAction.addController(ctrlr);
        JMenuItem menuItem = Ide.getMenubar().createMenuItem((ToggleAction)eiAction);
        return menuItem;
    }
}

