/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.editor.language;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.LexerBlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.parser.Lexer;
import oracle.jdevimpl.xml.xquery.editor.language.XQueryXMLRenderer;
import oracle.jdevimpl.xml.xquery.lexer.XQueryLexer;
import oracle.jdevimpl.xml.xquery.lexer.XQueryTokens;

public class XQueryBlockRenderer
extends LexerBlockRenderer
implements XQueryTokens {
    private XQueryXMLRenderer xmlRenderer;

    public XQueryBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this.xmlRenderer = new XQueryXMLRenderer(textBuffer);
    }

    protected Lexer createLexer() {
        return new XQueryLexer();
    }

    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        switch (token) {
            case 28: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.xmlRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
                break;
            }
        }
    }

    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 40: {
                return "xquery-comment-style";
            }
            case 41: {
                return "xquery-variable-style";
            }
            case 30: {
                return "xquery-string-style";
            }
            case 31: 
            case 32: 
            case 33: {
                return "xquery-number-style";
            }
            case 53: 
            case 54: 
            case 57: 
            case 63: 
            case 64: 
            case 66: {
                return "xquery-brace-style";
            }
        }
        if (45 <= token && token < 69) {
            return "xquery-operator-style";
        }
        if (70 <= token && token < 153) {
            return "xquery-keyword-style";
        }
        return this.getDefaultStyleName();
    }
}

