/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.runner;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.XMLItem;
import oracle.xml.xqxp.datamodel.XMLSequence;
import oracle.xquery.Configuration;
import oracle.xquery.PreparedXQuery;
import oracle.xquery.XQException;
import oracle.xquery.XQueryContext;

public class XQueryRunner {
    public static void main(String[] args) {
        try {
            FileReader reader = new FileReader(args[0]);
            XQueryContext context = new XQueryContext();
            File base = new File(args[0]).getAbsoluteFile().getParentFile();
            Configuration config = new Configuration();
            config.setBaseURI(base.toURI().toString());
            PreparedXQuery query = context.prepareXQuery((Reader)reader, config);
            XMLSequence result = query.executeQuery();
            while (result.next()) {
                XMLItem item = result.getCurrentItem();
                String output = XQueryRunner.getOutputString(item);
                if (output == null) continue;
                System.out.println(output);
            }
        }
        catch (XQException xqe) {
            System.err.println(xqe.getLocalizedMessage());
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static String getOutputString(XMLItem item) {
        XMLNode node;
        if (item.instanceOfType(99) && (node = item.getNode()) != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                node.print((OutputStream)out);
                String string = new String(out.toByteArray());
                return string;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return item.getLexicalValue();
    }
}

