/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.runner;

import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import oracle.ide.Ide;
import oracle.ide.log.LogPage;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.TextBufferStreamFactory;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdevimpl.xml.xquery.runner.XQueryRunner;
import oracle.xml.xqxp.datamodel.XMLSequence;
import oracle.xquery.Configuration;
import oracle.xquery.PreparedXQuery;
import oracle.xquery.XQException;
import oracle.xquery.XQueryContext;

public class XQueryStarter
extends JStarter {
    private Node target;
    private Thread xqueryThread;
    private LogPage logPage;
    private static final boolean PREVIEW_MODE = Boolean.getBoolean("xquery.preview.mode");

    public XQueryStarter(JRunProcess runProcess, Node target) {
        super(runProcess, new String[]{XQueryRunner.class.getName(), URLFileSystem.getPlatformPathName((URL)target.getURL())});
        this.target = target;
    }

    public boolean start() {
        if (PREVIEW_MODE) {
            this.logPage = this.runProcess.getLogPage();
            this.xqueryThread = new 1("XQuery");
            this.xqueryThread.start();
            return true;
        }
        return super.start();
    }

    public int waitForProcess() {
        if (PREVIEW_MODE) {
            try {
                this.xqueryThread.join();
            }
            catch (InterruptedException ie) {
                this.terminate();
            }
            Integer exitCode = this.getExitCode();
            return exitCode != null ? exitCode : -1;
        }
        return super.waitForProcess();
    }

    public File getStartDirectory() {
        URL targetDir;
        File startDir = super.getStartDirectory();
        if (startDir == null && (targetDir = URLFileSystem.getParent((URL)this.target.getURL())) != null) {
            startDir = new File(targetDir.getPath());
        }
        return startDir;
    }

    protected String getClassPath() {
        StringBuffer buffer = new StringBuffer();
        File libDir = new File(Ide.getOracleHomeDirectory(), "lib");
        File xqueryJar = new File(libDir, "xquery.jar");
        buffer.append(xqueryJar);
        buffer.append(File.pathSeparator);
        File xmlParserJar = new File(libDir, "xmlparserv2.jar");
        buffer.append(xmlParserJar);
        buffer.append(File.pathSeparator);
        File jdevJar = new File(Ide.getLibDirectory(), "jdev.jar");
        buffer.append(jdevJar);
        buffer.append(File.pathSeparator);
        File jlibDir = new File(Ide.getOracleHomeDirectory(), "jlib");
        File orai18nJar = new File(jlibDir, "orai18n-collation.jar");
        buffer.append(orai18nJar);
        return buffer.toString();
    }

    protected void addJavaOptions(List list) {
        super.addJavaOptions(list);
        list.add("-Xverify:none");
    }

    private void runXQuery() {
        try {
            Reader reader = this.getReader();
            XQueryContext context = new XQueryContext();
            Configuration config = new Configuration();
            config.setBaseURI(URLFileSystem.getParent((URL)this.target.getURL()).toString());
            PreparedXQuery query = context.prepareXQuery(reader, config);
            XMLSequence result = query.executeQuery();
            while (result.next()) {
                String output = XQueryRunner.getOutputString(result.getCurrentItem());
                if (output == null) continue;
                StyledMessage message = new StyledMessage((AttributeSet)RunProcess.getSystemOutAttributeSet(), output + "\n");
                this.logPage.log((Object)message);
            }
        }
        catch (XQException xqe) {
            StyledMessage message = new StyledMessage((AttributeSet)RunProcess.getSystemErrAttributeSet(), xqe.getLocalizedMessage() + "\n");
            this.logPage.log((Object)message);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
        }
    }

    private Reader getReader() throws FileNotFoundException {
        InputStreamReader reader = null;
        if (this.target instanceof TextNode) {
            TextNode textNode = (TextNode)this.target;
            TextBuffer buffer = textNode.acquireTextBuffer();
            try {
                InputStream in = TextBufferStreamFactory.getInputStream((TextBuffer)buffer);
                reader = new InputStreamReader(in);
            }
            finally {
                textNode.releaseTextBuffer();
            }
        }
        if (reader == null) {
            URL url = this.target.getURL();
            String path = URLFileSystem.getPlatformPathName((URL)url);
            reader = new FileReader(path);
        }
        return reader;
    }

    static void mav$runXQuery(XQueryStarter xQueryStarter) {
        xQueryStarter.runXQuery();
    }

    static RunProcess ra$runProcess(XQueryStarter xQueryStarter) {
        return xQueryStarter.runProcess;
    }

    final class oracle.jdevimpl.xml.xquery.runner.XQueryStarter$1
    extends Thread {
        public void run() {
            XQueryStarter.mav$runXQuery(XQueryStarter.this);
            SwingUtilities.invokeLater(new 1());
        }

        public oracle.jdevimpl.xml.xquery.runner.XQueryStarter$1(String string) {
            super(string);
        }

        final class 1
        implements Runnable {
            public void run() {
                XQueryStarter.ra$runProcess(XQueryStarter.this).finished();
                XQueryStarter.this.finished();
            }
        }
    }
}

