/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xsl;

import java.io.File;
import java.net.URL;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.proxy.GrammarProviderProxy;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.ide.Ide;
import oracle.ide.model.ElementAttributes;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.runner.Browseable;
import oracle.jdevimpl.xml.xsl.XSLCompletionInsightProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSLSourceNode
extends XMLSourceNode
implements Browseable {
    private String _XSLVersion;
    private SchemaGrammarProvider _sgpFor10;
    private SchemaGrammarProvider _sgpFor20;
    private GrammarProviderProxy _gpp;

    public XSLSourceNode() {
        this.getAttributes().set(ElementAttributes.BUILDABLE);
        this._XSLVersion = "1.0";
        this._sgpFor10 = null;
        this._sgpFor20 = null;
        this._gpp = null;
    }

    public XSLSourceNode(URL url) {
        this.getAttributes().set(ElementAttributes.BUILDABLE);
        this.setURL(url);
        this._XSLVersion = "1.0";
        this._sgpFor10 = null;
        this._sgpFor20 = null;
        this._gpp = null;
    }

    public XMLCompletionInsightProvider createInsightProvider(JDevXmlContext xmlContext) {
        DocumentScannerFactory factory = this.getDocumentScannerFactory(xmlContext.createContext(), xmlContext);
        return new XSLCompletionInsightProvider((XmlContext)xmlContext, factory);
    }

    public GrammarProvider createGrammarProvider(JDevXmlContext context) {
        if (this._gpp == null) {
            try {
                GrammarProvider base = super.createGrammarProvider(context);
                URL SchemaURL = this.getSchemaURL("2.0");
                if (URLFileSystem.exists((URL)SchemaURL)) {
                    this._sgpFor20 = new SchemaGrammarProvider(base);
                    this._sgpFor20.addSchema(SchemaURL);
                }
                this._sgpFor10 = new SchemaGrammarProvider(base);
                this._sgpFor10.addSchema(this.getSchemaURL("1.0"));
                this._gpp = new GrammarProviderProxy((GrammarProvider)this._sgpFor10);
            }
            catch (GrammarException e) {
                // empty catch block
            }
        }
        return this._gpp;
    }

    private URL getSchemaURL(String XSLVersion) {
        String SchemaFileName = "xslt/xslt.xsd";
        if (XSLVersion.equals("2.0")) {
            SchemaFileName = "xslt/xslt20.xsd";
        }
        File oraclehome = new File(Ide.getOracleHomeDirectory());
        File jlib = new File(oraclehome, "jlib");
        String zipFile = "schemas.zip";
        File f = new File(jlib, zipFile);
        URL url = URLFactory.newJarURL((File)f, (String)SchemaFileName);
        return url;
    }

    private void registerSchema(String newXSLVersion) {
        SchemaGrammarProvider sgp = this._sgpFor10;
        if (newXSLVersion.equals("2.0")) {
            sgp = this._sgpFor20;
        } else {
            newXSLVersion = "1.0";
        }
        if (!newXSLVersion.equals(this._XSLVersion) && this._gpp != null && sgp != null) {
            this._XSLVersion = newXSLVersion;
            this._gpp.changeUnderlyingGrammarProvider((GrammarProvider)sgp);
        }
    }

    protected XmlModel createXmlModel(JDevXmlContext context, MetadataProvider metaDataProvider) {
        XmlModel CurrentModel = new XmlModel(metaDataProvider);
        CurrentModel.addModelListener((XmlModelListener)new XSLModelListener(null));
        return CurrentModel;
    }

    static void mav$registerSchema(XSLSourceNode xSLSourceNode, String string) {
        xSLSourceNode.registerSchema(string);
    }

    private class XSLModelListener
    extends XmlModelAdapter {
        public void modelChanged(XmlModelEvent XmlModelEvent2) {
            String NewXSLVersion;
            Element element;
            Document doc;
            if (XmlModelEvent2.isDomTreeChanged() && (doc = XmlModelEvent2.getModel().getDocument()) != null && (element = doc.getDocumentElement()) != null && (NewXSLVersion = element.getAttribute("version")) != null) {
                XSLSourceNode.mav$registerSchema(XSLSourceNode.this, NewXSLVersion);
            }
        }

        public void listenerAttached(XmlModelEvent XmlModelEvent2) {
            this.modelChanged(XmlModelEvent2);
        }

        public void listenerDetached(XmlModelEvent XmlModelEvent2) {
            this.modelChanged(XmlModelEvent2);
        }

        private XSLModelListener() {
        }

        XSLModelListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

