/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.profiler;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.profiler.PLSQLController;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.navigator.NavigatorManager;
import oracle.javatools.db.Database;
import oracle.jdeveloper.JDeveloperMenuConstants;

public class PLSQLContextMenu
implements ContextMenuListener {
    private PLSQLController _controller = PLSQLController.getInstance();

    public PLSQLContextMenu() {
        this.initializeListeners();
    }

    private void initializeListeners() {
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)this);
        NavigatorManager navigatorManager = DatabaseNavigatorManager.getInstance();
        ContextMenu contextMenu2 = navigatorManager.getContextMenu();
        contextMenu2.addContextMenuListener((ContextMenuListener)this);
    }

    public void menuWillShow(ContextMenu contextMenu) {
        if (contextMenu.getContext().getNode() instanceof RunnableSourceNode) {
            URL uRL = contextMenu.getContext().getNode().getURL();
            String string = DBURLFormatHelper.getConnectionName((URL)uRL);
            try {
                IdeAction ideAction;
                Connection connection;
                int n;
                Database database = Connections.getInstance().getDatabase(string, true);
                if (database != null && (n = (connection = database.getConnection()).getMetaData().getDatabaseMajorVersion()) > 10 && (ideAction = IdeAction.find((int)PLSQLController.PROFILE_COMMAND)) != null) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

