/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.profiler;

import java.awt.Component;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.parser.PlsqlRules;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.runner.PlSqlRunnerPanel;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RunPrivilegedScript;
import oracle.dbtools.util.Util;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;

public class PLSQLController
implements Controller {
    private static final Object LOCK = new Object();
    private static PLSQLController _controller;
    public static final int PROFILE_COMMAND;
    public IdeAction actionProfile;
    public JMenuItem profileMenu;

    private PLSQLController() {
        this.createActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PLSQLController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_controller == null) {
                _controller = new PLSQLController();
            }
        }
        return _controller;
    }

    private void createActions() {
        this.actionProfile = IdeAction.get((int)PROFILE_COMMAND, (String)StringUtils.stripMnemonic((String)CompileArb.getString((int)1)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompileArb.getString((int)1))));
        this.actionProfile.addController((Controller)this);
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PROFILE_COMMAND && ideAction.isLocalAction() && context.getView() instanceof CodeEditor) {
            if (context.getNode() instanceof PlSqlNode) {
                ideAction.setEnabled(Boolean.valueOf((String)((PlSqlNode)context.getNode()).getProperty("INVALID")) == false);
            }
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        DBConfig dBConfig = DBConfig.getInstance();
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == PROFILE_COMMAND) {
            final RunnableSourceNode runnableSourceNode = (RunnableSourceNode)context.getNode();
            TextBuffer textBuffer = PlSqlRunnerPanel.runDialog((RunnableSourceNode)runnableSourceNode, (boolean)false, (boolean)true);
            if (textBuffer == null) {
                return false;
            }
            final String string = textBuffer.getString(0, textBuffer.getLength());
            String string2 = dBConfig.getString("PLSQLPROFILERDIR");
            if (string2 == null || "".equals(string2.trim())) {
                string2 = "PLSHPROF_DIR";
            }
            final String string3 = string2;
            final String string4 = "begin dbms_hprof.start_profiling('" + string3 + "', 'test.trc');" + "end;";
            final String string5 = "begin :1 := dbms_hprof.analyze('" + string3 + "','test.trc'," + "run_comment=>'" + runnableSourceNode.getProperty("commentReturn") + "'); end; ";
            Thread thread = new Thread("PL/SQL Profiler Starter Thread"){
                private int attempt;
                {
                    super(string6);
                    this.attempt = 0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block65: {
                        if (this.attempt++ > 2) {
                            return;
                        }
                        String string13 = runnableSourceNode.getConnectionName();
                        if (string13 == null) {
                            string13 = DBURLFormatHelper.getConnectionName((URL)runnableSourceNode.getURL());
                        }
                        Statement statement = null;
                        Statement statement2 = null;
                        Database database = null;
                        try {
                            database = Connections.getInstance().getDatabase(string13, true);
                        }
                        catch (DBException dBException) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)dBException.getMessage(), null, null);
                            return;
                        }
                        Connection connection = database.getConnection();
                        String string2 = null;
                        try {
                            string2 = connection.getMetaData().getUserName();
                            statement = connection.createStatement();
                            statement.execute(string4);
                            statement.execute(string);
                            statement.execute("begin dbms_hprof.stop_profiling;end;");
                            statement2 = connection.prepareCall(string5);
                            statement2.registerOutParameter(1, 1);
                            statement2.execute();
                            String string32 = statement2.getString(1);
                            String string42 = "Finished profiling: \nCheck up \"Execution Profiles\" for the results";
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string42, null, null);
                        }
                        catch (SQLException sQLException) {
                            String string52 = "grant READ, WRITE on directory " + string3 + " to " + string2;
                            String string6 = "grant execute on DBMS_HPROF to " + string2;
                            String string7 = "grant create table to " + string2;
                            String string8 = "grant create sequence to " + string2;
                            String string9 = "grant unlimited tablespace to " + string2;
                            if (sQLException.getErrorCode() == 29280 || sQLException.getErrorCode() == 29289 || sQLException.getErrorCode() == 6550) {
                                String string10;
                                ResultSet resultSet = null;
                                String string11 = null;
                                try {
                                    resultSet = statement.executeQuery("select directory_path from all_directories where directory_name = '" + string3 + "'");
                                    boolean bl = resultSet.next();
                                    if (bl && sQLException.getErrorCode() == 29280) {
                                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Directory exists; check if " + resultSet.getString(1) + " exists on file system,\n" + "and oracle has permissions to write there"), null, null);
                                        return;
                                    }
                                    if (!bl) {
                                        string10 = "No profiler log directory exists. \nWill attempt creating profiler directory. \n(Please make sure it exists on the file system!)";
                                        string11 = JOptionPane.showInputDialog(string10, (Object)"/tmp");
                                        if (string11 == null || string11.trim().length() == 0) {
                                            throw new Exception();
                                        }
                                    } else {
                                        string11 = resultSet.getString(1);
                                    }
                                }
                                catch (Exception exception) {
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Failed to select from all_directories: " + exception.getMessage()), null, null);
                                    try {
                                        if (statement != null) {
                                            statement.close();
                                        }
                                        if (statement2 != null) {
                                            statement2.close();
                                        }
                                    }
                                    catch (SQLException sQLException2) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                finally {
                                    if (resultSet != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (SQLException sQLException3) {}
                                    }
                                }
                                try {
                                    String[] stringArray = new String[]{"CREATE OR REPLACE directory " + string3 + " as '" + string11 + "'", string52, string6, string7, string8, string9};
                                    RunPrivilegedScript.runWithPreview((String[])stringArray, (String)string13, (String)"sys", (String)"sysdba");
                                    this.run();
                                    break block65;
                                }
                                catch (Exception exception) {
                                    string10 = exception.getMessage();
                                    if (sQLException.getErrorCode() == 29289) {
                                        string10 = string10 + "\n\nProblem accessing profiler log directory. \nTry fixing the problem manually: \nconnect / as sysdba;\nGRANT READ, WRITE on directory " + string3 + " to " + string2 + ";";
                                    } else if (sQLException.getErrorCode() == 6550) {
                                        string10 = string10 + "\n\nProblem invoking dbms_hprof. \nTry fixing the problem manually: \nconnect / as sysdba;\ngrant execute on DBMS_HPROF to " + string2 + ";\n";
                                    } else if (sQLException.getErrorCode() == 29280) {
                                        string10 = string10 + "\n\nFailed to create profiler directory. \nTry fixing the problem manually: \nconnect / as sysdba;\nCREATE directory " + string3 + " as '/private/plshprof/results';";
                                    }
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string10, null, null);
                                    try {
                                        if (statement != null) {
                                            statement.close();
                                        }
                                        if (statement2 != null) {
                                            statement2.close();
                                        }
                                    }
                                    catch (SQLException sQLException4) {
                                        // empty catch block
                                    }
                                    return;
                                }
                            }
                            if (sQLException.getErrorCode() == 942) {
                                try {
                                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)("Profiler tables missing.\nConfirm running dbmshptab.sql\n(Hope " + string2 + " has 'create table/sequence' permissions)"), null, null);
                                    URL uRL = PlsqlRules.class.getResource("/oracle/dbtools/raptor/profiler/dbmshptab.xml");
                                    InputStream inputStream = uRL.openStream();
                                    String string12 = Util.readFile((InputStream)inputStream);
                                    inputStream.close();
                                    ScriptRunner scriptRunner = new ScriptRunner(string12, connection);
                                    scriptRunner.run();
                                    this.run();
                                    break block65;
                                }
                                catch (Exception exception) {
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Profiler tables missing: \nconnect user/pwd;\n@?/rdbms/admin/dbmshptab.sql\n\n" + exception.getMessage()), null, null);
                                    try {
                                        if (statement != null) {
                                            statement.close();
                                        }
                                        if (statement2 != null) {
                                            statement2.close();
                                        }
                                    }
                                    catch (SQLException sQLException5) {
                                        // empty catch block
                                    }
                                    return;
                                }
                            }
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), null, null);
                        }
                        finally {
                            try {
                                if (statement != null) {
                                    statement.close();
                                }
                                if (statement2 != null) {
                                    statement2.close();
                                }
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
            };
            thread.start();
            return true;
        }
        return bl;
    }

    private static void openReport(Database database, final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string2 = "select LPAD(' ', LEVEL * 2) || p.function, c.function\n from dbmshp_parent_child_info pc, dbmshp_function_info p, dbmshp_function_info c\nstart with  pc.runid=" + string + "and p.runid = pc.runid and c.runid = pc.runid\n" + "and pc.childsymid = c.symbolid and pc.parentsymid = p.symbolid and p.symbolid=1\n" + "connect by  pc.runid=prior pc.runid and p.runid = pc.runid and c.runid = pc.runid\n" + "and pc.childsymid = c.symbolid and pc.parentsymid = p.symbolid\n" + "and prior pc.childsymid = pc.parentsymid";
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    static {
        PROFILE_COMMAND = Ide.findOrCreateCmdID((String)"ProfileSelectionCommand");
    }
}

