/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.profiler;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.sql.Connection;
import javax.swing.Icon;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.profiler.PLSQLController;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.view.View;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public class PLSQLEditorToolbar
implements EditorPlugin {
    public void install(BasicEditorPane basicEditorPane) {
        DBObject dBObject;
        String string;
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        Toolbar toolbar = codeEditor.getToolbar();
        if (!(!DBURLFormatHelper.isDBURL((URL)codeEditor.getContext().getNode().getURL()) || (string = (dBObject = new DBObject((Element)codeEditor.getContext().getNode())).getObjectType()) == null || "XML SCHEMA".equals(string) || "TRIGGER".equals(string) || "TYPE".equals(string) || "PACKAGE BODY".equals(string))) {
            this.addRunActions(codeEditor, toolbar, dBObject);
        }
        View.updateToolbarActions((Toolbar)toolbar);
    }

    private void addRunActions(CodeEditor codeEditor, Toolbar toolbar, DBObject dBObject) {
        URL uRL = codeEditor.getContext().getNode().getURL();
        String string = DBURLFormatHelper.getConnectionName((URL)uRL);
        try {
            Database database = Connections.getInstance().getDatabase(string, true);
            Connection connection = database.getConnection();
            int n = connection.getMetaData().getDatabaseMajorVersion();
            if (n > 10) {
                boolean bl = dBObject.getSchemaObject() != null;
                toolbar.addSeparator();
                toolbar.add((ToggleAction)this.createLocalAction((View)codeEditor, CommonArb.getIcon((int)8), Translate.translate((String)"Profile"), PLSQLController.PROFILE_COMMAND, bl));
                toolbar.addSeparator();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private IdeAction createLocalAction(View view, Icon icon, String string, int n, boolean bl) {
        IdeAction ideAction = IdeAction.newLocalAction((int)n, (View)view);
        ideAction.putValue("SmallIcon", (Object)icon);
        ideAction.putValue("ShortDescription", (Object)string);
        ideAction.setEnabled(bl);
        return ideAction;
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

