/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.sqltrace.IPopupSupplier;
import oracle.dbtools.raptor.sqltrace.MouseMotionTooltipListener;
import oracle.dbtools.raptor.sqltrace.SqlTraceEditorNode;
import oracle.dbtools.raptor.sqltrace.TableColumnChooser;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.dbtools.raptor.sqltrace.parser.Stat;
import oracle.dbtools.raptor.sqltrace.parser.WaitSummary;
import oracle.dbtools.raptor.sqltrace.ui.StatisticsSummaryTable;
import oracle.dbtools.raptor.sqltrace.ui.WaitSummaryTable;
import oracle.dbtools.raptor.sqltrace.ui.renderer.MultiLineTextCellEditor;
import oracle.dbtools.raptor.sqltrace.ui.renderer.MultiLineTextRenderer;
import oracle.dbtools.raptor.sqltrace.ui.renderer.SqlCursorRenderer;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.ui.balloon.Balloon;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTraceListCursorsEditor
extends Editor
implements IPopupSupplier {
    private JComponent _ui;
    Balloon b = new Balloon();
    private Toolbar _toolBar;
    private SqlCursorRenderer _renderer;
    private DefaultTableModel _model;
    private SqlTraceEditorNode _node;
    private JComboBox _filter;
    private StatisticsSummaryTable _cp;
    private WaitSummaryTable _ws;
    private JScrollPane _sp;
    private boolean _hasWaits;
    private boolean _hasStats;
    private boolean _hasTimes;
    private JCheckBox _includeSys;
    protected String _filterText;
    private int _sortBy = 0;
    protected int _sortOrder = 0;
    private JTable _table;
    private static final String PADDING = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    public void open() {
    }

    private void init() {
        if (this._ui == null) {
            Ide.getWaitCursor().show();
            this._table = new JTable();
            TableColumnChooser.install(this._table);
            MouseMotionTooltipListener mouseMotionTooltipListener = new MouseMotionTooltipListener(this._table, this);
            this._node = (SqlTraceEditorNode)this.getContext().getNode();
            this._hasWaits = false;
            this._hasStats = false;
            this._hasTimes = false;
            for (SqlCursor object2 : this._node.getTraceFile().getCursors()) {
                if (!this._hasWaits && object2.getWaitSummary() != null && object2.getWaitSummary().size() > 0) {
                    this._hasWaits = true;
                }
                if (!this._hasStats && object2.getStats() != null && object2.getStats().size() > 0) {
                    this._hasStats = true;
                }
                if (this._hasTimes || !(object2.getTotalCPU() > 0.0f)) continue;
                this._hasTimes = true;
            }
            this._table.setAutoResizeMode(0);
            this._model = (DefaultTableModel)this._table.getModel();
            this._model.addColumn("SQL");
            if (this._hasTimes) {
                this._model.addColumn("Statistics");
            }
            if (this._hasWaits) {
                this._model.addColumn("Waits");
            }
            if (this._hasStats) {
                this._model.addColumn("Row Sources");
            }
            int n = 0;
            this._table.getColumnModel().getColumn(n).setMinWidth(200);
            ++n;
            if (this._hasTimes) {
                this._table.getColumnModel().getColumn(n).setMinWidth(425);
                ++n;
            }
            if (this._hasWaits) {
                this._table.getColumnModel().getColumn(n).setMinWidth(350);
                ++n;
            }
            if (this._hasStats) {
                this._table.getColumnModel().getColumn(n).setMinWidth(450);
                ++n;
            }
            this._table.setRowHeight(95);
            this._renderer = new SqlCursorRenderer(false, false);
            this._table.setDefaultRenderer(Object.class, this._renderer);
            this._table.setDefaultEditor(Object.class, this._renderer);
            this._table.setShowGrid(true);
            this._table.getColumnModel().getColumn(0).setCellRenderer(new MultiLineTextRenderer());
            this._table.setDefaultEditor(Object.class, new MultiLineTextCellEditor());
            this.initToolbar();
            this.loadCursors();
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this._table);
            this._ui = jScrollPane;
            Ide.getWaitCursor().hide();
        }
    }

    private void initToolbar() {
        if (this._toolBar == null) {
            this._toolBar = new Toolbar();
            final JComboBox jComboBox = new JComboBox();
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
            defaultComboBoxModel.addElement("s");
            char c = '\u0173';
            defaultComboBoxModel.addElement(c + "s");
            jComboBox.setSize(20, jComboBox.getHeight());
            jComboBox.setMaximumSize(new Dimension(100, 30));
            jComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        if (jComboBox.getSelectedIndex() == 0) {
                            SqlTraceListCursorsEditor.this._renderer.setTimeFactor(1000000L);
                        } else if (jComboBox.getSelectedIndex() == 1) {
                            SqlTraceListCursorsEditor.this._renderer.setTimeFactor(0L);
                        }
                        SqlTraceListCursorsEditor.this.getGUI().repaint();
                    }
                }
            });
            this._filter = new JComboBox();
            DefaultComboBoxModel defaultComboBoxModel2 = (DefaultComboBoxModel)this._filter.getModel();
            defaultComboBoxModel2.addElement("All");
            defaultComboBoxModel2.addElement("NonRecursive");
            defaultComboBoxModel2.addElement("Recursive");
            this._filter.setSelectedIndex(1);
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    SqlTraceListCursorsEditor.this.loadCursors();
                }
            };
            this._filter.addItemListener(itemListener);
            this._filter.setMaximumSize(this._filter.getMinimumSize());
            this._includeSys = new JCheckBox();
            this._includeSys.setSelected(false);
            this._includeSys.addItemListener(itemListener);
            final SearchField searchField = new SearchField();
            Dimension dimension = searchField.getPreferredSize();
            dimension.setSize(150, dimension.height);
            searchField.setMinimumSize(dimension);
            searchField.setPreferredSize(dimension);
            searchField.setMaximumSize(dimension);
            searchField.addSearchListener(new SearchListener(){

                public void searchCategoryChanged(SearchEvent searchEvent) {
                }

                public void searchPerformed(SearchEvent searchEvent) {
                    SqlTraceListCursorsEditor.this._filterText = searchField.getText();
                    SqlTraceListCursorsEditor.this.loadCursors();
                }
            });
            final JComboBox jComboBox2 = new JComboBox();
            defaultComboBoxModel2 = (DefaultComboBoxModel)jComboBox2.getModel();
            defaultComboBoxModel2.addElement("Time");
            defaultComboBoxModel2.addElement("Count");
            defaultComboBoxModel2.addElement("CPU");
            defaultComboBoxModel2.addElement("Elapsed");
            defaultComboBoxModel2.addElement("Disk");
            defaultComboBoxModel2.addElement("Query");
            defaultComboBoxModel2.addElement("Current");
            defaultComboBoxModel2.addElement("Rows");
            jComboBox2.setSelectedIndex(0);
            jComboBox2.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        SqlTraceListCursorsEditor.this._sortBy = jComboBox2.getSelectedIndex();
                        SqlTraceListCursorsEditor.this.loadCursors();
                    }
                }
            });
            jComboBox2.setMaximumSize(jComboBox2.getMinimumSize());
            final JComboBox jComboBox3 = new JComboBox();
            defaultComboBoxModel2 = (DefaultComboBoxModel)jComboBox3.getModel();
            defaultComboBoxModel2.addElement("Asc");
            defaultComboBoxModel2.addElement("Desc");
            jComboBox3.setSelectedIndex(0);
            jComboBox3.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        SqlTraceListCursorsEditor.this._sortOrder = jComboBox3.getSelectedIndex();
                        SqlTraceListCursorsEditor.this.loadCursors();
                    }
                }
            });
            jComboBox3.setMaximumSize(jComboBox3.getMinimumSize());
            int n = 0;
            this._toolBar.addComponent((Component)searchField, n++);
            this._toolBar.addComponent((Component)new JLabel("Time:"), n++);
            this._toolBar.addComponent(jComboBox, n++);
            this._toolBar.addComponent((Component)new JLabel("Filter:"), n++);
            this._toolBar.addComponent((Component)this._filter, n++);
            this._toolBar.addComponent((Component)new JLabel("Sort:"), n++);
            this._toolBar.addComponent(jComboBox2, n++);
            this._toolBar.addComponent(jComboBox3, n++);
            this._toolBar.addComponent((Component)new JLabel("Include Sys:"), n++);
            this._toolBar.addComponent((Component)this._includeSys, n++);
            this._toolBar.addComponent(Box.createHorizontalGlue(), n++);
        }
    }

    @Override
    public Component getPopup(Object object) {
        Component component = null;
        if (object instanceof SqlCursor) {
            if (this._cp == null) {
                this._cp = new StatisticsSummaryTable((SqlCursor)object);
                this._cp.setPreferredSize(new Dimension(450, 95));
                this._cp.setMinimumSize(this._cp.getPreferredSize());
                this._cp.setMaximumSize(this._cp.getPreferredSize());
            } else {
                this._cp.setPreferredSize(new Dimension(450, 95));
                this._cp.setMinimumSize(this._cp.getPreferredSize());
                this._cp.setMaximumSize(this._cp.getPreferredSize());
                this._cp.setCursor((SqlCursor)object);
            }
            component = this._cp;
        } else if (object instanceof ArrayList && ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof WaitSummary) {
            if (this._ws == null) {
                this._ws = new WaitSummaryTable((ArrayList)object);
                this._ws.setMinimumSize(new Dimension(300, this._ws.getRowHeight() * (this._ws.getRowCount() + 5)));
                this._ws.setPreferredSize(this._ws.getMinimumSize());
            } else {
                if (this._ws.getWaits() == object) {
                    this._ws.setMinimumSize(new Dimension(300, this._ws.getRowHeight() * (this._ws.getRowCount() + 5)));
                    this._ws.setPreferredSize(this._ws.getMinimumSize());
                }
                this._ws.setWaits((ArrayList)object);
            }
            component = this._ws;
        } else if (object instanceof ArrayList && ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof Stat) {
            StringBuilder stringBuilder = new StringBuilder("<html>");
            String string = "%8d-%s<br>";
            JLabel jLabel = new JLabel();
            this.printCursorStats(stringBuilder, string, (ArrayList)object, 0);
            jLabel.setBackground(Color.WHITE);
            jLabel.setText(stringBuilder.toString());
            Dimension dimension = jLabel.getPreferredSize();
            jLabel.setMinimumSize(new Dimension(250, 100));
            component = jLabel;
        } else if (object instanceof String) {
            MultiLineLabel multiLineLabel = new MultiLineLabel();
            multiLineLabel.setText(object.toString());
            multiLineLabel.setBackground(Color.WHITE);
            multiLineLabel.setForceWrapping(true);
            String[] stringArray = object.toString().split("\n");
            if (stringArray.length < 20) {
                multiLineLabel.setMinimumRows(stringArray.length + 2);
            } else {
                multiLineLabel.setMinimumRows(21);
            }
            multiLineLabel.setOpaque(true);
            for (int i = 0; i < 20; ++i) {
                if (stringArray.length <= i || multiLineLabel.getMinimumColumns() >= stringArray[i].length()) continue;
                multiLineLabel.setMinimumColumns(stringArray[i].length() + 10);
            }
            component = multiLineLabel;
        } else {
            component = null;
        }
        if (component != null && component instanceof JTable) {
            if (this._sp == null) {
                this._sp = new JScrollPane(component);
                this._sp.setVerticalScrollBarPolicy(21);
            }
            this._sp.setViewportView(component);
            if (this._sp.getPreferredSize() != component.getPreferredSize()) {
                this._sp.setPreferredSize(((JTable)component).getPreferredSize());
                this._sp.setMinimumSize(((JTable)component).getPreferredSize());
            }
            component = this._sp;
        }
        return component;
    }

    public void printCursorStats(StringBuilder stringBuilder, String string, ArrayList<Stat> arrayList, int n) {
        for (Stat stat : arrayList) {
            if (stat.getOperation().indexOf("(cr") > 0) {
                stringBuilder.append(String.format(string, stat.getRows(), PADDING.substring(0, n * 6 * 2) + stat.getOperation().substring(0, stat.getOperation().indexOf("(cr"))));
            }
            this.printCursorStats(stringBuilder, string, stat.getStats(), n + 1);
        }
    }

    public Component getGUI() {
        this.init();
        return this._ui;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        this.init();
    }

    public Component getFixedTopMargin() {
        this.initToolbar();
        return this._toolBar;
    }

    public void loadCursors() {
        IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){
            private boolean _isCanceled = false;

            public void cancel() {
                this._isCanceled = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() {
                SqlTraceListCursorsEditor.this._node.getTraceFile();
                Vector<Vector> vector = SqlTraceListCursorsEditor.this._model.getDataVector();
                synchronized (vector) {
                    Vector<Vector> vector2 = SqlTraceListCursorsEditor.this._model.getDataVector();
                    vector2.removeAllElements();
                    for (SqlCursor sqlCursor : SqlTraceListCursorsEditor.this._node.getTraceFile().getCursors()) {
                        int n = SqlTraceListCursorsEditor.this._filter.getSelectedIndex();
                        boolean bl = false;
                        if (n == 0) {
                            bl = true;
                        } else if (n == 1 && sqlCursor.getDepLevel() == 0) {
                            bl = true;
                        } else if (n == 2 && sqlCursor.getDepLevel() > 0) {
                            bl = true;
                        }
                        if (sqlCursor.getUid() == 0 && SqlTraceListCursorsEditor.this._includeSys.isSelected()) {
                            bl = true;
                        } else if (sqlCursor.getUid() == 0 && !SqlTraceListCursorsEditor.this._includeSys.isSelected()) {
                            bl = false;
                        }
                        if (bl && SqlTraceListCursorsEditor.this._filterText != null && SqlTraceListCursorsEditor.this._filterText.trim().length() > 0 && sqlCursor.getSQL().toLowerCase().indexOf(SqlTraceListCursorsEditor.this._filterText.toLowerCase()) == -1) {
                            bl = false;
                        }
                        if (!bl) continue;
                        Vector<Object> vector3 = new Vector<Object>();
                        vector3.add(sqlCursor.getSQL());
                        if (SqlTraceListCursorsEditor.this._hasTimes) {
                            vector3.add(sqlCursor);
                        }
                        if (SqlTraceListCursorsEditor.this._hasWaits) {
                            vector3.add(sqlCursor.getWaitSummary());
                        }
                        if (SqlTraceListCursorsEditor.this._hasStats) {
                            vector3.add(sqlCursor.getStats());
                        }
                        vector2.add(vector3);
                    }
                    SqlTraceListCursorsEditor.this.sortCursors(SqlTraceListCursorsEditor.this._table, SqlTraceListCursorsEditor.this._model, SqlTraceListCursorsEditor.this._sortBy, SqlTraceListCursorsEditor.this._sortOrder);
                    SqlTraceListCursorsEditor.this._model.fireTableDataChanged();
                }
                return null;
            }

            public void finish(Object object) {
                Ide.getWaitCursor().hide();
            }

            public void preWork() {
                Ide.getWaitCursor().show();
            }
        };
        DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Parsing Trace File", null, 500, iDelayedProgressRunnable, null);
        delayedProgressRunnable.setCancellable(true);
        delayedProgressRunnable.start();
    }

    @Override
    public Component getComponentAt(Point point) {
        return this.getGUI().getComponentAt(point);
    }

    public void sortCursors(JTable jTable, DefaultTableModel defaultTableModel, final int n, final int n2) {
        Vector<Vector> vector = defaultTableModel.getDataVector();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                SqlCursor sqlCursor = (SqlCursor)((Vector)object).get(1);
                SqlCursor sqlCursor2 = (SqlCursor)((Vector)object2).get(1);
                int n3 = 0;
                if (n == 0) {
                    n3 = Long.valueOf(sqlCursor.getTime()).compareTo(sqlCursor2.getTime());
                } else if (n == 1) {
                    n3 = Float.valueOf(sqlCursor.getTotalCount()).compareTo(Float.valueOf(sqlCursor2.getTotalCount()));
                } else if (n == 2) {
                    n3 = Float.valueOf(sqlCursor.getTotalCPU()).compareTo(Float.valueOf(sqlCursor2.getTotalCPU()));
                } else if (n == 3) {
                    n3 = Float.valueOf(sqlCursor.getTotalElapsed(false)).compareTo(Float.valueOf(sqlCursor2.getTotalElapsed(false)));
                } else if (n == 4) {
                    n3 = Float.valueOf(sqlCursor.getTotalDisk()).compareTo(Float.valueOf(sqlCursor2.getTotalDisk()));
                } else if (n == 5) {
                    n3 = Float.valueOf(sqlCursor.getTotalQuery()).compareTo(Float.valueOf(sqlCursor2.getTotalQuery()));
                } else if (n == 6) {
                    n3 = Float.valueOf(sqlCursor.getTotalCurrent()).compareTo(Float.valueOf(sqlCursor2.getTotalCurrent()));
                } else if (n == 7) {
                    n3 = Float.valueOf(sqlCursor.getTotalRows()).compareTo(Float.valueOf(sqlCursor2.getTotalRows()));
                }
                return n3 == 0 || n2 == 0 ? n3 : n3 * -1;
            }
        });
    }
}

