/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace;

import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.dbtools.raptor.sqltrace.parser.TraceFile;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.TreeTableModel;

class SqlTraceTreeModel
extends AbstractTreeTableModel {
    public SqlTraceTreeModel(TraceFile traceFile) {
        super((Object)traceFile);
    }

    public int getColumnCount() {
        return 0;
    }

    public String getColumnName(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "SQL";
                break;
            }
            case 2: {
                string = "Hash";
                break;
            }
            case 3: {
                string = "Addr";
                break;
            }
            case 4: {
                string = "count";
                break;
            }
            case 5: {
                string = "elap";
                break;
            }
            case 6: {
                string = "c#";
                break;
            }
            case 7: {
                string = "cpu";
                break;
            }
            case 8: {
                string = "disk";
            }
        }
        return string;
    }

    public Object getValueAt(Object object, int n) {
        Object object2 = null;
        if (object instanceof SqlCursor) {
            SqlCursor sqlCursor = (SqlCursor)object;
            switch (n) {
                case 0: {
                    object2 = sqlCursor;
                    break;
                }
                case 1: {
                    object2 = sqlCursor;
                    break;
                }
                case 2: {
                    object2 = "" + sqlCursor.getSqlHash();
                    break;
                }
                case 3: {
                    object2 = "" + sqlCursor.getAddr();
                    break;
                }
                case 4: {
                    object2 = "" + sqlCursor.getTotalCount();
                    break;
                }
                case 5: {
                    object2 = "" + sqlCursor.getTotalElapsed(false);
                    break;
                }
                case 6: {
                    object2 = "" + sqlCursor.getCursorNumber();
                    break;
                }
                case 7: {
                    object2 = "" + sqlCursor.getTotalCPU();
                    break;
                }
                case 8: {
                    object2 = "" + sqlCursor.getTotalDisk();
                }
            }
        } else if (object instanceof TraceFile) {
            object2 = "xx";
        }
        return object2;
    }

    public Object getChild(Object object, int n) {
        SqlCursor sqlCursor = null;
        if (object instanceof TraceFile) {
            sqlCursor = ((TraceFile)object).getNonRecursiveCursors().get(n);
        } else if (object instanceof SqlCursor && ((SqlCursor)object).getRecursiveCursors() != null) {
            sqlCursor = ((SqlCursor)object).getRecursiveCursors().get(n);
        }
        return sqlCursor;
    }

    public int getChildCount(Object object) {
        if (object instanceof TraceFile) {
            return ((TraceFile)object).getNonRecursiveCursors().size();
        }
        if (object instanceof SqlCursor && ((SqlCursor)object).getRecursiveCursors() != null) {
            return ((SqlCursor)object).getRecursiveCursors().size();
        }
        return 0;
    }

    public boolean isCellEditable(Object object, int n) {
        if (n == 1) {
            return true;
        }
        return this.getColumnClass(n) == TreeTableModel.class;
    }
}

