/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableColumnChooser
extends MouseAdapter
implements ActionListener {
    public static final String FIXED_COLUMNS = "FixedColumns";
    private static final String COLUMN_INDEX = "ColumnIndex";
    private static final String JTABLE = "JTable";
    private static final String OLD_COLS = "REMOVED_TABLE_COLUMNS";
    private static WeakReference ref = null;

    private boolean isVisibleColumn(TableColumnModel tableColumnModel, int n) {
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i).getModelIndex() != n) continue;
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getComponent();
        TableModel tableModel = jTableHeader.getTable().getModel();
        TableColumnModel tableColumnModel = jTableHeader.getTable().getColumnModel();
        int[] nArray = (int[])jTableHeader.getTable().getClientProperty(FIXED_COLUMNS);
        if (nArray == null) {
            nArray = new int[]{0};
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(tableModel.getColumnName(i));
            jCheckBoxMenuItem.setSelected(this.isVisibleColumn(tableColumnModel, i));
            jCheckBoxMenuItem.setEnabled(Arrays.binarySearch(nArray, i) < 0);
            jCheckBoxMenuItem.putClientProperty(COLUMN_INDEX, new Integer(i));
            jCheckBoxMenuItem.putClientProperty(JTABLE, jTableHeader.getTable());
            jCheckBoxMenuItem.addActionListener(this);
            jPopupMenu.add(jCheckBoxMenuItem);
        }
        jPopupMenu.show(jTableHeader, mouseEvent.getX(), mouseEvent.getY());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        Integer n = (Integer)jMenuItem.getClientProperty(COLUMN_INDEX);
        JTable jTable = (JTable)jMenuItem.getClientProperty(JTABLE);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        if (!jMenuItem.isSelected()) {
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                if (tableColumn.getModelIndex() != n.intValue()) continue;
                jTable.putClientProperty(n, tableColumn);
                tableColumnModel.removeColumn(tableColumn);
                return;
            }
        } else {
            TableColumn tableColumn = (TableColumn)jTable.getClientProperty(n);
            jTable.addColumn(tableColumn);
            tableColumnModel.moveColumn(tableColumnModel.getColumnCount() - 1, n);
        }
    }

    private TableColumnChooser() {
    }

    private static TableColumnChooser getInstance() {
        if (ref == null || ref.get() == null) {
            ref = new WeakReference<TableColumnChooser>(new TableColumnChooser());
        }
        return (TableColumnChooser)ref.get();
    }

    public static void install(JTable jTable) {
        jTable.getTableHeader().addMouseListener(TableColumnChooser.getInstance());
    }

    public static void uninstall(JTable jTable) {
        jTable.getTableHeader().removeMouseListener(TableColumnChooser.getInstance());
    }

    public static void hideColumns(TableColumnModel tableColumnModel, int[] nArray) {
        int n;
        TableColumn[] tableColumnArray = new TableColumn[nArray.length];
        int n2 = 0;
        for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            if (tableColumn.getModelIndex() != nArray[n2]) continue;
            tableColumnArray[n2++] = tableColumn;
            if (n2 >= nArray.length) break;
        }
        for (n = 0; n < tableColumnArray.length; ++n) {
            tableColumnModel.removeColumn(tableColumnArray[n]);
        }
    }
}

