/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.parser;

import java.io.PrintStream;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.sqltrace.parser.IElapsedEvent;
import oracle.dbtools.raptor.sqltrace.parser.IResourceEvent;

public class EventFetch
implements IElapsedEvent,
IResourceEvent {
    private static final Logger LOGGER = Logger.getLogger(EventFetch.class.getName());
    private static final Pattern PATTERN = Pattern.compile("#([0-9]++):c=([0-9]++),e=([0-9]++),p=([0-9]++),cr=([0-9]++),cu=([0-9]++),mis=([0-9]++),r=([0-9]++),dep=([0-9]++),og=([0-9]++),tim=([0-9]++)");
    private int _curNum;
    private long _time;
    private long _optimizer;
    private long _misses;
    private long _rows;
    private long _depLevel;
    private long _logicalIO;
    private long _phyIO;
    private long _consisIO;
    private long _elapsed;
    private long _cpu;

    public EventFetch(String string) {
        Matcher matcher = PATTERN.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this._curNum = Integer.parseInt(matcher.group(1));
            this._cpu = Long.parseLong(matcher.group(2));
            this._elapsed = Long.parseLong(matcher.group(3));
            this._phyIO = Long.parseLong(matcher.group(4));
            this._consisIO = Long.parseLong(matcher.group(5));
            this._logicalIO = Long.parseLong(matcher.group(6));
            this._misses = Long.parseLong(matcher.group(7));
            this._rows = Long.parseLong(matcher.group(8));
            this._depLevel = Long.parseLong(matcher.group(9));
            this._optimizer = Long.parseLong(matcher.group(10));
            this._time = Long.parseLong(matcher.group(11));
        } else {
            LOGGER.severe("no match for line:" + string);
        }
    }

    public String toString() {
        return String.format("FETCH #%d:c=%d,e=%d,p=%d,cr=%d,cu=%d,mis=%d,r=%d,dep=%d,og=%d,tim=%d", this._curNum, this._cpu, this._elapsed, this._phyIO, this._consisIO, this._logicalIO, this._misses, this._rows, this._depLevel, this._optimizer, this._time);
    }

    public static void main(String[] stringArray) {
        String string = "FETCH #52:c=0,e=104,p=0,cr=4,cu=0,mis=0,r=1,dep=0,og=4,tim=308930794513";
        EventFetch eventFetch = new EventFetch(string);
        PrintStream printStream = System.out;
        printStream.println("TEST:" + string);
        printStream.println("REST:" + eventFetch.toString());
    }

    public long getConsistantIO() {
        return this._consisIO;
    }

    public long getCPU() {
        return this._cpu;
    }

    public int getCursorNum() {
        return this._curNum;
    }

    public long getDepLevel() {
        return this._depLevel;
    }

    public long getElapsed() {
        return this._elapsed;
    }

    public long getLogicalIO() {
        return this._logicalIO;
    }

    public long getCacheMisses() {
        return this._misses;
    }

    public long getOptimizer() {
        return this._optimizer;
    }

    public long getPhysicalIO() {
        return this._phyIO;
    }

    public long getRows() {
        return this._rows;
    }

    public long getTime() {
        return this._time;
    }
}

