/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.printers;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.raptor.sqltrace.parser.Bind;
import oracle.dbtools.raptor.sqltrace.parser.EventWait;
import oracle.dbtools.raptor.sqltrace.parser.IElapsedEvent;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.dbtools.raptor.sqltrace.parser.SqlTraceUtils;
import oracle.dbtools.raptor.sqltrace.parser.Stat;
import oracle.dbtools.raptor.sqltrace.printers.ISqlCursorPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPrinter
implements ISqlCursorPrinter {
    private static final String PADDING = "                                                                                                                     ";

    @Override
    public void printCursor(PrintStream printStream, SqlCursor sqlCursor) {
        printStream.println("********************************************************************************\n");
        printStream.println(sqlCursor.getSQL());
        printStream.println();
        for (Bind object2 : sqlCursor.getBinds()) {
            printStream.println("Bind#" + object2.getBindNum() + "=" + object2.getValue());
        }
        printStream.println();
        Object object3 = null;
        printStream.println("call      count      cpu    elapsed      disk     query   current       rows");
        printStream.println("-------  ------   ------- --------- --------- --------- ---------  ---------");
        String string = "%-10s%5.0f%10.2f%10.2f%10.0f%10.0f%10.0f%10.0f";
        object3 = String.format(string, "Parse", Float.valueOf(sqlCursor.getParseCount()), Float.valueOf(SqlTraceUtils.toSec(sqlCursor.getParseCPU())), Float.valueOf(SqlTraceUtils.toSec(sqlCursor.getParseElapsed(false))), Float.valueOf(sqlCursor.getParseDisk()), Float.valueOf(sqlCursor.getParseQuery()), Float.valueOf(sqlCursor.getParseCurrent()), Float.valueOf(sqlCursor.getParseRows()));
        printStream.println((String)object3);
        object3 = String.format(string, "Execute", sqlCursor.getExecuteCount(), Float.valueOf(SqlTraceUtils.toSec(sqlCursor.getExecuteCPU())), Float.valueOf(SqlTraceUtils.toSec(sqlCursor.getExecuteElapsed(false))), Float.valueOf(sqlCursor.getExecuteDisk()), Float.valueOf(sqlCursor.getExecuteQuery()), Float.valueOf(sqlCursor.getExecuteCurrent()), Float.valueOf(sqlCursor.getExecuteRows()));
        printStream.println((String)object3);
        object3 = String.format(string, "Fetch", Float.valueOf(sqlCursor.getFetchCount()), Float.valueOf(SqlTraceUtils.toSec(sqlCursor.getFetchCPU())), Float.valueOf(SqlTraceUtils.toSec(sqlCursor.getFetchElapsed(false))), Float.valueOf(sqlCursor.getFetchDisk()), Float.valueOf(sqlCursor.getFetchQuery()), Float.valueOf(sqlCursor.getFetchCurrent()), Float.valueOf(sqlCursor.getFetchRows()));
        printStream.println((String)object3);
        printStream.println("--------------------------------------------------------------------------------");
        object3 = String.format(string, "total", Float.valueOf(sqlCursor.getTotalCount()), Float.valueOf(SqlTraceUtils.toSec(sqlCursor.getTotalCPU())), Float.valueOf(SqlTraceUtils.toSec(sqlCursor.getTotalElapsed(false))), Float.valueOf(sqlCursor.getTotalDisk()), Float.valueOf(sqlCursor.getTotalQuery()), Float.valueOf(sqlCursor.getTotalCurrent()), Float.valueOf(sqlCursor.getTotalRows()));
        printStream.println((String)object3);
        printStream.println();
        printStream.println("Misses in library cache during parse:" + sqlCursor.getParseMissCount());
        printStream.println("Misses in library cache during execute:" + sqlCursor.getExecuteMissCount());
        printStream.println("Optimizer mode: " + sqlCursor.getOptimizerGoal());
        printStream.println("Parsing user id: " + sqlCursor.getUid());
        printStream.println("Rows     Row Source Operation");
        printStream.println("-------  ---------------------------------------------------");
        String string2 = "%8d  %s";
        this.printCursorStats(printStream, string2, sqlCursor.getStats(), 0);
        EventWait eventWait = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        String string3 = null;
        for (IElapsedEvent iElapsedEvent : sqlCursor.getEvents()) {
            if (!(iElapsedEvent instanceof EventWait)) continue;
            eventWait = (EventWait)iElapsedEvent;
            string3 = eventWait.getName().intern();
            if (!arrayList.contains(string3)) {
                arrayList.add(string3);
                hashMap.put(string3 + ".times", new Long(1L));
                hashMap.put(string3 + ".total", eventWait.getElapsed());
                hashMap.put(string3 + ".max", eventWait.getElapsed());
                continue;
            }
            hashMap.put(string3 + ".times", (Long)hashMap.get(string3 + ".times") + 1L);
            hashMap.put(string3 + ".total", (Long)hashMap.get(string3 + ".total") + eventWait.getElapsed());
            if ((Long)hashMap.get(string3 + ".max") >= eventWait.getElapsed()) continue;
            hashMap.put(string3 + ".max", eventWait.getElapsed());
        }
        printStream.println("\nElapsed times include waiting on following events:");
        printStream.println("Event waited on                             Times   Max. Wait  Total Waited");
        printStream.println("----------------------------------------   Waited  ----------  ------------");
        for (String string4 : arrayList) {
            printStream.println(String.format("%-38s%11d%12.2f%12.2f", string4, hashMap.get(string4 + ".times"), Float.valueOf(SqlTraceUtils.toSec((Long)hashMap.get(string4 + ".max"))), Float.valueOf(SqlTraceUtils.toSec((Long)hashMap.get(string4 + ".total")))));
        }
        ArrayList<SqlCursor> arrayList2 = sqlCursor.getRecursiveCursors();
        if (arrayList2 != null) {
            for (SqlCursor sqlCursor2 : arrayList2) {
                printStream.println("----BEGIN RECURSIVE SQL LEVEL=" + sqlCursor2.getDepLevel() + "----------");
                this.printCursor(printStream, sqlCursor2);
                printStream.println("----END RECURSIVE SQL LEVEL=" + sqlCursor2.getDepLevel() + "----------");
            }
        }
        printStream.println("********************************************************************************");
    }

    @Override
    public void printCursorStats(PrintStream printStream, String string, ArrayList<Stat> arrayList, int n) {
        for (Stat stat : arrayList) {
            printStream.println(String.format(string, stat.getRows(), PADDING.subSequence(0, n) + stat.getOperation()));
            this.printCursorStats(printStream, string, stat.getStats(), n + 1);
        }
    }

    @Override
    public void printCursorsWaitSummary(PrintStream printStream, ArrayList<SqlCursor> arrayList) {
        EventWait eventWait = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        String string = null;
        for (SqlCursor object : arrayList) {
            for (IElapsedEvent iElapsedEvent : object.getEvents()) {
                if (!(iElapsedEvent instanceof EventWait)) continue;
                eventWait = (EventWait)iElapsedEvent;
                string = eventWait.getName().intern();
                if (!arrayList2.contains(string)) {
                    arrayList2.add(string);
                    hashMap.put(string + ".times", new Long(1L));
                    hashMap.put(string + ".total", eventWait.getElapsed());
                    hashMap.put(string + ".max", eventWait.getElapsed());
                    continue;
                }
                hashMap.put(string + ".times", (Long)hashMap.get(string + ".times") + 1L);
                hashMap.put(string + ".total", (Long)hashMap.get(string + ".total") + eventWait.getElapsed());
                if ((Long)hashMap.get(string + ".max") >= eventWait.getElapsed()) continue;
                hashMap.put(string + ".max", eventWait.getElapsed());
            }
        }
        for (String string2 : arrayList2) {
            printStream.println(String.format("%-30s\t%d\t   %.2f\t   %.2f", string2, hashMap.get(string2 + ".times"), Float.valueOf(SqlTraceUtils.toSec((Long)hashMap.get(string2 + ".max"))), Float.valueOf(SqlTraceUtils.toSec((Long)hashMap.get(string2 + ".total")))));
        }
    }

    @Override
    public void printSummary(PrintStream printStream, ArrayList<SqlCursor> arrayList) {
        printStream.println("********************************************************************************");
        String string = null;
        printStream.println("call      count      cpu    elapsed      disk     query   current       rows");
        printStream.println("-------  ------   ------- --------- --------- --------- ---------  ---------");
        String string2 = "%-10s%5.0f%10.2f%10.2f%10.0f%10.0f%10.0f%10.0f";
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (SqlCursor object22 : arrayList) {
            f += object22.getParseCount();
            f2 += object22.getParseCPU();
            f3 += object22.getParseElapsed(false);
            f4 += object22.getParseDisk();
            f5 += object22.getParseQuery();
            f6 += object22.getParseCurrent();
            f7 += object22.getParseRows();
        }
        string = String.format(string2, "Parse", Float.valueOf(f), Float.valueOf(SqlTraceUtils.toSec(f2)), Float.valueOf(SqlTraceUtils.toSec(f3)), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7));
        printStream.println(string);
        f7 = 0.0f;
        f6 = 0.0f;
        f5 = 0.0f;
        f4 = 0.0f;
        f3 = 0.0f;
        f2 = 0.0f;
        f = 0.0f;
        for (SqlCursor sqlCursor : arrayList) {
            f += (float)sqlCursor.getExecuteCount();
            f2 += sqlCursor.getExecuteCPU();
            f3 += sqlCursor.getExecuteElapsed(false);
            f4 += sqlCursor.getExecuteDisk();
            f5 += sqlCursor.getExecuteQuery();
            f6 += sqlCursor.getExecuteCurrent();
            f7 += sqlCursor.getExecuteRows();
        }
        string = String.format(string2, "Execute", Float.valueOf(f), Float.valueOf(SqlTraceUtils.toSec(f2)), Float.valueOf(SqlTraceUtils.toSec(f3)), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7));
        printStream.println(string);
        f7 = 0.0f;
        f6 = 0.0f;
        f5 = 0.0f;
        f4 = 0.0f;
        f3 = 0.0f;
        f2 = 0.0f;
        f = 0.0f;
        for (SqlCursor sqlCursor : arrayList) {
            f += sqlCursor.getFetchCount();
            f2 += sqlCursor.getFetchCPU();
            f3 += sqlCursor.getFetchElapsed(false);
            f4 += sqlCursor.getFetchDisk();
            f5 += sqlCursor.getFetchQuery();
            f6 += sqlCursor.getFetchCurrent();
            f7 += sqlCursor.getFetchRows();
        }
        string = String.format(string2, "Fetch", Float.valueOf(f), Float.valueOf(SqlTraceUtils.toSec(f2)), Float.valueOf(SqlTraceUtils.toSec(f3)), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7));
        printStream.println(string);
        printStream.println("--------------------------------------------------------------------------------");
        f7 = 0.0f;
        f6 = 0.0f;
        f5 = 0.0f;
        f4 = 0.0f;
        f3 = 0.0f;
        f2 = 0.0f;
        f = 0.0f;
        for (SqlCursor sqlCursor : arrayList) {
            f += sqlCursor.getTotalCount();
            f2 += sqlCursor.getTotalCPU();
            f3 += sqlCursor.getTotalElapsed(false);
            f4 += sqlCursor.getTotalDisk();
            f5 += sqlCursor.getTotalQuery();
            f6 += sqlCursor.getTotalCurrent();
            f7 += sqlCursor.getTotalRows();
        }
        string = String.format(string2, "Total", Float.valueOf(f), Float.valueOf(SqlTraceUtils.toSec(f2)), Float.valueOf(SqlTraceUtils.toSec(f3)), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7));
        printStream.println(string);
        int n = 0;
        for (SqlCursor sqlCursor : arrayList) {
            n += sqlCursor.getParseMissCount();
        }
        printStream.println("Misses in library cache during parse: " + n);
        n = 0;
        for (SqlCursor sqlCursor : arrayList) {
            n += sqlCursor.getExecuteMissCount();
        }
        printStream.println("Misses in library cache during execute: " + n);
        Object var13_23 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        String string3 = null;
        for (SqlCursor sqlCursor : arrayList) {
            for (IElapsedEvent iElapsedEvent : sqlCursor.getEvents()) {
                if (!(iElapsedEvent instanceof EventWait)) continue;
                EventWait eventWait = (EventWait)iElapsedEvent;
                string3 = eventWait.getName().intern();
                if (!arrayList2.contains(string3)) {
                    arrayList2.add(string3);
                    hashMap.put(string3 + ".times", new Long(1L));
                    hashMap.put(string3 + ".total", eventWait.getElapsed());
                    hashMap.put(string3 + ".max", eventWait.getElapsed());
                    continue;
                }
                hashMap.put(string3 + ".times", (Long)hashMap.get(string3 + ".times") + 1L);
                hashMap.put(string3 + ".total", (Long)hashMap.get(string3 + ".total") + eventWait.getElapsed());
                if ((Long)hashMap.get(string3 + ".max") >= eventWait.getElapsed()) continue;
                hashMap.put(string3 + ".max", eventWait.getElapsed());
            }
        }
        printStream.println("\nElapsed times include waiting on following events:");
        printStream.println("Event waited on                             Times   Max. Wait  Total Waited");
        printStream.println("----------------------------------------   Waited  ----------  ------------");
        for (String string4 : arrayList2) {
            printStream.println(String.format("%-38s%11d%12.2f%12.2f", string4, hashMap.get(string4 + ".times"), Float.valueOf(SqlTraceUtils.toSec((Long)hashMap.get(string4 + ".max"))), Float.valueOf(SqlTraceUtils.toSec((Long)hashMap.get(string4 + ".total")))));
        }
        printStream.println("********************************************************************************");
    }
}

