/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotHeaderInputHandler;
import oracle.bali.ewt.pivot.PivotScrollPaneView;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabModel;
import oracle.dss.crosstab.CrosstabPivotHeader;

public class CrosstabHeaderInputHandler
extends PivotHeaderInputHandler {
    private static final String m_method_mousemoved = "mouseMoved(MouseEvent e, Grid grid, int column, int row)";
    private static final String m_method_mousepressed = "mousePressed(MouseEvent e, Grid grid, int column, int row)";
    private CrosstabModel _crosstabmodel;
    private Crosstab crosstab;

    public CrosstabHeaderInputHandler(Crosstab crosstab) {
        this.$init$();
        this.crosstab = crosstab;
        this._crosstabmodel = crosstab.getCrosstabModel();
    }

    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        if (column < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_mousepressed);
            return;
        }
        if (row < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_mousepressed);
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        boolean left = SwingUtilities.isLeftMouseButton(e);
        PivotHeader header = this._getHeader(grid);
        AbstractPivotHeaderCell cell = this.getPivotHeaderCell(header, column, row);
        if (cell != null && left) {
            int newRow;
            Point p = this._convertPoint(grid, cell, column, row, e.getX(), e.getY());
            int newColumn = cell.getColumn();
            if (((CrosstabPivotHeader)header).isDrillOut(newColumn, newRow = cell.getRow(), p.x, p.y)) {
                int index;
                int depth;
                int edge;
                int type = 1;
                int imageIndex = ((CrosstabPivotHeader)header).getStyle(column, row).getGraphicImageIndex();
                if (header.getOrientation() == 0) {
                    edge = 0;
                    depth = row;
                    index = column;
                } else {
                    edge = 1;
                    depth = column;
                    index = row;
                }
                this.getCrosstabModel().getGridViewControllerActions().headerDrillOutGestureHappened(this.crosstab, edge, depth, index, type, imageIndex);
            } else {
                super.mousePressed(e, grid, column, row);
            }
        } else if (cell != null && !left) {
            TwoDSelection selection = grid.getSelection();
            if (!selection.containsCell(column, row)) {
                grid.requestFocus();
                try {
                    TwoDSelection sel = new TwoDSelection(column, row);
                    grid.setSelection(sel);
                    grid.setFocusCell(new Cell(column, row));
                }
                catch (PropertyVetoException ex) {}
            }
        } else {
            super.mousePressed(e, grid, column, row);
        }
    }

    public void mouseMoved(MouseEvent e, Grid grid, int column, int row) {
        if (column < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_mousemoved);
            return;
        }
        if (row < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_mousemoved);
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        PivotHeader header = this._getHeader(grid);
        AbstractPivotHeaderCell cell = this.getPivotHeaderCell(header, column, row);
        if (cell != null) {
            int newRow;
            Point p = this._convertPoint(grid, cell, column, row, e.getX(), e.getY());
            int newColumn = cell.getColumn();
            if (((CrosstabPivotHeader)header).isDrillOut(newColumn, newRow = cell.getRow(), p.x, p.y)) {
                grid.setCursor(this.crosstab.getGridViewController().getCursorType(13));
            } else {
                super.mouseMoved(e, grid, column, row);
            }
        } else {
            super.mouseMoved(e, grid, column, row);
        }
    }

    public CrosstabModel getCrosstabModel() {
        return this._crosstabmodel;
    }

    private PivotHeader _getHeader(Grid grid) {
        Container parent = grid.getParent();
        PivotHeader header = null;
        if (parent instanceof PivotHeader) {
            header = (PivotHeader)parent;
        } else if (parent instanceof PivotScrollPaneView) {
            PivotScrollPaneView view = (PivotScrollPaneView)parent;
            PivotTable table = view.getPivotTable();
            header = table.getPivotHeader(view.getOrientation());
        }
        return header;
    }

    private Point _convertPoint(Grid grid, AbstractPivotHeaderCell cell, int column, int row, int x, int y) {
        boolean l2r;
        boolean bl = l2r = grid.getActualReadingDirection() == 1;
        if (!l2r) {
            x = grid.getColumnWidth(cell.getColumn()) - x;
        }
        int cellCol = cell.getColumn();
        while (cellCol < column) {
            x += grid.getColumnWidth(cellCol);
            ++cellCol;
        }
        int cellRow = cell.getRow();
        while (cellRow < row) {
            y += grid.getRowHeight(cellRow);
            ++cellRow;
        }
        return new Point(x, y);
    }

    private AbstractPivotHeaderCell getPivotHeaderCell(PivotHeader header, int column, int row) {
        Object data = header.getGrid().getModel().getData(column, row);
        if (data instanceof AbstractPivotHeaderCell) {
            return (AbstractPivotHeaderCell)data;
        }
        return null;
    }

    private void $init$() {
        this._crosstabmodel = null;
        this.crosstab = null;
    }
}

