/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.util.EventListener;
import oracle.dss.crosstab.ColHeaderData;
import oracle.dss.crosstab.ColumnHeaderPivotHandleData;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabData;
import oracle.dss.crosstab.CrosstabDefaultValues;
import oracle.dss.crosstab.CrosstabModel;
import oracle.dss.crosstab.RowHeaderData;
import oracle.dss.crosstab.RowHeaderPivotHandleData;
import oracle.dss.dataView.DrillEvent;
import oracle.dss.gridView.GridViewModelAdapter;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.SliceOutOfRangeException;

public class CrosstabModelAdapter
extends GridViewModelAdapter
implements CrosstabModel,
Cloneable {
    protected RowHeaderData rowHeaderData;
    protected ColHeaderData colHeaderData;
    protected ColumnHeaderPivotHandleData colHandleData;
    protected RowHeaderPivotHandleData rowHandleData;
    protected boolean enableIndent;
    protected int autoIndent;
    protected boolean ol;
    protected CrosstabData dataSource;
    protected Crosstab crosstab;
    private static final String m_method_setautoindent = "setAutoIndent (int i)";
    private static final String m_method_setsupporteddatalayerflags = "setSupportedDataLayerFlags ()";

    public CrosstabModelAdapter(Crosstab crosstab) {
        super(crosstab);
        this.$init$();
        this.crosstab = crosstab;
    }

    public void setDataSource(DataSource ds) {
        super.setDataSource(ds);
        if (this.dataDirectorFactory != null) {
            this.setDataDirector((DataDirector)this.dataDirectorFactory.createCubeDataDirector());
        }
    }

    protected void setSupportedDataLayerFlags() {
        super.setSupportedDataLayerFlags();
        MetadataMap metaMap = this.getDataDirector().getSupportedMetadataMap();
        LayerMetadataMap layerMap = this.getDataDirector().getSupportedLayerMetadataMap();
        boolean typeSupported = false;
        typeSupported = metaMap != null ? metaMap.contains((Object)"hierLevel") : false;
        this.crosstab.setMetadataIndentSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"relIndent") : false;
        this.crosstab.setMetadataRelIndentSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"isTotal") : false;
        this.crosstab.setMetadataIsTotalSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"dimDrillState") : false;
        this.crosstab.setLayerMetaDrillStateSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"dimIsMeasure") : false;
        this.crosstab.setLayerMetaMeasureSupported(typeSupported);
    }

    public ColHeaderData getColumnDataSource() {
        return this.colHeaderData;
    }

    public RowHeaderData getRowDataSource() {
        return this.rowHeaderData;
    }

    public CrosstabData getCrosstabDataSource() {
        return this.dataSource;
    }

    public RowHeaderPivotHandleData getRowHeaderHandleDataSource() {
        return this.rowHandleData;
    }

    public ColumnHeaderPivotHandleData getColumnHeaderHandleDataSource() {
        return this.colHandleData;
    }

    public void newRowPivotHandleDataSource() {
        try {
            this.rowHandleData = this.crosstab.getCrosstabModel().isRowHeaderVisible() ? new RowHeaderPivotHandleData(this, this.crosstab) : null;
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
    }

    public void newColumnPivotHandleDataSource() {
        try {
            this.colHandleData = this.crosstab.getCrosstabModel().isColumnHeaderVisible() ? new ColumnHeaderPivotHandleData(this, this.crosstab) : null;
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
    }

    public void newRowDataSource() {
        this.rowHeaderData = this.crosstab.getCrosstabModel().isRowHeaderVisible() ? new RowHeaderData(this.crosstab) : null;
    }

    public void newColDataSource() {
        this.colHeaderData = this.crosstab.getCrosstabModel().isColumnHeaderVisible() ? new ColHeaderData(this.crosstab) : null;
    }

    public void newDataSource() {
        this.dataSource = new CrosstabData(this, this.crosstab);
        super.setGridViewDataSource(this.dataSource);
    }

    public void setIndentEnabled(boolean b) {
        if (this.enableIndent != b) {
            this.enableIndent = b;
            this.clearMetadataCache();
        }
    }

    public boolean isIndentEnabled() {
        return this.enableIndent;
    }

    public void setAutoIndent(int i) {
        if (i < 0) {
            this.getErrorHandler().log("invalid number of spaces", this.getClass().getName(), m_method_setautoindent);
        } else if (this.autoIndent != i) {
            this.autoIndent = i;
            this.clearMetadataCache();
        }
    }

    public int getAutoIndent() {
        return this.autoIndent;
    }

    public Object clone() throws CloneNotSupportedException {
        CrosstabModelAdapter cma = new CrosstabModelAdapter(this.crosstab);
        Object[] o = this.listenerList.getListenerList();
        int l = 2;
        while (l < o.length) {
            cma.listenerList.add((Class)o[l], (EventListener)o[l + 1]);
            l += 2;
        }
        return cma;
    }

    public boolean drillGestureHappened(Object source, int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        if (slice == -2) {
            DrillEvent e = new DrillEvent(source, edge, layer, slice, flags);
            this.fireviewDrillRequesting(e);
            if (e.isConsumed()) {
                return false;
            }
            this.fireviewDrillRequested(e);
            return true;
        }
        return super.drillGestureHappened(source, edge, layer, slice, flags);
    }

    public boolean canDrill(Object source, int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        if (slice < 0) {
            return true;
        }
        return super.canDrill(source, edge, layer, slice, flags);
    }

    public void setOutline(boolean outline) {
        this.ol = outline;
    }

    public boolean isOutline() {
        return this.ol;
    }

    public boolean isRowHeaderVisible() {
        try {
            boolean bl = this.getDataAccess().getLayerCount(1) > 0 && this.getDataAccess().getEdgeExtent(1) > 0;
            return bl;
        }
        catch (EdgeOutOfRangeException e) {
            this.crosstab.getErrorHandler().error((Throwable)e, this.getClass().getName(), "isRowHeaderVisible");
            return false;
        }
    }

    public boolean isColumnHeaderVisible() {
        try {
            boolean bl = this.getDataAccess().getLayerCount(0) > 0 && this.getDataAccess().getEdgeExtent(0) > 0;
            return bl;
        }
        catch (EdgeOutOfRangeException e) {
            this.crosstab.getErrorHandler().error((Throwable)e, this.getClass().getName(), "isColumnHeaderVisible");
            return false;
        }
    }

    public LayerMetadataMap getLayerMetadataMap(int edge) {
        String[] types = new String[]{"dimName", "dimLongName", "dimMediumName", "dimShortName", "dimDrillState", "dimIsMeasure", "viewStyle"};
        return new LayerMetadataMap(types);
    }

    public MetadataMap getMetadataMap(int edge) {
        String[] types = new String[]{"value", "longName", "mediumName", "shortName", "hierLevel", "relIndent", "drillState", "viewStyle", "isTotal"};
        return new MetadataMap(types);
    }

    public DataMap getDataMap() {
        String[] types = new String[]{"dataValue", "dataFormattedValue", "dataRatio", "dataViewFormat", "dataViewStyle", "dataAnnotation", "dataIsTotal", "dataType"};
        return new DataMap(types);
    }

    private void $init$() {
        this.rowHeaderData = null;
        this.colHeaderData = null;
        this.colHandleData = null;
        this.rowHandleData = null;
        this.enableIndent = CrosstabDefaultValues.isIndentEnabled();
        this.autoIndent = CrosstabDefaultValues.getAutoIndent();
        this.ol = CrosstabDefaultValues.isOutline();
        this.dataSource = null;
        this.crosstab = null;
    }
}

