/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.beans.BeanInfo;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.header.NullInputHandler;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotHeaderGridSelectionManager;
import oracle.bali.ewt.pivot.PivotScrollPaneView;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabHeaderCell;
import oracle.dss.crosstab.CrosstabHeaderInputHandler;
import oracle.dss.crosstab.CrosstabTips;
import oracle.dss.crosstab.HeaderAutoScroller;
import oracle.dss.crosstab.HeaderPainter;
import oracle.dss.crosstab.PivotHandleCell;
import oracle.dss.crosstab.RowPivotHeader;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.dataView.managers.ViewStyleCallback;
import oracle.dss.gridView.GridViewHeader;
import oracle.dss.gridView.GridViewHeaderAttributes;
import oracle.dss.gridView.GridViewHeaderXML;
import oracle.dss.gridView.GridViewWrappingTextPainter;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.xml.ObjectNode;

public abstract class CrosstabPivotHeader
extends PivotHeader
implements GridViewHeader,
ViewStyleCallback,
GridViewHeaderAttributes {
    private static final boolean DEBUG = false;
    protected Crosstab crosstab;
    private transient Hashtable metadataCache;
    protected HeaderAppMgr ham;
    protected ViewStyle defaultViewStyle;
    private Image blankImage;
    private Image unscaledBlankImage;
    private transient DataComponentInfo info;
    protected CrosstabTips tips;
    protected int colDropIndex;
    protected int colDragIndex;
    protected int rowDropIndex;
    protected int rowDragIndex;
    protected int swapRow;
    protected int swapColumn;
    protected boolean currentIndexUsed;
    private boolean swapping;
    private boolean mouseReleased;
    private String prevString;
    private String dragString;
    private String nextString;
    private static final int _PIVOT_FEEDBACK_SIZE = 4;
    private static final int _PIVOT_SIZE = 6;
    private ResourceBundle gBundle;
    private ResourceBundle cBundle;
    public static final int MAX_DIMENSIONS = 500;
    private static final String m_method_styleChanged = "styleChanged(int attributeId, String attributeName, Object oldValue, Object newValue)";
    private static final String m_method_updateforpropset = "updateForPropSet(BitSet bs)";
    private static final String m_method_getdrillimage = "getDrillImage(int column, int row)";
    private static final String m_method_isdrill = "isDrill(int column, int row, int x, int y)";
    private static final String m_method_isdrillout = "isDrillOut(int column, int row, int x, int y)";
    private static final String m_method_getcrosstabpivotheadercell = "getCrosstabPivotHeaderCell(int column, int row)";
    private static final String m_method_getgraphicimage = "getGraphicImage(int column, int row)";
    private GridViewHeaderXML _viewHeaderXML;

    public CrosstabPivotHeader(Crosstab ct, TwoDModel ds, int orientation) {
        super(ds, orientation);
        this.$init$();
        this.crosstab = ct;
        this.updateResourceBundle(this.crosstab.getLocale());
        this.metadataCache = new Hashtable();
        this.setPainter((Painter)new HeaderPainter(this));
        Header header = this.isHorizontal() ? this.getRowHeader() : this.getColumnHeader();
        this.setAxisLabelPainter((Painter)new EnhancedTextPainter());
        this.setKeepHeaderCellsVisible(true);
        this.defaultViewStyle = new ViewStyle((DataviewCommon)this.crosstab, this.getDefaultAppearance());
        this.defaultViewStyle.setViewStyleCallback(this);
        this.ham = new HeaderAppMgr(ct);
        this.setAppearanceManager(this.ham);
        this.getGrid().setSelectionTransparent(true);
        header.setSelectionTransparent(true);
        this.getGrid().setDrawSelectionBorder(true);
        header.setDrawSelectionBorder(true);
        this.getGrid().setGridSelectionManager((GridSelectionManager)new PivotHeaderGridSelectionManager(this.getGrid(), 2, 2, this.isHorizontal()));
        header.setHeaderSelectionManager((HeaderSelectionManager)new GeneralHeaderSelectionManager(2));
        PivotHeaderMotionListener listener = new PivotHeaderMotionListener(null);
        this.getGrid().addMouseMotionListener((MouseMotionListener)listener);
        this.getGrid().addMouseListener((MouseListener)listener);
        CrosstabHeaderInputHandler cthandler = new CrosstabHeaderInputHandler(this.crosstab);
        this.setInputHandler((CellInputHandler)cthandler);
        PivotHandleInputHandler pivotHandler = new PivotHandleInputHandler(header.getItemInputHandler());
        header.setItemInputHandler((HeaderItemInputHandler)pivotHandler);
        this._viewHeaderXML = new GridViewHeaderXML(this);
    }

    public void setPainter(Painter painter) {
        this.getGrid().setDefaultPainter(painter);
    }

    public Painter getPainter() {
        return this.getGrid().getDefaultPainter();
    }

    public ViewStyle getViewStyle() {
        return this.defaultViewStyle;
    }

    public void setViewStyle(ViewStyle vs) {
        if (vs == null) {
            this.crosstab.getErrorHandler().log("invalid ViewStyle", this.getClass().getName(), "setViewStyle");
            return;
        }
        ViewStyle oldval = this.defaultViewStyle;
        this.defaultViewStyle = new ViewStyle((DataviewCommon)this.crosstab, vs);
        this.defaultViewStyle.setViewStyleCallback(this);
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(oldval, this.defaultViewStyle));
        if (!this.isHorizontal()) {
            this.crosstab.setDefaultCornerComponentColor(this.defaultViewStyle.getBackground());
        }
        this.crosstab.firePropertyChange(this, "ViewStyle", oldval, this.defaultViewStyle);
    }

    public void styleChanged(int attributeId, String attributeName, Object oldValue, Object newValue) {
        if (attributeId < 0 || attributeId > 37) {
            this.crosstab.getErrorHandler().log("invalid view style attribute", this.getClass().getName(), m_method_styleChanged);
            return;
        }
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(attributeId));
        this.crosstab.firePropertyChange(this, attributeName, oldValue, newValue);
    }

    protected void updateForPropSet(BitSet bs) {
        if (bs == null) {
            this.crosstab.getErrorHandler().log("invalid bit set", this.getClass().getName(), m_method_updateforpropset);
            return;
        }
        this.propSet();
        if (bs.get(0) && !this.isHorizontal()) {
            this.crosstab.setDefaultCornerComponentColor(this.getViewStyle().getBackground());
        }
        if (bs.get(3) || bs.get(4) || bs.get(6) || bs.get(26) || bs.get(28) || bs.get(8) || bs.get(18)) {
            if (this.isHorizontal()) {
                this.crosstab.updateColumnWidth();
            } else {
                this.crosstab.updateRowHeaderWidths();
            }
        }
        if (bs.get(1) || bs.get(3) || bs.get(4) || bs.get(5) || bs.get(6) || bs.get(27) || bs.get(26) || bs.get(28) || bs.get(25) || bs.get(8) || bs.get(7) || bs.get(16) || bs.get(18)) {
            if (this.isHorizontal()) {
                this.crosstab.updateColumnHeaderRowHeights();
            } else {
                this.crosstab.updateRowHeights();
            }
            this.crosstab.updatePivotHandleSize();
        }
        this.crosstab.repaint();
    }

    public BeanInfo getBeanInfo() {
        return null;
    }

    public boolean isHorizontal() {
        return this.getOrientation() == 0;
    }

    public void clearCache() {
        if (this.metadataCache != null) {
            this.metadataCache.clear();
        }
        this.refreshPivotHandleStyle();
    }

    Image getBlankImage() {
        if (this.unscaledBlankImage == null) {
            this.createUnscaledBlankImage();
        }
        return this.unscaledBlankImage;
    }

    Image getScaledBlankImage() {
        if (!this.crosstab.isImagesScaled()) {
            return this.getBlankImage();
        }
        if (this.blankImage == null) {
            this.createBlankImage();
        }
        return this.blankImage;
    }

    protected void propSet() {
        this.crosstab.getCrosstabModel().getGridViewHeaderStyleManager().metadataStyleChanged();
        this.clearCache();
    }

    public Appearance getDefaultAppearance() {
        Appearance app = ((Appearance)UIManager.get("PivotHeader.DefaultAppearance")).copy();
        app.setInsets(new ImmInsets(1, 0, 1, 0));
        app.setForeground(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
        app.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        if (this.isHorizontal()) {
            app.setHorizontalJustify(3);
        } else {
            app.setHorizontalJustify(0);
        }
        app.setVerticalJustify(1);
        return app;
    }

    protected void setZoomFactor(int zoom) {
        this.createBlankImage();
    }

    protected Image getAxisLabelDrillImage(int layer) {
        return this.getAxisLabelDrillImage(layer, true);
    }

    protected Image getAxisLabelDrillImage(int layer, boolean scaled) {
        PivotHandleCell cell;
        boolean bl = scaled = scaled && this.crosstab.isImagesScaled();
        if (layer < 0) {
            this.crosstab.getErrorHandler().log("invalid layer", this.getClass().getName(), "protected Image getAxisLabelDrillImage(int layer, boolean scaled)");
            return null;
        }
        int edge = 0;
        if (!this.isHorizontal()) {
            edge = 1;
        }
        if (!(this.crosstab.isDrillingEnabled() && this.crosstab.isEnabled() && this.crosstab.isPivotHandleDrillIconVisible(edge))) {
            return null;
        }
        if (this.blankImage == null) {
            this.createBlankImage();
        }
        if (this.unscaledBlankImage == null) {
            this.createUnscaledBlankImage();
        }
        if ((cell = (PivotHandleCell)((Object)this.getAxisLabelModel().getData(layer))) != null) {
            int drillState = cell.getDrillState();
            if (drillState == 0) {
                if (scaled) {
                    return this.blankImage;
                }
                return this.unscaledBlankImage;
            }
            if (scaled) {
                return this.crosstab.getScaledDrillImage(drillState);
            }
            return this.crosstab.getDrillImage(drillState);
        }
        if (scaled) {
            return this.blankImage;
        }
        return this.unscaledBlankImage;
    }

    protected Cursor getAxisLabelDrillCursor(int levelIndex) {
        PivotHandleCell cell;
        Header header = null;
        header = this.isHorizontal() ? this.getRowHeader() : this.getColumnHeader();
        OneDModel model = header.getModel();
        Object obj = model.getData(levelIndex);
        if (obj != null && obj instanceof PivotHandleCell && (cell = (PivotHandleCell)((Object)obj)).getDrillState() == 0) {
            return header.getCursor();
        }
        return super.getAxisLabelDrillCursor(levelIndex);
    }

    protected boolean isDrilledOrDrillable(int column, int row) {
        if (this instanceof RowPivotHeader) {
            return true;
        }
        boolean drilledOrDrillable = true;
        CrosstabHeaderCell cell = (CrosstabHeaderCell)this.getModel().getData(column, row);
        if (cell == null) {
            drilledOrDrillable = false;
        } else {
            int drillState = cell.getDrillState();
            switch (drillState) {
                case 0: {
                    drilledOrDrillable = false;
                }
            }
        }
        return drilledOrDrillable;
    }

    protected Image getDrillImage(int column, int row) {
        return this.getDrillImage(column, row, true);
    }

    protected Image getDrillImage(int column, int row, boolean scaled) {
        CrosstabHeaderCell cell;
        boolean bl = scaled = scaled && this.crosstab.isImagesScaled();
        if (column < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getdrillimage);
            return null;
        }
        if (row < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getdrillimage);
            return null;
        }
        if (!this.crosstab.isDrillingEnabled() || !this.crosstab.isEnabled() || !this.isDrilledOrDrillable(column, row) || this.crosstab.isPrintOrPreviewMode()) {
            return null;
        }
        if (this.blankImage == null) {
            this.createBlankImage();
        }
        if (this.unscaledBlankImage == null) {
            this.createUnscaledBlankImage();
        }
        if ((cell = (CrosstabHeaderCell)this.getModel().getData(column, row)) != null) {
            int drillState = cell.getDrillState();
            switch (drillState) {
                case 0: {
                    if (scaled) {
                        return this.blankImage;
                    }
                    return this.unscaledBlankImage;
                }
            }
            if (scaled) {
                return this.crosstab.getScaledDrillImage(drillState);
            }
            return this.crosstab.getDrillImage(drillState);
        }
        if (scaled) {
            return this.blankImage;
        }
        return this.unscaledBlankImage;
    }

    protected boolean isDrill(int column, int row, int x, int y) {
        if (column < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_isdrill);
            return false;
        }
        if (row < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_isdrill);
            return false;
        }
        boolean drill = false;
        Image image = this.getDrillImage(column, row);
        if (image == this.blankImage) {
            return drill;
        }
        if (image != null) {
            int xMax;
            int xMin;
            int width = image.getWidth((ImageObserver)((Object)this));
            int height = image.getHeight((ImageObserver)((Object)this));
            ViewStyle app = this.getStyle(column, row);
            ImmInsets insets = app.getInsets();
            Grid grid = this.getGrid();
            AbstractPivotHeaderCell cell = this.getCrosstabPivotHeaderCell(column, row);
            Rectangle cellBounds = AbstractPivotHeaderCell.getCellBounds((Grid)grid, (int)column, (int)row);
            int rowHeight = cellBounds.height;
            float align = grid.getCellPaintContext(column, row).getInteriorAlignmentY();
            boolean l2r = true;
            if (this.getKeepHeaderCellsVisible() && cell != null && this.getParent() != null) {
                int rowPos;
                Point p = this.getParent().getLocation();
                int columnPos = this.getGrid().getColumnPosition(column);
                if (l2r) {
                    if (columnPos < -p.x) {
                        x -= -p.x - columnPos;
                    }
                } else {
                    int colWidth = 0;
                    colWidth = !this.isHorizontal() && this.isOutline() ? this.getColumnWidth(cell.getIndent()) : this.getColumnWidth(column);
                    if (columnPos + colWidth + p.x > this.getParent().getParent().getWidth()) {
                        x += columnPos + colWidth + p.x - this.getParent().getParent().getWidth();
                    }
                }
                if ((rowPos = this.getGrid().getRowPosition(row)) < -p.y) {
                    y -= -p.y - rowPos;
                }
                Point pointOnGrid = grid.convertCanvasToOuter(columnPos, rowPos);
                Rectangle rect = new Rectangle(pointOnGrid.x, pointOnGrid.y, cellBounds.width, cellBounds.height);
                rect = rect.intersection(grid.getVisibleRect());
                rowHeight = rect.height;
            }
            if (l2r) {
                xMin = insets.left;
                xMax = insets.left + width;
            } else {
                int colWidth = 0;
                colWidth = !this.isHorizontal() && this.isOutline() ? this.getWidth() : this.getColumnWidth(column);
                xMin = colWidth - insets.right - width;
                xMax = colWidth - insets.right;
            }
            Font f = app.getFont();
            int fontSize = 0;
            if (f == null) {
                f = this.getFont();
            }
            if (f != null) {
                fontSize = this.getFontMetrics(f).getHeight();
            }
            if (rowHeight < fontSize) {
                rowHeight = fontSize;
            }
            y = (int)((float)y - ((float)(rowHeight - insets.top - insets.bottom - fontSize) * align + (float)((fontSize - height) / 2)));
            drill = x >= xMin && x <= xMax && (y -= insets.top) >= 0 && y <= height;
        }
        return drill;
    }

    protected boolean isDrillOut(int column, int row, int x, int y) {
        if (column < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_isdrillout);
            return false;
        }
        if (row < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_isdrillout);
            return false;
        }
        boolean drillOut = false;
        Image image = this.getScaledBlankImage();
        Image drillImage = this.getDrillImage(column, row);
        Image gImage = this.getGraphicImage(column, row);
        int width = 0;
        if (image != null && drillImage != null) {
            width = image.getWidth((ImageObserver)((Object)this)) + 1;
        }
        ViewStyle app = this.getStyle(column, row);
        ImmInsets insets = app.getInsets();
        int columnPos = 0;
        AbstractPivotHeaderCell cell = this.getCrosstabPivotHeaderCell(column, row);
        Grid grid = this.getGrid();
        Rectangle cellBounds = AbstractPivotHeaderCell.getCellBounds((Grid)grid, (int)column, (int)row);
        int rowHeight = cellBounds.height;
        float align = grid.getCellPaintContext(column, row).getInteriorAlignmentY();
        boolean l2r = true;
        if (gImage != null) {
            int xMax;
            int xMin;
            if (this.getKeepHeaderCellsVisible() && cell != null && this.getParent() != null) {
                int rowPos;
                Point p = this.getParent().getLocation();
                columnPos = this.getGrid().getColumnPosition(column);
                if (!this.isHorizontal() && this.isOutline()) {
                    columnPos = this.getGrid().getColumnPosition(cell.getIndent());
                }
                if (l2r) {
                    if (columnPos < -p.x) {
                        x -= -p.x - columnPos;
                    }
                } else {
                    int colWidth = 0;
                    colWidth = !this.isHorizontal() && this.isOutline() ? this.getColumnWidth(cell.getIndent()) : this.getColumnWidth(column);
                    if (columnPos + colWidth + p.x > this.getParent().getParent().getWidth()) {
                        x += columnPos + colWidth + p.x - this.getParent().getParent().getWidth();
                    }
                }
                if ((rowPos = this.getGrid().getRowPosition(row)) < -p.y) {
                    y -= -p.y - rowPos;
                }
                Point pointOnGrid = grid.convertCanvasToOuter(columnPos, rowPos);
                Rectangle rect = new Rectangle(pointOnGrid.x, pointOnGrid.y, cellBounds.width, cellBounds.height);
                rect = rect.intersection(grid.getVisibleRect());
                rowHeight = rect.height;
            }
            int gWidth = gImage.getWidth((ImageObserver)((Object)this));
            int gHeight = gImage.getHeight((ImageObserver)((Object)this));
            if (l2r) {
                if (!this.isHorizontal() && this.isOutline()) {
                    width += columnPos;
                }
                xMin = width + insets.left;
                xMax = width + insets.left + gWidth;
            } else {
                int colWidth = 0;
                if (!this.isHorizontal() && this.isOutline()) {
                    colWidth = cell != null ? this.getColumnWidth(cell.getIndent()) : this.getColumnWidth(column);
                    colWidth += columnPos;
                } else {
                    colWidth = this.getColumnWidth(column);
                }
                xMin = colWidth - insets.right - width - gWidth;
                xMax = colWidth - insets.right - width;
            }
            Font f = app.getFont();
            int fontSize = 0;
            if (f == null) {
                f = this.getFont();
            }
            if (f != null) {
                fontSize = this.getFontMetrics(f).getHeight();
            }
            if (rowHeight < fontSize) {
                rowHeight = fontSize;
            }
            y = (int)((float)y - ((float)(rowHeight - insets.top - insets.bottom - fontSize) * align + (float)((fontSize - gHeight) / 2)));
            drillOut = x >= xMin && x <= xMax && (y -= insets.top) >= 0 && y <= gHeight;
        }
        return drillOut;
    }

    AbstractPivotHeaderCell getCrosstabPivotHeaderCell(int column, int row) {
        if (column < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getcrosstabpivotheadercell);
            return null;
        }
        if (row < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getcrosstabpivotheadercell);
            return null;
        }
        Object data = this.getGrid().getModel().getData(column, row);
        if (data instanceof AbstractPivotHeaderCell) {
            return (AbstractPivotHeaderCell)data;
        }
        return null;
    }

    protected Image getGraphicImage(int column, int row) {
        return this.getGraphicImage(column, row, true);
    }

    protected Image getGraphicImage(int column, int row, boolean scaled) {
        boolean bl = scaled = scaled && this.crosstab.isImagesScaled();
        if (column < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getgraphicimage);
            return null;
        }
        if (row < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getgraphicimage);
            return null;
        }
        int index = this.getStyle(column, row).getGraphicImageIndex();
        if (index >= 0 && index < this.crosstab.getGraphicImageCount()) {
            if (scaled) {
                return this.crosstab.getScaledGraphicImage(index);
            }
            return this.crosstab.getGraphicImage(index);
        }
        return null;
    }

    protected void drawEnhancedFont(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX) {
        int stringWidth;
        ViewStyle app = (ViewStyle)context.getPaintData(Header.KEY_APPEARANCE);
        if (alignmentX != 0.0f && (stringWidth = metrics.stringWidth(text)) < availableWidth) {
            x = (int)((float)x + (float)(availableWidth - stringWidth) * alignmentX);
        }
        if (app.isUnderline()) {
            g.drawLine(x, y + 2, x + metrics.stringWidth(text), y + 2);
        } else if (app.isDoubleUnderline()) {
            g.drawLine(x, y + 2, x + metrics.stringWidth(text), y + 2);
            g.drawLine(x, y + 4, x + metrics.stringWidth(text), y + 4);
        }
        if (app.isStrikeThrough()) {
            g.drawLine(x, y - metrics.getAscent() / 2 + 1, x + metrics.stringWidth(text), y - metrics.getAscent() / 2 + 1);
        }
    }

    protected abstract int getEdge();

    protected abstract int getDepth(int var1, int var2);

    protected abstract int getIndex(int var1, int var2);

    protected abstract void refreshPivotHandleStyle();

    protected HeaderPainter getHeaderPainter() {
        return (HeaderPainter)this.getGrid().getDefaultPainter();
    }

    protected int getDragIndex(Point p, boolean inHeader) {
        this.crosstab.getPivotTable().setReorderRow(-1);
        this.crosstab.getPivotTable().setReorderCol(-1);
        if (this.crosstab.getReorderType() != 1) {
            return super.getDragIndex(p, inHeader);
        }
        if (inHeader) {
            return super.getDragIndex(p, inHeader);
        }
        Grid grid = this.getGrid();
        if (grid.getRowCount() == 0 || grid.getColumnCount() == 0) {
            return -1;
        }
        int column = grid.getColumnAt(p.x);
        int row = grid.getRowAt(p.y);
        if (column == -1 || row == -1) {
            return super.getDragIndex(p, inHeader);
        }
        AbstractBigCell cell = AbstractBigCell.getBigCell((Grid)grid, (int)column, (int)row);
        if (cell == null) {
            return super.getDragIndex(p, inHeader);
        }
        row = cell.getRow();
        if (this.isHorizontal()) {
            column = cell.getColumn();
        } else if (this.isOutline() && cell instanceof AbstractPivotHeaderCell) {
            AbstractPivotHeaderCell a = (AbstractPivotHeaderCell)cell;
            column = a.getColumn() + a.getIndent();
        } else {
            column = cell.getColumn();
        }
        EdgeComponentInfo info = new EdgeComponentInfo(this.getEdge(), this.getDepth(column, row), this.getIndex(column, row));
        QDR qdr = info.getQDR(this.crosstab.getCrosstabModel().getDataAccess(), 0);
        String layerName = null;
        if (this.crosstab.isLayerMetaNameSupported()) {
            try {
                Object layerMetadata = this.crosstab.getCrosstabModel().getDataAccess().getLayerMetadata(this.getEdge(), this.getDepth(column, row), "dimName");
                layerName = layerMetadata.toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (qdr != null && qdr.getDimMember(qdr.getMeasureDim()) != null && layerName != null && qdr.getMeasureDim().equals(layerName)) {
            if (this.isHorizontal()) {
                this.colDragIndex = column;
                this.crosstab.getPivotTable().setReorderRow(row);
                return this.colDragIndex + 500;
            }
            this.rowDragIndex = row;
            this.crosstab.getPivotTable().setReorderCol(column);
            if (this.isOutline()) {
                this.extractAdjacentElements(this.rowDragIndex, column);
            }
            return this.rowDragIndex + 500;
        }
        return super.getDragIndex(p, inHeader);
    }

    protected int getDropIndex(Point p, boolean inHeader, boolean isSwap) {
        if (this.crosstab.getReorderType() != 1) {
            return super.getDropIndex(p, inHeader, isSwap);
        }
        if (inHeader) {
            return super.getDropIndex(p, inHeader, isSwap);
        }
        if (this.isHorizontal() && this.crosstab.getPivotTable().getReorderRow() == -1 || !this.isHorizontal() && this.crosstab.getPivotTable().getReorderCol() == -1) {
            return super.getDropIndex(p, inHeader, isSwap);
        }
        Grid grid = this.getGrid();
        if (grid.getRowCount() == 0 || grid.getColumnCount() == 0) {
            return super.getDropIndex(p, inHeader, isSwap);
        }
        boolean l2r = this.getActualReadingDirection() == 1;
        int column = grid.getColumnAt(p.x);
        int row = grid.getRowAt(p.y);
        if (column == -1 || row == -1) {
            return super.getDropIndex(p, inHeader, isSwap);
        }
        AbstractPivotHeaderCell cell = (AbstractPivotHeaderCell)AbstractPivotHeaderCell.getBigCell((Grid)grid, (int)column, (int)row);
        if (cell == null) {
            return super.getDragIndex(p, inHeader);
        }
        row = cell.getRow();
        if (this.isHorizontal()) {
            column = cell.getColumn();
        } else if (this.isOutline() && cell instanceof AbstractPivotHeaderCell) {
            AbstractPivotHeaderCell a = cell;
            column = a.getColumn() + a.getIndent();
        } else {
            column = cell.getColumn();
        }
        EdgeComponentInfo info = new EdgeComponentInfo(this.getEdge(), this.getDepth(column, row), this.getIndex(column, row));
        QDR qdr = info.getQDR(this.crosstab.getCrosstabModel().getDataAccess(), 0);
        String layerName = null;
        if (this.crosstab.isLayerMetaNameSupported()) {
            try {
                Object layerMetadata = this.crosstab.getCrosstabModel().getDataAccess().getLayerMetadata(this.getEdge(), this.getDepth(column, row), "dimName");
                layerName = layerMetadata.toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (qdr == null) {
            return super.getDropIndex(p, inHeader, isSwap);
        }
        if (qdr.getDimMember(qdr.getMeasureDim()) == null || layerName == null || !qdr.getMeasureDim().equals(layerName)) {
            return super.getDropIndex(p, inHeader, isSwap);
        }
        int prevIndex = -1;
        if (this.isHorizontal()) {
            this.colDropIndex = column;
            if (!this.swapping) {
                AbstractBigCell cell2;
                int startCol = cell.getColumn();
                int startx = this.getGrid().getColumnPosition(startCol);
                Rectangle rect = AbstractBigCell.getCellBounds((Grid)grid, (int)column, (int)row);
                if (l2r) {
                    if (p.x > startx + rect.width / 2) {
                        this.colDropIndex = this.colDropIndex + (cell.getColumnCount() - 1) + 1;
                    }
                } else if (p.x < startx + rect.width / 2) {
                    this.colDropIndex = this.colDropIndex + (cell.getColumnCount() - 1) + 1;
                }
                if (this.colDropIndex > 0 && this.colDragIndex == (prevIndex = (cell2 = AbstractBigCell.getBigCell((Grid)grid, (int)(this.colDropIndex - 1), (int)row)).getColumn())) {
                    this.colDropIndex = this.colDragIndex;
                }
            }
            int colIndex = this.colDropIndex;
            if (this.colDropIndex == grid.getColumnCount()) {
                --colIndex;
                prevIndex = -1;
            }
            if (this.checkParentPath(this.swapping, this.colDragIndex, colIndex, prevIndex, this.crosstab.getPivotTable().getReorderRow())) {
                return this.colDropIndex + 500;
            }
        } else {
            this.rowDropIndex = row;
            if (!this.swapping) {
                AbstractPivotHeaderCell cell2;
                AbstractPivotHeaderCell cell3;
                AbstractBigCell cell22;
                int startRow = cell.getRow();
                int starty = this.getGrid().getRowPosition(startRow);
                Rectangle rect = AbstractBigCell.getCellBounds((Grid)grid, (int)column, (int)row);
                if (p.y > starty + rect.height / 2) {
                    this.rowDropIndex = this.rowDropIndex + (cell.getRowCount() - 1) + 1;
                }
                if (this.rowDropIndex > 0 && this.rowDragIndex == (prevIndex = (cell22 = AbstractBigCell.getBigCell((Grid)grid, (int)column, (int)(this.rowDropIndex - 1))).getRow())) {
                    this.rowDropIndex = this.rowDragIndex;
                }
                if (this.isOutline() && this.rowDropIndex != grid.getRowCount() && (cell3 = (AbstractPivotHeaderCell)AbstractPivotHeaderCell.getBigCell((Grid)grid, (int)column, (int)this.rowDropIndex)).getIndent() != this.crosstab.getPivotTable().getReorderCol() && (cell2 = (AbstractPivotHeaderCell)AbstractPivotHeaderCell.getBigCell((Grid)grid, (int)column, (int)(this.rowDropIndex - 1))).getIndent() != this.crosstab.getPivotTable().getReorderCol()) {
                    return super.getDropIndex(p, inHeader, isSwap);
                }
            }
            int rowIndex = this.rowDropIndex;
            if (this.rowDropIndex == grid.getRowCount()) {
                --rowIndex;
                prevIndex = -1;
            }
            if (this.checkParentPath(this.swapping, this.rowDragIndex, rowIndex, prevIndex, this.crosstab.getPivotTable().getReorderCol())) {
                if (this.isOutline() && !this.swapping) {
                    if (this.rowDropIndex == grid.getRowCount()) {
                        return this.rowDropIndex + 500;
                    }
                    if (this.isValidDrop(column, this.rowDragIndex, rowIndex, prevIndex)) {
                        return this.rowDropIndex + 500;
                    }
                } else {
                    return this.rowDropIndex + 500;
                }
            }
        }
        return super.getDropIndex(p, inHeader, isSwap);
    }

    private boolean isValidDrop(int depth, int rowDragIndex, int rowIndex, int prevIndex) {
        try {
            DataAccess dataAccess = this.crosstab.getCrosstabModel().getDataAccess();
            Object dropObj = null;
            if (this.crosstab.isMetadataValueSupported()) {
                if (this.currentIndexUsed) {
                    dropObj = dataAccess.getMemberMetadata(this.getEdge(), depth, rowIndex, "value");
                } else if (prevIndex != -1) {
                    dropObj = dataAccess.getMemberMetadata(this.getEdge(), depth, prevIndex, "value");
                }
            }
            if (this.prevString == null && this.nextString == null || dropObj == null) {
                boolean bl = false;
                return bl;
            }
            String dropStr = null;
            if (dropObj != null) {
                dropStr = dropObj.toString();
            }
            if (this.prevString == null) {
                if (this.currentIndexUsed && this.nextString.equals(dropStr)) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            if (this.nextString == null) {
                if (!this.currentIndexUsed && this.prevString.equals(dropStr)) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            if (this.currentIndexUsed && this.nextString.equals(dropStr)) {
                boolean bl = false;
                return bl;
            }
            if (!this.currentIndexUsed && this.prevString.equals(dropStr)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (DataException exception) {
            boolean bl = false;
            return bl;
        }
    }

    private void extractAdjacentElements(int dragIndex, int depth) {
        if (this.crosstab.isMetadataValueSupported()) {
            try {
                DataAccess dataAccess = this.crosstab.getCrosstabModel().getDataAccess();
                Object dragObj = dataAccess.getMemberMetadata(this.getEdge(), depth, dragIndex, "value");
                String dragStr = null;
                if (dragObj == null) {
                    return;
                }
                dragStr = dragObj.toString();
                int[] array = this.crosstab.getCrosstabModel().getDataAccess().getMemberHPos(this.getEdge(), depth, dragIndex);
                int dimensionCount = -1;
                dimensionCount = dataAccess.getMemberSiblingCount(this.getEdge(), array, depth);
                this.prevString = null;
                this.dragString = null;
                this.nextString = null;
                int i = 0;
                while (i < dimensionCount) {
                    Object obj = dataAccess.getMemberMetadata(this.getEdge(), array, depth, i, "value");
                    if (obj != null) {
                        String str = obj.toString();
                        if (str.equals(dragStr)) {
                            this.dragString = str;
                            if (++i < dimensionCount) {
                                Object nextObject = dataAccess.getMemberMetadata(this.getEdge(), array, depth, i, "value");
                                this.nextString = nextObject != null ? nextObject.toString() : null;
                            }
                            break;
                        }
                        this.prevString = str;
                    }
                    ++i;
                }
            }
            catch (DataException exception) {
                // empty catch block
            }
        }
    }

    private boolean checkParentPath(boolean swapping, int dragIndex, int dropIndex, int prevIndex, int depth) {
        this.currentIndexUsed = true;
        int[] dragArray = null;
        int[] dropArray = null;
        try {
            dragArray = this.crosstab.getCrosstabModel().getDataAccess().getMemberHPos(this.getEdge(), depth, dragIndex);
            dropArray = this.crosstab.getCrosstabModel().getDataAccess().getMemberHPos(this.getEdge(), depth, dropIndex);
        }
        catch (DataException e) {
            // empty catch block
        }
        if (!(dragArray != null && dragArray.length != 0 || dropArray != null && dropArray.length != 0)) {
            return true;
        }
        if (!(dragArray != null && dragArray.length != 0 || swapping || prevIndex == -1)) {
            int[] prevArray = null;
            try {
                prevArray = this.crosstab.getCrosstabModel().getDataAccess().getMemberHPos(this.getEdge(), depth, prevIndex);
            }
            catch (DataException e) {
                // empty catch block
            }
            if (prevArray == null || prevArray.length == 0) {
                this.currentIndexUsed = false;
                return true;
            }
        }
        if (!(dragArray == null && dragArray.length == 0 || dropArray != null && dropArray.length != 0 || swapping || prevIndex == -1)) {
            int[] prevArray = null;
            try {
                prevArray = this.crosstab.getCrosstabModel().getDataAccess().getMemberHPos(this.getEdge(), depth, prevIndex);
            }
            catch (DataException e) {
                // empty catch block
            }
            if (prevArray == null || prevArray.length == 0) {
                return false;
            }
        }
        boolean group = true;
        if (dropArray != null) {
            if (dragArray.length < depth || dropArray.length < depth) {
                return false;
            }
            int i = 0;
            while (i < depth) {
                if (dragArray[i] != dropArray[i]) {
                    group = false;
                }
                ++i;
            }
        } else {
            group = false;
        }
        if (!swapping && prevIndex != -1 && !group) {
            group = true;
            int[] prevArray = null;
            try {
                prevArray = this.crosstab.getCrosstabModel().getDataAccess().getMemberHPos(this.getEdge(), depth, prevIndex);
            }
            catch (DataException e) {
                // empty catch block
            }
            if (prevArray == null || prevArray.length == 0) {
                return false;
            }
            if (dragArray.length < depth || prevArray.length < depth) {
                return false;
            }
            int i = 0;
            while (i < depth) {
                if (dragArray[i] != prevArray[i]) {
                    group = false;
                }
                if (i == depth - 1 && group) {
                    this.currentIndexUsed = false;
                }
                ++i;
            }
        }
        return group;
    }

    protected void paintDropFeedback(Graphics g, int dropIndex, boolean isSwap) {
        if (this.crosstab.getReorderType() != 1 || this.swapping) {
            super.paintDropFeedback(g, dropIndex, isSwap);
            return;
        }
        if (dropIndex < 500) {
            if (this.getDragIndex() >= 500) {
                int reorderRow = this.crosstab.getPivotTable().getReorderRow();
                if (this.isHorizontal() && (reorderRow == dropIndex || reorderRow + 1 == dropIndex)) {
                    return;
                }
                int reorderCol = this.crosstab.getPivotTable().getReorderCol();
                if (!(this.isHorizontal() || reorderCol != dropIndex && reorderCol + 1 != dropIndex)) {
                    return;
                }
            }
            super.paintDropFeedback(g, dropIndex, isSwap);
            return;
        }
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        if (this.isHorizontal()) {
            if (this.colDragIndex == this.colDropIndex) {
                super.paintDropFeedback(g, dropIndex, isSwap);
                return;
            }
            if (this.colDropIndex == -1) {
                super.paintDropFeedback(g, dropIndex, isSwap);
                return;
            }
            boolean l2r = this.getActualReadingDirection() == 1;
            int index = dropIndex - 500;
            int count = this.getColumnCount();
            int y = this.getGrid().getRowPosition(this.crosstab.getPivotTable().getReorderRow());
            int x = index < count ? this.getGrid().getColumnPosition(index) - 2 : (index == count && count != 0 ? this.getGrid().getColumnPosition(index - 1) + this.getGrid().getColumnWidth(index - 1) - 2 : 0);
            if (!l2r) {
                if (count != 0) {
                    if (index == count) {
                        x = this.getGrid().getColumnPosition(index - 1) - 2;
                    } else {
                        Rectangle rectangle = AbstractBigCell.getCellBounds((Grid)this.getGrid(), (int)index, (int)this.crosstab.getPivotTable().getReorderRow());
                        x = rectangle.x + rectangle.width - 2;
                    }
                } else {
                    x = 0;
                }
            }
            Rectangle rect = index == count ? AbstractBigCell.getCellBounds((Grid)this.getGrid(), (int)(index - 1), (int)this.crosstab.getPivotTable().getReorderRow()) : AbstractBigCell.getCellBounds((Grid)this.getGrid(), (int)index, (int)this.crosstab.getPivotTable().getReorderRow());
            g.fillRect(x, y, 4, rect.height);
        } else {
            if (this.rowDragIndex == this.rowDropIndex) {
                super.paintDropFeedback(g, dropIndex, isSwap);
                return;
            }
            if (this.rowDropIndex == -1) {
                super.paintDropFeedback(g, dropIndex, isSwap);
                return;
            }
            boolean l2r = this.getActualReadingDirection() == 1;
            int index = dropIndex - 500;
            int count = this.getRowCount();
            int x = this.getGrid().getColumnPosition(this.crosstab.getPivotTable().getReorderCol());
            if (this.isOutline()) {
                x = 0;
            }
            int y = index < count ? this.getGrid().getRowPosition(index) - 2 : (index == count && count != 0 ? this.getGrid().getRowPosition(index - 1) + this.getGrid().getRowHeight(index - 1) - 2 : 0);
            Rectangle rect = index == count ? AbstractBigCell.getCellBounds((Grid)this.getGrid(), (int)this.crosstab.getPivotTable().getReorderCol(), (int)(index - 1)) : AbstractBigCell.getCellBounds((Grid)this.getGrid(), (int)this.crosstab.getPivotTable().getReorderCol(), (int)index);
            g.fillRect(x, y, rect.width, 4);
        }
        if (oldColor != null) {
            g.setColor(oldColor);
        }
    }

    protected boolean isSwap(Point p, boolean inHeader) {
        int index;
        Header header;
        this.swapping = false;
        this.setSwapCell(null);
        if (this.crosstab.getReorderType() != 1) {
            return super.isSwap(p, inHeader);
        }
        if (this.getPivotTable() == null) {
            return super.isSwap(p, inHeader);
        }
        if (this.getDragIndex() == -1) {
            if (this.isHorizontal()) {
                if (this.crosstab.getPivotTable().getReorderRow() != -1) {
                    this.crosstab.getPivotTable().setReorderRow(-1);
                }
            } else if (this.crosstab.getPivotTable().getReorderCol() != -1) {
                this.crosstab.getPivotTable().setReorderCol(-1);
            }
        }
        if (this.isHorizontal() && this.crosstab.getPivotTable().getReorderRow() == -1 || !this.isHorizontal() && this.crosstab.getPivotTable().getReorderCol() == -1) {
            return super.isSwap(p, inHeader);
        }
        Grid grid = this.getGrid();
        if (grid.getRowCount() == 0 || grid.getColumnCount() == 0) {
            return super.isSwap(p, inHeader);
        }
        int column = grid.getColumnAt(p.x);
        int row = grid.getRowAt(p.y);
        if (this.isHorizontal() && (inHeader || column == -1)) {
            header = this.getRowHeader();
            index = header.getItemAt(p.x, p.y);
            if (index == -1) {
                return false;
            }
            if (this.crosstab.getPivotTable().getReorderRow() == index) {
                return false;
            }
        }
        if (!this.isHorizontal() && (inHeader || row == -1)) {
            header = this.getColumnHeader();
            index = header.getItemAt(p.x, p.y);
            if (index == -1) {
                return false;
            }
            if (this.crosstab.getPivotTable().getReorderCol() == index) {
                return false;
            }
        }
        if (column == -1 || row == -1) {
            return super.isSwap(p, inHeader);
        }
        AbstractPivotHeaderCell cell = (AbstractPivotHeaderCell)AbstractPivotHeaderCell.getBigCell((Grid)grid, (int)column, (int)row);
        if (cell == null) {
            return super.isSwap(p, inHeader);
        }
        row = cell.getRow();
        if (this.isHorizontal()) {
            column = cell.getColumn();
        } else if (this.isOutline() && cell instanceof AbstractPivotHeaderCell) {
            AbstractPivotHeaderCell a = cell;
            column = a.getColumn() + a.getIndent();
        } else {
            column = cell.getColumn();
        }
        EdgeComponentInfo info = new EdgeComponentInfo(this.getEdge(), this.getDepth(column, row), this.getIndex(column, row));
        QDR qdr = info.getQDR(this.crosstab.getCrosstabModel().getDataAccess(), 0);
        String layerName = null;
        if (this.crosstab.isLayerMetaNameSupported()) {
            try {
                Object layerMetadata = this.crosstab.getCrosstabModel().getDataAccess().getLayerMetadata(this.getEdge(), this.getDepth(column, row), "dimName");
                layerName = layerMetadata.toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (qdr == null) {
            if (!this.isHorizontal() && this.isOutline()) {
                header = this.getColumnHeader();
                index = header.getItemAt(p.x, p.y);
                if (index == -1) {
                    return false;
                }
                if (this.crosstab.getPivotTable().getReorderCol() == index) {
                    return false;
                }
            }
            return super.isSwap(p, inHeader);
        }
        if (!this.crosstab.isSwapMembersAllowed()) {
            if (qdr.getDimMember(qdr.getMeasureDim()) != null && layerName != null && qdr.getMeasureDim().equals(layerName)) {
                return false;
            }
            return super.isSwap(p, inHeader);
        }
        if (qdr.getDimMember(qdr.getMeasureDim()) == null || layerName != null && !qdr.getMeasureDim().equals(layerName)) {
            if (!this.isHorizontal() && this.isOutline()) {
                header = this.getColumnHeader();
                index = header.getItemAt(p.x, p.y);
                if (index == -1) {
                    return false;
                }
                if (this.crosstab.getPivotTable().getReorderCol() == index) {
                    return false;
                }
            }
            return super.isSwap(p, inHeader);
        }
        Rectangle rect = AbstractBigCell.getCellBounds((Grid)grid, (int)column, (int)row);
        if (this.isHorizontal()) {
            if (this.colDragIndex == column) {
                return false;
            }
            int position = grid.getColumnPosition(column);
            if (p.x < position + 6) {
                return false;
            }
            if (p.x > position + rect.width - 6) {
                return false;
            }
            if (!this.checkParentPath(true, this.colDragIndex, column, -1, this.crosstab.getPivotTable().getReorderRow())) {
                return false;
            }
        } else {
            if (this.rowDragIndex == row) {
                return false;
            }
            int position = grid.getRowPosition(row);
            if (p.y < position + 6) {
                return false;
            }
            if (p.y > position + rect.height - 6) {
                return false;
            }
            if (this.isOutline() && cell.getIndent() != this.crosstab.getPivotTable().getReorderCol()) {
                return false;
            }
            if (!this.checkParentPath(true, this.rowDragIndex, row, -1, this.crosstab.getPivotTable().getReorderCol())) {
                if (!this.isHorizontal() && this.isOutline()) {
                    header = this.getColumnHeader();
                    index = header.getItemAt(p.x, p.y);
                    if (index == -1) {
                        return false;
                    }
                    return this.crosstab.getPivotTable().getReorderCol() != index;
                }
                return false;
            }
        }
        if (this.mouseReleased) {
            this.setSwapCell(null);
        } else {
            this.setSwapCell(cell);
        }
        this.swapping = true;
        return true;
    }

    Image getDrillImage() {
        return this.getPivotHeaderUI().getDrillImage((JComponent)((Object)this));
    }

    Image getDrilledImage() {
        return this.getPivotHeaderUI().getDrilledImage((JComponent)((Object)this));
    }

    ViewStyle getStyle(int column, int row) {
        CrosstabHeaderCell cell;
        if (this.isOutline() && !this.isHorizontal() && (cell = (CrosstabHeaderCell)this.getModel().getData(column, row)) != null) {
            column = cell.getIndent();
        }
        this.info.setRowCol(row, column);
        ViewStyle style = (ViewStyle)this.metadataCache.get(this.info);
        if (style == null) {
            Object metadata = this.getModel().getData(column, row);
            if (metadata != null && metadata instanceof CrosstabHeaderCell) {
                metadata = ((CrosstabHeaderCell)metadata).getData();
            }
            if ((style = this.crosstab.getGridViewHeaderStyleManager().getMetadataStyle(this.crosstab, metadata, this.defaultViewStyle, this.getEdge(), this.getDepth(column, row), this.getIndex(column, row))) == null) {
                style = (ViewStyle)this.defaultViewStyle.clone();
            }
            this.metadataCache.put(this.info.clone(), style);
        }
        style.setView(this.crosstab);
        if (this.crosstab.getZoomFactor() != 100) {
            style = style.scaleStyle(style.getFont());
            style.setView(this.crosstab);
        }
        style.setReadingDirection(this.getReadingDirectionForLocale(this.crosstab.getLocale()));
        return style;
    }

    private void setSwapCell(AbstractPivotHeaderCell cell) {
        if (cell == null) {
            this.swapRow = -1;
            this.swapColumn = -1;
        } else {
            this.swapRow = cell.getRow();
            this.swapColumn = cell.getColumn();
        }
    }

    private void createBlankImage() {
        Image realImage = null;
        realImage = this.crosstab.getScaledDrillImage(1);
        int imageWidth = 0;
        int imageHeight = 0;
        if (realImage != null) {
            imageWidth = realImage.getWidth(null);
            imageHeight = realImage.getHeight(null);
        }
        realImage = this.crosstab.getScaledDrillImage(2);
        int newWidth = 0;
        int newHeight = 0;
        if (realImage != null) {
            newWidth = realImage.getWidth(null);
            newHeight = realImage.getHeight(null);
        }
        if (newWidth > imageWidth) {
            imageWidth = newWidth;
        }
        if (newHeight > imageHeight) {
            imageHeight = newHeight;
        }
        int[] pixels = new int[imageWidth * imageHeight];
        this.blankImage = this.createImage(new MemoryImageSource(imageWidth, imageHeight, pixels, 0, imageWidth));
    }

    private void createUnscaledBlankImage() {
        Image realImage = null;
        realImage = this.crosstab.getDrillImage(1);
        int imageWidth = 0;
        int imageHeight = 0;
        if (realImage != null) {
            imageWidth = realImage.getWidth(null);
            imageHeight = realImage.getHeight(null);
        }
        realImage = this.crosstab.getDrillImage(2);
        int newWidth = 0;
        int newHeight = 0;
        if (realImage != null) {
            newWidth = realImage.getWidth(null);
            newHeight = realImage.getHeight(null);
        }
        if (newWidth > imageWidth) {
            imageWidth = newWidth;
        }
        if (newHeight > imageHeight) {
            imageHeight = newHeight;
        }
        int[] pixels = new int[imageWidth * imageHeight];
        this.unscaledBlankImage = this.createImage(new MemoryImageSource(imageWidth, imageHeight, pixels, 0, imageWidth));
    }

    void clearUnscaledBlankImage() {
        this.unscaledBlankImage = null;
    }

    void clearScaledBlankImage() {
        this.blankImage = null;
    }

    public int getColumnCount() {
        return this.getModel().getColumnCount();
    }

    public int getRowCount() {
        return this.getModel().getRowCount();
    }

    public void setXML(ObjectNode node, String version, int reset) {
        this._viewHeaderXML.setXML(node, version, reset);
        if (!this.isHorizontal()) {
            this.crosstab.setDefaultCornerComponentColor(this.defaultViewStyle.getBackground());
        }
    }

    public ObjectNode getXML(boolean allProperties) {
        return this._viewHeaderXML.getXML(allProperties);
    }

    protected void resetToDefault(int reset) {
        this.defaultViewStyle.resetToDefault(reset);
        this.propSet();
        if (!this.isHorizontal() && reset != 0) {
            this.crosstab.setDefaultCornerComponentColor(this.defaultViewStyle.getBackground());
        }
    }

    public ComponentInfo getCellFocus() {
        Component focusCellComponent = this.getPivotTable().getGlobalFocusCellComponent();
        if (focusCellComponent != null && (this.isHorizontal() && focusCellComponent == this.getPivotTable().getColumnPivotHeader().getGrid() || !this.isHorizontal() && focusCellComponent == this.getPivotTable().getRowPivotHeader().getGrid())) {
            int slice;
            int layer;
            int edge;
            Cell globalFocusCell = this.getPivotTable().getGlobalFocusCell();
            if (this.isHorizontal()) {
                edge = 0;
                layer = globalFocusCell.row;
                slice = globalFocusCell.column;
            } else {
                edge = 1;
                layer = globalFocusCell.column;
                slice = globalFocusCell.row;
            }
            return new EdgeComponentInfo(edge, layer, slice);
        }
        return null;
    }

    public void setCellFocus(ComponentInfo focusedCell) {
        if (focusedCell instanceof EdgeComponentInfo) {
            int column;
            int row;
            EdgeComponentInfo ecInfo = (EdgeComponentInfo)focusedCell;
            if (ecInfo.getEdge() == 0) {
                row = ecInfo.getDepth();
                column = ecInfo.getIndex();
                this.getPivotTable().setGlobalFocusCell(new Cell(column, row), (Component)this.getPivotTable().getColumnPivotHeader().getGrid());
            } else {
                row = ecInfo.getIndex();
                column = ecInfo.getDepth();
                this.getPivotTable().setGlobalFocusCell(new Cell(column, row), (Component)this.getPivotTable().getRowPivotHeader().getGrid());
            }
            if (this.isHorizontal()) {
                this.crosstab.getPivotTable().getPivotGrid().getGrid().scrollColumnIntoView(column);
            } else {
                this.crosstab.getPivotTable().getPivotGrid().getGrid().scrollRowIntoView(row);
            }
            if (this.crosstab.isFocusRequestedForCell()) {
                this.requestFocus();
            }
        }
    }

    protected ViewStyle getPivotHandleViewStyle(int layer) {
        Appearance a = null;
        a = this.isHorizontal() ? this.getRowHeader().getItemAppearance(layer) : this.getColumnHeader().getItemAppearance(layer);
        if (a instanceof ViewStyle) {
            return (ViewStyle)a;
        }
        return null;
    }

    private void _checkScroller(MouseEvent mouseEvent) {
        HeaderAutoScroller autoScroller = HeaderAutoScroller.getAutoScroller();
        boolean needHorizontal = false;
        boolean needVertical = false;
        boolean horizontalDecrease = false;
        boolean verticalDecrease = false;
        Container c = this.getGrid().getParent();
        while (c != null && !(c instanceof JViewport)) {
            c = c.getParent();
        }
        int max = 0;
        int count = 0;
        int averageItemSize = 0;
        int pointToCheck = 0;
        if (this.isHorizontal()) {
            pointToCheck = mouseEvent.getX() + ((PivotScrollPaneView)this.getGrid().getParent().getParent()).getX();
            max = c != null ? ((JViewport)c).getExtentSize().width : ((PivotScrollPaneView)this.getGrid().getParent().getParent()).getWidth();
            count = this.getColumnCount();
            int n = averageItemSize = count == 0 ? 0 : this.getGrid().getColumnGeometryManager().getTotalSize() / count;
            if (pointToCheck < (averageItemSize /= 2)) {
                needHorizontal = true;
                horizontalDecrease = true;
            } else if (pointToCheck > max - averageItemSize) {
                needHorizontal = true;
                horizontalDecrease = false;
            }
        } else {
            pointToCheck = mouseEvent.getY() + ((PivotScrollPaneView)this.getGrid().getParent().getParent()).getY();
            max = c != null ? ((JViewport)c).getExtentSize().height : ((PivotScrollPaneView)this.getGrid().getParent().getParent()).getHeight();
            count = this.getRowCount();
            int n = averageItemSize = count == 0 ? 0 : this.getGrid().getRowGeometryManager().getTotalSize() / count;
            if (pointToCheck < (averageItemSize /= 2)) {
                needVertical = true;
                verticalDecrease = true;
            } else if (pointToCheck > max - averageItemSize) {
                needVertical = true;
                verticalDecrease = false;
            }
        }
        if ((needVertical ^ true) & (needHorizontal ^ true)) {
            autoScroller.cancel();
        } else {
            autoScroller.schedule(this.getGrid(), needHorizontal, horizontalDecrease, needVertical, verticalDecrease);
        }
    }

    private boolean shouldWrap(ViewStyle style) {
        return style == null ? this.getViewStyle().isWordWrapEnabled() : style.isWordWrapEnabled();
    }

    private void updateResourceBundle(Locale loc) {
        if (loc != null) {
            this.gBundle = ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle", loc);
            this.cBundle = ResourceBundle.getBundle("oracle.dss.crosstab.resource.CrosstabBundle", loc);
        } else {
            this.gBundle = ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle");
            this.cBundle = ResourceBundle.getBundle("oracle.dss.crosstab.resource.CrosstabBundle");
        }
    }

    protected PivotHeader.PivotHeaderGrid createPivotHeaderGrid(TwoDModel model) {
        return new CrosstabPivotHeaderGrid(model);
    }

    protected PivotHeader.PivotHeaderHeader createPivotHeaderColumnHeader(OneDModel model) {
        return new CrosstabPivotHeaderHeader(model, 0);
    }

    protected PivotHeader.PivotHeaderHeader createPivotHeaderRowHeader(OneDModel model) {
        return new CrosstabPivotHeaderHeader(model, 1);
    }

    private int getReadingDirectionForLocale(Locale loc) {
        String language;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if ((language = loc.getLanguage()).equals("ar") || language.equals("he") || language.equals("iw")) {
            return 2;
        }
        return 1;
    }

    private void $init$() {
        this.crosstab = null;
        this.metadataCache = null;
        this.ham = null;
        this.defaultViewStyle = null;
        this.blankImage = null;
        this.unscaledBlankImage = null;
        this.info = new DataComponentInfo(0, 0);
        this.tips = null;
        this.colDropIndex = -1;
        this.colDragIndex = -1;
        this.rowDropIndex = -1;
        this.rowDragIndex = -1;
        this.swapRow = -1;
        this.swapColumn = -1;
        this.currentIndexUsed = true;
        this.swapping = false;
        this.mouseReleased = true;
        this.prevString = null;
        this.dragString = null;
        this.nextString = null;
        this.gBundle = null;
        this.cBundle = null;
    }

    static boolean mav$shouldWrap(CrosstabPivotHeader crosstabPivotHeader, ViewStyle viewStyle) {
        return crosstabPivotHeader.shouldWrap(viewStyle);
    }

    static void wa$mouseReleased(CrosstabPivotHeader crosstabPivotHeader, boolean bl) {
        crosstabPivotHeader.mouseReleased = bl;
    }

    static void mav$setSwapCell(CrosstabPivotHeader crosstabPivotHeader, AbstractPivotHeaderCell abstractPivotHeaderCell) {
        crosstabPivotHeader.setSwapCell(abstractPivotHeaderCell);
    }

    static void mav$_checkScroller(CrosstabPivotHeader crosstabPivotHeader, MouseEvent mouseEvent) {
        crosstabPivotHeader._checkScroller(mouseEvent);
    }

    static ResourceBundle ra$gBundle(CrosstabPivotHeader crosstabPivotHeader) {
        return crosstabPivotHeader.gBundle;
    }

    static ResourceBundle ra$cBundle(CrosstabPivotHeader crosstabPivotHeader) {
        return crosstabPivotHeader.cBundle;
    }

    private class HeaderAppMgr
    implements AppearanceManager {
        public HeaderAppMgr(Crosstab ct) {
        }

        public void updateUI() {
        }

        public Appearance getCellPaintingAppearance(int column, int row) {
            ViewStyle style = CrosstabPivotHeader.this.getStyle(column, row);
            if (style != null && column == CrosstabPivotHeader.this.swapColumn && row == CrosstabPivotHeader.this.swapRow) {
                Appearance newApp = style.copy();
                EWTPivotHeaderUI ui = CrosstabPivotHeader.this.getPivotHeaderUI();
                Color color = ui.getSwapForegroundColor((JComponent)((Object)CrosstabPivotHeader.this), (Appearance)style);
                newApp.setForeground(color);
                newApp.setSelectForeground(color);
                color = ui.getSwapBackgroundColor((JComponent)((Object)CrosstabPivotHeader.this), (Appearance)style);
                newApp.setBackground(color);
                newApp.setSelectBackground(color);
                return newApp;
            }
            return style;
        }

        public void setGrid(Grid grid) {
        }

        public TwoDModelListener getTwoDModelListener() {
            return null;
        }

        public ViewStyle getDefaultStyle() {
            return CrosstabPivotHeader.this.defaultViewStyle;
        }
    }

    private class EnhancedTextPainter
    extends TextPainter {
        private WrappingPainter wrappingPainter;

        public EnhancedTextPainter() {
            this.wrappingPainter = new WrappingPainter();
        }

        protected String getStringData(PaintContext context) {
            Object o = context.getPaintData(this.getDataKey());
            PivotHandleCell cell = (PivotHandleCell)((Object)o);
            if (cell != null && CrosstabPivotHeader.this.crosstab.isPivotLabelVisible()) {
                return (String)cell.getData();
            }
            return null;
        }

        protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
            int retVal = super.paintText(context, g, metrics, text, x, --y, availableWidth, alignmentX, mnemonicIndex);
            if (CrosstabPivotHeader.this.crosstab.isPivotLabelVisible()) {
                String paintText = this.getPaintText(context, text, metrics, availableWidth);
                CrosstabPivotHeader.this.drawEnhancedFont(context, g, metrics, paintText, x, y, availableWidth, alignmentX);
            }
            return retVal;
        }

        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            ViewStyle style = (ViewStyle)context.getPaintData(Header.KEY_APPEARANCE);
            if (CrosstabPivotHeader.mav$shouldWrap(CrosstabPivotHeader.this, style)) {
                this.wrappingPainter.paint(context, g, x, y, width, height);
            } else {
                super.paint(context, g, x, y, width, height);
            }
        }
    }

    private class WrappingPainter
    extends GridViewWrappingTextPainter {
        protected String getStringData(PaintContext context) {
            Object o = context.getPaintData(this.getDataKey());
            PivotHandleCell cell = (PivotHandleCell)((Object)o);
            if (cell != null && CrosstabPivotHeader.this.crosstab.isPivotLabelVisible()) {
                return (String)cell.getData();
            }
            return null;
        }

        protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
            ViewStyle style = (ViewStyle)context.getPaintData(Header.KEY_APPEARANCE);
            int retVal = super.paintText(context, g, metrics, text, x, --y, availableWidth, alignmentX, mnemonicIndex);
            if (CrosstabPivotHeader.this.crosstab.isPivotLabelVisible()) {
                String paintText = this.getPaintText(context, text, metrics, availableWidth);
                CrosstabPivotHeader.this.drawEnhancedFont(context, g, metrics, paintText, x, y, availableWidth, alignmentX);
            }
            return retVal;
        }
    }

    private class PivotHeaderMotionListener
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent e) {
            CrosstabPivotHeader.wa$mouseReleased(CrosstabPivotHeader.this, false);
            if (!CrosstabPivotHeader.this.crosstab.isHeaderResizing()) {
                CrosstabPivotHeader.mav$_checkScroller(CrosstabPivotHeader.this, e);
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            CrosstabPivotHeader.mav$setSwapCell(CrosstabPivotHeader.this, null);
            HeaderAutoScroller.getAutoScroller().cancel();
        }

        public void mouseReleased(MouseEvent e) {
            CrosstabPivotHeader.wa$mouseReleased(CrosstabPivotHeader.this, true);
            HeaderAutoScroller.getAutoScroller().cancel();
        }

        private PivotHeaderMotionListener() {
        }

        PivotHeaderMotionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PivotHandleInputHandler
    extends NullInputHandler {
        private HeaderItemInputHandler input;

        protected PivotHandleInputHandler(HeaderItemInputHandler input) {
            this.input = input;
        }

        public void mouseClicked(MouseEvent e, Header header, int itemIndex) {
            if (!e.isConsumed() && this.input != null) {
                this.input.mouseClicked(e, header, itemIndex);
            }
        }

        public void mouseMoved(MouseEvent e, Header header, int itemIndex) {
            if (!e.isConsumed() && this.input != null) {
                this.input.mouseMoved(e, header, itemIndex);
            }
        }

        public void mouseEntered(MouseEvent e, Header header, int itemIndex) {
            if (!e.isConsumed() && this.input != null) {
                this.input.mouseEntered(e, header, itemIndex);
            }
        }

        public void mouseExited(MouseEvent e, Header header, int itemIndex) {
            if (!e.isConsumed() && this.input != null) {
                this.input.mouseExited(e, header, itemIndex);
            }
        }

        public void mouseDragged(MouseEvent e, Header header, int itemIndex) {
            if (!e.isConsumed() && this.input != null) {
                this.input.mouseDragged(e, header, itemIndex);
            }
        }

        public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
            header.setArmedItem(-1);
            if (!e.isConsumed() && this.input != null) {
                this.input.mouseReleased(e, header, itemIndex);
            }
        }

        public void mousePressed(MouseEvent e, Header header, int itemIndex) {
            boolean right = SwingUtilities.isRightMouseButton(e);
            if (right) {
                header.setArmedItem(itemIndex);
                OneDSelection selection = header.getSelection();
                if (!selection.contains(itemIndex)) {
                    try {
                        header.deselectAll();
                        OneDSelection sel = new OneDSelection(itemIndex);
                        header.setSelection(sel);
                    }
                    catch (PropertyVetoException ex) {
                        // empty catch block
                    }
                }
            }
            if (!e.isConsumed() && this.input != null) {
                this.input.mousePressed(e, header, itemIndex);
            }
        }
    }

    public class CrosstabPivotHeaderGrid
    extends PivotHeader.PivotHeaderGrid {
        public CrosstabPivotHeaderGrid(TwoDModel ds) {
            super((PivotHeader)CrosstabPivotHeader.this, ds);
        }

        public void scrollColumnIntoView(int column) {
            if (CrosstabPivotHeader.this.crosstab != null) {
                CrosstabPivotHeader.this.crosstab.setDuringScroll(true);
            }
            super.scrollColumnIntoView(column);
            if (CrosstabPivotHeader.this.crosstab != null) {
                CrosstabPivotHeader.this.crosstab.setDuringScroll(false);
            }
        }

        public void scrollRowIntoView(int row) {
            if (CrosstabPivotHeader.this.crosstab != null) {
                CrosstabPivotHeader.this.crosstab.setDuringScroll(true);
            }
            super.scrollRowIntoView(row);
            if (CrosstabPivotHeader.this.crosstab != null) {
                CrosstabPivotHeader.this.crosstab.setDuringScroll(false);
            }
        }

        public void scrollCellIntoView(int column, int row) {
            if (CrosstabPivotHeader.this.crosstab != null) {
                CrosstabPivotHeader.this.crosstab.setDuringScroll(true);
            }
            super.scrollCellIntoView(column, row);
            if (CrosstabPivotHeader.this.crosstab != null) {
                CrosstabPivotHeader.this.crosstab.setDuringScroll(false);
            }
        }

        protected Grid.AccessibleGrid createAccessibleGrid() {
            return new CrosstabHeaderAccessibleGrid();
        }

        public class CrosstabHeaderAccessibleGrid
        extends PivotHeader.PivotHeaderGrid.PivotHeaderAccessibleGrid {
            protected String getAccessibleNameForTable(int column, int row, Object data, String cellName) {
                return cellName;
            }

            protected String getAccessibleName(int column, int row, Object data) {
                String name = super.getAccessibleName(column, row, data);
                Image image = CrosstabPivotHeader.this.getGraphicImage(column, row);
                if (image != null) {
                    name = MessageFormat.format(CrosstabPivotHeader.ra$gBundle(CrosstabPivotHeader.this).getString("Graphic Image"), name);
                }
                return name;
            }

            public CrosstabHeaderAccessibleGrid() {
                super((PivotHeader.PivotHeaderGrid)CrosstabPivotHeaderGrid.this);
            }
        }
    }

    public class CrosstabPivotHeaderHeader
    extends PivotHeader.PivotHeaderHeader {
        int orientation;

        public CrosstabPivotHeaderHeader(OneDModel ds, int orientation) {
            super((PivotHeader)CrosstabPivotHeader.this, ds, orientation);
            this.orientation = orientation;
        }

        protected Header.AccessibleHeader createAccessibleHeader() {
            return new CrossHeaderAccessibleHeader();
        }

        public class CrossHeaderAccessibleHeader
        extends PivotHeader.PivotHeaderHeader.PivotHeaderAccessibleHeader {
            public String getAccessibleName(int index) {
                String name = "";
                try {
                    Object objVal = null;
                    String str = null;
                    if (CrosstabPivotHeaderHeader.this.orientation == 0) {
                        objVal = CrosstabPivotHeader.this.crosstab.getCrosstabModel().getDataAccess().getLayerMetadata(1, index, "dimLongName");
                        str = objVal != null ? objVal.toString() : "";
                        name = MessageFormat.format(CrosstabPivotHeader.ra$cBundle(CrosstabPivotHeader.this).getString("Pivot Handle for"), str);
                    } else if (CrosstabPivotHeaderHeader.this.orientation == 1) {
                        objVal = CrosstabPivotHeader.this.crosstab.getCrosstabModel().getDataAccess().getLayerMetadata(0, index, "dimLongName");
                        str = objVal != null ? objVal.toString() : "";
                        name = MessageFormat.format(CrosstabPivotHeader.ra$cBundle(CrosstabPivotHeader.this).getString("Pivot Handle for"), str);
                    }
                }
                catch (EdgeOutOfRangeException re) {
                }
                catch (LayerOutOfRangeException se) {
                    // empty catch block
                }
                return name;
            }

            public CrossHeaderAccessibleHeader() {
                super((PivotHeader.PivotHeaderHeader)CrosstabPivotHeaderHeader.this);
            }
        }
    }
}

