/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.util.Dictionary;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import oracle.bali.ewt.geometry.AbstractWrappingGeometryManager;
import oracle.bali.ewt.geometry.GeneralGeometryManager;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.pivot.PivotGrid;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.dss.crosstab.ColPivotHeader;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabDatabody;
import oracle.dss.crosstab.CrosstabPivotHeader;
import oracle.dss.crosstab.CrosstabTips;
import oracle.dss.crosstab.RowPivotHeader;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.gridView.GridViewTable;

public class CrosstabPivotTable
extends PivotTable
implements GridViewTable {
    protected CrosstabDatabody pivotGrid;
    protected ColPivotHeader colHeader;
    protected RowPivotHeader rowHeader;
    protected transient Crosstab crosstab;
    protected JLabel nodatalabel;
    protected CrosstabTips tips;
    protected int selectorSize;
    protected transient int[] m_calculatedRowHeights;
    protected transient boolean[] m_sizedRowFlags;
    protected transient boolean[] m_sizedColFlags;
    protected transient int m_calculatedRowCount;
    protected transient int m_accumulatedCalculatedRowHeight;
    protected boolean m_bCheckingRowHeights;
    protected boolean canPaint;
    private int reorderCol;
    private int reorderRow;
    private int m_freezeLevel;
    private static final String m_method_checkResizeRowHeights = "protected void checkResizeRowHeights()";

    public CrosstabPivotTable(CrosstabDatabody _pivotGrid, ColPivotHeader _colHeader, RowPivotHeader _rowHeader, Crosstab ct) {
        super((PivotGrid)_pivotGrid, (PivotHeader)_colHeader, (PivotHeader)_rowHeader);
        this.$init$();
        this.pivotGrid = _pivotGrid;
        this.colHeader = _colHeader;
        this.rowHeader = _rowHeader;
        this.crosstab = ct;
        CrosstabDatabody pg = this.getCrosstabDatabody();
        CrosstabPivotHeader rh = this.getCrosstabRowHeader();
        CrosstabPivotHeader ch = this.getCrosstabColumnHeader();
        ((GeneralGeometryManager)pg.getColumnGeometryManager()).setDefaultMinimumItemSize(0);
        ((GeneralGeometryManager)pg.getRowGeometryManager()).setDefaultMinimumItemSize(0);
        ((GeneralGeometryManager)((AbstractWrappingGeometryManager)rh.getColumnGeometryManager()).getWrappedGeometryManager()).setDefaultMinimumItemSize(0);
        ((GeneralGeometryManager)rh.getRowGeometryManager()).setDefaultMinimumItemSize(0);
        ((GeneralGeometryManager)ch.getColumnGeometryManager()).setDefaultMinimumItemSize(0);
        ((GeneralGeometryManager)((AbstractWrappingGeometryManager)ch.getRowGeometryManager()).getWrappedGeometryManager()).setDefaultMinimumItemSize(0);
        this.nodatalabel = new JLabel(ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("No data"), 0);
        this.nodatalabel.setVerticalAlignment(0);
        this.nodatalabel.setOpaque(true);
        this.add(this.nodatalabel);
        this.clearRowHeightsCache();
    }

    protected CrosstabDatabody getCrosstabDatabody() {
        return this.pivotGrid;
    }

    protected CrosstabPivotHeader getCrosstabColumnHeader() {
        return this.colHeader;
    }

    protected CrosstabPivotHeader getCrosstabRowHeader() {
        return this.rowHeader;
    }

    public int getID() {
        return 21;
    }

    public String getComponentName() {
        return "Crosstab";
    }

    public BeanInfo getBeanInfo() {
        return null;
    }

    void redoHighlighters(int value) {
        this.selectorSize = DataviewUtils.scaleByZoom(value, this.crosstab.getZoomFactor());
        this.getPivotGrid().setColumnHeaderHeight(this.selectorSize);
        this.getPivotGrid().setRowHeaderWidth(this.selectorSize);
        this.getColumnPivotHeader().setRowHeaderWidth(this.selectorSize);
        this.getRowPivotHeader().setColumnHeaderHeight(this.selectorSize);
    }

    void setReorderRow(int row) {
        this.reorderRow = row;
    }

    int getReorderRow() {
        return this.reorderRow;
    }

    void setReorderCol(int col) {
        this.reorderCol = col;
    }

    int getReorderCol() {
        return this.reorderCol;
    }

    Crosstab getCrosstab() {
        return this.crosstab;
    }

    public void setModels(TwoDModel databodyDataSource, TwoDModel colHeaderDataSource, TwoDModel rowHeaderDataSource) {
        super.setModels(databodyDataSource, colHeaderDataSource, rowHeaderDataSource);
        if (this.crosstab.m_colHeaderVisible) {
            this.setColumnPivotHeaderVisible(this.crosstab.getCrosstabModel().isColumnHeaderVisible());
        }
        if (this.crosstab.m_rowHeaderVisible) {
            this.setRowPivotHeaderVisible(this.crosstab.getCrosstabModel().isRowHeaderVisible());
        }
    }

    public void doLayout() {
        super.doLayout();
        if (this.getPivotGrid().getModel().getColumnCount() == 0 || this.getPivotGrid().getModel().getRowCount() == 0) {
            this.nodatalabel.setBounds(this.getPivotGrid().getBounds());
            this.getPivotGrid().setBounds(0, 0, 0, 0);
        } else {
            this.nodatalabel.setBounds(0, 0, 0, 0);
        }
    }

    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        if (this.getPivotGrid().getModel().getColumnCount() == 0 || this.getPivotGrid().getModel().getRowCount() == 0) {
            FontMetrics fm = g.getFontMetrics();
            int stringWidth = fm.stringWidth(this.nodatalabel.getText());
            int stringHeight = fm.getHeight();
            Rectangle clipBounds = g.getClipBounds();
            int printX = clipBounds.width / 2 - stringWidth / 2;
            int printY = clipBounds.height / 2 - stringHeight / 2;
            g.drawString(this.nodatalabel.getText(), printX, printY);
        }
        super.printPage(context, printProperties, g);
    }

    public void addNotify() {
        super.addNotify();
    }

    public int getType() {
        return 0;
    }

    protected void paintChildren(Graphics g) {
        if (!this.canPaint) {
            return;
        }
        if (!this._isRepaintFrozen()) {
            if (this.crosstab.canResizeWidths) {
                this.checkResizeColumnWidths();
            }
            if (this.crosstab.canResizeHeights) {
                this.checkResizeRowHeights();
            }
            super.paintChildren(g);
        }
    }

    protected void clearRowHeightsCache() {
        int gridRows = this.getGridModel().getRowCount();
        if (gridRows == 0) {
            this.m_calculatedRowHeights = null;
        } else {
            this.m_calculatedRowHeights = new int[gridRows];
            int i = 0;
            while (i < gridRows) {
                this.m_calculatedRowHeights[i] = -1;
                ++i;
            }
        }
        this.m_calculatedRowCount = 0;
        this.m_accumulatedCalculatedRowHeight = 0;
        this.clearSizedRowFlags();
    }

    protected void clearSizedRowFlags() {
        int gridRows = this.getGridModel().getRowCount();
        if (gridRows == 0) {
            this.m_sizedRowFlags = null;
        } else {
            this.m_sizedRowFlags = new boolean[gridRows];
            int i = 0;
            while (i < gridRows) {
                this.m_sizedRowFlags[i] = false;
                ++i;
            }
        }
    }

    protected void clearSizedColumnFlags() {
        int gridCols = this.getGridModel().getColumnCount();
        if (gridCols == 0) {
            this.m_sizedColFlags = null;
        } else {
            this.m_sizedColFlags = new boolean[gridCols];
            int i = 0;
            while (i < gridCols) {
                this.m_sizedColFlags[i] = false;
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void checkResizeRowHeights() {
        block18: {
            block19: {
                block20: {
                    if (this.m_sizedRowFlags == null) {
                        return;
                    }
                    bCalcRowHeights = (this.crosstab.getAutoFitScope() & 1) > 0;
                    gridRows = this.getGridModel().getRowCount();
                    if (this.m_sizedRowFlags.length != gridRows) {
                        return;
                    }
                    resize = false;
                    startRow = this.getCrosstabDatabody().getFirstRowOnScreen();
                    if (startRow == -1) break block18;
                    lastRowOnScreen = this.getCrosstabDatabody().getOnScreenRowCount() + startRow - 1;
                    firstRowToSize = startRow;
                    if (!bCalcRowHeights) break block19;
                    this.m_bCheckingRowHeights = true;
                    totalRowsHt = 0;
                    pc = this.getPivotGrid().getGrid().getPaintContext();
                    sepHeight = 0;
                    if (this.getPivotGrid().getVerticalSeparatorsVisible()) {
                        sepHeight = this.getCrosstabDatabody().getVerticalSeparatorPainter().getPreferredSize((PaintContext)pc).width;
                    }
                    i = startRow;
                    while (i <= lastRowOnScreen) {
                        if (this.m_calculatedRowHeights[i] == -1) {
                            resize = true;
                            firstRowToSize = i;
                            break;
                        }
                        totalRowsHt += this.getRowHeight(i) + sepHeight;
                        ++i;
                    }
                    if (!resize) break block20;
                    this.canPaint = false;
                    y1 = this.getPivotGrid().getGrid().getRowPosition(firstRowToSize);
                    y2 = this.getPivotGrid().getGrid().getRowPosition(lastRowOnScreen) + this.getRowHeight(lastRowOnScreen) + sepHeight;
                    visibleCanvasHeight = y2 - y1;
                    done = false;
                    upward = false;
                    beginRow = curRow = firstRowToSize;
                    endRow = curRow;
                    range = this.crosstab.getAutoFitColumnRange();
                    endCol = range.end;
                    startCol = range.begin;
                    if (endCol >= startCol) ** GOTO lbl58
                    this.crosstab.getErrorHandler().log("invalid column range", this.getClass().getName(), "protected void checkResizeRowHeights()");
                    this.m_bCheckingRowHeights = false;
                    return;
lbl-1000:
                    // 1 sources

                    {
                        rowHt = this.crosstab.resizeRowHeight(curRow, startCol, endCol);
                        if ((totalRowsHt += rowHt + sepHeight) >= visibleCanvasHeight) {
                            done = true;
                            continue;
                        }
                        if (!upward && gridRows - curRow > 1) {
                            endRow = ++curRow;
                            continue;
                        }
                        if (!upward) {
                            curRow = startRow - 1;
                        }
                        beginRow = --curRow;
                        upward = true;
                        if (curRow >= 0) continue;
                        done = true;
                        beginRow = 0;
lbl58:
                        // 5 sources

                        ** while (!done)
                    }
lbl59:
                    // 1 sources

                    if (this.crosstab.getAutoFitColumnRangeCallback() != null) {
                        this.crosstab.getAutoFitColumnRangeCallback().endAutoFit();
                    }
                    i = beginRow;
                    while (i <= endRow) {
                        this.crosstab.getCrosstabSizingManager().setCalculatedRowHeight(i, this.m_calculatedRowHeights[i]);
                        if (this.m_accumulatedCalculatedRowHeight < 0x7FFFFFFF - this.m_calculatedRowHeights[i]) {
                            ++this.m_calculatedRowCount;
                            this.m_accumulatedCalculatedRowHeight += this.m_calculatedRowHeights[i];
                        }
                        ++i;
                    }
                    if (this.m_calculatedRowCount > 0) {
                        defHeight = this.m_accumulatedCalculatedRowHeight / this.m_calculatedRowCount;
                        this.crosstab.getCrosstabSizingManager().setDefaultRowHeight(defHeight);
                    }
                    this.crosstab.sizeRowHeights(beginRow, endRow);
                    this.canPaint = true;
                }
                this.m_bCheckingRowHeights = false;
            }
            resize = false;
            firstRowToSize = startRow;
            i = startRow;
            while (i <= lastRowOnScreen) {
                if (!this.m_sizedRowFlags[i]) {
                    resize = true;
                    firstRowToSize = i;
                    break;
                }
                ++i;
            }
            if (resize) {
                lastRowToSize = firstRowToSize;
                i = lastRowOnScreen;
                while (i >= firstRowToSize) {
                    if (!this.m_sizedRowFlags[i]) {
                        lastRowToSize = i;
                        break;
                    }
                    --i;
                }
                this.crosstab.sizeRowHeights(firstRowToSize, lastRowToSize);
            }
        }
    }

    protected void checkResizeColumnWidths() {
        if (this.m_sizedColFlags == null) {
            return;
        }
        int gridCols = this.getGridModel().getColumnCount();
        if (this.m_sizedColFlags.length != gridCols) {
            return;
        }
        boolean resize = false;
        int startCol = this.getCrosstabDatabody().getFirstColumnOnScreen();
        if (startCol != -1) {
            int lastColOnScreen = this.getCrosstabDatabody().getOnScreenColumnCount() + startCol - 1;
            int firstColToSize = startCol;
            int i = startCol;
            while (i <= lastColOnScreen) {
                if (!this.m_sizedColFlags[i]) {
                    resize = true;
                    firstColToSize = i;
                    break;
                }
                ++i;
            }
            if (resize) {
                int lastColToSize = firstColToSize;
                int i2 = lastColOnScreen;
                while (i2 >= firstColToSize) {
                    if (!this.m_sizedColFlags[i2]) {
                        lastColToSize = i2;
                        break;
                    }
                    --i2;
                }
                this.crosstab.sizeColumnWidths(firstColToSize, lastColToSize);
            }
        }
    }

    private boolean _isRepaintFrozen() {
        return this.m_freezeLevel > 0;
    }

    protected void freezePivotTableRepaints() {
        ++this.m_freezeLevel;
        this.freezeRepaints();
        if (this.getCrosstabDatabody() != null) {
            this.getCrosstabDatabody().freezeRepaints();
            if (this.getCrosstabDatabody().getColumnHeader() != null) {
                this.getCrosstabDatabody().getColumnHeader().freezeRepaints();
            }
            if (this.getCrosstabDatabody().getRowHeader() != null) {
                this.getCrosstabDatabody().getRowHeader().freezeRepaints();
            }
        }
        if (this.getColumnPivotHeader() != null) {
            this.getColumnPivotHeader().freezeRepaints();
            if (this.getColumnPivotHeader().getRowHeader() != null) {
                this.getColumnPivotHeader().getRowHeader().freezeRepaints();
            }
            if (this.getColumnPivotHeader().getGrid() != null) {
                this.getColumnPivotHeader().getGrid().freezeRepaints();
            }
        }
        if (this.getRowPivotHeader() != null) {
            this.getRowPivotHeader().freezeRepaints();
            if (this.getRowPivotHeader().getColumnHeader() != null) {
                this.getRowPivotHeader().getColumnHeader().freezeRepaints();
            }
            if (this.getRowPivotHeader().getGrid() != null) {
                this.getRowPivotHeader().getGrid().freezeRepaints();
            }
        }
    }

    protected void unfreezePivotTableRepaints() {
        if (this.m_freezeLevel > 0) {
            --this.m_freezeLevel;
        }
        if (this.getRowPivotHeader() != null) {
            this.getRowPivotHeader().unfreezeRepaints();
            if (this.getRowPivotHeader().getColumnHeader() != null) {
                this.getRowPivotHeader().getColumnHeader().unfreezeRepaints();
            }
            if (this.getRowPivotHeader().getGrid() != null) {
                this.getRowPivotHeader().getGrid().unfreezeRepaints();
            }
        }
        if (this.getColumnPivotHeader() != null) {
            this.getColumnPivotHeader().unfreezeRepaints();
            if (this.getColumnPivotHeader().getRowHeader() != null) {
                this.getColumnPivotHeader().getRowHeader().unfreezeRepaints();
            }
            if (this.getColumnPivotHeader().getGrid() != null) {
                this.getColumnPivotHeader().getGrid().unfreezeRepaints();
            }
        }
        if (this.getCrosstabDatabody() != null) {
            this.getCrosstabDatabody().unfreezeRepaints();
            if (this.getCrosstabDatabody().getColumnHeader() != null) {
                this.getCrosstabDatabody().getColumnHeader().unfreezeRepaints();
            }
            if (this.getCrosstabDatabody().getRowHeader() != null) {
                this.getCrosstabDatabody().getRowHeader().unfreezeRepaints();
            }
        }
        this.unfreezeRepaints();
    }

    private void $init$() {
        this.pivotGrid = null;
        this.colHeader = null;
        this.rowHeader = null;
        this.tips = null;
        this.selectorSize = 11;
        this.m_calculatedRowCount = 0;
        this.m_accumulatedCalculatedRowHeight = 0;
        this.m_bCheckingRowHeights = false;
        this.canPaint = true;
        this.reorderCol = -1;
        this.reorderRow = -1;
        this.m_freezeLevel = 0;
    }
}

