/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabControllerAdapter;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.EdgeComponentHandle;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.GridViewAppearanceMgr;
import oracle.dss.gridView.GridViewTips;

class CrosstabTips
extends GridViewTips {
    private static final String m_method_getcelltooltipvalue = "getCellToolTipValue(Grid grid, int column, int row)";
    private static final String m_method_getitemtooltipvalue = "getItemToolTipValue(Header header, int index)";
    protected Crosstab crosstab;
    protected CrosstabControllerAdapter controller;

    public CrosstabTips(Crosstab ct, CrosstabControllerAdapter cca, int id) {
        super(ct, cca, id);
        this.crosstab = ct;
        this.controller = cca;
    }

    public String getCellToolTipValue(Grid grid, int column, int row) {
        ViewStyle vs;
        ComponentHandle loc;
        if (column < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getcelltooltipvalue);
            return null;
        }
        if (row < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getcelltooltipvalue);
            return null;
        }
        if (this.controller == null || this.controller.getMouseEvent() == null) {
            return null;
        }
        switch (this.compId) {
            case 12: {
                loc = new DataComponentHandle(this.compId, this.crosstab.getNameFromID(12), (Object)grid, row, column);
                break;
            }
            case 10: {
                loc = new EdgeComponentHandle(this.compId, this.crosstab.getNameFromID(10), grid, 0, row, column);
                break;
            }
            case 11: {
                loc = new EdgeComponentHandle(this.compId, this.crosstab.getNameFromID(11), grid, 1, column, row);
                break;
            }
            default: {
                return null;
            }
        }
        if (this.compId == 12) {
            GridViewAppearanceMgr appMgr;
            ViewStyle vs2;
            if (this.crosstab.getCrosstabDatabody().isAnnotation(column, row, this.controller.getMouseEvent().getX() - this.crosstab.getCrosstabDatabody().getGrid().getColumnPosition(column), this.controller.getMouseEvent().getY() - this.crosstab.getCrosstabDatabody().getGrid().getRowPosition(row))) {
                Object annotation = this.crosstab.getGridViewModel().getGridViewDataSource().getAnnotation(column, row);
                if (annotation != null && annotation instanceof String[]) {
                    String[] strings = (String[])annotation;
                    StringBuffer result = new StringBuffer("");
                    if (strings.length > 0) {
                        result.append(strings[0]);
                    }
                    int i = 1;
                    while (i < strings.length) {
                        result.append("\n");
                        if (strings[i] == null) {
                            result.append("");
                        } else {
                            result.append(strings[i]);
                        }
                        ++i;
                    }
                    return result.toString();
                }
                return null;
            }
            if (this.crosstab.getCrosstabDatabody().isDrillOut(column, row, this.controller.getMouseEvent().getX() - this.crosstab.getCrosstabDatabody().getGrid().getColumnPosition(column), this.controller.getMouseEvent().getY() - this.crosstab.getCrosstabDatabody().getGrid().getRowPosition(row)) && (vs2 = (appMgr = (GridViewAppearanceMgr)this.crosstab.getCrosstabDatabody().getAppearanceManager()).getCellAppearance(column, row)) != null) {
                return vs2.getGraphicImageTooltip();
            }
        } else if (this.compId == 10) {
            ViewStyle vs3;
            if (this.crosstab.getCrosstabColumnHeader().isDrillOut(column, row, this.controller.getMouseEvent().getX() - this.crosstab.getCrosstabColumnHeader().getGrid().getColumnPosition(column), this.controller.getMouseEvent().getY() - this.crosstab.getCrosstabColumnHeader().getGrid().getRowPosition(row)) && (vs3 = this.crosstab.getCrosstabColumnHeader().getStyle(column, row)) != null) {
                return vs3.getGraphicImageTooltip();
            }
        } else if (this.compId == 11 && this.crosstab.getCrosstabRowHeader().isDrillOut(column, row, this.controller.getMouseEvent().getX() - this.crosstab.getCrosstabRowHeader().getGrid().getColumnPosition(column), this.controller.getMouseEvent().getY() - this.crosstab.getCrosstabRowHeader().getGrid().getRowPosition(row)) && (vs = this.crosstab.getCrosstabRowHeader().getStyle(column, row)) != null) {
            return vs.getGraphicImageTooltip();
        }
        String displayText = this.crosstab.getRolloverTextManager().getRolloverText(this.crosstab, loc, this.controller.getMouseEvent().getX(), this.controller.getMouseEvent().getY(), this.controller.getMouseEvent().getModifiers());
        return displayText;
    }

    public String getItemToolTipValue(Header header, int index) {
        ComponentHandle loc;
        if (index < 0) {
            this.crosstab.getErrorHandler().log("invalid index", this.getClass().getName(), m_method_getitemtooltipvalue);
            return null;
        }
        switch (this.compId) {
            case 22: {
                loc = new RowComponentHandle(this.compId, "RowHighlighter", (Object)header, index);
                break;
            }
            case 23: {
                loc = new ColumnComponentHandle(this.compId, "ColumnHighlighter", (Object)header, index);
                break;
            }
            case 24: {
                loc = new ColumnComponentHandle(this.compId, "RowGrabber", (Object)header, index);
                break;
            }
            case 25: {
                loc = new RowComponentHandle(this.compId, "ColumnGrabber", (Object)header, index);
                break;
            }
            default: {
                return null;
            }
        }
        String displayText = this.crosstab.getRolloverTextManager().getRolloverText(this.crosstab, loc, this.controller.getMouseEvent().getX(), this.controller.getMouseEvent().getY(), this.controller.getMouseEvent().getModifiers());
        return displayText;
    }
}

