/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.io.Serializable;
import oracle.bali.ewt.grid.bigCell.BigCellTwoDModel;
import oracle.dss.crosstab.ColHeaderCell;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabModel;
import oracle.dss.crosstab.RowHeaderCell;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccess2;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

abstract class HeaderData
extends BigCellTwoDModel
implements Serializable {
    protected DataAccess dataAccess;
    protected CrosstabModel model;
    protected Crosstab crosstab;
    protected int maxDepth;
    protected int currentSlice;
    private boolean calculating;
    private static final String m_method_getdata = "getData(int columnIndex, int rowIndex)";

    HeaderData(Crosstab _crosstab) {
        super(0, 0);
        this.$init$();
        this.crosstab = _crosstab;
        this.model = _crosstab.getCrosstabModel();
        this.dataAccess = this.model.getDataAccess();
    }

    public void setData(int columnIndex, int rowIndex, Object data) {
    }

    protected abstract boolean isRowHeader();

    public Object getData(int columnIndex, int rowIndex) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            this.model.getErrorHandler().log("columnIndex out of bounds", this.getClass().getName(), m_method_getdata);
        }
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            this.model.getErrorHandler().log("rowIndex out of bounds", this.getClass().getName(), m_method_getdata);
        }
        Object data = super.getData(columnIndex, rowIndex);
        if (this.isCalculating()) {
            return data;
        }
        if (data != null) {
            return data;
        }
        if (this.crosstab.getModel().getDataAccess() instanceof DataAccess2) {
            DataAccess2 dataAccess3 = (DataAccess2)this.crosstab.getModel().getDataAccess();
            if (this.isRowHeader()) {
                if (rowIndex > this.currentSlice) {
                    int maxRows = this.crosstab.getCrosstabRowHeader().getModel().getRowCount();
                    this.currentSlice = rowIndex + 20;
                    if (this.currentSlice > maxRows - 1) {
                        this.currentSlice = maxRows - 1;
                    }
                    int[] startSlice = new int[]{0, rowIndex};
                    int[] endSlice = new int[]{0, this.currentSlice};
                    try {
                        if (!dataAccess3.isFetched(startSlice, endSlice, 4)) {
                            this.crosstab.forceFetchFromDataAccess(startSlice, endSlice, 4, dataAccess3);
                        }
                    }
                    catch (DataException e) {
                        this.model.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getData()");
                    }
                }
            } else if (columnIndex > this.currentSlice) {
                int maxColumns = this.crosstab.getCrosstabColumnHeader().getModel().getColumnCount();
                this.currentSlice = columnIndex + 20;
                if (this.currentSlice > maxColumns - 1) {
                    this.currentSlice = maxColumns - 1;
                }
                int[] startSlice = new int[]{columnIndex, 0};
                int[] endSlice = new int[]{this.currentSlice, 0};
                try {
                    if (!dataAccess3.isFetched(startSlice, endSlice, 4)) {
                        this.crosstab.forceFetchFromDataAccess(startSlice, endSlice, 4, dataAccess3);
                    }
                }
                catch (DataException e) {
                    this.model.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getData()");
                }
            }
        }
        return this.calculateCell(columnIndex, rowIndex);
    }

    void invalidateHeader() {
        this.fireModelEvent(2007, 0, this.getColumnCount(), 0, this.getRowCount());
    }

    protected int getMaximumDepth(int edge, int size) throws EdgeOutOfRangeException {
        if (this.maxDepth > -1) {
            return this.maxDepth;
        }
        int depth = 0;
        try {
            int index = 0;
            while (index < size) {
                depth = this.dataAccess.getSliceMemberCount(edge, index);
                if (depth > this.maxDepth) {
                    this.maxDepth = depth;
                }
                ++index;
            }
        }
        catch (SliceOutOfRangeException e) {
            this.model.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getMaximumDepth");
        }
        return this.maxDepth;
    }

    protected Object calculateCell(int column, int row) {
        Object c;
        this.setCalculating(true);
        try {
            int indexSpan;
            int depthSpanStart;
            int indexSpanStart;
            int edge;
            if (this.isRowHeader()) {
                edge = 1;
                indexSpanStart = this.dataAccess.getMemberStartSlice(edge, column, row);
                depthSpanStart = this.dataAccess.getMemberStartLayer(edge, column, row);
                if (this.model.isOutline()) {
                    depthSpanStart = 0;
                    indexSpan = 1;
                } else {
                    indexSpan = this._mySpan(edge, depthSpanStart, indexSpanStart);
                }
            } else {
                edge = 0;
                indexSpanStart = this.dataAccess.getMemberStartSlice(edge, row, column);
                depthSpanStart = this.dataAccess.getMemberStartLayer(edge, row, column);
                indexSpan = this._mySpan(edge, depthSpanStart, indexSpanStart);
            }
            int depthSpan = this.dataAccess.getMemberDepth(edge, depthSpanStart, indexSpanStart);
            c = this._setCellSize(edge, depthSpanStart, depthSpan, indexSpanStart, indexSpan);
        }
        catch (DataException e) {
            this.model.getErrorHandler().error((Throwable)e, this.getClass().getName(), "calculateCell");
            c = null;
        }
        this.setCalculating(false);
        return c;
    }

    private Object _setCellSize(int edge, int depth, int depthSpan, int index, int size) {
        if (!this.isRowHeader()) {
            ColHeaderCell c = new ColHeaderCell(this.crosstab, depth, depthSpan, index, size);
            super.storeCell(index, size, depth, depthSpan, (Object)c);
            return c;
        }
        RowHeaderCell c = new RowHeaderCell(this.crosstab, depth, depthSpan, index, size);
        super.storeCell(depth, depthSpan, index, size, (Object)c);
        return c;
    }

    private int _mySpan(int edge, int depth, int index) throws LayerOutOfRangeException, EdgeOutOfRangeException, SliceOutOfRangeException {
        return this.dataAccess.getMemberExtent(edge, depth, index);
    }

    protected void setCalculating(boolean calc) {
        this.calculating = calc;
    }

    protected boolean isCalculating() {
        return this.calculating;
    }

    private void $init$() {
        this.dataAccess = null;
        this.model = null;
        this.crosstab = null;
        this.maxDepth = -1;
        this.currentSlice = -1;
        this.calculating = false;
    }
}

