/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabHeaderCell;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class RowHeaderCell
extends CrosstabHeaderCell {
    private int m_position;
    protected static final StringBuffer INDENT_UNIT = new StringBuffer(" ");
    private static final String m_rowHeaderCell = "RowHeaderCell(CrosstabModel model, int layer, int depth, int slice, int extent)";
    protected Crosstab m_crosstab;

    public RowHeaderCell(Crosstab crosstab, int layer, int depth, int slice, int extent) {
        super(crosstab, layer, depth, slice, extent);
        this.$init$();
        this.m_crosstab = crosstab;
        this.m_model = crosstab.getCrosstabModel();
        this.m_position = this.m_layer;
        if (this.m_model.isOutline()) {
            try {
                this.m_layer = this.m_model.getDataAccess().getSliceOutlineLayer(this.getEdge(), this.m_slice);
            }
            catch (EdgeOutOfRangeException eoore) {
                this.m_model.getErrorHandler().log("edge out of range", this.getClass().getName(), m_rowHeaderCell);
            }
            catch (SliceOutOfRangeException soore) {
                this.m_model.getErrorHandler().log("slice out of range", this.getClass().getName(), m_rowHeaderCell);
            }
            this.m_position = 0;
        }
    }

    public int getColumn() {
        return this.m_position;
    }

    public int getRow() {
        return this.m_slice;
    }

    public int getColumnCount() {
        return this.m_depth;
    }

    public int getRowCount() {
        return this.m_extent;
    }

    protected int getEdge() {
        return 1;
    }

    protected String applyIndent(String data, int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (!this.m_model.isIndentEnabled() || this.m_model.isOutline()) {
            return data;
        }
        Object spaceObj = null;
        if (this.m_crosstab.isMetadataRelIndentSupported()) {
            spaceObj = this.m_model.getDataAccess().getMemberMetadata(edge, this.m_layer, this.m_slice, "relIndent");
        } else if (this.m_crosstab.isMetadataIndentSupported()) {
            spaceObj = this.m_model.getDataAccess().getMemberMetadata(edge, this.m_layer, this.m_slice, "hierLevel");
        }
        if (spaceObj == null || !(spaceObj instanceof Integer)) {
            return data;
        }
        int spaces = (Integer)spaceObj;
        StringBuffer prefix = new StringBuffer();
        int i = 0;
        while (i < spaces * this.m_model.getAutoIndent()) {
            prefix.append(INDENT_UNIT);
            ++i;
        }
        return prefix + data;
    }

    private void $init$() {
        this.m_position = 0;
        this.m_crosstab = null;
    }
}

