/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.dss.dataView.BaseTitleAttributes;
import oracle.dss.dataView.BaseTitleXML;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.util.xml.ObjectNode;

public abstract class BaseTitle
extends JLabel
implements DataviewTitles,
ViewComponent,
Serializable,
BaseTitleAttributes {
    protected BitSet _userOverrideFlags;
    protected BitSet _styleOverrideFlags;
    protected Dataview dataView;
    protected boolean m_underline;
    protected int m_horzAlign;
    protected Font m_font;
    protected FontMetrics fm;
    protected int baseline;
    protected int constrainWidth;
    protected int zoomFactor;
    protected String m_text;
    protected static final String m_errorMsg = "Text is null";
    protected static final String m_errorBG = "Background is null";
    protected static final String m_errorFG = "Foreground is null";
    protected static final String m_errorSetFont = "Font size is less or equal to 0";
    protected static final String m_errorSetZoom = "Zoom factor is negative";
    protected static final String m_errorSetHA = "Invalid value for Horizontal Alignment";
    protected static final String m_method_setText = "setText";
    protected static final String m_method_setBG = "setBackground";
    protected static final String m_method_setFG = "setForeground";
    protected static final String m_method_setFont = "setFont";
    protected static final String m_method_setZoomFactor = "setZoomFactor";
    protected static final String m_method_setHA = "setHorizontalAlignment";
    private Color focusColor;
    private boolean selected;
    private boolean m_visible;
    protected BaseTitleXML _baseTitleXML;
    protected int d_fontSize;
    protected String m_version;

    public BaseTitle(String t, Dataview v) {
        this.$init$();
        this.dataView = v;
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setVisible(DataviewDefaultValues.isBaseTitleVisible());
        }
        super.setForeground(DataviewDefaultValues.getBaseTitleForeground());
        super.setBackground(DataviewDefaultValues.getBaseTitleBackground());
        super.setHorizontalAlignment(DataviewDefaultValues.getBaseTitleHorizontalAlignment());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setText(t);
        this.setOpaque(true);
        this.m_version = "";
        if (v != null) {
            this.m_version = v.getVersion();
        }
        this.createPropertyOverrideFlags();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setVisible(boolean b) {
        boolean oldVal = this.isVisible();
        if (oldVal != b) {
            if (this.dataView != null && this.dataView.isJavaComponent()) {
                super.setVisible(b);
                this.dataView.validate();
            } else {
                this.m_visible = b;
            }
        }
    }

    public boolean isVisible() {
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            return super.isVisible();
        }
        return this.m_visible;
    }

    public void setText(String t) {
        if (t == null) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(m_errorMsg, this.getClass().getName(), m_method_setText);
            }
            return;
        }
        if (this.dataView != null) {
            String oldVal = this.getText();
            TokenSubstitution vs = this.dataView.getTokenSubstitution();
            String[] tokenArray = null;
            if (vs != null) {
                tokenArray = vs.getListItems();
                int i = 0;
                while (i < tokenArray.length) {
                    tokenArray[i] = vs.getToken(tokenArray[i]);
                    ++i;
                }
            }
            t = this.truncateText(t, tokenArray);
            String pstring = vs.getParsedString(t);
            if (oldVal != null && !oldVal.equals(pstring) || oldVal == null && pstring != null) {
                super.setText(pstring);
                this.m_text = t;
                if (this.dataView != null && this.dataView.isJavaComponent()) {
                    this.invalidate();
                    this.dataView.validate();
                    this.repaint();
                }
            }
        } else {
            t = this.truncateText(t);
            super.setText(t);
            this.m_text = t;
        }
    }

    public String getText() {
        if (this.dataView == null) {
            return super.getText();
        }
        TokenSubstitution vs = this.dataView.getTokenSubstitution();
        return vs.getParsedString(this.m_text);
    }

    public String getUnParseText() {
        return this.m_text;
    }

    public void setBackground(Color bg) {
        if (bg == null) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(m_errorBG, this.getClass().getName(), m_method_setBG);
            }
            return;
        }
        super.setBackground(bg);
        this.setPropertyOverrideFlags(5);
    }

    public void setForeground(Color fg) {
        if (fg == null) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(m_errorFG, this.getClass().getName(), m_method_setFG);
            }
            return;
        }
        super.setForeground(fg);
        this.setPropertyOverrideFlags(4);
    }

    public void setFont(Font f) {
        if (f.getSize() <= 0) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(m_errorSetFont, this.getClass().getName(), m_method_setFont);
            }
            return;
        }
        this.m_font = f;
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setFont(f);
        }
        this.setPropertyOverrideFlags(0);
        this.setPropertyOverrideFlags(2);
        this.setPropertyOverrideFlags(3);
        this.setPropertyOverrideFlags(1);
    }

    public Font getFont() {
        Font f = this.getUnscaledFont();
        if (this.dataView != null) {
            return this.dataView.scaleFont(f, this.zoomFactor);
        }
        return f;
    }

    public Font getUnscaledFont() {
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            return super.getFont();
        }
        return this.m_font;
    }

    public int getFontSize() {
        return this.getFont().getSize();
    }

    public void setFontSize(int size) {
        Font f = this.getFont();
        this.m_font = new Font(f.getName(), f.getStyle(), size);
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setFont(this.m_font);
        }
        this.setPropertyOverrideFlags(1);
    }

    public String getFontName() {
        return this.getFont().getName();
    }

    public void setFontName(String name) {
        Font f = this.getFont();
        this.m_font = new Font(name, f.getStyle(), f.getSize());
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setFont(this.m_font);
        }
        this.setPropertyOverrideFlags(0);
    }

    public boolean isFontBold() {
        return this.getFont().isBold();
    }

    public void setFontBold(boolean bold) {
        Font f = this.getFont();
        int style = f.getStyle();
        style = bold ? (style |= 1) : (style &= 0xFFFFFFFE);
        this.m_font = new Font(f.getName(), style, f.getSize());
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setFont(this.m_font);
        }
        this.setPropertyOverrideFlags(2);
    }

    public boolean isFontItalic() {
        return this.getFont().isItalic();
    }

    public void setFontItalic(boolean italic) {
        Font f = this.getFont();
        int style = f.getStyle();
        style = italic ? (style |= 2) : (style &= 0xFFFFFFFD);
        this.m_font = new Font(f.getName(), style, f.getSize());
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setFont(this.m_font);
        }
        this.setPropertyOverrideFlags(3);
    }

    public void setStyleProperty(int attrID, String value) {
        switch (attrID) {
            case 0: {
                this.setFontName(value);
                break;
            }
            case 1: {
                this.setFontSize(Integer.valueOf(value));
                break;
            }
            case 2: {
                this.setFontBold(Boolean.valueOf(value));
                break;
            }
            case 3: {
                this.setFontItalic(Boolean.valueOf(value));
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
    }

    public void setUnderline(boolean underline) {
        if (this.m_underline != underline) {
            this.m_underline = underline;
            if (this.dataView != null && this.dataView.isJavaComponent()) {
                this.invalidate();
                this.repaint();
            }
        }
        this.setPropertyOverrideFlags(6);
    }

    public boolean isUnderline() {
        return this.m_underline;
    }

    public void setHorizontalAlignment(int alignment) {
        if (alignment == 4 || alignment == 2 || alignment == 0 || alignment == 10) {
            super.setHorizontalAlignment(alignment);
            this.setPropertyOverrideFlags(7);
        } else if (this.dataView != null) {
            this.dataView.getErrorHandler().log(m_errorSetHA, this.getClass().getName(), m_method_setHA);
        }
    }

    public int getHorizontalAlignment() {
        return super.getHorizontalAlignment();
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public BeanInfo getBeanInfo() {
        return null;
    }

    public String getToolTipText(MouseEvent event) {
        ViewComponent c = this;
        return this.dataView.getRolloverTextManager().getRolloverText(this.dataView, new NonDataComponentHandle(c.getID(), c.getComponentName(), c), event.getX(), event.getY(), event.getModifiers());
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = this.adjustForEnhancements(super.getPreferredSize());
        String strText = this.getText();
        if (strText == null) {
            return prefSize;
        }
        Border b = this.getBorder();
        Insets insets = b != null ? b.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        StringTokenizer st = new StringTokenizer(strText, "\r\n");
        int iNumLines = st.countTokens();
        int iExtraLines = 0;
        int iMaxWidth = 0;
        this.fm = this.getToolkit().getFontMetrics(this.getFont());
        int i = 0;
        while (i < iNumLines) {
            int iThis = this.fm.stringWidth(st.nextToken());
            this.constrainWidth = this.dataView.isPrintOrPreviewMode() ? this.getBounds().width : this.getParent().getParent().getBounds().width;
            if (iThis > this.constrainWidth && this.constrainWidth != 0) {
                iExtraLines += iThis / this.constrainWidth;
                iThis %= this.constrainWidth;
                iMaxWidth = this.constrainWidth;
            }
            if (iThis > iMaxWidth) {
                iMaxWidth = iThis;
            }
            ++i;
        }
        int iMaxHeight = (iNumLines + iExtraLines) * this.fm.getHeight();
        this.fm = null;
        return this.adjustForEnhancements(new Dimension(iMaxWidth + insets.left + insets.right, iMaxHeight + insets.top + insets.bottom));
    }

    /*
     * Unable to fully structure code
     */
    public void paintComponent(Graphics g) {
        block11: {
            strText = this.getText();
            b = this.getBorder();
            insets = b != null ? b.getBorderInsets(this) : new Insets(0, 0, 0, 0);
            this.fm = this.getToolkit().getFontMetrics(this.getFont());
            this.baseline = this.fm.getMaxAscent();
            x = insets.left;
            y = insets.top;
            boundx = this.getWidth() - insets.right - insets.left;
            boundy = this.getHeight() - insets.bottom - insets.top;
            tempColor = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(tempColor);
            if (strText == null) break block11;
            st = new StringTokenizer(strText, "\r\n");
            lines = new String[st.countTokens()];
            iLineIndex = 0;
            while (st.hasMoreTokens()) {
                lines[iLineIndex++] = st.nextToken();
            }
            outStrings = new Vector<String>();
            iLineIndex = 0;
            while (y <= boundy && iLineIndex < lines.length) {
                block12: {
                    strText = lines[iLineIndex++];
                    fromIndex = 0;
                    pos = 0;
                    break block12;
                    while (++fromIndex < strText.length()) lbl-1000:
                    // 2 sources

                    {
                        ** while (fromIndex >= strText.length() || strText.charAt((int)fromIndex) != ' ')
lbl30:
                        // 1 sources

                    }
lbl31:
                    // 2 sources

                    pos = fromIndex;
                    bestpos = -1;
                    largestString = null;
                    while (pos >= fromIndex) {
                        s = (pos = strText.indexOf(32, pos)) == -1 ? strText.substring(fromIndex) : strText.substring(fromIndex, pos);
                        if (this.fm.stringWidth(s) > boundx) break;
                        largestString = s;
                        bestpos = pos;
                        if (pos == -1) break;
                        ++pos;
                    }
                    if (largestString == null) {
                        totalWidth = 0;
                        pos = fromIndex;
                        while (pos < strText.length()) {
                            oneCharWidth = this.fm.charWidth(strText.charAt(pos));
                            if (totalWidth + oneCharWidth > boundx) break;
                            totalWidth += oneCharWidth;
                            ++pos;
                        }
                        outStrings.addElement(strText.substring(fromIndex, pos));
                        fromIndex = pos;
                    } else {
                        outStrings.addElement(largestString);
                        fromIndex = bestpos;
                    }
                    y += this.fm.getHeight();
                }
                if (y <= boundy && fromIndex != -1) ** GOTO lbl-1000
            }
            y = insets.top + (boundy - outStrings.size() * this.fm.getHeight()) / 2;
            if (y < insets.top) {
                y = insets.top;
            }
            i = 0;
            while (i < outStrings.size()) {
                this.drawAlignedString(g, (String)outStrings.elementAt(i), x, y, boundx, false);
                if ((y += this.fm.getHeight()) > boundy) break;
                ++i;
            }
            this.fm = null;
            outStrings = null;
        }
        if (this.isSelected()) {
            r = new Rectangle(insets.left, insets.top, boundx, boundy);
            this.paintFocus(g, r);
        }
    }

    public static void drawEnhancedAdornments(FontMetrics metrics, Graphics g, int x, int y, int sw, boolean underline, boolean doubleUnderline, boolean strikeThrough) {
        if (underline) {
            g.drawLine(x, y + 2, x + sw, y + 2);
        } else if (doubleUnderline) {
            g.drawLine(x, y + 2, x + sw, y + 2);
            g.drawLine(x, y + 2 + 2, x + sw, y + 2 + 2);
        }
        if (strikeThrough) {
            g.drawLine(x, y - metrics.getAscent() / 2 + 1, x + sw, y - metrics.getAscent() / 2 + 1);
        }
    }

    public void setZoomFactor(int f) {
        if (f < 0) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(m_errorSetZoom, this.getClass().getName(), m_method_setZoomFactor);
            }
            return;
        }
        this.zoomFactor = f;
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            this.invalidate();
            this.repaint();
        }
    }

    public void setSelected(boolean sel) {
        if (sel != this.isSelected()) {
            this.selected = sel;
            this.repaint();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public boolean isForegroundUsed() {
        return this.isUserOverrideFlag(4);
    }

    public boolean isBackgroundUsed() {
        return this.isUserOverrideFlag(5);
    }

    protected void paintFocus(Graphics g, Rectangle focusRect) {
        Color tempColor = g.getColor();
        g.setColor(this.focusColor);
        g.drawRect(focusRect.x, focusRect.y, focusRect.width - 1, focusRect.height - 1);
        g.setColor(tempColor);
    }

    protected void drawAlignedString(Graphics g, String s, int x, int y, int width, boolean bDontdraw) {
        String language;
        int sw = this.fm.stringWidth(s);
        if (this.dataView != null && this.dataView.getLocale() != null && this.getHorizontalAlignment() == 10 && ((language = this.getLocale().getLanguage()).equals("ar") || language.equals("he") || language.equals("iw"))) {
            x = x + width - sw;
        }
        if (this.getHorizontalAlignment() == 0) {
            x += (width - sw) / 2;
        } else if (this.getHorizontalAlignment() == 4) {
            x = x + width - sw;
        }
        if (!bDontdraw) {
            g.drawString(s, x, y + this.baseline);
        }
        BaseTitle.drawEnhancedAdornments(this.fm, g, x, y + this.baseline, sw, this.isUnderline(), false, false);
    }

    protected Dimension adjustForEnhancements(Dimension size) {
        Dimension newSize = new Dimension(size);
        newSize.setSize(size.width, DataviewUtils.adjustForEnhancedFont(size.height, this.isUnderline(), false));
        return newSize;
    }

    public abstract String getComponentName();

    public void setXML(ObjectNode node, String version, int reset) {
        this._baseTitleXML.setXML(node, version, reset);
    }

    public void setXML(ObjectNode node, String version, int reset, HashMap map) {
        this._baseTitleXML.setXML(node, version, reset, map);
    }

    public ObjectNode getXML(boolean allProperties) {
        return this._baseTitleXML.getXML(allProperties);
    }

    public void setStyleXML(ObjectNode node, String version, int reset) {
        this._baseTitleXML.setStyleXML(node);
    }

    public ObjectNode getStyleXML(boolean allProperties) {
        return this._baseTitleXML.getStyleXML(allProperties);
    }

    public void resetToDefault(int reset) {
        this.resetToDefault(reset, this.dataView.getVersion());
    }

    public void resetToDefault(int reset, String version) {
        this._baseTitleXML.resetToDefault(reset, version);
        this.createPropertyOverrideFlags();
    }

    protected Font initializeFont() {
        this.m_font = this.dataView != null ? this.dataView.getFontList().getFont(DataviewDefaultValues.getBaseTitleFontName(), DataviewUtils.fontStyle(DataviewDefaultValues.isBaseTitleFontBold(), DataviewDefaultValues.isBaseTitleFontItalic()), this.d_fontSize) : new Font(DataviewDefaultValues.getBaseTitleFontName(), DataviewUtils.fontStyle(DataviewDefaultValues.isBaseTitleFontBold(), DataviewDefaultValues.isBaseTitleFontItalic()), this.d_fontSize);
        return this.m_font;
    }

    public void createPropertyOverrideFlags() {
        if (this.dataView != null) {
            this._userOverrideFlags = this.dataView.createPropertyOverrideFlags(8);
            this._styleOverrideFlags = this.dataView.createPropertyOverrideFlags(8);
        }
    }

    private void setPropertyOverrideFlags(int attrID) {
        if (this.dataView != null) {
            this.dataView.setPropertyOverrideFlags(attrID, this._userOverrideFlags, this._styleOverrideFlags);
        }
    }

    public boolean isUserOverrideFlag(int attrID) {
        if (this.dataView == null) {
            return false;
        }
        return this.dataView.isPropertyOverrideFlag(attrID, this._userOverrideFlags);
    }

    public boolean isStyleOverrideFlag(int attrID) {
        if (this.dataView == null) {
            return false;
        }
        return this.dataView.isPropertyOverrideFlag(attrID, this._styleOverrideFlags);
    }

    public void resetStyle() {
        this._baseTitleXML.resetStyle();
        this.createPropertyOverrideFlags();
    }

    private String truncateText(String txt) {
        return this.truncateText(txt, null);
    }

    private String truncateText(String txt, String[] tokenArray) {
        if (txt.length() <= 1024) {
            return txt;
        }
        int index = 0;
        String maxStr = txt.substring(0, 1024);
        if (tokenArray != null) {
            int lastTokenIndex = -1;
            int tokenLength = 0;
            int i = 0;
            while (i < tokenArray.length) {
                String tokenStr = tokenArray[i];
                index = maxStr.lastIndexOf(tokenStr);
                if (index > lastTokenIndex) {
                    lastTokenIndex = index;
                    tokenLength = tokenStr.length();
                }
                ++i;
            }
            if (lastTokenIndex == -1) {
                if (txt.charAt(1024) != ' ' && (index = maxStr.lastIndexOf(32)) != -1) {
                    maxStr = maxStr.substring(0, index);
                }
            } else if (txt.charAt(1024) != ' ') {
                index = maxStr.lastIndexOf(32);
                maxStr = index != -1 ? (index > lastTokenIndex ? maxStr.substring(0, index) : maxStr.substring(0, lastTokenIndex + tokenLength)) : maxStr.substring(0, lastTokenIndex + tokenLength);
            }
        } else if (txt.charAt(1024) != ' ' && (index = maxStr.lastIndexOf(32)) != -1) {
            maxStr = maxStr.substring(0, index);
        }
        return maxStr;
    }

    private void $init$() {
        this._userOverrideFlags = null;
        this._styleOverrideFlags = null;
        this.dataView = null;
        this.m_underline = DataviewDefaultValues.isBaseTitleUnderline();
        this.m_horzAlign = DataviewDefaultValues.getBaseTitleHorzAlign();
        this.constrainWidth = -1;
        this.zoomFactor = 100;
        this.m_text = DataviewDefaultValues.getBaseTitleText();
        this.focusColor = UIManager.getColor("Button.focus");
        this.selected = DataviewDefaultValues.isBaseTitleSelected();
        this.m_visible = DataviewDefaultValues.isBaseTitleVisible();
    }
}

