/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import oracle.dss.dataView.BaseTitleAttributes;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class BaseTitleXML {
    public static String a_visible = "visible";
    public static String a_text = "text";
    public static String a_horzAlign = "horzAlign";
    protected boolean d_visible;
    protected String d_text;
    protected boolean d_underline;
    protected boolean d_fontBold;
    protected boolean d_fontItalic;
    protected String d_fontName;
    protected int d_fontSize;
    protected int d_horzAlign;
    protected Color d_background;
    protected Color d_foreground;
    protected BaseTitleAttributes _baseTitle;
    protected String _version;
    private HashMap m_jsfHashMap;

    public BaseTitleXML(BaseTitleAttributes baseTitle, String version) {
        this.$init$();
        this._baseTitle = baseTitle;
        this._version = version;
    }

    public void setXML(ObjectNode node, String version, int reset, HashMap map) {
        if (map != null) {
            this.m_jsfHashMap = (HashMap)map.get(this._baseTitle.getComponentName());
        }
        try {
            this.setXML(node, version, reset);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    public void setXML(ObjectNode node, String version, int reset) {
        PropertyNode pNode = node.getProperty(a_text);
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_text, pNode.getValueAsString());
            } else {
                this._baseTitle.setText(pNode.getValueAsString());
            }
        }
        if ((pNode = node.getProperty(a_visible)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_visible, new Boolean(pNode.getValueAsBoolean()));
            } else {
                this._baseTitle.setVisible(pNode.getValueAsBoolean());
            }
        }
        this.setStyleXML(node);
    }

    public void setStyleXML(ObjectNode node) {
        String fontProperty;
        PropertyNode pNode = node.getProperty("fontName");
        if (pNode != null) {
            fontProperty = pNode.getValueAsString();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fontName", fontProperty);
            } else {
                this._baseTitle.setStyleProperty(0, fontProperty);
            }
        }
        if ((pNode = node.getProperty("fontSize")) != null) {
            fontProperty = pNode.getValueAsString();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fontSize", new Integer(pNode.getValueAsInteger()));
            } else {
                this._baseTitle.setStyleProperty(1, fontProperty);
            }
        }
        if ((pNode = node.getProperty("fontBold")) != null) {
            fontProperty = pNode.getValueAsString();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fontBold", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this._baseTitle.setStyleProperty(2, fontProperty);
            }
        }
        if ((pNode = node.getProperty("fontItalic")) != null) {
            fontProperty = pNode.getValueAsString();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fontItalic", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this._baseTitle.setStyleProperty(3, fontProperty);
            }
        }
        if ((pNode = node.getProperty(a_horzAlign)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_horzAlign, new Integer(PresUtils.convertHorizontalAlignmentToInt(pNode.getValueAsString())));
            } else {
                this._baseTitle.setHorizontalAlignment(PresUtils.convertHorizontalAlignmentToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("foreground")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("foreground", new Color(DataviewUtils.hexStringToInt(pNode.getValueAsString())));
            } else {
                this._baseTitle.setForeground(new Color(DataviewUtils.hexStringToInt(pNode.getValueAsString())));
            }
        }
        if ((pNode = node.getProperty("background")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("background", new Color(DataviewUtils.hexStringToInt(pNode.getValueAsString())));
            } else {
                this._baseTitle.setBackground(new Color(DataviewUtils.hexStringToInt(pNode.getValueAsString())));
            }
        }
        if ((pNode = node.getProperty("underline")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("underline", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this._baseTitle.setUnderline(pNode.getValueAsBoolean());
            }
        }
    }

    public ObjectNode getXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(this._baseTitle.getComponentName());
        boolean nodeExists = this.getStyleXML(allProperties, node);
        if (allProperties || !this.d_text.equals(this._baseTitle.getUnParseText())) {
            node.addProperty(a_text, this._baseTitle.getUnParseText());
            nodeExists = true;
        }
        if (allProperties || this.d_visible != this._baseTitle.isVisible()) {
            node.addProperty(a_visible, this._baseTitle.isVisible());
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    public ObjectNode getStyleXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(this._baseTitle.getComponentName());
        return this.getStyleXML(allProperties, node) ? node : null;
    }

    private boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = false;
        if (allProperties || this._baseTitle.isUserOverrideFlag(0)) {
            node.addProperty("fontName", this._baseTitle.getFont().getName());
            styleOverridden = true;
        }
        if (allProperties || this._baseTitle.isUserOverrideFlag(1)) {
            node.addProperty("fontSize", this._baseTitle.getFont().getSize());
            styleOverridden = true;
        }
        if (allProperties || this._baseTitle.isUserOverrideFlag(2)) {
            node.addProperty("fontBold", this._baseTitle.getFont().isBold());
            styleOverridden = true;
        }
        if (allProperties || this._baseTitle.isUserOverrideFlag(3)) {
            node.addProperty("fontItalic", this._baseTitle.getFont().isItalic());
            styleOverridden = true;
        }
        if (allProperties || this._baseTitle.isUserOverrideFlag(7)) {
            node.addProperty(a_horzAlign, PresUtils.convertHorizontalAlignmentToString(this._baseTitle.getHorizontalAlignment()));
            styleOverridden = true;
        }
        if (allProperties || this._baseTitle.isUserOverrideFlag(4)) {
            node.addProperty("foreground", DataviewUtils.toHexString(this._baseTitle.getForeground().getRGB()));
            styleOverridden = true;
        }
        if (allProperties || this._baseTitle.isUserOverrideFlag(5)) {
            node.addProperty("background", DataviewUtils.toHexString(this._baseTitle.getBackground().getRGB()));
            styleOverridden = true;
        }
        if (allProperties || this._baseTitle.isUserOverrideFlag(6)) {
            node.addProperty("underline", this._baseTitle.isUnderline());
            styleOverridden = true;
        }
        return styleOverridden;
    }

    public void resetToDefault(int reset) {
        this.resetToDefault(reset, this._version);
    }

    protected void resetToDefault(int reset, String version) {
        this._baseTitle.setText(this.d_text);
        this._baseTitle.setVisible(this.d_visible);
        this.resetStyle();
    }

    public void resetStyle() {
        this._baseTitle.setUnderline(this.d_underline);
        this._baseTitle.setBackground(this.d_background);
        this._baseTitle.setForeground(this.d_foreground);
        this._baseTitle.setFont(new Font(this.d_fontName, DataviewUtils.fontStyle(this.d_fontBold, this.d_fontItalic), this.d_fontSize));
        this._baseTitle.setHorizontalAlignment(this.d_horzAlign);
    }

    private void $init$() {
        this.d_visible = DataviewDefaultValues.isBaseTitleVisible();
        this.d_text = DataviewDefaultValues.getBaseTitleText();
        this.d_underline = DataviewDefaultValues.isBaseTitleUnderline();
        this.d_fontBold = DataviewDefaultValues.isBaseTitleFontBold();
        this.d_fontItalic = DataviewDefaultValues.isBaseTitleFontItalic();
        this.d_fontName = DataviewDefaultValues.getBaseTitleFontName();
        this.d_horzAlign = DataviewDefaultValues.getBaseTitleHorzAlign();
        this.d_background = DataviewDefaultValues.getBaseTitleBackground();
        this.d_foreground = DataviewDefaultValues.getBaseTitleForeground();
        this.m_jsfHashMap = null;
    }
}

