/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Font;
import java.beans.Beans;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.dss.dataView.DataviewAttributes;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewConstants;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.dataView.FontList;
import oracle.dss.dataView.LocalXMLDataSource;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.ThickDataview;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.TokenSubstitutionAdapter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataSource;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.WaitData;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.XMLObjectWriter;

public class CommonDataview
implements DataviewCommon,
DataviewConstants,
DataviewAttributes {
    protected FontList fontList;
    protected transient ErrorHandler m_eh;
    private DataAccess m_dataAccess;
    private DataDirector m_dataDirector;
    protected ThickDataview m_thickView;
    protected DataviewXML m_viewXML;
    protected String[] m_memberMetadataLabelTypes;
    protected String[] m_layerMetadataLabelTypes;
    protected WaitData[] m_waitDataForRows;
    protected boolean m_dataUnformattedSupported;
    protected boolean m_metaDateSupported;
    protected boolean m_metaLonglabelSupported;
    protected boolean m_metaMediumlabelSupported;
    protected boolean m_metaShortlabelSupported;
    protected boolean m_metaViewStyleSupported;
    protected boolean m_metaValueSupported;
    protected boolean m_layermetaShortlabelSupported;
    protected boolean m_layermetaMediumlabelSupported;
    protected boolean m_layermetaLonglabelSupported;
    protected boolean m_layermetaNameSupported;
    protected boolean m_layermetaViewStyleSupported;
    protected transient PersistableAttributes m_attrs;
    protected ResourceBundle m_dvStrings;
    private boolean _userOverrideMode;
    private boolean _styleOverrideMode;
    private boolean _styleModified;
    private Model m_model;
    private Locale m_locale;
    protected boolean m_htmlPagingControlAutosubmit;
    protected int m_htmlPagingControlWidth;
    protected String m_name;
    protected String m_localName;
    protected String m_description;
    protected int m_pagingControlPosition;
    protected boolean m_pagingVisible;
    protected boolean m_validate;
    private boolean m_drillingEnabled;
    private TokenSubstitution m_tokenSubstitution;
    public static final String a_animationOnDataChange = "animationOnDataChange";
    public static final String a_animationIndicators = "animationIndicators";
    public static final String a_animationUpColor = "animationUpColor";
    public static final String a_animationDownColor = "animationDownColor";
    public static final String a_animationDuration = "animationDuration";
    public static final String a_animationOnDisplay = "animationOnDisplay";
    public static final String a_visualEffects = "visualEffects";
    public static final String adc_none = "NONE";
    public static final String adc_auto = "AUTO";
    public static final String adc_on = "ON";
    public static final String ai_none = "NONE";
    public static final String ai_all = "ALL";
    public static final String ad_none = "NONE";
    public static final String ad_auto = "AUTO";
    public static final String ve_none = "NONE";
    public static final String ve_auto = "AUTO";
    public static final String ve_shadow = "SHADOW";
    public static final String ve_glow = "GLOW";
    public static final String ve_bevel = "BEVEL";
    protected static final String m_method_setName = "setName(String n)";
    protected static final String m_method_setLocalName = "setLocalName(String n)";
    protected static final String m_method_setDescription = "setDescription(String n)";
    private static final String m_method_setMemberMetadataLabelType = "public void setMemberMetadataLabelType(int edge, String type)";
    private static final String m_method_getMemberMetadataLabelType = "public String getMemberMetadataLabelType(int edge)";
    private static final String m_method_setMemberMetadataLabelType_all = "public void setMemberMetadataLabelType(String type)";
    private static final String m_method_setLayerMetadataLabelType = "public void setLayerMetadataLabelType(int edge, String type)";
    private static final String m_method_getLayerMetadataLabelType = "public String getLayerMetadataLabelType(int edge)";
    private static final String m_method_setLayerMetadataLabelType_all = "public void setLayerMetadataLabelType(String type)";
    private static final String m_method_setGridData = "public void setGridData(Object[] columnLabels, Object[] rowLabels, Object[][] data)";
    private static final String m_method_setTabularData = "setTabularData(List tableRows)";
    protected static final String m_method_fillRelationalDataArrays = "protected void fillRelationalDataArrays(int colCount, int rowCount, List colLabelsList, List rowLabelsList, Hashtable dataVals, Object[] colLabels, Object[] rowLabels, Object[][] data)";

    public CommonDataview(Locale loc) {
        this.$init$();
        this.setLocale(loc);
        DefaultErrorHandler handler = new DefaultErrorHandler();
        if (Beans.isDesignTime()) {
            handler.setDebugMode(6);
        }
        this.addErrorHandler((ErrorHandler)handler);
        this.m_memberMetadataLabelTypes = new String[3];
        this.m_layerMetadataLabelTypes = new String[3];
        int edge = 0;
        while (edge < 3) {
            this.m_memberMetadataLabelTypes[edge] = DataviewDefaultValues.getMemberMetadataLabelType(edge);
            this.m_layerMetadataLabelTypes[edge] = DataviewDefaultValues.getLayerMetadataLabelType(edge);
            ++edge;
        }
        this.updateResourceBundle();
    }

    public CommonDataview(Locale loc, ErrorHandler handler) {
        this(loc);
        if (handler != null) {
            this.addErrorHandler(handler);
        }
    }

    public void addErrorHandler(ErrorHandler eh) {
        if (eh != null) {
            this.m_eh = eh;
            if (this.getModel() != null) {
                this.getModel().setErrorHandler(eh);
            }
        }
    }

    public void removeErrorHandler() {
        DefaultErrorHandler handler = new DefaultErrorHandler();
        if (Beans.isDesignTime()) {
            handler.setDebugMode(6);
        }
        this.addErrorHandler((ErrorHandler)handler);
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public FontList getFontList() {
        return this.fontList;
    }

    public int getZoomFactor() {
        return 100;
    }

    public String getVersion() {
        if (this.m_thickView != null) {
            return this.m_thickView.getVersion();
        }
        return null;
    }

    public Font scaleFont(Font f, int zoomFactor) {
        if (zoomFactor == 100) {
            return f;
        }
        int newSize = DataviewUtils.scaleByZoom(f.getSize(), zoomFactor);
        return this.fontList.getFont(f.getName(), f.getStyle(), newSize);
    }

    public String getIntlString(String key) {
        return this.getIntlString(key, this.m_dvStrings);
    }

    public String getIntlString(String key, ResourceBundle rBundle) {
        String strTemp;
        if (rBundle == null) {
            return key;
        }
        try {
            strTemp = rBundle.getString(key);
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().log("missing resource \"" + key + "\" in " + rBundle.getClass().getName(), this.getClass().getName(), "getIntlString(String key, ResourceBundle rBundle)");
            String string = key;
            return string;
        }
        return strTemp;
    }

    public void setThickDataview(ThickDataview view) {
        this.m_thickView = view;
    }

    public ThickDataview getThickDataview() {
        return this.m_thickView;
    }

    protected void updateResourceBundle() {
        try {
            this.m_dvStrings = this.getLocale() != null ? ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle", this.getLocale()) : ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle");
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().log("missing resource bundle oracle.dss.dataView.resource.DataviewBundle", this.getClass().getName(), "updateResourceBundle()");
            this.m_dvStrings = null;
        }
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale loc) {
        this.m_locale = loc;
    }

    public Model getModel() {
        return this.m_model;
    }

    public void setModel(Model model) {
        this.m_model = model;
    }

    public void setPersistableAttributes(PersistableAttributes attrs) {
        this.m_attrs = attrs;
    }

    public AggregateInfo[] getPersistableComponents() {
        AggregateInfo[] aggregates = null;
        DataSource ds = this.getDataSource();
        if (ds != null && ds instanceof Persistable) {
            aggregates = new AggregateInfo[]{new AggregateInfo((Persistable)ds, 0)};
        }
        return aggregates;
    }

    public void setPersistableComponents(AggregateInfo[] persistables) {
        if (persistables != null) {
            int i = 0;
            while (i < persistables.length) {
                Persistable aggregate = persistables[i].getPersistable();
                if (aggregate instanceof DataSource) {
                    this.setDataSource((DataSource)aggregate);
                    break;
                }
                ++i;
            }
        }
    }

    public void setMemberMetadataLabelType(int edge, String type) {
        if (!this.isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_setMemberMetadataLabelType);
            return;
        }
        if (!this._isMemberMetadataLabelTypeValid(type)) {
            this.getErrorHandler().log("invalid member metadata label type", this.getClass().getName(), m_method_setMemberMetadataLabelType);
            return;
        }
        this.m_memberMetadataLabelTypes[edge] = type;
    }

    public String getMemberMetadataLabelType(int edge) {
        if (!this.isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_getMemberMetadataLabelType);
            return null;
        }
        return this.m_memberMetadataLabelTypes[edge];
    }

    public boolean isMemberMetadataLabelTypeSupported(String type) {
        if (!this._isMemberMetadataLabelTypeValid(type)) {
            return false;
        }
        if (type.equals("shortName")) {
            return this.isMetadataShortLabelSupported();
        }
        if (type.equals("mediumName")) {
            return this.isMetadataMediumLabelSupported();
        }
        if (type.equals("longName")) {
            return this.isMetadataLongLabelSupported();
        }
        if (type.equals("value")) {
            return this.isMetadataValueSupported();
        }
        return false;
    }

    public void setMemberMetadataLabelType(String type) {
        if (!this._isMemberMetadataLabelTypeValid(type)) {
            this.getErrorHandler().log("invalid member metadata label type", this.getClass().getName(), m_method_setMemberMetadataLabelType_all);
            return;
        }
        int edge = 0;
        while (edge < this.m_memberMetadataLabelTypes.length) {
            this.m_memberMetadataLabelTypes[edge] = type;
            ++edge;
        }
    }

    public String getMemberMetadataLabelType() {
        String type = this.m_memberMetadataLabelTypes[0];
        int edge = 1;
        while (edge < this.m_memberMetadataLabelTypes.length) {
            if (!type.equals(this.m_memberMetadataLabelTypes[edge])) {
                return null;
            }
            ++edge;
        }
        return type;
    }

    public void setLayerMetadataLabelType(String type) {
        if (!this._isLayerMetadataLabelTypeValid(type)) {
            this.getErrorHandler().log("invalid layer metadata label type", this.getClass().getName(), m_method_setLayerMetadataLabelType_all);
            return;
        }
        int edge = 0;
        while (edge < this.m_layerMetadataLabelTypes.length) {
            this.m_layerMetadataLabelTypes[edge] = type;
            ++edge;
        }
    }

    public boolean isMetadataViewStyleSupported() {
        return this.m_metaViewStyleSupported;
    }

    public void setMetadataViewStyleSupported(boolean supported) {
        this.m_metaViewStyleSupported = supported;
    }

    public void setMetadataDateSupported(boolean supported) {
        this.m_metaDateSupported = supported;
    }

    public boolean isMetadataDateSupported() {
        return this.m_metaDateSupported;
    }

    public String getLayerMetadataLabelType() {
        String type = this.m_layerMetadataLabelTypes[0];
        int edge = 1;
        while (edge < this.m_layerMetadataLabelTypes.length) {
            if (!type.equals(this.m_layerMetadataLabelTypes[edge])) {
                return null;
            }
            ++edge;
        }
        return type;
    }

    public void setLayerMetadataLabelType(int edge, String type) {
        if (!this.isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_setLayerMetadataLabelType);
            return;
        }
        if (!this._isLayerMetadataLabelTypeValid(type)) {
            this.getErrorHandler().log("invalid layer metadata label type", this.getClass().getName(), m_method_setLayerMetadataLabelType);
            return;
        }
        this.m_layerMetadataLabelTypes[edge] = type;
    }

    public String getLayerMetadataLabelType(int edge) {
        if (!this.isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_getLayerMetadataLabelType);
            return null;
        }
        return this.m_layerMetadataLabelTypes[edge];
    }

    public void setMetadataLongLabelSupported(boolean supported) {
        this.m_metaLonglabelSupported = supported;
    }

    public boolean isMetadataLongLabelSupported() {
        return this.m_metaLonglabelSupported;
    }

    public void setMetadataMediumLabelSupported(boolean supported) {
        this.m_metaMediumlabelSupported = supported;
    }

    public boolean isMetadataMediumLabelSupported() {
        return this.m_metaMediumlabelSupported;
    }

    public void setMetadataShortLabelSupported(boolean supported) {
        this.m_metaShortlabelSupported = supported;
    }

    public boolean isMetadataShortLabelSupported() {
        return this.m_metaShortlabelSupported;
    }

    public void setMetadataValueSupported(boolean supported) {
        this.m_metaValueSupported = supported;
    }

    public boolean isMetadataValueSupported() {
        return this.m_metaValueSupported;
    }

    public boolean isLayerMetadataLabelTypeSupported(String type) {
        if (!this._isLayerMetadataLabelTypeValid(type)) {
            return false;
        }
        if (type.equals("dimShortName")) {
            return this.isLayerMetaShortLabelSupported();
        }
        if (type.equals("dimMediumName")) {
            return this.isLayerMetaMediumLabelSupported();
        }
        if (type.equals("dimLongName")) {
            return this.isLayerMetaLongLabelSupported();
        }
        if (type.equals("dimName")) {
            return this.isLayerMetaNameSupported();
        }
        return false;
    }

    public void setLayerMetaLongLabelSupported(boolean supported) {
        this.m_layermetaLonglabelSupported = supported;
    }

    public boolean isLayerMetaLongLabelSupported() {
        return this.m_layermetaLonglabelSupported;
    }

    public void setLayerMetaMediumLabelSupported(boolean supported) {
        this.m_layermetaMediumlabelSupported = supported;
    }

    public boolean isLayerMetaMediumLabelSupported() {
        return this.m_layermetaMediumlabelSupported;
    }

    public void setLayerMetaShortLabelSupported(boolean supported) {
        this.m_layermetaShortlabelSupported = supported;
    }

    public boolean isLayerMetaShortLabelSupported() {
        return this.m_layermetaShortlabelSupported;
    }

    public void setLayerMetaNameSupported(boolean supported) {
        this.m_layermetaNameSupported = supported;
    }

    public boolean isLayerMetaNameSupported() {
        return this.m_layermetaNameSupported;
    }

    public void setLayerMetaViewStyleSupported(boolean supported) {
        this.m_layermetaViewStyleSupported = supported;
    }

    public boolean isLayerMetaViewStyleSupported() {
        return this.m_layermetaViewStyleSupported;
    }

    public void setDataUnformattedSupported(boolean supported) {
        this.m_dataUnformattedSupported = supported;
    }

    public boolean isDataUnformattedSupported() {
        return this.m_dataUnformattedSupported;
    }

    public boolean isDataViewFormatSupported() {
        return false;
    }

    public void repaint() {
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            view.repaint();
        }
    }

    public DataviewTitles getDataviewFootnote() {
        return null;
    }

    public DataviewTitles getDataviewSubtitle() {
        return null;
    }

    public DataviewTitles getDataviewTitle() {
        return null;
    }

    public void dataFormatChanged() {
    }

    public void metadataStyleChanged() {
    }

    public void dataStyleChanged() {
    }

    public void setWaitDataForRow(int row, WaitData waitData) {
        try {
            if (this.m_waitDataForRows == null) {
                this.m_waitDataForRows = new WaitData[this.getModel().getDataAccess().getEdgeExtent(1)];
            }
        }
        catch (EdgeOutOfRangeException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "setWaitDataForRow");
            this.m_waitDataForRows = new WaitData[0];
        }
        if (row >= 0 && row < this.m_waitDataForRows.length) {
            this.m_waitDataForRows[row] = waitData;
        } else {
            this.getErrorHandler().log("row index out of range", this.getClass().getName(), "setWaitDataForRow");
        }
    }

    public WaitData getWaitDataForRow(int row) {
        if (this.m_waitDataForRows != null) {
            if (row >= 0 && row < this.m_waitDataForRows.length) {
                return this.m_waitDataForRows[row];
            }
            this.getErrorHandler().log("row index out of range", this.getClass().getName(), "getWaitDataForRow");
            return null;
        }
        return null;
    }

    protected WaitData[] getWaitData() {
        return this.m_waitDataForRows;
    }

    public void clearWaitDataForAllRows() {
        if (this.m_waitDataForRows != null) {
            int i = 0;
            while (i < this.m_waitDataForRows.length) {
                this.m_waitDataForRows[i] = null;
                ++i;
            }
            this.m_waitDataForRows = null;
        }
    }

    public DataAccess getDataAccess() {
        return this.m_dataAccess;
    }

    public void setDataAccess(DataAccess dataAccess) {
        this.m_dataAccess = dataAccess;
    }

    public DataDirector getDataDirector() {
        return this.m_dataDirector;
    }

    public void setDataDirector(DataDirector dataDirector) {
        this.m_dataDirector = dataDirector;
    }

    protected void setLocalXMLDataSource(LocalXMLDataSource ds) {
        this.setDataDirector((DataDirector)ds);
        this.setDataAccess((DataAccess)ds);
        this.setMetadataViewStyleSupported(true);
        this.setMetadataDateSupported(true);
        this.setMetadataMediumLabelSupported(true);
        this.setMetadataShortLabelSupported(true);
        this.setLayerMetaLongLabelSupported(true);
        this.setLayerMetaMediumLabelSupported(true);
        this.setLayerMetaShortLabelSupported(true);
    }

    public boolean setGridData(Object[] columnLabels, Object[] rowLabels, Object[][] data) {
        return this.setGridData(columnLabels, rowLabels, data, true);
    }

    protected boolean setGridData(Object[] columnLabels, Object[] rowLabels, Object[][] data, boolean bAllowNoData) {
        if (columnLabels == null) {
            this.getErrorHandler().log("columnLabels array null", this.getClass().getName(), m_method_setGridData);
            if (!bAllowNoData) {
                return false;
            }
            columnLabels = new String[]{};
        }
        if (rowLabels == null) {
            this.getErrorHandler().log("rowLabels array null", this.getClass().getName(), m_method_setGridData);
            if (!bAllowNoData) {
                return false;
            }
            rowLabels = new String[]{};
        }
        if (data == null) {
            this.getErrorHandler().log("data array null", this.getClass().getName(), m_method_setGridData);
            if (!bAllowNoData) {
                return false;
            }
            data = new Double[0][0];
        }
        int colCount = columnLabels.length;
        int rowCount = rowLabels.length;
        if (data.length != colCount) {
            this.getErrorHandler().log("data column count different from column label count", this.getClass().getName(), m_method_setGridData);
            return false;
        }
        int col = 0;
        while (col < colCount) {
            if (data[col] != null && data[col].length != rowCount) {
                this.getErrorHandler().log("data row count different from row label count", this.getClass().getName(), m_method_setGridData);
                return false;
            }
            ++col;
        }
        int col2 = 0;
        while (col2 < colCount) {
            if (columnLabels[col2] == null) {
                this.getErrorHandler().log("column label null at column " + col2, this.getClass().getName(), m_method_setGridData);
            }
            ++col2;
        }
        int row = 0;
        while (row < rowCount) {
            if (rowLabels[row] == null) {
                this.getErrorHandler().log("row label null at row " + row, this.getClass().getName(), m_method_setGridData);
            }
            ++row;
        }
        int col3 = 0;
        while (col3 < colCount) {
            int row2 = 0;
            while (row2 < rowCount) {
                if (data[col3] == null) {
                    this.getErrorHandler().log("data cell null at column " + col3 + ", row " + row2, this.getClass().getName(), m_method_setGridData);
                }
                ++row2;
            }
            ++col3;
        }
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            view.setDataSource(new LocalXMLDataSource(columnLabels, rowLabels, data));
        } else {
            this.setLocalXMLDataSource(new LocalXMLDataSource(columnLabels, rowLabels, data));
        }
        return true;
    }

    public boolean setTabularData(List tableRows) {
        return this.setTabularData(tableRows, true);
    }

    protected boolean setTabularData(List tableRows, boolean bAllowNoData) {
        if (tableRows == null) {
            this.getErrorHandler().log("tableRows list null", this.getClass().getName(), m_method_setTabularData);
            if (!bAllowNoData) {
                return false;
            }
            tableRows = new ArrayList();
        }
        boolean COL = false;
        boolean ROW = true;
        int DATA = 2;
        int rowKeyCount = 0;
        int colKeyCount = 0;
        Hashtable<Object, Integer> rowKeys = new Hashtable<Object, Integer>();
        Hashtable<Object, Integer> colKeys = new Hashtable<Object, Integer>();
        Hashtable<String, Object> dataVals = new Hashtable<String, Object>();
        ArrayList<Object> rowLabelsList = new ArrayList<Object>();
        ArrayList<Object> colLabelsList = new ArrayList<Object>();
        boolean bNonNullRelRowExists = false;
        for (Object obj : tableRows) {
            Object rowLabel;
            Object[] relRow = null;
            if (obj == null) {
                this.getErrorHandler().log("element of tableRows list null", this.getClass().getName(), m_method_setTabularData);
                continue;
            }
            if (!(obj instanceof Object[])) {
                this.getErrorHandler().log("element of tableRows list not Object[]", this.getClass().getName(), m_method_setTabularData);
                continue;
            }
            bNonNullRelRowExists = true;
            Object[] tmpRelRow = (Object[])obj;
            if (tmpRelRow.length < 3) {
                relRow = new Object[3];
                int i = 0;
                while (i < tmpRelRow.length) {
                    relRow[i] = tmpRelRow[i];
                    ++i;
                }
            } else {
                relRow = tmpRelRow;
            }
            Object colLabel = relRow[0];
            if (colLabel == null) {
                this.getErrorHandler().log("null column label", this.getClass().getName(), m_method_setTabularData);
                colLabel = "";
            }
            if (!colKeys.containsKey(colLabel)) {
                colKeys.put(colLabel, new Integer(colKeyCount++));
                colLabelsList.add(colLabel);
            }
            if ((rowLabel = relRow[1]) == null) {
                this.getErrorHandler().log("null row label", this.getClass().getName(), m_method_setTabularData);
                rowLabel = "";
            }
            if (!rowKeys.containsKey(rowLabel)) {
                rowKeys.put(rowLabel, new Integer(rowKeyCount++));
                rowLabelsList.add(rowLabel);
            }
            String dataKey = rowLabel.toString() + ",";
            dataKey = colLabel instanceof Date ? dataKey + ((Date)colLabel).getTime() : dataKey + colLabel.toString();
            Object dataObj = relRow[2];
            if (dataVals.containsKey(dataKey)) {
                this.getErrorHandler().log("duplicate data at (row,column) = (" + dataKey + ")", this.getClass().getName(), m_method_setTabularData);
            }
            if (dataObj != null) {
                dataVals.put(dataKey, dataObj);
                continue;
            }
            dataVals.put(dataKey, NullObject.getNullObject());
        }
        if (!bNonNullRelRowExists) {
            this.getErrorHandler().log("all relational rows are null", this.getClass().getName(), m_method_setTabularData);
            if (!bAllowNoData) {
                return false;
            }
        }
        if (rowKeyCount < 1 || colKeyCount < 1) {
            this.getErrorHandler().log("fewer than 1 column or 1 row of data provided", this.getClass().getName(), m_method_setTabularData);
            if (!bAllowNoData) {
                return false;
            }
        }
        int rowCount = rowKeyCount;
        int colCount = colKeyCount;
        Object[] rowLabels = new Object[rowCount];
        Object[] colLabels = new Object[colCount];
        Object[][] data = new Object[colCount][rowCount];
        this.fillRelationalDataArrays(colCount, rowCount, colLabelsList, rowLabelsList, dataVals, colLabels, rowLabels, data);
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            view.setDataSource(new LocalXMLDataSource(colLabels, rowLabels, data));
        } else {
            this.setLocalXMLDataSource(new LocalXMLDataSource(colLabels, rowLabels, data));
        }
        return true;
    }

    protected void fillRelationalDataArrays(int colCount, int rowCount, List colLabelsList, List rowLabelsList, Hashtable dataVals, Object[] colLabels, Object[] rowLabels, Object[][] data) {
        int row = 0;
        int col = 0;
        int rowLabelsListSize = rowLabelsList.size();
        int i = 0;
        while (i < rowLabelsListSize) {
            Object rowLabel = rowLabelsList.get(i);
            if (row < rowCount) {
                rowLabels[row] = rowLabel;
            } else {
                this.getErrorHandler().log("label for out of bounds row index " + row, this.getClass().getName(), m_method_fillRelationalDataArrays);
            }
            ++row;
            ++i;
        }
        while (row < rowCount) {
            this.getErrorHandler().log("missing label for row index " + row, this.getClass().getName(), m_method_fillRelationalDataArrays);
            rowLabels[row] = null;
            ++row;
        }
        int colLabelsListSize = colLabelsList.size();
        int j = 0;
        while (j < colLabelsListSize) {
            Object colLabel = colLabelsList.get(j);
            if (col < colCount) {
                colLabels[col] = colLabel;
            } else {
                this.getErrorHandler().log("label for out of bounds column index " + col, this.getClass().getName(), m_method_fillRelationalDataArrays);
            }
            ++col;
            ++j;
        }
        while (col < colCount) {
            this.getErrorHandler().log("missing label for column index " + col, this.getClass().getName(), m_method_fillRelationalDataArrays);
            colLabels[col] = null;
            ++col;
        }
        int totalCellCount = colCount * rowCount;
        int cellCount = 0;
        Object dataObj = null;
        boolean bLogTabularMissingDataWarning = this.isLogTabularMissingDataWarning();
        row = 0;
        while (row < rowCount) {
            Object rowLabel = rowLabels[row];
            if (rowLabel == null) {
                rowLabel = "";
            }
            col = 0;
            while (col < colCount) {
                Object colLabel = colLabels[col];
                if (colLabel == null) {
                    colLabel = "";
                }
                String dataKey = rowLabel.toString() + ",";
                dataKey = colLabel instanceof Date ? dataKey + ((Date)colLabel).getTime() : dataKey + colLabel.toString();
                dataObj = dataVals.remove(dataKey);
                if (dataObj != null) {
                    if (dataObj instanceof NullObject) {
                        dataObj = null;
                    } else {
                        ++cellCount;
                    }
                } else if (bLogTabularMissingDataWarning) {
                    this.getErrorHandler().log("missing data for cell at (row,column) = (" + dataKey + ")", this.getClass().getName(), m_method_fillRelationalDataArrays);
                }
                data[col][row] = dataObj;
                ++col;
            }
            ++row;
        }
        Enumeration dataKeysEnum = dataVals.keys();
        while (dataKeysEnum.hasMoreElements()) {
            String dataKey = (String)dataKeysEnum.nextElement();
            this.getErrorHandler().log("unused data for (row,column) = (" + dataKey + ")", this.getClass().getName(), m_method_fillRelationalDataArrays);
        }
    }

    protected boolean isLogTabularMissingDataWarning() {
        return true;
    }

    public void setHTMLPagingControlAutosubmit(boolean autosubmit) {
        this.m_htmlPagingControlAutosubmit = autosubmit;
    }

    public boolean isHTMLPagingControlAutosubmit() {
        return this.m_htmlPagingControlAutosubmit;
    }

    public void setHTMLPagingControlWidth(int width) {
        this.m_htmlPagingControlWidth = width;
    }

    public int getHTMLPagingControlWidth() {
        return this.m_htmlPagingControlWidth;
    }

    public void setName(String name) {
        if (name == null) {
            this.getErrorHandler().log("invalid name", this.getClass().getName(), m_method_setName);
            return;
        }
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setLocalName(String name) {
        if (name == null) {
            this.getErrorHandler().log("invalid Local name", this.getClass().getName(), m_method_setLocalName);
            return;
        }
        this.m_localName = name;
    }

    public String getLocalName() {
        return this.m_localName;
    }

    public void setDescription(String desc) {
        if (desc == null) {
            this.getErrorHandler().log("invalid Description", this.getClass().getName(), m_method_setDescription);
            return;
        }
        this.m_description = desc;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDrillingEnabled(boolean b) {
        if (this.getModel() != null) {
            this.getModel().setDrillingEnabled(b);
        }
        this.m_drillingEnabled = b;
    }

    public boolean isDrillingEnabled() {
        if (this.getModel() != null) {
            return this.getModel().isDrillingEnabled();
        }
        return this.m_drillingEnabled;
    }

    public boolean isDrillingSupported() {
        return false;
    }

    public void setPagingControlVisible(boolean v) {
        this.m_pagingVisible = v;
    }

    public boolean isPagingControlVisible() {
        return this.m_pagingVisible;
    }

    public void setPagingControlPosition(int loc) {
        this.m_pagingControlPosition = loc;
    }

    public int getPagingControlPosition() {
        return this.m_pagingControlPosition;
    }

    public void setXMLValidated(boolean validate) {
        this.m_validate = validate;
    }

    public boolean isXMLValidated() {
        return this.m_validate;
    }

    protected ObjectNode getObjectNode(String objName, boolean allProperties) {
        return this.getObjectNode(objName, allProperties, "");
    }

    protected ObjectNode getObjectNode(String objName, boolean allProperties, String version) {
        ObjectNode node = new ObjectNode(objName);
        node.addProperty("version", version);
        this.getViewXML().getObjectNode(node, allProperties);
        return node;
    }

    public String getXML(String objName, boolean allProperties) {
        XMLObjectWriter writer = new XMLObjectWriter();
        try {
            writer.setIndentMode(1);
            writer.writeObjectNode((BaseObjectNode)this.getObjectNode(objName, allProperties));
            String string = writer.toString();
            return string;
        }
        catch (BIIOException biioe) {
            this.getErrorHandler().log("oracle.dss.util.xml.BIIOException occured", this.getClass().getName(), "getXML(boolean allProperties)");
            return null;
        }
    }

    protected DataviewXML getViewXML() {
        return this.m_viewXML;
    }

    protected void setViewXML(DataviewXML viewXML) {
        this.m_viewXML = viewXML;
    }

    public void setDataSource(DataSource ds) {
    }

    public int convertComponentTypeToInteger(String type) {
        if (type.equals("PAGE_HEADER")) {
            return 3;
        }
        return -1;
    }

    public String convertComponentTypeToString(int type) {
        if (type == 3) {
            return "PAGE_HEADER";
        }
        return null;
    }

    public DataSource getDataSource() {
        return null;
    }

    public int getViewType() {
        return 0;
    }

    public String getFlashPlayerDownloadMessageHTML(String version, String url) {
        String s = MessageFormat.format(this.getIntlString("FlashPlayerDownload"), version, "<a href='" + url + "'>" + url + "</a>");
        return s;
    }

    public BitSet createPropertyOverrideFlags(int maxID) {
        return new BitSet(maxID);
    }

    public void setPropertyOverrideFlags(int attrID, BitSet userFlags, BitSet styleFlags) {
        if (userFlags != null && attrID >= 0 && attrID < userFlags.size()) {
            if (this.isUserOverrideMode()) {
                userFlags.set(attrID);
            }
            if (this.isStyleOverrideMode()) {
                styleFlags.set(attrID);
            }
            this._styleModified = true;
        }
    }

    public TokenSubstitution getTokenSubstitution() {
        if (this.m_tokenSubstitution == null) {
            this.m_tokenSubstitution = new TokenSubstitutionAdapter(this);
        }
        return this.m_tokenSubstitution;
    }

    public void setTokenSubstitution(TokenSubstitution token) {
        this.m_tokenSubstitution = token;
    }

    public boolean isPropertyOverrideFlag(int attrID, BitSet overrideFlags) {
        if (attrID >= 0 && attrID < overrideFlags.size()) {
            return overrideFlags.get(attrID);
        }
        return false;
    }

    public void clearPropertyOverrideFlag(int attrID, BitSet overrideFlags) {
        if (attrID >= 0 && attrID < overrideFlags.size()) {
            overrideFlags.clear(attrID);
        }
    }

    protected void setStyleOverrideMode(boolean flag) {
        this._styleOverrideMode = flag;
    }

    protected boolean isStyleOverrideMode() {
        return this._styleOverrideMode;
    }

    protected boolean isStyleModified() {
        return this._styleModified;
    }

    protected void clearStyleModified() {
        this._styleModified = false;
    }

    protected void setUserOverrideMode(boolean flag) {
        this._userOverrideMode = flag;
    }

    protected boolean isUserOverrideMode() {
        return this._userOverrideMode;
    }

    protected boolean isEdgeValid(int edge) {
        return edge == 0 || edge == 1 || edge == 2;
    }

    private boolean _isMemberMetadataLabelTypeValid(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("longName") || type.equals("mediumName") || type.equals("value") || type.equals("shortName");
    }

    private boolean _isLayerMetadataLabelTypeValid(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("dimLongName") || type.equals("dimMediumName") || type.equals("dimName") || type.equals("dimShortName");
    }

    public static int convertAnimationOnDataChangeToInt(String type) {
        int styleName = DataviewDefaultValues.getAnimationOnDataChange();
        if (type.equals("NONE")) {
            styleName = 0;
        } else if (type.equals("AUTO")) {
            styleName = 1;
        } else if (type.equals(adc_on)) {
            styleName = 2;
        }
        return styleName;
    }

    public static String convertAnimationOnDataChangeToString(int type) {
        String styleName = "AUTO";
        if (type == 0) {
            styleName = "NONE";
        } else if (type == 1) {
            styleName = "AUTO";
        } else if (type == 2) {
            styleName = adc_on;
        }
        return styleName;
    }

    public static int convertAnimationIndicatorsToInt(String type) {
        int styleName = DataviewDefaultValues.getAnimationIndicators();
        if (type.equals("NONE")) {
            styleName = 0;
        } else if (type.equals(ai_all)) {
            styleName = 1;
        }
        return styleName;
    }

    public static String convertAnimationIndicatorsToString(int type) {
        String styleName = ai_all;
        if (type == 0) {
            styleName = "NONE";
        } else if (type == 1) {
            styleName = ai_all;
        }
        return styleName;
    }

    public static int convertAnimationOnDisplayToInt(String type) {
        int styleName = DataviewDefaultValues.getAnimationOnDisplay();
        if (type.equals("NONE")) {
            styleName = 0;
        } else if (type.equals("AUTO")) {
            styleName = 1;
        }
        return styleName;
    }

    public static String convertAnimationOnDisplayToString(int type) {
        String styleName = "NONE";
        if (type == 0) {
            styleName = "NONE";
        } else if (type == 1) {
            styleName = "AUTO";
        }
        return styleName;
    }

    public static int convertVisualEffectsToInt(String type) {
        int styleName = DataviewDefaultValues.getVisualEffects();
        if (type.equals("NONE")) {
            styleName = 0;
        } else if (type.equals("AUTO")) {
            styleName = 1;
        }
        return styleName;
    }

    public static String convertVisualEffectsToString(int type) {
        String styleName = "AUTO";
        if (type == 0) {
            styleName = "NONE";
        } else if (type == 1) {
            styleName = "AUTO";
        }
        return styleName;
    }

    private void $init$() {
        this.fontList = new FontList();
        this.m_eh = null;
        this.m_memberMetadataLabelTypes = null;
        this.m_layerMetadataLabelTypes = null;
        this.m_waitDataForRows = null;
        this.m_dataUnformattedSupported = true;
        this.m_metaDateSupported = false;
        this.m_metaLonglabelSupported = true;
        this.m_metaMediumlabelSupported = false;
        this.m_metaShortlabelSupported = false;
        this.m_metaViewStyleSupported = false;
        this.m_metaValueSupported = true;
        this.m_layermetaShortlabelSupported = false;
        this.m_layermetaMediumlabelSupported = false;
        this.m_layermetaLonglabelSupported = true;
        this.m_layermetaNameSupported = false;
        this.m_layermetaViewStyleSupported = false;
        this.m_attrs = null;
        this.m_dvStrings = null;
        this._userOverrideMode = false;
        this._styleOverrideMode = false;
        this._styleModified = false;
        this.m_model = null;
        this.m_htmlPagingControlAutosubmit = DataviewDefaultValues.isHTMLPagingControlAutosubmit();
        this.m_htmlPagingControlWidth = DataviewDefaultValues.getHTMLPagingControlWidth();
        this.m_name = DataviewDefaultValues.getName();
        this.m_localName = DataviewDefaultValues.getLocalName();
        this.m_description = DataviewDefaultValues.getDescription();
        this.m_pagingControlPosition = DataviewDefaultValues.getPagingControlPosition();
        this.m_pagingVisible = false;
        this.m_validate = false;
        this.m_drillingEnabled = false;
    }

    protected static class NullObject {
        private static NullObject m_nullObj = null;

        private NullObject() {
        }

        public static NullObject getNullObject() {
            if (m_nullObj == null) {
                m_nullObj = new NullObject();
            }
            return m_nullObj;
        }
    }
}

