/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DimensionMetadata;
import oracle.dss.rules.discriminator.DateValueDiscriminator;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.rules.discriminator.StringValueDiscriminator;
import oracle.dss.rules.discriminator.ValueDiscriminator;
import oracle.dss.util.MemberContext;
import oracle.dss.util.Utility;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ConditionElement {
    private String[] stateNames;
    public static final char sc_Number = 'n';
    public static final char sc_Date = 'd';
    public static final char sc_Boolean = 'b';
    public static final char sc_String = 's';
    private static final String s_datatype = "a";
    private static final String s_badThreshold = "b";
    private static final String s_goodThreshold = "g";
    private static final String s_value1 = "b";
    private static final String s_operator = "o";
    private static final String s_conditionSelected = "c";
    public static final int FIXED = 0;
    public static final int LIST = 1;
    public static final int MIXED = 2;
    public static final int VALUE = 3;
    public static final int STOPLIGHT = 4;
    public static final int EQ = 0;
    public static final int GT = 3;
    public static final int GE = 4;
    public static final int LE = 2;
    public static final int LT = 1;
    public static final int BT = 5;
    private static final String[] sOperatorList = new String[]{">", ">=", "<", "<=", "="};
    private static final int[] iOperatorList = new int[]{3, 4, 1, 2, 0};
    public static final String NAME_CONDITION_ELEMENT = "Cond";
    private static final String a_dimName = "dimName";
    protected static final String a_selected = "selected";
    private static final String a_valueCondition = "ValCond";
    private static final String a_measure = "measure";
    private static final String a_operator = "op";
    private static final String a_value1 = "value1";
    private static final String a_value2 = "value2";
    private static final String a_valueType = "type";
    private static final String a_defaultValue = "default";
    private static final String a_badThreshold = "value1";
    private static final String a_goodThreshold = "value2";
    private Object m_Data;
    private boolean m_Selected;
    private int m_type;
    private String m_Dim;
    private Object m_badThreshold;
    private Object m_goodThreshold;
    private DimensionMetadata m_metadata;
    private boolean m_stoplightOK;
    public static final String MemSep = ", ";
    private String m_valueType;
    private static final String eq = "EQ";
    private static final String le = "LE";
    private static final String lt = "LT";
    private static final String ge = "GE";
    private static final String gt = "GT";
    private static final String bt = "BT";
    private static final String sl = "SL";
    private static final int MEASURE_INDEX = 0;
    private static final int OPERATOR_INDEX = 1;
    private static final int VALUE1_INDEX = 2;
    private static final int VALUE2_INDEX = 3;
    public static final String DEFAULT_BAD_THRESHOLD = "";
    public static final String DEFAULT_GOOD_THRESHOLD = "";
    private static final boolean PERSIST_DATE_IN_LONG = true;

    public ConditionElement() {
        this.$init$();
    }

    public ConditionElement(String dimension, String data, boolean selected, int type) {
        this(dimension, data, type);
    }

    public ConditionElement(String dimension, String data, boolean selected) {
        this(dimension, data);
    }

    public ConditionElement(String dimension, Vector data, boolean selected) {
        this(dimension, data);
    }

    public ConditionElement(String dimension, Object data, boolean selected) {
        this(dimension, data);
    }

    public ConditionElement(String dimension, String data, int type) {
        this.$init$();
        this.setDimension(dimension);
        this.setData(data);
        this.setType(type);
    }

    public ConditionElement(String dimension, Vector data, int type) {
        this.$init$();
        this.setDimension(dimension);
        this.setData(data);
        this.setType(type);
    }

    public ConditionElement(String dimension, String data) {
        this.$init$();
        this.setDimension(dimension);
        this.setData(data);
        this.setType(0);
    }

    public ConditionElement(String dimension, Vector data) {
        this.$init$();
        this.setDimension(dimension);
        if (data.size() > 1) {
            this.setType(1);
            this.setData(data);
        } else {
            this.setType(0);
            this.setData(data.elementAt(0));
        }
    }

    public ConditionElement(String dimension, Object data) {
        this.$init$();
        if (data instanceof Vector) {
            this.setType(1);
        } else {
            this.setType(0);
        }
        this.setDimension(dimension);
        this.setData(data);
    }

    public ConditionElement(String measure, int operator, Double value1, Double value2, boolean selected) {
        this.$init$();
        Vector<Object> data = new Vector<Object>();
        data.addElement(measure);
        switch (operator) {
            case 0: {
                data.addElement("=");
                break;
            }
            case 2: {
                data.addElement("<=");
                break;
            }
            case 1: {
                data.addElement("<");
                break;
            }
            case 4: {
                data.addElement(">=");
                break;
            }
            case 3: {
                data.addElement(">");
                break;
            }
            case 5: {
                data.addElement(bt);
                break;
            }
            default: {
                data.addElement("=");
            }
        }
        data.addElement(value1);
        if (value2 != null) {
            data.addElement(value2);
        }
        this.setData(data);
        this.setType(3);
        this.setDimension(measure);
        this.setSelected(selected);
    }

    public ConditionElement(String measure, int operator, Date date1, Date date2, boolean selected) {
        this.$init$();
        Vector<Object> data = new Vector<Object>();
        data.addElement(measure);
        switch (operator) {
            case 0: {
                data.addElement("=");
                break;
            }
            case 2: {
                data.addElement("<=");
                break;
            }
            case 1: {
                data.addElement("<");
                break;
            }
            case 4: {
                data.addElement(">=");
                break;
            }
            case 3: {
                data.addElement(">");
                break;
            }
            case 5: {
                data.addElement(bt);
                break;
            }
            default: {
                data.addElement("=");
            }
        }
        data.addElement(date1);
        if (date2 != null) {
            data.addElement(date2);
        }
        this.setData(data);
        this.setType(3);
        this.setDimension(measure);
        this.setSelected(selected);
    }

    public ConditionElement(Object badThreshold, Object goodThreshold, String datatype) {
        this.$init$();
        this.setBadThreshold(badThreshold);
        this.setGoodThreshold(goodThreshold);
        this.setType(4);
        this.setValueType(datatype);
        this.setSelected(true);
    }

    public ConditionElement(Vector data) {
        this.$init$();
        this.setData(data);
        this.setType(3);
    }

    public void setData(Object data) {
        this.m_Data = data;
    }

    public Object getData() {
        return this.m_Data;
    }

    public void setDimension(String dimension) {
        this.m_Dim = dimension;
    }

    public String getDimension() {
        return this.m_Dim;
    }

    public boolean isSelected() {
        return this.m_Selected;
    }

    public void setSelected(boolean b) {
        this.m_Selected = b;
    }

    public boolean isStoplightOK() {
        return this.m_stoplightOK;
    }

    public void setStoplightOK(boolean b) {
        this.m_stoplightOK = b;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int t) {
        this.m_type = t;
    }

    private Object getElement(int type, int index) {
        if (this.getType() == type && this.m_Data != null && ((Vector)this.m_Data).size() > index) {
            return ((Vector)this.m_Data).elementAt(index);
        }
        return null;
    }

    private void setElement(int type, int index, Object obj) {
        if (this.getType() == type) {
            if (this.m_Data == null) {
                this.m_Data = new Vector();
            }
            if (this.m_Data instanceof Vector && ((Vector)this.m_Data).size() <= index) {
                ((Vector)this.m_Data).insertElementAt(obj, index);
            } else {
                ((Vector)this.m_Data).setElementAt(obj, index);
            }
        }
    }

    public String getMeasure() {
        Object value = this.getElement(this.getType(), 0);
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    public void setMeasure(String measure) {
        this.setElement(this.getType(), 0, measure);
    }

    public String getOperator() {
        return (String)this.getElement(3, 1);
    }

    public void setOperator(String operator) {
        this.setElement(3, 1, operator);
    }

    public Object getValue1() {
        Object value = this.getElement(3, 2);
        if (value == null) {
            return null;
        }
        return value;
    }

    public void setValue1(Object value1) throws NumberFormatException {
        this.setElement(3, 2, value1);
        this.setValueType(ConditionElement.getDatatype(value1));
    }

    public Object getBadThreshold() {
        return this.m_badThreshold;
    }

    public void setBadThreshold(Object value) {
        this.m_badThreshold = value;
        this.setValueType(value);
    }

    public Object getGoodThreshold() {
        return this.m_goodThreshold;
    }

    public void setGoodThreshold(Object value) {
        this.m_goodThreshold = value;
        this.setValueType(value);
    }

    public String getValueType() {
        return this.m_valueType;
    }

    protected void setValueType(String t) {
        this.m_valueType = t;
    }

    protected void setValueType(Object value) {
        String datatype = ConditionElement.getDatatype(value);
        if (datatype != null) {
            this.setValueType(datatype);
        }
    }

    public static String getDatatype(Object value) {
        String datatype = null;
        if (value != null) {
            datatype = value instanceof Number ? "Double" : (value instanceof Date ? "Date" : (value instanceof Boolean ? "Boolean" : "String"));
        }
        return datatype;
    }

    public boolean setXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty(a_dimName);
        if (pNode != null) {
            this.setDimension(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_selected)) != null) {
            this.setSelected(pNode.getValueAsBoolean());
        }
        Vector<Object> m_data = new Vector<Object>();
        ObjectNode valueNode = node.getPropertyValueAsObjectNode(a_valueCondition, true);
        if (valueNode != null) {
            this.setType(3);
            boolean defaultValue = true;
            PropertyNode typeNode = valueNode.getProperty(a_defaultValue);
            if (typeNode != null) {
                defaultValue = typeNode.getValueAsBoolean();
            }
            if (defaultValue) {
                this.m_Data = null;
            } else {
                try {
                    m_data.addElement(valueNode.getPropertyValueAsString(a_measure));
                    String op = valueNode.getPropertyValueAsString(a_operator);
                    if (op.equals(eq)) {
                        m_data.addElement("=");
                    } else if (op.equals(lt)) {
                        m_data.addElement("<");
                    } else if (op.equals(le)) {
                        m_data.addElement("<=");
                    } else if (op.equals(gt)) {
                        m_data.addElement(">");
                    } else if (op.equals(ge)) {
                        m_data.addElement(">=");
                    } else if (op.equals(bt)) {
                        m_data.addElement(bt);
                    } else if (op.equals(sl)) {
                        this.setStoplightXML(valueNode);
                        boolean bl = true;
                        return bl;
                    }
                    if (valueNode.getPropertyValueAsString(a_valueType).equals("Double")) {
                        m_data.addElement(new Double(valueNode.getPropertyValueAsDouble("value1")));
                        pNode = valueNode.getProperty("value2");
                        if (pNode != null) {
                            m_data.addElement(new Double(pNode.getValueAsDouble()));
                        }
                    } else if (valueNode.getPropertyValueAsString(a_valueType).equals("Date")) {
                        Date date = ConditionElement.getDateXML(valueNode, "value1");
                        if (date != null) {
                            m_data.addElement(date);
                        }
                        if ((date = ConditionElement.getDateXML(valueNode, "value2")) != null) {
                            m_data.addElement(date);
                        }
                    } else {
                        m_data.addElement(new String(valueNode.getPropertyValueAsString("value1")));
                        pNode = valueNode.getProperty("value2");
                        if (pNode != null) {
                            m_data.addElement(new String(pNode.getValueAsString()));
                        }
                    }
                    this.m_Data = m_data;
                }
                catch (NoSuchPropertyException e) {
                    this.m_Data = null;
                }
            }
            return true;
        }
        return false;
    }

    public ObjectNode getXML() {
        ObjectNode node = new ObjectNode(NAME_CONDITION_ELEMENT);
        if (this.getType() == 3) {
            node.addProperty(a_dimName, this.m_Dim);
            node.addProperty(a_selected, this.m_Selected);
            boolean value1Set = false;
            ObjectNode valueCondition = new ObjectNode(a_valueCondition);
            if (this.m_Data instanceof Vector) {
                valueCondition.addProperty(a_defaultValue, false);
                boolean type = false;
                int i = 0;
                while (i < ((Vector)this.m_Data).size()) {
                    Object obj = ((Vector)this.m_Data).elementAt(i);
                    if (obj instanceof String) {
                        String op = (String)obj;
                        if (op.equals("=")) {
                            valueCondition.addProperty(a_operator, eq);
                        } else if (op.equals("<")) {
                            valueCondition.addProperty(a_operator, lt);
                        } else if (op.equals("<=")) {
                            valueCondition.addProperty(a_operator, le);
                        } else if (op.equals(">")) {
                            valueCondition.addProperty(a_operator, gt);
                        } else if (op.equals(">=")) {
                            valueCondition.addProperty(a_operator, ge);
                        } else if (op.equals(bt)) {
                            valueCondition.addProperty(a_operator, bt);
                        } else {
                            valueCondition.addProperty(a_measure, op);
                        }
                    } else if (obj instanceof Double) {
                        if (!value1Set) {
                            valueCondition.addProperty("value1", obj.toString());
                            value1Set = true;
                        } else {
                            valueCondition.addProperty("value2", obj.toString());
                        }
                        type = false;
                    } else if (obj instanceof Date) {
                        if (!value1Set) {
                            ConditionElement.addDateXML(valueCondition, "value1", (Date)obj);
                            value1Set = true;
                        } else {
                            ConditionElement.addDateXML(valueCondition, "value2", (Date)obj);
                        }
                        type = true;
                    }
                    ++i;
                }
                if (!type) {
                    valueCondition.addProperty(a_valueType, "Double");
                } else if (type) {
                    valueCondition.addProperty(a_valueType, "Date");
                } else {
                    valueCondition.addProperty(a_valueType, "String");
                }
            } else {
                valueCondition.addProperty(a_defaultValue, true);
            }
            node.addProperty(valueCondition);
        } else if (this.getType() == 4) {
            this.getStoplightXML(node);
        }
        return node;
    }

    public ObjectNode getStoplightXML(ObjectNode node) {
        node.addProperty(a_dimName, this.m_Dim);
        node.addProperty(a_selected, this.m_Selected);
        ObjectNode valueCondition = new ObjectNode(a_valueCondition);
        valueCondition.addProperty(a_defaultValue, false);
        valueCondition.addProperty(a_measure, "");
        valueCondition.addProperty(a_operator, sl);
        if (this.m_valueType.equals("Double")) {
            valueCondition.addProperty("value1", this.m_badThreshold.toString());
            valueCondition.addProperty("value2", this.m_goodThreshold.toString());
        } else {
            ConditionElement.addDateXML(valueCondition, "value1", (Date)this.m_badThreshold);
            ConditionElement.addDateXML(valueCondition, "value2", (Date)this.m_goodThreshold);
        }
        valueCondition.addProperty(a_valueType, this.m_valueType);
        node.addProperty(valueCondition);
        return node;
    }

    public void setStoplightXML(ObjectNode valueNode) {
        try {
            this.setType(4);
            String valueType = valueNode.getPropertyValueAsString(a_valueType);
            this.setValueType(valueType);
            if (valueType.equals("Double")) {
                this.m_badThreshold = new Double(valueNode.getPropertyValueAsDouble("value1"));
                this.m_goodThreshold = new Double(valueNode.getPropertyValueAsDouble("value2"));
            } else {
                this.m_badThreshold = ConditionElement.getDateXML(valueNode, "value1");
                this.m_goodThreshold = ConditionElement.getDateXML(valueNode, "value2");
            }
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
    }

    public static void addDateXML(ObjectNode node, String key, Date data) {
        node.addProperty(key, data.getTime());
    }

    public static Date getDateXML(ObjectNode node, String key) {
        try {
            Date date = new Date(node.getPropertyValueAsLong(key));
            return date;
        }
        catch (NoSuchPropertyException e) {
            Date date = null;
            return date;
        }
        catch (Exception e) {
            Date date = null;
            return date;
        }
    }

    public Object clone() {
        ConditionElement myClone = new ConditionElement();
        myClone.setSelected(this.isSelected());
        myClone.setType(this.getType());
        myClone.setDimension(this.getDimension());
        myClone.setValueType(this.getValueType());
        myClone.setMetadata(this.getMetadata());
        if (this.getType() == 4) {
            myClone.setBadThreshold(this.getBadThreshold());
            myClone.setGoodThreshold(this.getGoodThreshold());
        } else if (this.getData() instanceof Vector) {
            myClone.setData(((Vector)this.getData()).clone());
        }
        return myClone;
    }

    private char getStateDatatype() {
        String type = this.getValueType();
        if ("Double".equals(type)) {
            return 'n';
        }
        if ("Date".equals(type)) {
            return 'd';
        }
        if ("Boolean".equals(type)) {
            return 'b';
        }
        return 's';
    }

    private void setStateDatatype(PropertyNode node) {
        int datatype = 115;
        if (node != null) {
            datatype = node.getValueAsCharacter();
        }
        switch (datatype) {
            case 110: {
                this.setValueType("Double");
                break;
            }
            case 100: {
                this.setValueType("Date");
                break;
            }
            case 98: {
                this.setValueType("Boolean");
                break;
            }
            default: {
                this.setValueType("String");
                break;
            }
        }
    }

    public boolean setStateAsObjectNode(ObjectNode node, ConditionElement baseState, boolean isStoplight) {
        boolean overridden = false;
        PropertyNode pNode = node.getProperty(s_datatype);
        this.setStateDatatype(pNode);
        if (isStoplight) {
            this.setType(4);
            pNode = node.getProperty("b");
            if (pNode != null) {
                this.setBadThreshold(this.createDataValue(pNode));
                overridden = true;
            } else if (baseState != null) {
                this.setBadThreshold(baseState.getBadThreshold());
            }
            pNode = node.getProperty(s_goodThreshold);
            if (pNode != null) {
                this.setGoodThreshold(this.createDataValue(pNode));
                overridden = true;
            } else if (baseState != null) {
                this.setGoodThreshold(baseState.getGoodThreshold());
            }
        } else {
            pNode = node.getProperty(s_operator);
            if (pNode != null) {
                this.setOpCode(pNode.getValueAsInteger());
                overridden = true;
            } else if (baseState != null) {
                this.setOperator(baseState.getOperator());
            }
            pNode = node.getProperty("b");
            if (pNode != null) {
                this.setValue1(this.createDataValue(pNode));
                overridden = true;
            } else if (baseState != null) {
                this.setValue1(baseState.getValue1());
            }
            pNode = node.getProperty(s_conditionSelected);
            if (pNode != null) {
                this.setSelected(Utility.getValueAsBoolean((PropertyNode)pNode));
                overridden = true;
            } else if (baseState != null) {
                this.setSelected(baseState.isSelected());
            }
        }
        return overridden;
    }

    public boolean addConditionProperty(ObjectNode node, ConditionElement baseState) {
        boolean hasState = false;
        if (baseState == null) {
            baseState = new ConditionElement();
        }
        if (this.getType() == 4) {
            if (!Utility.compareObj((Object)baseState.getBadThreshold(), (Object)this.getBadThreshold())) {
                this.addProperty(node, "b", this.getBadThreshold());
                hasState = true;
            }
            if (!Utility.compareObj((Object)baseState.getGoodThreshold(), (Object)this.getGoodThreshold())) {
                this.addProperty(node, s_goodThreshold, this.getGoodThreshold());
                hasState = true;
            }
        } else {
            if (!Utility.compareObj((Object)baseState.getOperator(), (Object)this.getOperator())) {
                node.addProperty(s_operator, this.getOpCode());
                hasState = true;
            }
            if (!Utility.compareObj((Object)baseState.getValue1(), (Object)this.getValue1())) {
                this.addProperty(node, "b", this.getValue1());
                hasState = true;
            }
            if (baseState.isSelected() != this.isSelected()) {
                node.addProperty(s_conditionSelected, Utility.getBooleanAsChar((boolean)this.isSelected()));
                hasState = true;
            }
        }
        if (hasState) {
            node.addProperty(s_datatype, this.getStateDatatype());
        }
        return hasState;
    }

    public int getOpCode() {
        String operator = (String)this.getElement(3, 1);
        int i = 0;
        while (i < this.stateNames.length) {
            if (this.stateNames[i].equals(operator)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setOpCode(int opCode) {
        String operator = this.stateNames[opCode];
        this.setElement(3, 1, operator);
    }

    public void addProperty(ObjectNode node, String key, Object data) {
        if (data instanceof Date) {
            node.addProperty(key, ((Date)data).getTime());
        } else {
            node.addProperty(key, data.toString());
        }
    }

    public boolean equals(ConditionElement condition) {
        if (!Utility.compareObj((Object)condition.getValueType(), (Object)this.getValueType())) {
            return false;
        }
        if (this.getType() == 4) {
            if (!Utility.compareObj((Object)condition.getBadThreshold(), (Object)this.getBadThreshold())) {
                return false;
            }
            if (!Utility.compareObj((Object)condition.getGoodThreshold(), (Object)this.getGoodThreshold())) {
                return false;
            }
        } else {
            if (!Utility.compareObj((Object)condition.getOperator(), (Object)this.getOperator())) {
                return false;
            }
            if (!Utility.compareObj((Object)condition.getValue1(), (Object)this.getValue1())) {
                return false;
            }
            if (condition.isSelected() != this.isSelected()) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof ConditionElement) {
            return this.equals((ConditionElement)o);
        }
        return false;
    }

    protected Object createDataValue(PropertyNode node) {
        String type = this.getValueType();
        if ("Double".equals(type)) {
            return new Double(node.getValueAsDouble());
        }
        if ("Date".equals(type)) {
            return new Date(node.getValueAsLong());
        }
        return new String(node.getValueAsString());
    }

    public List getSelectedMemberLabelList() {
        ArrayList<String> list = new ArrayList<String>();
        DimensionMetadata meta = this.getMetadata();
        if (this.getData() instanceof Vector) {
            Vector data = (Vector)this.getData();
            int i = 0;
            while (i < data.size()) {
                list.add(meta.getMemberLabel(data.elementAt(i).toString()));
                ++i;
            }
        } else if (this.getData() != null) {
            list.add(meta.getMemberLabel(this.getData().toString()));
        }
        return list;
    }

    public List getSelectedMemberIDList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.getData() instanceof Vector) {
            Vector data = (Vector)this.getData();
            list.addAll(data);
        } else if (this.getData() != null) {
            list.add(this.getData().toString());
        }
        return list;
    }

    public String getMemberLabels(DataviewCommon view) {
        List list = this.getSelectedMemberLabelList();
        if (list.size() == 0) {
            return MessageFormat.format("Any {0}", this.getMetadata().getDimLabel());
        }
        StringBuffer members = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            members.append(list.get(i) + MemSep);
            ++i;
        }
        members.setLength(members.length() - MemSep.length());
        return members.toString();
    }

    public List getAllMemberLabelList() {
        return this.getMetadata().getMemberLabels();
    }

    public String getDimensionPluralLabel() {
        return this.getMetadata().getDimPluralLabel();
    }

    public String getDimensionLabel() {
        return this.getMetadata().getDimLabel();
    }

    public String getMemberID(String label) {
        return this.getMetadata().getMemberID(label);
    }

    public int getMemberIndex(String label) {
        return this.getMetadata().getMemberLabelIndex(label);
    }

    public String getMemberLabel(int index) {
        return this.getMetadata().getMemberLabel(index);
    }

    public void setMetadata(DimensionMetadata metadata) {
        this.m_metadata = metadata;
    }

    public DimensionMetadata getMetadata() {
        return this.m_metadata;
    }

    private int toValueDiscriminatorOperator() {
        String operator = this.getOperator();
        int i = 0;
        while (i < sOperatorList.length) {
            if (sOperatorList[i].equals(operator)) {
                return iOperatorList[i];
            }
            ++i;
        }
        return -1;
    }

    public ValueDiscriminator toValueDiscriminator() {
        NumberValueDiscriminator discriminator = null;
        if (this.isSelected()) {
            int operator = this.toValueDiscriminatorOperator();
            Object valueObj = this.getValue1();
            if (valueObj instanceof Double) {
                discriminator = new NumberValueDiscriminator(((Double)valueObj).doubleValue(), operator);
            } else if (valueObj instanceof Date) {
                discriminator = new DateValueDiscriminator((Date)valueObj, operator);
            } else if (valueObj instanceof String) {
                discriminator = new StringValueDiscriminator((String)valueObj, operator);
            }
        }
        return discriminator;
    }

    public void setDimensionState(String memberState) {
        DimensionMetadata meta = this.getMetadata();
        StringTokenizer tokenizer = new StringTokenizer(memberState, MemberContext.MEMBER_SEPARATOR_S);
        Vector<String> data = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            String entry = tokenizer.nextToken();
            int memberIndex = Integer.valueOf(entry);
            data.addElement(meta.getMemberID(memberIndex));
        }
        if (data.size() == 0) {
            this.setData(null);
        } else {
            this.setData(data);
        }
    }

    public static void setDimensionListState(List dimensionList, String dimMemsState) {
        StringTokenizer tokenizer = new StringTokenizer(dimMemsState, MemberContext.ENTRY_SEPARATOR_S);
        while (tokenizer.hasMoreTokens()) {
            String entry = tokenizer.nextToken();
            int index = entry.indexOf(MemberContext.DIMENSION_SEPARATOR_S);
            if (index == -1) continue;
            int dimIndex = Integer.valueOf(entry.substring(0, index));
            ConditionElement condition = (ConditionElement)dimensionList.get(dimIndex);
            condition.setDimensionState(entry.substring(index + 1));
        }
    }

    public String getDimensionState(int dimIndex) {
        StringBuffer buffer = new StringBuffer();
        DimensionMetadata meta = this.getMetadata();
        buffer.append(dimIndex);
        buffer.append(MemberContext.DIMENSION_SEPARATOR_S);
        if (this.getData() instanceof Vector) {
            Vector data = (Vector)this.getData();
            int i = 0;
            while (i < data.size()) {
                if (i > 0) {
                    buffer.append(MemberContext.MEMBER_SEPARATOR_S);
                }
                buffer.append(meta.getMemberIndex(data.elementAt(i).toString()));
                ++i;
            }
        } else if (this.getData() != null) {
            buffer.append(meta.getMemberIndex(this.getData().toString()));
        }
        return buffer.toString();
    }

    public static String getDimensionListState(List dimList) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < dimList.size()) {
            if (dimList.get(i) instanceof ConditionElement) {
                if (i > 0) {
                    buffer.append(MemberContext.ENTRY_SEPARATOR_S);
                }
                buffer.append(((ConditionElement)dimList.get(i)).getDimensionState(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    private void $init$() {
        this.stateNames = new String[]{"=", "<", "<=", ">", ">=", bt, sl};
        this.m_Selected = true;
        this.m_type = 0;
        this.m_Dim = null;
        this.m_badThreshold = null;
        this.m_goodThreshold = null;
        this.m_metadata = null;
        this.m_stoplightOK = false;
        this.m_valueType = "Double";
    }
}

