/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import oracle.bali.ewt.util.MenuUtils;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.Controller;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.ControllerListener;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.ManagerAdapter;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.PopupManager;
import oracle.dss.dataView.RolloverTextManager;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.ViewControllerAdapter;
import oracle.dss.dataView.ViewMouseEvent;
import oracle.dss.dataView.ViewMouseListener;
import oracle.dss.pagingControl.PageItem;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.pagingControl.PagingComponent;

public abstract class ControllerAdapter
extends ViewControllerAdapter
implements Controller {
    public static final boolean DEBUG = false;
    private Dataview view;
    private PopupManager popupManager;
    private RolloverTextManager rolloverManager;

    public ControllerAdapter(Dataview v) {
        BaseTitle baseTitle;
        this.$init$();
        this.view = v;
        if (v.getDataviewTitle() != null) {
            baseTitle = (BaseTitle)v.getDataviewTitle();
            baseTitle.addFocusListener(this);
            baseTitle.addMouseMotionListener(this);
            baseTitle.addMouseListener(this);
            baseTitle.addKeyListener(this);
        }
        if (v.getDataviewSubtitle() != null) {
            baseTitle = (BaseTitle)v.getDataviewSubtitle();
            baseTitle.addFocusListener(this);
            baseTitle.addMouseMotionListener(this);
            baseTitle.addMouseListener(this);
            baseTitle.addKeyListener(this);
        }
        if (v.getDataviewFootnote() != null) {
            baseTitle = (BaseTitle)v.getDataviewFootnote();
            baseTitle.addFocusListener(this);
            baseTitle.addMouseMotionListener(this);
            baseTitle.addMouseListener(this);
            baseTitle.addKeyListener(this);
        }
    }

    public void cleanUp() {
        if (this.view.getDataviewTitle() != null) {
            Title title = (Title)this.view.getDataviewTitle();
            title.removeFocusListener(this);
            title.removeMouseMotionListener(this);
            title.removeMouseListener(this);
            title.removeKeyListener(this);
        }
        if (this.view.getDataviewSubtitle() != null) {
            Subtitle subtitle = (Subtitle)this.view.getDataviewSubtitle();
            subtitle.removeFocusListener(this);
            subtitle.removeMouseMotionListener(this);
            subtitle.removeMouseListener(this);
            subtitle.removeKeyListener(this);
        }
        if (this.view.getDataviewFootnote() != null) {
            Footnote footnote = (Footnote)this.view.getDataviewFootnote();
            footnote.removeFocusListener(this);
            footnote.removeMouseMotionListener(this);
            footnote.removeMouseListener(this);
            footnote.removeKeyListener(this);
        }
    }

    protected void changeTitleSelectedState(boolean state) {
        ((Title)this.view.getDataviewTitle()).setSelected(state);
        ((Subtitle)this.view.getDataviewSubtitle()).setSelected(state);
        ((Footnote)this.view.getDataviewFootnote()).setSelected(state);
    }

    protected ComponentHandle createComponentFromPageItem(Object source) {
        PageItem pi = (PageItem)source;
        PagingComponent dpc = this.view.getPagingControl().getPagingComponent();
        return new PageItemComponentHandle(4, this.view.getNameFromID(4), source, dpc.getIndex(pi));
    }

    public void setPopupManager(PopupManager pm) {
        this.popupManager = pm;
    }

    public PopupManager getPopupManager() {
        return this.popupManager;
    }

    public void setRolloverTextManager(RolloverTextManager rm) {
        this.rolloverManager = rm;
    }

    public RolloverTextManager getRolloverTextManager() {
        return this.rolloverManager;
    }

    public void focusGained(FocusEvent e) {
        NonDataComponentHandle c = this.getNonDataComponent((ViewComponent)e.getSource());
        this.processViewFocusEvent(e, c);
    }

    public void focusLost(FocusEvent e) {
        NonDataComponentHandle c = this.getNonDataComponent((ViewComponent)e.getSource());
        if (!e.isTemporary()) {
            this.changeTitleSelectedState(false);
        }
        this.processViewFocusEvent(e, c);
    }

    public void mousePressed(MouseEvent e) {
        this.mouseEvent = e;
        this.processViewMouseEvent(e, this.getNonDataComponent((ViewComponent)e.getSource()));
    }

    protected void processViewMouseEvent(MouseEvent me, ComponentHandle id) {
        ViewMouseEvent e = new ViewMouseEvent(me, id);
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ViewMouseListener.class) {
                ViewMouseListener l = (ViewMouseListener)listeners[i + 1];
                switch (e.getID()) {
                    case 500: {
                        l.mouseClicked(e);
                        break;
                    }
                    case 501: {
                        l.mousePressed(e);
                        break;
                    }
                    case 502: {
                        l.mouseReleased(e);
                        break;
                    }
                    case 504: {
                        l.mouseEntered(e);
                        break;
                    }
                    case 505: {
                        l.mouseExited(e);
                        break;
                    }
                }
                if (e.isConsumed()) {
                    me.consume();
                }
            }
            i -= 2;
        }
        if (this.view.isEnabled() && me.isPopupTrigger()) {
            this.processPopup(me, id);
        }
    }

    protected void processPopup(MouseEvent e, ComponentHandle id) {
        ControllerEvent ce = new ControllerEvent(e.getSource(), id);
        if (this.firePopupTriggering(ce)) {
            return;
        }
        JPopupMenu menu = this.getPopupManager().getPopupMenu(this.view, id);
        if (menu != null) {
            MenuUtils.showPopupMenu((JPopupMenu)menu, (Component)((Component)e.getSource()), (int)e.getX(), (int)e.getY());
        }
        this.firePopupTriggered(ce);
    }

    protected boolean firePopupTriggering(ControllerEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        boolean consumed = false;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ControllerListener.class) {
                ((ControllerListener)listeners[i + 1]).popupTriggering(e);
                if (e.isConsumed()) {
                    consumed = true;
                }
            }
            i -= 2;
        }
        return consumed;
    }

    protected void firePopupTriggered(ControllerEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ControllerListener.class) {
                ((ControllerListener)listeners[i + 1]).popupTriggered(e);
            }
            i -= 2;
        }
    }

    private void $init$() {
        this.view = null;
        this.popupManager = ManagerAdapter.getInstance();
        this.rolloverManager = ManagerAdapter.getInstance();
    }
}

