/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import oracle.dss.dataView.Attributes;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.GroupComponentInfo;

public class GroupComponentHandle
extends ComponentHandle {
    private GroupComponentInfo _groupInfo;
    protected boolean m_seriesAreRows;

    public GroupComponentHandle(int id, String name, Object comp, int group) {
        super(id, name, comp);
        this._groupInfo = new GroupComponentInfo(group);
    }

    public GroupComponentHandle(int id, String name, Object comp, GroupComponentInfo info) {
        super(id, name, comp);
        this._groupInfo = info;
    }

    public GroupComponentHandle(int id, String name, Object comp, int group, int edge, int slice) {
        super(id, name, comp);
        this._groupInfo = new GroupComponentInfo(group, edge, slice);
    }

    public int getLayer() {
        if (this._groupInfo != null) {
            return this._groupInfo.getLayer();
        }
        return 0;
    }

    public int getGroup() {
        return this._groupInfo.getGroup();
    }

    public int getEdge() {
        return this._groupInfo.getEdge();
    }

    public int getSlice() {
        return this._groupInfo.getSlice();
    }

    public String toString() {
        return this.getClass().getName() + " [Name=" + this.getName() + "," + this._groupInfo.toString() + "]";
    }

    public ComponentInfo getComponentInfo() {
        return this._groupInfo;
    }

    public Attributes[] getGroupAttributes() {
        int edge = 1;
        if (this.m_seriesAreRows) {
            edge = 0;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            int i = 0;
            while (i < layers) {
                attrs[i] = new Attributes(this.m_dataAccess, i, this.getGroup(), edge);
                ++i;
            }
            Attributes[] attributesArray = attrs;
            return attributesArray;
        }
        catch (Exception e) {
            Attributes[] attributesArray = null;
            return attributesArray;
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof GroupComponentHandle)) {
            return false;
        }
        return super.equals((GroupComponentHandle)o);
    }

    public void setSeriesAreRows(boolean seriesAreRows) {
        this.m_seriesAreRows = seriesAreRows;
    }
}

