/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import javax.swing.event.EventListenerList;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataAccess;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.RelationalDataAccess;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class LocalXMLDataSource
extends DataAccessAdapter
implements CubeDataDirector,
CubeDataAccess,
RelationalDataDirector,
RelationalDataAccess,
DataSource {
    protected EventListenerList m_listenerList;
    protected DataMap m_dataMap;
    protected MetadataMap m_metadataMap;
    protected int m_columnCount;
    protected int m_rowCount;
    protected int m_pageCount;
    protected Object[] m_columnLabels;
    protected Object[] m_rowLabels;
    protected Object[][] m_data;

    public LocalXMLDataSource(Object[] columnLabels, Object[] rowLabels, Object[][] data) {
        this.$init$();
        if (columnLabels != null) {
            this.m_columnCount = columnLabels.length;
            this.m_columnLabels = columnLabels;
        }
        if (rowLabels != null) {
            this.m_rowCount = rowLabels.length;
            this.m_rowLabels = rowLabels;
        }
        if (data != null) {
            this.m_data = data;
        }
    }

    public CubeDataDirector createCubeDataDirector() {
        return this;
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return this;
    }

    public void addDataDirectorListener(DataDirectorListener l) {
        if (l != null) {
            this.m_listenerList.add(DataDirectorListener.class, l);
            this.fireDataAvailableEvent(new DataAvailableEvent((Object)this, (DataAccess)this));
        }
    }

    public void removeDataDirectorListener(DataDirectorListener l) {
        if (l != null) {
            this.m_listenerList.remove(DataDirectorListener.class, l);
        }
    }

    public DataDirector createDataDirector() {
        return this;
    }

    public DataAccess getDataAccess() throws DataDirectorException {
        return this;
    }

    public DataMap getDataMap() {
        if (this.m_dataMap == null) {
            this.m_dataMap = new DataMap(new String[]{"dataValue"});
        }
        return this.m_dataMap;
    }

    public int getEdgeCount() {
        return 3;
    }

    public int getEdgeExtent(int edge) throws EdgeOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        switch (edge) {
            case 0: {
                return this.m_columnCount;
            }
            case 1: {
                return this.m_rowCount;
            }
            case 2: {
                return this.m_pageCount;
            }
        }
        return 0;
    }

    public int getLayerCount(int edge) throws EdgeOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        switch (edge) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public int getMemberExtent(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        if (layer < 0 || layer >= this.getLayerCount(edge)) {
            throw new LayerOutOfRangeException(layer, this.getLayerCount(edge) - 1);
        }
        if (slice < 0 || slice >= this.getEdgeExtent(edge)) {
            throw new SliceOutOfRangeException(slice, this.getEdgeExtent(edge) - 1);
        }
        switch (edge) {
            case 0: 
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public Object getMemberMetadata(int edge, int layer, int slice, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        if (layer < 0 || layer >= this.getLayerCount(edge)) {
            throw new LayerOutOfRangeException(layer, this.getLayerCount(edge) - 1);
        }
        if (slice < 0 || slice >= this.getEdgeExtent(edge)) {
            throw new SliceOutOfRangeException(slice, this.getEdgeExtent(edge) - 1);
        }
        if (!(type.equals("shortName") || type.equals("mediumName") || type.equals("longName") || type.equals("value"))) {
            return null;
        }
        switch (edge) {
            case 0: {
                return this.m_columnLabels[slice];
            }
            case 1: {
                return this.m_rowLabels[slice];
            }
        }
        return null;
    }

    public int getMemberStartSlice(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        if (layer < 0 || layer >= this.getLayerCount(edge)) {
            throw new LayerOutOfRangeException(layer, this.getLayerCount(edge) - 1);
        }
        if (slice < 0 || slice >= this.getEdgeExtent(edge)) {
            throw new SliceOutOfRangeException(slice, this.getEdgeExtent(edge) - 1);
        }
        switch (edge) {
            case 0: {
                return slice;
            }
            case 1: {
                return slice;
            }
        }
        return 0;
    }

    public MetadataMap getMetadataMap(int edge, int layer) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        if (this.m_metadataMap == null) {
            this.m_metadataMap = new MetadataMap(new String[]{"shortName", "mediumName", "longName"});
        }
        return this.m_metadataMap;
    }

    public Object getSliceLabel(int edge, int slice, String type) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        if (slice < 0 || slice >= this.getEdgeExtent(edge)) {
            throw new SliceOutOfRangeException(slice, this.getEdgeExtent(edge) - 1);
        }
        if (!(type.equals("shortName") || type.equals("mediumName") || type.equals("longName") || type.equals("value"))) {
            return null;
        }
        switch (edge) {
            case 0: {
                return this.m_columnLabels[slice];
            }
            case 1: {
                return this.m_rowLabels[slice];
            }
        }
        return null;
    }

    public int getSliceMemberCount(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        if (slice < 0 || slice >= this.getEdgeExtent(edge)) {
            throw new SliceOutOfRangeException(slice, this.getEdgeExtent(edge) - 1);
        }
        switch (edge) {
            case 0: 
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public Object getValue(int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        try {
            if (row < 0 || row >= this.getEdgeExtent(1)) {
                throw new RowOutOfRangeException((long)row, (long)(this.getEdgeExtent(1) - 1));
            }
            if (col < 0 || col >= this.getEdgeExtent(0)) {
                throw new ColumnOutOfRangeException((long)col, (long)(this.getEdgeExtent(0) - 1));
            }
        }
        catch (EdgeOutOfRangeException e) {
            Object var5_5 = null;
            return var5_5;
        }
        if (!type.equals("dataValue")) {
            return null;
        }
        if (this.m_data == null || this.m_data[col] == null) {
            return null;
        }
        return this.m_data[col][row];
    }

    protected void fireDataAvailableEvent(DataAvailableEvent e) {
        Object[] listeners = this.m_listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DataDirectorListener.class) {
                ((DataDirectorListener)listeners[i + 1]).viewDataAvailable(e);
            }
            i -= 2;
        }
    }

    public DataMap getSupportedDataMap() {
        String[] supported = new String[]{"dataValue"};
        return new DataMap(supported);
    }

    public MetadataMap getSupportedMetadataMap() {
        String[] supported = new String[]{"longName", "mediumName", "shortName", "date", "value", "viewStyle"};
        return new MetadataMap(supported);
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        String[] supported = new String[]{"dimLongName", "dimMediumName", "dimShortName"};
        return new LayerMetadataMap(supported);
    }

    private void $init$() {
        this.m_listenerList = new EventListenerList();
        this.m_dataMap = null;
        this.m_metadataMap = null;
        this.m_columnCount = 0;
        this.m_rowCount = 0;
        this.m_pageCount = 0;
        this.m_columnLabels = null;
        this.m_rowLabels = null;
        this.m_data = null;
    }
}

