/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.io.Serializable;
import javax.swing.event.EventListenerList;
import oracle.dss.dataView.ControllerActions;
import oracle.dss.dataView.DataListener;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DrillEvent;
import oracle.dss.dataView.FormatManager;
import oracle.dss.dataView.LocalDataSource;
import oracle.dss.dataView.ManagerAdapter;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.ModelListener;
import oracle.dss.dataView.PageEvent;
import oracle.dss.dataView.PivotEvent;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataException;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.WaitDataAvailableEvent;

public abstract class ModelAdapter
implements Model,
ControllerActions,
DataDirectorListener,
Serializable {
    protected static final int INITIAL_EDGE_SIZE = 100;
    protected static final int INITIAL_DATA_COLUMN = 20;
    protected static final int INITIAL_DATA_ROW = 20;
    protected EventListenerList listenerList;
    protected transient DataSource dataDirectorFactory;
    protected transient DataDirector dataDirector;
    protected transient DataAccess dataAccess;
    protected transient DataAccess metadataAccess;
    protected boolean drillingEnabled;
    protected transient ErrorHandler m_eh;
    private FormatManager formatManager;

    public ModelAdapter() {
        this.$init$();
    }

    protected void initDefaults(DataviewDefaultValues ddv) {
        this.drillingEnabled = ddv.isDrillingEnabled();
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void setDataSource(DataSource ds) {
        if (this.dataDirector != null && this.dataDirector instanceof DataDirector) {
            this.dataDirector.removeDataDirectorListener((DataDirectorListener)this);
        }
        this.dataDirectorFactory = ds == null ? this.createDefaultDataSource() : ds;
    }

    protected DataSource createDefaultDataSource() {
        return new LocalDataSource();
    }

    public DataSource getDataSource() {
        return this.dataDirectorFactory;
    }

    public void setDataDirector(DataDirector dd) {
        this.dataDirector = dd;
        if (this.dataDirector instanceof DataDirector) {
            DataDirector fullDataDirector = dd;
            fullDataDirector.setManualUpdate();
            try {
                fullDataDirector.setDataMap(this.getDataMap(), 20, 20);
                fullDataDirector.setMetadataMap(0, -1, this.getMetadataMap(0), 100);
                fullDataDirector.setMetadataMap(1, -1, this.getMetadataMap(1), 100);
                fullDataDirector.setMetadataMap(2, -1, this.getMetadataMap(2), 100);
                fullDataDirector.update();
            }
            catch (DataException e) {
                this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "setDataDirector");
            }
        }
        this.setSupportedDataLayerFlags();
        if (this.dataDirector instanceof DataDirector) {
            this.dataDirector.addDataDirectorListener((DataDirectorListener)this);
        } else {
            try {
                this.setDataAccess(this.dataDirector.getDataAccess());
            }
            catch (DataException e) {
                this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "setDataDirector");
            }
        }
    }

    protected abstract void setSupportedDataLayerFlags();

    public DataDirector getDataDirector() {
        return this.dataDirector;
    }

    public void setDataAccess(DataAccess dp) {
        this.dataAccess = dp;
    }

    public DataAccess getDataAccess() {
        return this.dataAccess;
    }

    public void addDataListener(DataListener l) {
        this.listenerList.add(DataListener.class, l);
    }

    public void removeDataListener(DataListener l) {
        this.listenerList.remove(DataListener.class, l);
    }

    public void addModelListener(ModelListener l) {
        this.listenerList.add(ModelListener.class, l);
    }

    public void removeModelListener(ModelListener l) {
        this.listenerList.remove(ModelListener.class, l);
    }

    public boolean pivotGestureHappened(Object source, int fromEdge, int toEdge, int fromLayer, int toLayer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, DataDirectorException {
        PivotEvent e = new PivotEvent(source, fromEdge, toEdge, fromLayer, toLayer, flags);
        this.fireviewPivotRequesting(e);
        if (e.isConsumed()) {
            return false;
        }
        boolean success = this.dataDirector.pivot(fromEdge, toEdge, fromLayer, toLayer, flags);
        this.fireviewPivotRequested(e);
        return success;
    }

    public boolean canPivot(Object source, int fromEdge, int toEdge, int fromLayer, int toLayer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, DataDirectorException {
        return this.dataDirector.pivotOK(fromEdge, toEdge, fromLayer, toLayer, flags);
    }

    public boolean drillGestureHappened(Object source, int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        DrillEvent e = new DrillEvent(source, edge, layer, slice, flags);
        this.fireviewDrillRequesting(e);
        if (e.isConsumed()) {
            return false;
        }
        boolean success = this.dataDirector.drill(edge, layer, slice, flags);
        this.fireviewDrillRequested(e);
        return success;
    }

    public boolean canDrill(Object source, int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        return this.dataDirector.drillOK(edge, layer, slice, flags);
    }

    public boolean pageChangeHappened(Object source, int pos) throws SliceOutOfRangeException, DataDirectorException {
        int[] newHPos = null;
        try {
            int[] currHPos = null;
            switch (pos) {
                case 0: {
                    newHPos = this.dataAccess.getFirstHPos(2);
                    break;
                }
                case 1: {
                    newHPos = this.dataAccess.getLastHPos(2);
                    break;
                }
                case 2: {
                    currHPos = this.dataAccess.getEdgeCurrentHPos(2);
                    newHPos = this.dataAccess.getPrevHPos(2, currHPos);
                    if (newHPos != null) break;
                    boolean bl = false;
                    return bl;
                }
                case 3: {
                    currHPos = this.dataAccess.getEdgeCurrentHPos(2);
                    newHPos = this.dataAccess.getNextHPos(2, currHPos);
                    if (newHPos != null) break;
                    boolean bl = false;
                    return bl;
                }
            }
            int maxLayerSpecified = -1;
            if (newHPos != null) {
                maxLayerSpecified = newHPos.length - 1;
            }
            PageEvent e = new PageEvent(source, newHPos, maxLayerSpecified);
            this.fireviewPageRequesting(e);
            if (e.isConsumed()) {
                boolean bl = false;
                return bl;
            }
            boolean success = this.dataDirector.changeEdgeCurrentHPos(2, newHPos, maxLayerSpecified);
            this.fireviewPageRequested(e);
            boolean bl = success;
            return bl;
        }
        catch (DataException ex) {
            this.getErrorHandler().error((Throwable)ex, this.getClass().getName(), "pageChangeHappened");
            return false;
        }
    }

    public boolean pageChangeHappened(Object source, int[] hPos, int maxLayerSpecified) throws LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        PageEvent e = new PageEvent(source, hPos, maxLayerSpecified);
        this.fireviewPageRequesting(e);
        if (e.isConsumed()) {
            return false;
        }
        boolean success = false;
        try {
            success = this.dataDirector.changeEdgeCurrentHPos(2, hPos, maxLayerSpecified);
        }
        catch (EdgeOutOfRangeException ex) {
            this.getErrorHandler().error((Throwable)ex, this.getClass().getName(), "pageChangeHappened");
        }
        this.fireviewPageRequested(e);
        return success;
    }

    public void setDrillingEnabled(boolean b) {
        this.drillingEnabled = b;
    }

    public boolean isDrillingEnabled() {
        return this.drillingEnabled;
    }

    public ControllerActions getControllerActions() {
        return this;
    }

    protected void fireviewPivotRequesting(PivotEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DataListener.class) {
                ((DataListener)listeners[i + 1]).viewPivotRequesting(e);
            }
            i -= 2;
        }
    }

    protected void fireviewPivotRequested(PivotEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DataListener.class) {
                ((DataListener)listeners[i + 1]).viewPivotRequested(e);
            }
            i -= 2;
        }
    }

    protected void fireviewDrillRequesting(DrillEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DataListener.class) {
                ((DataListener)listeners[i + 1]).viewDrillRequesting(e);
            }
            i -= 2;
        }
    }

    protected void fireviewDrillRequested(DrillEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DataListener.class) {
                ((DataListener)listeners[i + 1]).viewDrillRequested(e);
            }
            i -= 2;
        }
    }

    protected void fireviewPageRequesting(PageEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DataListener.class) {
                ((DataListener)listeners[i + 1]).viewPageRequesting(e);
            }
            i -= 2;
        }
    }

    protected void fireviewPageRequested(PageEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DataListener.class) {
                ((DataListener)listeners[i + 1]).viewPageRequested(e);
            }
            i -= 2;
        }
    }

    public void viewDataChanged(DataChangedEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ModelListener.class) {
                ((ModelListener)listeners[i + 1]).modelDataChanged(e);
            }
            i -= 2;
        }
    }

    public void viewDataAvailable(DataAvailableEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ModelListener.class) {
                ((ModelListener)listeners[i + 1]).modelDataAvailable(e);
            }
            i -= 2;
        }
    }

    public void waitDataAvailable(WaitDataAvailableEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ModelListener.class) {
                ((ModelListener)listeners[i + 1]).modelWaitDataAvailable(e);
            }
            i -= 2;
        }
    }

    protected void setFormatManager(FormatManager fm) {
        this.formatManager = fm;
    }

    protected FormatManager getFormatManager() {
        return this.formatManager;
    }

    protected abstract DataMap getDataMap();

    protected abstract MetadataMap getMetadataMap(int var1);

    protected abstract LayerMetadataMap getLayerMetadataMap(int var1);

    private void $init$() {
        this.listenerList = new EventListenerList();
        this.dataDirector = null;
        this.dataAccess = null;
        this.metadataAccess = null;
        this.m_eh = null;
        this.formatManager = ManagerAdapter.getInstance();
    }
}

