/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import oracle.dss.dataView.Attributes;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.SeriesComponentInfo;

public class SeriesComponentHandle
extends ComponentHandle {
    private SeriesComponentInfo _seriesInfo;
    protected boolean m_seriesAreRows;

    public SeriesComponentHandle(int id, String name, Object comp, int series) {
        super(id, name, comp);
        this._seriesInfo = new SeriesComponentInfo(series);
    }

    public SeriesComponentHandle(int id, String name, Object comp, SeriesComponentInfo info) {
        super(id, name, comp);
        this._seriesInfo = info;
    }

    public SeriesComponentHandle(int id, String name, Object comp, int series, int edge) {
        super(id, name, comp);
        this._seriesInfo = new SeriesComponentInfo(series, edge);
    }

    public int getSeries() {
        return this._seriesInfo.getSeries();
    }

    public int getEdge() {
        return this._seriesInfo.getEdge();
    }

    public String toString() {
        return this.getClass().getName() + " [Name=" + this.getName() + "," + this._seriesInfo.toString() + "]";
    }

    public ComponentInfo getComponentInfo() {
        return this._seriesInfo;
    }

    public Attributes[] getSeriesAttributes() {
        int edge = 0;
        if (this.m_seriesAreRows) {
            edge = 1;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            int i = 0;
            while (i < layers) {
                attrs[i] = new Attributes(this.m_dataAccess, i, this.getSeries(), edge);
                ++i;
            }
            Attributes[] attributesArray = attrs;
            return attributesArray;
        }
        catch (Exception e) {
            Attributes[] attributesArray = null;
            return attributesArray;
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SeriesComponentHandle)) {
            return false;
        }
        return super.equals((SeriesComponentHandle)o);
    }

    public void setSeriesAreRows(boolean seriesAreRows) {
        this.m_seriesAreRows = seriesAreRows;
    }
}

