/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import oracle.dss.dataView.Attributes;
import oracle.dss.dataView.DataComponentHandle;

public class StockDataComponentHandle
extends DataComponentHandle {
    private int m_openIndex;
    private int m_highIndex;
    private int m_lowIndex;
    private int m_closeIndex;
    private int m_volumeIndex;

    public StockDataComponentHandle(int id, String name, Object comp, int r, int c, int group, int series, int o, int h, int l, int cl, int v) {
        super(id, name, comp, r, c, group, series);
        this.$init$();
        this.m_openIndex = o;
        this.m_highIndex = h;
        this.m_lowIndex = l;
        this.m_closeIndex = cl;
        this.m_volumeIndex = v;
    }

    public Object getOpenValue(String attrName) {
        if (this.m_dataAccess != null && this.m_openIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    Object object = this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_openIndex, attrName);
                    return object;
                }
                Object object = this.m_dataAccess.getValue(this.getRow() + this.m_openIndex, this.getColumn(), attrName);
                return object;
            }
            catch (Exception exp) {
                Object var5_5 = null;
                return var5_5;
            }
        }
        return null;
    }

    public Object getHighValue(String attrName) {
        if (this.m_dataAccess != null && this.m_highIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    Object object = this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_highIndex, attrName);
                    return object;
                }
                Object object = this.m_dataAccess.getValue(this.getRow() + this.m_highIndex, this.getColumn(), attrName);
                return object;
            }
            catch (Exception exp) {
                Object var5_5 = null;
                return var5_5;
            }
        }
        return null;
    }

    public Object getLowValue(String attrName) {
        if (this.m_dataAccess != null && this.m_lowIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    Object object = this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_lowIndex, attrName);
                    return object;
                }
                Object object = this.m_dataAccess.getValue(this.getRow() + this.m_lowIndex, this.getColumn(), attrName);
                return object;
            }
            catch (Exception exp) {
                Object var5_5 = null;
                return var5_5;
            }
        }
        return null;
    }

    public Object getCloseValue(String attrName) {
        if (this.m_dataAccess != null && this.m_closeIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    Object object = this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_closeIndex, attrName);
                    return object;
                }
                Object object = this.m_dataAccess.getValue(this.getRow() + this.m_closeIndex, this.getColumn(), attrName);
                return object;
            }
            catch (Exception exp) {
                Object var5_5 = null;
                return var5_5;
            }
        }
        return null;
    }

    public Object getVolumeValue(String attrName) {
        if (this.m_dataAccess != null && this.m_closeIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    Object object = this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_volumeIndex, attrName);
                    return object;
                }
                Object object = this.m_dataAccess.getValue(this.getRow() + this.m_volumeIndex, this.getColumn(), attrName);
                return object;
            }
            catch (Exception exp) {
                Object var5_5 = null;
                return var5_5;
            }
        }
        return null;
    }

    public Attributes[] getOpenAttributes() {
        if (this.m_openIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_openIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_openIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            int i = 0;
            while (i < layers) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
                ++i;
            }
            Attributes[] attributesArray = attrs;
            return attributesArray;
        }
        catch (Exception e) {
            Attributes[] attributesArray = null;
            return attributesArray;
        }
    }

    public Attributes[] getHighAttributes() {
        if (this.m_highIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_highIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_highIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            int i = 0;
            while (i < layers) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
                ++i;
            }
            Attributes[] attributesArray = attrs;
            return attributesArray;
        }
        catch (Exception e) {
            Attributes[] attributesArray = null;
            return attributesArray;
        }
    }

    public Attributes[] getLowAttributes() {
        if (this.m_lowIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_lowIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_lowIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            int i = 0;
            while (i < layers) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
                ++i;
            }
            Attributes[] attributesArray = attrs;
            return attributesArray;
        }
        catch (Exception e) {
            Attributes[] attributesArray = null;
            return attributesArray;
        }
    }

    public Attributes[] getCloseAttributes() {
        if (this.m_closeIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_closeIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_closeIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            int i = 0;
            while (i < layers) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
                ++i;
            }
            Attributes[] attributesArray = attrs;
            return attributesArray;
        }
        catch (Exception e) {
            Attributes[] attributesArray = null;
            return attributesArray;
        }
    }

    public Attributes[] getVolumeAttributes() {
        if (this.m_volumeIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_volumeIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_volumeIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            int i = 0;
            while (i < layers) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
                ++i;
            }
            Attributes[] attributesArray = attrs;
            return attributesArray;
        }
        catch (Exception e) {
            Attributes[] attributesArray = null;
            return attributesArray;
        }
    }

    private void $init$() {
        this.m_openIndex = -1;
        this.m_highIndex = -1;
        this.m_lowIndex = -1;
        this.m_closeIndex = -1;
        this.m_volumeIndex = -1;
    }
}

