/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerListener;
import oracle.dss.dataView.ManagerAdapter;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.SelectEvent;
import oracle.dss.dataView.SelectionManager;
import oracle.dss.dataView.SizeEvent;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.ViewController;
import oracle.dss.dataView.ViewFocusEvent;
import oracle.dss.dataView.ViewFocusListener;
import oracle.dss.dataView.ViewKeyEvent;
import oracle.dss.dataView.ViewKeyListener;
import oracle.dss.dataView.ViewMouseEvent;
import oracle.dss.dataView.ViewMouseListener;
import oracle.dss.dataView.ViewMouseMotionListener;

public abstract class ViewControllerAdapter
implements ViewController,
Serializable,
FocusListener,
MouseMotionListener,
MouseListener,
KeyListener {
    public static final boolean DEBUG = false;
    protected MouseEvent mouseEvent;
    protected EventListenerList listenerList;
    protected Cursor m_defaultCursor;
    protected Cursor m_moveCursor;
    protected Cursor m_waitCursor;
    protected Cursor m_nResizeCursor;
    protected Cursor m_sResizeCursor;
    protected Cursor m_eResizeCursor;
    protected Cursor m_wResizeCursor;
    protected Cursor m_neResizeCursor;
    protected Cursor m_swResizeCursor;
    protected Cursor m_nwResizeCursor;
    protected Cursor m_seResizeCursor;
    protected Cursor m_selectCursor;
    protected Cursor m_textCursor;
    protected Cursor m_drillCursor;
    protected Cursor m_noDropCursor;
    protected Cursor m_vertSplitCursor;
    protected Cursor m_horzSplitCursor;
    protected boolean m_isWaitCursor;
    protected int m_viewPositionX;
    protected int m_viewPositionY;
    protected int m_viewSizeWidth;
    protected int m_viewSizeHeight;
    protected boolean m_viewSizeSet;
    private SelectionManager selectionManager;

    private void $init$() {
        this.listenerList = new EventListenerList();
        this.m_viewPositionX = 0;
        this.m_viewPositionY = 0;
        this.m_viewSizeWidth = 0;
        this.m_viewSizeHeight = 0;
        this.m_viewSizeSet = false;
        this.selectionManager = ManagerAdapter.getInstance();
    }

    public ViewControllerAdapter() {
        this.$init$();
        this.m_isWaitCursor = false;
        this.m_defaultCursor = Cursor.getPredefinedCursor(0);
        this.m_moveCursor = Cursor.getPredefinedCursor(13);
        this.m_waitCursor = Cursor.getPredefinedCursor(3);
        this.m_nResizeCursor = Cursor.getPredefinedCursor(8);
        this.m_sResizeCursor = Cursor.getPredefinedCursor(9);
        this.m_eResizeCursor = Cursor.getPredefinedCursor(11);
        this.m_wResizeCursor = Cursor.getPredefinedCursor(10);
        this.m_neResizeCursor = Cursor.getPredefinedCursor(7);
        this.m_swResizeCursor = Cursor.getPredefinedCursor(4);
        this.m_nwResizeCursor = Cursor.getPredefinedCursor(6);
        this.m_seResizeCursor = Cursor.getPredefinedCursor(5);
        this.m_selectCursor = Cursor.getPredefinedCursor(1);
        this.m_textCursor = Cursor.getPredefinedCursor(2);
        this.m_drillCursor = Cursor.getPredefinedCursor(12);
        this.m_noDropCursor = Cursor.getPredefinedCursor(0);
        this.m_vertSplitCursor = Cursor.getPredefinedCursor(0);
        this.m_horzSplitCursor = Cursor.getPredefinedCursor(0);
    }

    public void cleanUp() {
    }

    public void addControllerListener(ControllerListener l) {
        this.listenerList.add(ControllerListener.class, l);
    }

    public void removeControllerListener(ControllerListener l) {
        this.listenerList.remove(ControllerListener.class, l);
    }

    public void addViewMouseListener(ViewMouseListener l) {
        this.listenerList.add(ViewMouseListener.class, l);
    }

    public void removeViewMouseListener(ViewMouseListener l) {
        this.listenerList.remove(ViewMouseListener.class, l);
    }

    public void addViewMouseMotionListener(ViewMouseMotionListener l) {
        this.listenerList.add(ViewMouseMotionListener.class, l);
    }

    public void removeViewMouseMotionListener(ViewMouseMotionListener l) {
        this.listenerList.remove(ViewMouseMotionListener.class, l);
    }

    public void addViewKeyListener(ViewKeyListener l) {
        this.listenerList.add(ViewKeyListener.class, l);
    }

    public void removeViewKeyListener(ViewKeyListener l) {
        this.listenerList.remove(ViewKeyListener.class, l);
    }

    public void addViewFocusListener(ViewFocusListener l) {
        this.listenerList.add(ViewFocusListener.class, l);
    }

    public void removeViewFocusListener(ViewFocusListener l) {
        this.listenerList.remove(ViewFocusListener.class, l);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        NonDataComponentHandle c = this.getNonDataComponent((ViewComponent)e.getSource());
        this.processViewFocusEvent(e, c);
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseEvent = e;
        this.processViewMouseMotionEvent(e, this.getNonDataComponent((ViewComponent)e.getSource()));
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseEvent = e;
        this.processViewMouseMotionEvent(e, this.getNonDataComponent((ViewComponent)e.getSource()));
    }

    public void mouseClicked(MouseEvent e) {
        this.mouseEvent = e;
        this.processViewMouseEvent(e, this.getNonDataComponent((ViewComponent)e.getSource()));
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseEvent = e;
        this.processViewMouseEvent(e, this.getNonDataComponent((ViewComponent)e.getSource()));
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseEvent = e;
        this.processViewMouseEvent(e, this.getNonDataComponent((ViewComponent)e.getSource()));
    }

    public void mouseExited(MouseEvent e) {
        this.mouseEvent = e;
        this.processViewMouseEvent(e, this.getNonDataComponent((ViewComponent)e.getSource()));
    }

    public void keyTyped(KeyEvent e) {
        this.processViewKeyEvent(e, this.getNonDataComponent((ViewComponent)e.getSource()));
    }

    public void keyPressed(KeyEvent e) {
        this.processViewKeyEvent(e, this.getNonDataComponent((ViewComponent)e.getSource()));
    }

    public void keyReleased(KeyEvent e) {
        this.processViewKeyEvent(e, this.getNonDataComponent((ViewComponent)e.getSource()));
    }

    protected void setSelectionManager(SelectionManager sm) {
        this.selectionManager = sm;
    }

    protected SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    protected void processViewMouseEvent(MouseEvent me, ComponentHandle id) {
    }

    protected void processViewMouseMotionEvent(MouseEvent me, ComponentHandle id) {
        ViewMouseEvent e = new ViewMouseEvent(me, id);
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ViewMouseMotionListener.class) {
                ViewMouseMotionListener l = (ViewMouseMotionListener)listeners[i + 1];
                switch (e.getID()) {
                    case 506: {
                        l.mouseDragged(e);
                        break;
                    }
                    case 503: {
                        l.mouseMoved(e);
                        break;
                    }
                }
                if (e.isConsumed()) {
                    me.consume();
                }
            }
            i -= 2;
        }
    }

    protected void processViewKeyEvent(KeyEvent me, ComponentHandle id) {
        ViewKeyEvent e = new ViewKeyEvent(me, id);
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ViewKeyListener.class) {
                ViewKeyListener l = (ViewKeyListener)listeners[i + 1];
                switch (e.getID()) {
                    case 401: {
                        l.keyPressed(e);
                        break;
                    }
                    case 402: {
                        l.keyReleased(e);
                        break;
                    }
                    case 400: {
                        l.keyTyped(e);
                        break;
                    }
                }
                me.setKeyCode(e.getKeyCode());
                me.setKeyChar(e.getKeyChar());
                if (e.isConsumed()) {
                    me.consume();
                }
            }
            i -= 2;
        }
    }

    protected void processViewFocusEvent(FocusEvent me, ComponentHandle id) {
        ViewFocusEvent e = new ViewFocusEvent(me, id);
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ViewFocusListener.class) {
                ViewFocusListener l = (ViewFocusListener)listeners[i + 1];
                switch (e.getID()) {
                    case 1004: {
                        l.focusGained(e);
                        break;
                    }
                    case 1005: {
                        l.focusLost(e);
                        break;
                    }
                }
            }
            i -= 2;
        }
    }

    protected boolean fireComponentSizing(Object source, ComponentHandle id) {
        SizeEvent e = new SizeEvent(source, 0, id);
        Object[] listeners = this.listenerList.getListenerList();
        boolean bNotConsumed = true;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ControllerListener.class) {
                ((ControllerListener)listeners[i + 1]).componentSizing(e);
                if (e.isConsumed()) {
                    bNotConsumed = false;
                }
            }
            i -= 2;
        }
        return bNotConsumed;
    }

    protected void fireComponentSized(Object source, ComponentHandle id) {
        SizeEvent e = new SizeEvent(source, 1, id);
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ControllerListener.class) {
                ((ControllerListener)listeners[i + 1]).componentSized(e);
            }
            i -= 2;
        }
    }

    protected boolean fireComponentSelecting(Object source, ComponentHandle id) {
        SelectEvent e = new SelectEvent(source, 0, id);
        Object[] listeners = this.listenerList.getListenerList();
        boolean bNotConsumed = true;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ControllerListener.class) {
                ((ControllerListener)listeners[i + 1]).componentSelecting(e);
                if (e.isConsumed()) {
                    bNotConsumed = false;
                }
            }
            i -= 2;
        }
        return bNotConsumed;
    }

    protected void fireComponentSelected(Object source, ComponentHandle id) {
        SelectEvent e = new SelectEvent(source, 1, id);
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ControllerListener.class) {
                ((ControllerListener)listeners[i + 1]).componentSelected(e);
            }
            i -= 2;
        }
    }

    protected NonDataComponentHandle getNonDataComponent(ViewComponent c) {
        return new NonDataComponentHandle(c.getID(), c.getComponentName(), c);
    }

    protected MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    public void setCursorType(Cursor c, int type) {
        switch (type) {
            case 0: {
                this.m_defaultCursor = c;
                break;
            }
            case 1: {
                this.m_moveCursor = c;
                break;
            }
            case 2: {
                this.m_waitCursor = c;
                break;
            }
            case 3: {
                this.m_nResizeCursor = c;
                break;
            }
            case 4: {
                this.m_sResizeCursor = c;
                break;
            }
            case 5: {
                this.m_eResizeCursor = c;
                break;
            }
            case 6: {
                this.m_wResizeCursor = c;
                break;
            }
            case 7: {
                this.m_neResizeCursor = c;
                break;
            }
            case 8: {
                this.m_swResizeCursor = c;
                break;
            }
            case 9: {
                this.m_nwResizeCursor = c;
                break;
            }
            case 10: {
                this.m_seResizeCursor = c;
                break;
            }
            case 11: {
                this.m_selectCursor = c;
                break;
            }
            case 12: {
                this.m_textCursor = c;
                break;
            }
            case 13: {
                this.m_drillCursor = c;
                break;
            }
            case 14: {
                this.m_drillCursor = c;
                break;
            }
            case 16: {
                this.m_nResizeCursor = c;
                break;
            }
            case 15: {
                this.m_nResizeCursor = c;
                break;
            }
        }
    }

    public Cursor getCursorType(int type) {
        Cursor c = Cursor.getPredefinedCursor(0);
        switch (type) {
            case 0: {
                c = this.m_defaultCursor;
                break;
            }
            case 1: {
                c = this.m_moveCursor;
                break;
            }
            case 2: {
                c = this.m_waitCursor;
                break;
            }
            case 3: {
                c = this.m_nResizeCursor;
                break;
            }
            case 4: {
                c = this.m_sResizeCursor;
                break;
            }
            case 5: {
                c = this.m_eResizeCursor;
                break;
            }
            case 6: {
                c = this.m_wResizeCursor;
                break;
            }
            case 7: {
                c = this.m_neResizeCursor;
                break;
            }
            case 8: {
                c = this.m_swResizeCursor;
                break;
            }
            case 9: {
                c = this.m_nwResizeCursor;
                break;
            }
            case 10: {
                c = this.m_seResizeCursor;
                break;
            }
            case 11: {
                c = this.m_selectCursor;
                break;
            }
            case 12: {
                c = this.m_textCursor;
                break;
            }
            case 13: {
                c = this.m_drillCursor;
                break;
            }
            case 14: {
                c = this.m_noDropCursor;
                break;
            }
            case 16: {
                c = this.m_nResizeCursor;
                break;
            }
            case 15: {
                c = this.m_nResizeCursor;
                break;
            }
        }
        return c;
    }

    public void setWaitCursorForced(boolean yesNo) {
        this.m_isWaitCursor = yesNo;
    }

    public boolean isWaitCursorForced() {
        return this.m_isWaitCursor;
    }
}

