/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.sql.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Data {
    protected Dictionary m_dataDict;
    protected Map m_map;
    protected int m_rows;
    protected int m_cols;
    protected static final String CELL = "Cell";
    protected static final String DATA = "Data";
    protected static final String DATAMAP = "DataMap";
    protected static final String DATATYPE = "dtype";
    protected static final String DATE = "date";
    protected static final String DOUBLE = "double";
    protected static final String LONG = "long";
    protected static final String STRING = "str";

    Data(Map dataMap, int nRows, int nCols) {
        this.m_map = dataMap;
        this.m_rows = nRows;
        this.m_cols = nCols;
        this.m_dataDict = new Hashtable();
        Enumeration types = this.m_map.getSupportedMap().types();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            this.m_dataDict.put(type, new Object[nRows][nCols]);
        }
    }

    public Map getMap() {
        return this.m_map;
    }

    public Object getValue(int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        Object[][] data = this.getData(type);
        if (data == null) {
            return null;
        }
        int rows = data.length;
        if (row >= rows) {
            throw new RowOutOfRangeException((long)row, (long)(rows - 1));
        }
        int columns = data[row].length;
        if (col >= columns) {
            throw new ColumnOutOfRangeException((long)col, (long)(columns - 1));
        }
        return data[row][col];
    }

    public void setValue(Object value, int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        Object[][] data = this.getData(type);
        if (data == null) {
            return;
        }
        int rows = data.length;
        if (row >= rows) {
            throw new RowOutOfRangeException((long)row, (long)(rows - 1));
        }
        int columns = data[row].length;
        if (col >= columns) {
            throw new ColumnOutOfRangeException((long)col, (long)(columns - 1));
        }
        data[row][col] = value;
    }

    public void readDataFromXML(ContainerNode dataNode, int col) {
        String coltype = DOUBLE;
        PropertyNode typeNode = dataNode.getProperty(DATATYPE);
        if (typeNode != null) {
            coltype = typeNode.getValueAsString();
        }
        Enumeration cells = dataNode.getContainedObject(CELL);
        int row = 0;
        while (cells.hasMoreElements()) {
            String celltype = coltype;
            ObjectNode cell = (ObjectNode)cells.nextElement();
            typeNode = cell.getProperty(DATATYPE);
            if (typeNode != null) {
                celltype = typeNode.getValueAsString();
            }
            Enumeration types = this.m_map.types();
            while (types.hasMoreElements()) {
                String type = (String)types.nextElement();
                Object[][] data = this.getData(type);
                Object obj = this.m_map.readDataFromXML((BaseObjectNode)cell, type);
                if (obj == null || data == null || row >= data.length || col >= data[row].length) continue;
                Object result = obj;
                if (type.equals("dataValue")) {
                    String value = obj.toString();
                    if (celltype.equals(DOUBLE)) {
                        result = Double.valueOf(value);
                    } else if (celltype.equals(LONG)) {
                        result = Long.valueOf(value);
                    } else if (celltype.equals(DATE)) {
                        result = Date.valueOf(value);
                    }
                } else if (type.equals("dataGroupSort")) {
                    result = Integer.valueOf(obj.toString());
                } else if (type.equals("dataIsTotal")) {
                    result = Boolean.valueOf(obj.toString());
                }
                data[row][col] = result;
            }
            ++row;
        }
    }

    public void addDataToXML(ContainerNode datacells, int col) {
        int row;
        String coltype = null;
        if (this.m_map.getSupportedMap().contains((Object)"dataValue")) {
            row = 0;
            while (row < this.m_rows) {
                try {
                    coltype = Data.getDataType(this.getValue(row, col, "dataValue"));
                }
                catch (RowOutOfRangeException re) {
                }
                catch (ColumnOutOfRangeException ce) {
                    // empty catch block
                }
                if (coltype != null) break;
                ++row;
            }
        }
        if (coltype != null && coltype != DOUBLE) {
            datacells.addProperty(DATATYPE, coltype);
        }
        row = 0;
        while (row < this.m_rows) {
            ObjectNode cell = new ObjectNode(CELL);
            Enumeration types = this.m_map.types();
            while (types.hasMoreElements()) {
                String celltype;
                String type = (String)types.nextElement();
                Object val = null;
                try {
                    val = this.getValue(row, col, type);
                }
                catch (RowOutOfRangeException re) {
                }
                catch (ColumnOutOfRangeException ce) {
                    // empty catch block
                }
                if (val != null && type.equals("dataValue") && coltype != (celltype = Data.getDataType(val))) {
                    cell.addProperty(DATATYPE, celltype);
                }
                this.m_map.addDataToXML((BaseObjectNode)cell, type, val);
            }
            datacells.addContainedObject((BaseNode)cell);
            ++row;
        }
    }

    public void initializeDataSource(DataAccess da) {
        Enumeration types = this.m_map.types();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            Object[][] data = this.getData(type);
            int row = 0;
            while (row < this.m_rows) {
                int col = 0;
                while (col < this.m_cols) {
                    try {
                        data[row][col] = da.getValue(row, col, type);
                    }
                    catch (RowOutOfRangeException re) {
                    }
                    catch (ColumnOutOfRangeException ce) {
                        // empty catch block
                    }
                    ++col;
                }
                ++row;
            }
        }
    }

    private static String getDataType(Object data) {
        String ret = null;
        if (data == null) {
            return null;
        }
        ret = data instanceof Double || data instanceof Float ? DOUBLE : (data instanceof Integer || data instanceof Long || data instanceof Short ? LONG : (data instanceof Date ? DATE : STRING));
        return ret;
    }

    private Object[][] getData(String type) {
        return (Object[][])this.m_dataDict.get(type);
    }
}

