/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Enumeration;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Metadata;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ObjectNode;

public class Member
extends Metadata {
    public static final String MEMBER = "Member";
    private static final String[] INTEGER_METADATA = new String[]{"hierLevel", "drillState", "relIndent"};
    private static final String[] BOOLEAN_METADATA = new String[]{"isTotal"};

    public Member() {
    }

    public Member(ObjectNode memberNode, Map metadataMap) {
        Enumeration types = metadataMap.types();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            Object value = metadataMap.readDataFromXML((BaseObjectNode)memberNode, type);
            if (value == null) continue;
            Object result = value;
            int i = 0;
            while (i < INTEGER_METADATA.length) {
                if (type.equals(INTEGER_METADATA[i])) {
                    result = Integer.valueOf(value.toString());
                    break;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < BOOLEAN_METADATA.length) {
                if (type.equals(BOOLEAN_METADATA[i2])) {
                    result = Boolean.valueOf(value.toString());
                    break;
                }
                ++i2;
            }
            this.setMetadata(type, result);
        }
    }

    public Member(DataAccess da, int edge, int layer, int slice, Map metadataMap) {
        Enumeration types = metadataMap.types();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            try {
                Object value = da.getMemberMetadata(edge, layer, slice, type);
                if (value == null) continue;
                this.setMetadata(type, value);
            }
            catch (EdgeOutOfRangeException e) {
            }
            catch (LayerOutOfRangeException e) {
            }
            catch (SliceOutOfRangeException e) {
                // empty catch block
            }
        }
    }

    public ObjectNode addMemberToXML(Map metadataMap) {
        ObjectNode member = new ObjectNode(MEMBER);
        Enumeration types = metadataMap.types();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            Object value = this.getMetadata(type);
            metadataMap.addDataToXML((BaseObjectNode)member, type, value);
        }
        return member;
    }
}

