/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Member;
import oracle.dss.dataView.datacache.PageLayer;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class PageEdge
implements Edge {
    private PageLayer[] m_layers;
    private int[] m_defHPos;

    public PageEdge(PageLayer[] layers) {
        this.m_layers = layers;
        this.m_defHPos = new int[this.m_layers.length];
    }

    public PageEdge(ObjectNode edgeNode, Map metadataMap, Map layerMap) {
        int layerCount = 0;
        try {
            layerCount = edgeNode.getPropertyValueAsInteger("layerCount");
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        ContainerNode layersNode = edgeNode.getContainer("Layers");
        if (layersNode == null) {
            layerCount = 0;
        }
        this.m_layers = new PageLayer[layerCount];
        if (layersNode != null) {
            Enumeration entries = layersNode.getContainerNodes("Layer");
            int layer = 0;
            while (layer < layerCount) {
                if (entries.hasMoreElements()) {
                    ContainerNode layerNode = (ContainerNode)entries.nextElement();
                    this.m_layers[layer] = new PageLayer(layerNode, metadataMap, layerMap);
                } else {
                    this.m_layers[layer] = new PageLayer();
                }
                ++layer;
            }
        }
        this.m_defHPos = new int[layerCount];
    }

    public PageEdge(DataAccess da, int edge, Map metadataMap, Map layerMap) {
        int slice = 0;
        int layerCount = 0;
        try {
            slice = da.getEdgeCurrentSlice(edge);
            layerCount = da.getLayerCount(edge);
        }
        catch (EdgeOutOfRangeException e) {
            // empty catch block
        }
        this.m_layers = new PageLayer[layerCount];
        int layer = 0;
        while (layer < layerCount) {
            this.m_layers[layer] = new PageLayer(da, edge, layer, slice, metadataMap, layerMap);
            ++layer;
        }
        this.m_defHPos = new int[layerCount];
    }

    public ObjectNode addEdgeToXML(String name, Data data, Map metadataMap, Map layerMap) {
        ObjectNode edgeNode = new ObjectNode(name);
        int layerCount = this.getLayerCount();
        edgeNode.addProperty("layerCount", layerCount);
        ContainerNode layersNode = new ContainerNode("Layers");
        int layer = 0;
        while (layer < layerCount) {
            ContainerNode layerNode = this.m_layers[layer].addLayerToXML(metadataMap, layerMap);
            layersNode.addContainedObject((BaseNode)layerNode);
            ++layer;
        }
        edgeNode.addContainer(layersNode);
        return edgeNode;
    }

    public Object getMemberMetadata(int layer, int slice, String type) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return this.getMember(layer, slice).getMetadata(type);
    }

    public Object getLayerMetadata(int layer, String type) throws LayerOutOfRangeException {
        if (layer >= this.m_layers.length) {
            throw new LayerOutOfRangeException(layer, this.m_layers.length - 1);
        }
        return this.m_layers[layer].getMetadata(type);
    }

    public int getLayerCount() {
        return this.m_layers.length;
    }

    public int getExtent() {
        return 1;
    }

    public int getLimit() {
        return -1;
    }

    public int getSliceOutlineLayer(int slice) throws SliceOutOfRangeException {
        return 0;
    }

    public Object getSliceLabel(int slice) throws SliceOutOfRangeException {
        return null;
    }

    public int getSliceMemberCount(int slice) throws SliceOutOfRangeException {
        if (slice != 0) {
            throw new SliceOutOfRangeException(slice, 0);
        }
        return this.m_layers.length;
    }

    public int getMemberDepth(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        this.getMember(layer, slice);
        return 1;
    }

    public int getMemberStartLayer(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        this.getMember(layer, slice);
        return layer;
    }

    public int getMemberExtent(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        this.getMember(layer, slice);
        return 1;
    }

    public int getMemberStartSlice(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        this.getMember(layer, slice);
        return slice;
    }

    public int getMemberSiblingCount(int[] hPos, int memberLayer) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    public Object getMemberMetadata(int[] hPos, int memberLayer, int hIndex, String type) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getMemberMetadata(memberLayer, 0, type);
    }

    public int[] getMemberHPos(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        this.getMember(layer, slice);
        return new int[layer + 1];
    }

    public int[] getFirstHPos() {
        return this.m_defHPos;
    }

    public int[] getLastHPos() {
        return this.m_defHPos;
    }

    public int[] getPrevHPos(int[] hPos) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    public int[] getNextHPos(int[] hPos) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    public int getCurrentSlice() {
        return 0;
    }

    public int[] getCurrentHPos() {
        return this.m_defHPos;
    }

    public QDR getSliceQDR(int slice) {
        return null;
    }

    public QDR getMemberQDR(int layer, int slice) {
        return null;
    }

    private Member getMember(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        if (slice != 0) {
            throw new SliceOutOfRangeException(slice, 0);
        }
        if (layer < 0) {
            throw new LayerOutOfRangeException(slice, 0);
        }
        if (layer >= this.m_layers.length) {
            throw new LayerOutOfRangeException(slice, this.m_layers.length - 1);
        }
        return this.m_layers[layer].getMember();
    }

    public Enumeration getMemberEnumeration(int layer) {
        return new _MemberEnumeration(layer);
    }

    static PageLayer[] ra$m_layers(PageEdge pageEdge) {
        return pageEdge.m_layers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _MemberEnumeration
    implements Enumeration {
        private Member member;

        _MemberEnumeration(int layer) {
            this.member = PageEdge.ra$m_layers(PageEdge.this)[layer].getMember();
        }

        @Override
        public boolean hasMoreElements() {
            return this.member != null;
        }

        public Object nextElement() throws NoSuchElementException {
            Member ret = null;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            ret = this.member;
            this.member = null;
            return ret;
        }
    }
}

