/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Enumeration;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Member;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class RelationalEdge
implements Edge {
    private int m_nLimit;
    private Member[] m_members;

    private void $init$() {
        this.m_nLimit = -1;
    }

    public RelationalEdge(ObjectNode edgeNode, Data d, Map metadataMap) {
        this.$init$();
        int layerCount = 0;
        ContainerNode layersNode = null;
        if (edgeNode != null) {
            try {
                layerCount = edgeNode.getPropertyValueAsInteger("layerCount");
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
            try {
                this.m_nLimit = edgeNode.getPropertyValueAsInteger("limit");
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
            layersNode = edgeNode.getContainer("Layers");
            if (layersNode == null) {
                layerCount = 0;
            }
        }
        this.m_members = new Member[layerCount];
        if (layerCount > 0) {
            Enumeration entries = layersNode.getContainedObject("Member");
            int layer = 0;
            while (layer < layerCount) {
                if (entries.hasMoreElements()) {
                    ObjectNode memberNode = (ObjectNode)entries.nextElement();
                    this.m_members[layer] = new Member(memberNode, metadataMap);
                    ContainerNode dataNode = memberNode.getContainer("Data");
                    if (d != null && dataNode != null) {
                        d.readDataFromXML(dataNode, layer);
                    }
                } else {
                    this.m_members[layer] = new Member();
                }
                ++layer;
            }
        }
    }

    public RelationalEdge(DataAccess da, int edge, Map metadataMap, int limit) {
        this.$init$();
        int layerCount = 1;
        try {
            layerCount = da.getLayerCount(edge);
        }
        catch (EdgeOutOfRangeException e) {
            // empty catch block
        }
        if (limit != -1 && layerCount > limit) {
            layerCount = limit;
            this.m_nLimit = limit;
        }
        this.m_members = new Member[layerCount];
        int layer = 0;
        while (layer < layerCount) {
            this.m_members[layer] = new Member(da, edge, layer, 0, metadataMap);
            ++layer;
        }
    }

    public ObjectNode addEdgeToXML(String name, Data d, Map metadataMap, Map layerMap) {
        ObjectNode edgeNode = new ObjectNode(name);
        int layerCount = this.getLayerCount();
        edgeNode.addProperty("layerCount", layerCount);
        edgeNode.addProperty("limit", this.getLimit());
        ContainerNode layersNode = new ContainerNode("Layers");
        int layer = 0;
        while (layer < layerCount) {
            ObjectNode memberNode = this.m_members[layer].addMemberToXML(metadataMap);
            if (d != null) {
                ContainerNode dataNode = new ContainerNode("Data");
                d.addDataToXML(dataNode, layer);
                memberNode.addContainer(dataNode);
            }
            layersNode.addContainedObject((BaseNode)memberNode);
            ++layer;
        }
        edgeNode.addContainer(layersNode);
        return edgeNode;
    }

    public Object getMemberMetadata(int layer, int slice, String type) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return this.getMember(layer).getMetadata(type);
    }

    public Object getLayerMetadata(int layer, String type) throws LayerOutOfRangeException {
        if (type.equals("dimShortName")) {
            type = "shortName";
        } else if (type.equals("dimMediumName")) {
            type = "mediumName";
        } else if (type.equals("dimLongName")) {
            type = "longName";
        } else if (type.equals("dimName")) {
            type = "value";
        }
        return this.getMember(layer).getMetadata(type);
    }

    public int getLayerCount() {
        return this.m_members.length;
    }

    public int getExtent() {
        return this.getLayerCount();
    }

    public int getLimit() {
        return this.m_nLimit;
    }

    public Object getSliceLabel(int slice) throws SliceOutOfRangeException {
        try {
            Object object = this.getMember(slice).getMetadata("longName");
            return object;
        }
        catch (LayerOutOfRangeException e) {
            Object var4_4 = null;
            return var4_4;
        }
    }

    public int getSliceMemberCount(int slice) throws SliceOutOfRangeException {
        return 0;
    }

    public int getMemberDepth(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    public int getSliceOutlineLayer(int slice) throws SliceOutOfRangeException {
        return 0;
    }

    public int getMemberStartLayer(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return 0;
    }

    public int getMemberExtent(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return 1;
    }

    public int getMemberStartSlice(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return 0;
    }

    public int getMemberSiblingCount(int[] hPos, int memberLayer) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return 0;
    }

    public Object getMemberMetadata(int[] hPos, int memberLayer, int hIndex, String type) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    public int[] getMemberHPos(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    public int[] getFirstHPos() {
        return null;
    }

    public int[] getLastHPos() {
        return null;
    }

    public int[] getPrevHPos(int[] hPos) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    public int[] getNextHPos(int[] hPos) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    public int getCurrentSlice() {
        return 0;
    }

    public int[] getCurrentHPos() {
        return null;
    }

    public QDR getMemberQDR(int layer, int slice) {
        return null;
    }

    public QDR getSliceQDR(int slice) {
        return null;
    }

    private Member getMember(int layer) throws LayerOutOfRangeException {
        if (layer >= this.m_members.length) {
            throw new LayerOutOfRangeException(layer, this.m_members.length - 1);
        }
        if (layer < 0) {
            throw new LayerOutOfRangeException(layer, 0);
        }
        return this.m_members[layer];
    }

    public Enumeration getMemberEnumeration(int layer) {
        return null;
    }
}

