/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.dss.dataView.datacache.CubeLayer;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Member;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class RowColumnEdge
implements Edge {
    private CubeLayer[] m_layers;
    private int m_nExtent;
    private int m_nLimit;
    private boolean m_isOutline;
    private Cell[][] m_cells;
    private QDR[][] m_memberQDRs;
    private QDR[] m_sliceQDRs;
    public static final String EDGECELLS = "EdgeCells";
    public static final String EDGECELL = "EdgeCell";
    public static final String VAL = "val";
    public static final String DEPTH = "depth";
    public static final String OUTLINELAYER = "outlineLayer";
    public static final String MEMBERQDRS = "memberQdrs";
    public static final String SLICEQDRS = "sliceQdrs";

    RowColumnEdge(DataAccess da, boolean isOutline, int edge, Map metadataMap, Map layerMap, int limit) {
        this.$init$();
        if (isOutline) {
            this.m_isOutline = isOutline;
            this._buildOutlineMode(da, edge, metadataMap, layerMap, limit);
            return;
        }
        int layerCount = 1;
        this.m_nExtent = 0;
        boolean limited = false;
        try {
            layerCount = da.getLayerCount(edge);
            this.m_nExtent = da.getEdgeExtent(edge);
        }
        catch (EdgeOutOfRangeException e) {
            // empty catch block
        }
        if (limit != -1 && this.m_nExtent > limit) {
            limited = true;
            this.m_nExtent = limit;
            this.m_nLimit = limit;
        }
        this.m_cells = new Cell[layerCount][this.m_nExtent];
        this.m_layers = new CubeLayer[layerCount];
        int layer = 0;
        while (layer < layerCount) {
            this.m_layers[layer] = new CubeLayer(da, edge, layer, layerMap);
            try {
                int j = 0;
                while (j < this.m_nExtent) {
                    block14: {
                        int start_slice;
                        int start_layer;
                        int depth;
                        int span;
                        block16: {
                            block15: {
                                block13: {
                                    block12: {
                                        span = da.getMemberExtent(edge, layer, j);
                                        depth = da.getMemberDepth(edge, layer, j);
                                        start_layer = da.getMemberStartLayer(edge, layer, j);
                                        if (depth <= 1) break block12;
                                        if (start_layer == layer) break block13;
                                        break block14;
                                    }
                                    start_layer = layer;
                                }
                                start_slice = da.getMemberStartSlice(edge, layer, j);
                                if (limited && span + start_slice > this.m_nExtent) {
                                    span = this.m_nExtent - start_slice;
                                }
                                if (span <= 1) break block15;
                                if (start_slice == j) break block16;
                                break block14;
                            }
                            start_slice = j;
                        }
                        Object value = null;
                        value = da.getMemberMetadata(edge, layer, j, "value");
                        Member member = this.m_layers[layer].getMember(value);
                        if (member == null) {
                            member = new Member(da, edge, layer, j, metadataMap);
                            this.m_layers[layer].putMember(value, member);
                        }
                        this.addCell(member, start_layer, start_slice, depth, span);
                    }
                    ++j;
                }
            }
            catch (EdgeOutOfRangeException e) {
            }
            catch (LayerOutOfRangeException e) {
            }
            catch (SliceOutOfRangeException e) {
                // empty catch block
            }
            ++layer;
        }
    }

    public RowColumnEdge(ObjectNode edgeNode, boolean isOutline, Data d, Map metadataMap, Map layerMap) {
        ContainerNode sliceQDRs;
        ContainerNode memberQDRs;
        this.$init$();
        int layerCount = 0;
        this.m_isOutline = isOutline;
        ContainerNode layersNode = null;
        if (edgeNode != null) {
            try {
                layerCount = edgeNode.getPropertyValueAsInteger("layerCount");
                this.m_nExtent = edgeNode.getPropertyValueAsInteger("extent");
                this.m_nLimit = edgeNode.getPropertyValueAsInteger("limit");
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
            layersNode = edgeNode.getContainer("Layers");
            if (layersNode == null) {
                layerCount = 0;
            }
        }
        this.m_layers = new CubeLayer[layerCount];
        if (layerCount > 0) {
            this.m_cells = this.m_isOutline ? new Cell[1][this.m_nExtent] : new Cell[layerCount][this.m_nExtent];
            Enumeration entries = layersNode.getContainerNodes("Layer");
            int layer = 0;
            while (entries.hasMoreElements() && layer < layerCount) {
                ContainerNode layerNode = (ContainerNode)entries.nextElement();
                this.m_layers[layer] = new CubeLayer(layerNode, layerMap, metadataMap);
                ++layer;
            }
            ContainerNode edgeCells = edgeNode.getContainer(EDGECELLS);
            if (edgeCells != null) {
                this.readEdgeCells(edgeCells, 0, 0, d);
            }
        }
        if ((memberQDRs = edgeNode.getContainer(MEMBERQDRS)) != null) {
            this.readMemberQDRs(memberQDRs, layerCount, this.m_nExtent);
        }
        if ((sliceQDRs = edgeNode.getContainer(SLICEQDRS)) != null) {
            this.readSliceQDRs(sliceQDRs, this.m_nExtent);
        }
    }

    protected void _buildQDRStorage(DataAccess da, int edge, int layerCount, int extent) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge != 1) {
            return;
        }
        this.m_memberQDRs = new QDR[layerCount][extent];
        this.m_sliceQDRs = new QDR[extent];
        Object tempQDR = null;
        int i = 0;
        while (i < extent) {
            int l = 0;
            while (l < layerCount) {
                this.m_memberQDRs[l][i] = da.getMemberQDR(edge, l, i, 0);
                ++l;
            }
            this.m_sliceQDRs[i] = da.getSliceQDR(edge, i, 0);
            ++i;
        }
    }

    protected void _buildOutlineMode(DataAccess da, int edge, Map metadataMap, Map layerMap, int limit) {
        int layerCount = 1;
        this.m_nExtent = 0;
        try {
            layerCount = da.getLayerCount(edge);
            this.m_nExtent = da.getEdgeExtent(edge);
        }
        catch (EdgeOutOfRangeException e) {
            // empty catch block
        }
        boolean limited = false;
        if (limit != -1 && this.m_nExtent > limit) {
            limited = true;
            this.m_nExtent = limit;
            this.m_nLimit = limit;
        }
        this.m_cells = new Cell[1][this.m_nExtent];
        this.m_layers = new CubeLayer[layerCount];
        int layer = 0;
        while (layer < layerCount) {
            this.m_layers[layer] = new CubeLayer(da, edge, layer, layerMap);
            ++layer;
        }
        try {
            int j = 0;
            while (j < this.m_nExtent) {
                block13: {
                    int start_slice;
                    int start_layer;
                    int depth;
                    int span;
                    int layer2;
                    block12: {
                        block11: {
                            layer2 = da.getSliceOutlineLayer(edge, j);
                            span = da.getMemberExtent(edge, layer2, j);
                            depth = da.getMemberDepth(edge, layer2, j);
                            start_layer = da.getMemberStartLayer(edge, 0, j);
                            start_slice = da.getMemberStartSlice(edge, layer2, j);
                            if (span <= 1) break block11;
                            if (start_slice == j) break block12;
                            break block13;
                        }
                        start_slice = j;
                    }
                    if (limited && span + start_slice > this.m_nExtent) {
                        span = this.m_nExtent - start_slice;
                    }
                    Object value = null;
                    value = da.getMemberMetadata(edge, layer2, j, "value");
                    Member member = this.m_layers[layer2].getMember(value);
                    if (member == null) {
                        member = new Member(da, edge, layer2, j, metadataMap);
                        this.m_layers[layer2].putMember(value, member);
                    }
                    this.addOutlineCell(member, start_layer, start_slice, depth, span, layer2);
                }
                ++j;
            }
            this._buildQDRStorage(da, edge, layerCount, this.m_nExtent);
        }
        catch (EdgeOutOfRangeException e) {
        }
        catch (LayerOutOfRangeException e) {
        }
        catch (SliceOutOfRangeException e) {
            // empty catch block
        }
    }

    public Object getMemberMetadata(int layer, int slice, String type) throws SliceOutOfRangeException, LayerOutOfRangeException {
        Cell cell = this.getCell(layer, slice);
        return cell.getMember().getMetadata(type);
    }

    public Object getLayerMetadata(int layer, String type) throws LayerOutOfRangeException {
        if (layer >= this.m_layers.length) {
            throw new LayerOutOfRangeException(layer, this.m_layers.length - 1);
        }
        if (layer < 0) {
            throw new LayerOutOfRangeException(layer, 0);
        }
        return this.m_layers[layer].getMetadata(type);
    }

    public int getLayerCount() {
        return this.m_layers.length;
    }

    public int getExtent() {
        return this.m_nExtent;
    }

    public int getLimit() {
        return this.m_nLimit;
    }

    public Object getSliceLabel(int slice) throws SliceOutOfRangeException {
        StringBuffer label = new StringBuffer(50);
        try {
            int i = 0;
            while (i < this.getLayerCount()) {
                if (i != 0) {
                    label.append(' ');
                }
                label.append(this.getCell(i, slice).getMember().getMetadata("longName"));
                i += this.getCell(i, slice).getDepth();
            }
        }
        catch (LayerOutOfRangeException e) {
            // empty catch block
        }
        return label.toString();
    }

    public int getSliceMemberCount(int slice) throws SliceOutOfRangeException {
        int count = 0;
        try {
            int i = 0;
            while (i < this.getLayerCount()) {
                i += this.getCell(i, slice).getDepth();
                ++count;
            }
        }
        catch (LayerOutOfRangeException e) {
            // empty catch block
        }
        return count;
    }

    public int getSliceOutlineLayer(int slice) throws SliceOutOfRangeException {
        try {
            int n = this.getCell(0, slice).getOutlineLayer();
            return n;
        }
        catch (LayerOutOfRangeException e) {
            throw new SliceOutOfRangeException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public int getMemberDepth(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getCell(layer, slice).getDepth();
    }

    public int getMemberStartLayer(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        int _layer = layer;
        Cell cell = this.getCell(layer, slice);
        if (cell.hasDepth()) {
            _layer = ((BigCell)cell).getStartLayer();
        }
        return _layer;
    }

    public int getMemberExtent(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return this.getCell(layer, slice).getSpan();
    }

    public int getMemberStartSlice(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        int _slice = slice;
        Cell cell = this.getCell(layer, slice);
        if (cell.hasSpan()) {
            _slice = ((BigCell)cell).getStartSlice();
        }
        return _slice;
    }

    public int getMemberSiblingCount(int[] hPos, int memberLayer) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return 0;
    }

    public Object getMemberMetadata(int[] hPos, int memberLayer, int hIndex, String type) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    public int[] getMemberHPos(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    public int[] getFirstHPos() {
        return null;
    }

    public int[] getLastHPos() {
        return null;
    }

    public int[] getPrevHPos(int[] hPos) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    public int[] getNextHPos(int[] hPos) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    public int getCurrentSlice() {
        return 0;
    }

    public int[] getCurrentHPos() {
        return null;
    }

    public QDR getSliceQDR(int slice) {
        if (this.m_sliceQDRs != null) {
            return this.m_sliceQDRs[slice];
        }
        return null;
    }

    public QDR getMemberQDR(int layer, int slice) {
        if (this.m_memberQDRs != null) {
            return this.m_memberQDRs[layer][slice];
        }
        return null;
    }

    public Enumeration getMemberEnumeration(int layer) {
        return new _MemberEnumeration(layer);
    }

    public ObjectNode addEdgeToXML(String name, Data d, Map metadataMap, Map layerMap) {
        ObjectNode edgeNode = new ObjectNode(name);
        int layerCount = this.getLayerCount();
        int nExtent = this.getExtent();
        int nLimit = this.getLimit();
        edgeNode.addProperty("layerCount", layerCount);
        edgeNode.addProperty("extent", nExtent);
        edgeNode.addProperty("limit", nLimit);
        ContainerNode layersNode = new ContainerNode("Layers");
        int layer = 0;
        while (layer < layerCount) {
            ContainerNode layerNode = this.m_layers[layer].addLayerToXML(metadataMap, layerMap);
            layersNode.addContainedObject((BaseNode)layerNode);
            ++layer;
        }
        edgeNode.addContainer(layersNode);
        ContainerNode cells = new ContainerNode(EDGECELLS);
        try {
            this.addCellsToXML(cells, 0, layerCount, 0, nExtent - 1, d);
        }
        catch (LayerOutOfRangeException e) {
        }
        catch (SliceOutOfRangeException e) {
            // empty catch block
        }
        edgeNode.addContainer(cells);
        try {
            if (this.m_memberQDRs != null) {
                ContainerNode qdrs = new ContainerNode(MEMBERQDRS);
                this.addMemberQDRsToXML(qdrs, layerCount, 0, nExtent - 1);
                edgeNode.addContainer(qdrs);
            }
            if (this.m_sliceQDRs != null) {
                ContainerNode qdrs = new ContainerNode(SLICEQDRS);
                this.addSliceQDRsToXML(qdrs, 0, nExtent - 1);
                edgeNode.addContainer(qdrs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return edgeNode;
    }

    private void readMemberQDRs(ContainerNode node, int layerCount, int extent) {
        this.m_memberQDRs = new QDR[layerCount][extent];
        Enumeration memberQDRs = node.getContainerNodes("QDR");
        int slice = 0;
        int layer = 0;
        while (memberQDRs.hasMoreElements()) {
            ContainerNode qdrNode = (ContainerNode)memberQDRs.nextElement();
            if (qdrNode != null) {
                QDR qdr = new QDR();
                qdr.setXML(null, (Object)qdrNode);
                this.m_memberQDRs[layer][slice] = qdr;
            }
            if (++layer < layerCount) continue;
            layer = 0;
            ++slice;
        }
    }

    private void readSliceQDRs(ContainerNode node, int extent) {
        this.m_sliceQDRs = new QDR[extent];
        Enumeration sliceQDRs = node.getContainerNodes("QDR");
        int slice = 0;
        while (sliceQDRs.hasMoreElements()) {
            ContainerNode qdrNode = (ContainerNode)sliceQDRs.nextElement();
            if (qdrNode != null) {
                QDR qdr = new QDR();
                qdr.setXML(null, (Object)qdrNode);
                this.m_sliceQDRs[slice] = qdr;
            }
            ++slice;
        }
    }

    private int readEdgeCells(ContainerNode node, int layer_index, int start_cell, Data d) {
        int extent = 0;
        int layerCount = this.getLayerCount();
        if (this.m_layers[layer_index] != null) {
            Enumeration edgecells = node.getContainerNodes(EDGECELL);
            while (edgecells.hasMoreElements()) {
                Enumeration datanodes;
                ContainerNode edgeCellNode = (ContainerNode)edgecells.nextElement();
                int depth = 1;
                PropertyNode nd = edgeCellNode.getProperty(DEPTH);
                if (nd != null) {
                    depth = nd.getValueAsInteger();
                }
                int outlineLayer = 0;
                PropertyNode nol = edgeCellNode.getProperty(OUTLINELAYER);
                if (nol != null) {
                    outlineLayer = nol.getValueAsInteger();
                }
                int span = 1;
                int currCell = start_cell + extent;
                if (layer_index + depth < layerCount) {
                    span = this.readEdgeCells(edgeCellNode, layer_index + depth, start_cell + extent, d);
                } else if (d != null && (datanodes = edgeCellNode.getContainerNodes("Data")).hasMoreElements()) {
                    ContainerNode dataNode = (ContainerNode)datanodes.nextElement();
                    d.readDataFromXML(dataNode, currCell);
                }
                Member member = null;
                PropertyNode val = edgeCellNode.getProperty(VAL);
                if (val != null) {
                    member = this.m_layers[this.m_isOutline ? outlineLayer : layer_index].getMember(val.getValueAsString());
                }
                try {
                    if (member != null) {
                        if (this.m_isOutline) {
                            this.addOutlineCell(member, layer_index, currCell, depth, span, outlineLayer);
                        } else {
                            this.addCell(member, layer_index, currCell, depth, span);
                        }
                    }
                }
                catch (LayerOutOfRangeException e) {
                }
                catch (SliceOutOfRangeException e) {
                    // empty catch block
                }
                extent += span;
            }
        }
        if (extent < 1) {
            extent = 1;
        }
        return extent;
    }

    private void addMemberQDRsToXML(ContainerNode node, int numLayers, int startSlice, int endSlice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (this.m_memberQDRs == null) {
            return;
        }
        int i = startSlice;
        while (i <= endSlice) {
            int l = 0;
            while (l < numLayers) {
                node.addContainedObject((BaseNode)((ContainerNode)this.m_memberQDRs[l][i].getXML(null)));
                ++l;
            }
            ++i;
        }
    }

    private void addSliceQDRsToXML(ContainerNode node, int startSlice, int endSlice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (this.m_sliceQDRs == null) {
            return;
        }
        int i = startSlice;
        while (i <= endSlice) {
            node.addContainedObject((BaseNode)((ContainerNode)this.m_sliceQDRs[i].getXML(null)));
            ++i;
        }
    }

    private void addCellsToXML(ContainerNode node, int currLayer, int numLayers, int startSlice, int endSlice, Data d) throws LayerOutOfRangeException, SliceOutOfRangeException {
        int i = startSlice;
        while (i <= endSlice) {
            int extent = this.getMemberExtent(currLayer, i);
            int depth = this.getMemberDepth(currLayer, i);
            int outlineLayer = this.getSliceOutlineLayer(i);
            int next_layer = currLayer + depth;
            ContainerNode cell = new ContainerNode(EDGECELL);
            Object member = this.getMemberMetadata(currLayer, i, "value");
            cell.addProperty(VAL, member == null ? null : member.toString());
            if (depth > 1) {
                cell.addProperty(DEPTH, depth);
            }
            if (outlineLayer > 0) {
                cell.addProperty(OUTLINELAYER, outlineLayer);
            }
            if (next_layer < numLayers) {
                this.addCellsToXML(cell, next_layer, numLayers, i, i + extent - 1, d);
            } else if (d != null) {
                ContainerNode dataNode = new ContainerNode("Data");
                d.addDataToXML(dataNode, i);
                cell.addContainedObject((BaseNode)dataNode);
            }
            node.addContainedObject((BaseNode)cell);
            i += extent;
        }
    }

    private void addOutlineCell(Member member, int startLayer, int startSlice, int depth, int span, int outlineLayer) throws LayerOutOfRangeException, SliceOutOfRangeException {
        if (startLayer + depth > this.m_layers.length) {
            throw new LayerOutOfRangeException(startLayer + depth - 1, this.m_layers.length - 1);
        }
        if (startSlice + span > this.m_nExtent) {
            throw new SliceOutOfRangeException(startSlice + span - 1, this.m_nExtent - 1);
        }
        if (startLayer < 0) {
            throw new LayerOutOfRangeException(startLayer, 0);
        }
        if (startSlice < 0) {
            throw new SliceOutOfRangeException(startSlice, 0);
        }
        if (this.m_cells[startLayer][startSlice] != null) {
            return;
        }
        if (depth == 1 && span == 1) {
            this.m_cells[startLayer][startSlice] = new Cell(member);
        } else {
            BigCell cell = new BigCell(member, startLayer, startSlice, depth, span, outlineLayer);
            int j = 0;
            while (j < span) {
                this.m_cells[startLayer][startSlice + j] = cell;
                ++j;
            }
        }
    }

    private void addCell(Member member, int startLayer, int startSlice, int depth, int span) throws LayerOutOfRangeException, SliceOutOfRangeException {
        if (startLayer + depth > this.m_layers.length) {
            throw new LayerOutOfRangeException(startLayer + depth - 1, this.m_layers.length - 1);
        }
        if (startSlice + span > this.m_nExtent) {
            throw new SliceOutOfRangeException(startSlice + span - 1, this.m_nExtent - 1);
        }
        if (startLayer < 0) {
            throw new LayerOutOfRangeException(startLayer, 0);
        }
        if (startSlice < 0) {
            throw new SliceOutOfRangeException(startSlice, 0);
        }
        if (this.m_cells[startLayer][startSlice] != null) {
            return;
        }
        if (depth == 1 && span == 1) {
            this.m_cells[startLayer][startSlice] = new Cell(member);
        } else {
            BigCell cell = new BigCell(member, startLayer, startSlice, depth, span);
            int i = 0;
            while (i < depth) {
                int j = 0;
                while (j < span) {
                    this.m_cells[startLayer + i][startSlice + j] = cell;
                    ++j;
                }
                ++i;
            }
        }
    }

    private Cell getCell(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        if (layer >= this.m_layers.length) {
            throw new LayerOutOfRangeException(layer, this.m_layers.length - 1);
        }
        if (slice >= this.m_nExtent) {
            throw new SliceOutOfRangeException(slice, this.m_nExtent - 1);
        }
        if (layer < 0) {
            throw new LayerOutOfRangeException(layer, 0);
        }
        if (slice < 0) {
            throw new SliceOutOfRangeException(slice, 0);
        }
        if (this.m_isOutline) {
            return this.m_cells[0][slice];
        }
        return this.m_cells[layer][slice];
    }

    private void $init$() {
        this.m_nLimit = -1;
    }

    static CubeLayer[] ra$m_layers(RowColumnEdge rowColumnEdge) {
        return rowColumnEdge.m_layers;
    }

    private static class Cell {
        private Member m_member;

        protected Cell(Member member) {
            this.m_member = member;
        }

        protected Member getMember() {
            return this.m_member;
        }

        protected boolean hasSpan() {
            return false;
        }

        protected boolean hasDepth() {
            return false;
        }

        protected int getSpan() {
            return 1;
        }

        protected int getDepth() {
            return 1;
        }

        protected int getOutlineLayer() {
            return 0;
        }
    }

    private static class BigCell
    extends Cell {
        private int startLayer;
        private int startSlice;
        private int span;
        private int depth;
        private int m_outlineLayer;

        protected BigCell(Member member, int _startLayer, int _startSlice, int _depth, int _span) {
            super(member);
            this.span = _span;
            this.depth = _depth;
            this.startLayer = _startLayer;
            this.startSlice = _startSlice;
        }

        protected BigCell(Member member, int _startLayer, int _startSlice, int _depth, int _span, int outlineLayer) {
            this(member, _startLayer, _startSlice, _depth, _span);
            this.m_outlineLayer = outlineLayer;
        }

        protected int getOutlineLayer() {
            return this.m_outlineLayer;
        }

        protected int getSpan() {
            return this.span;
        }

        protected int getDepth() {
            return this.depth;
        }

        protected int getStartSlice() {
            return this.startSlice;
        }

        protected int getStartLayer() {
            return this.startLayer;
        }

        protected boolean hasSpan() {
            return this.span > 1;
        }

        protected boolean hasDepth() {
            return this.depth > 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _MemberEnumeration
    implements Enumeration {
        private Enumeration keys;
        private Dictionary members;

        _MemberEnumeration(int layer) {
            this.members = RowColumnEdge.ra$m_layers(RowColumnEdge.this)[layer].getMembers();
            this.keys = this.members.keys();
        }

        @Override
        public boolean hasMoreElements() {
            return this.keys.hasMoreElements();
        }

        public Object nextElement() throws NoSuchElementException {
            return this.members.get(this.keys.nextElement());
        }
    }
}

