/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.gui.InsertButton;
import oracle.dss.util.help.HelpContext;

public class DatePanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
HelpContext,
ListSelectionListener {
    private ResourceBundle rBundle;
    protected Locale m_locale;
    protected ViewFormat m_viewFormat;
    protected ViewFormat m_tempViewFormat;
    protected JList m_CategoriesList;
    protected JList m_TimeList;
    protected JList m_DateList;
    protected JList m_DateTimeList;
    private JList m_customTypeList;
    protected JPanel m_TimeListPanel;
    protected JPanel m_DateListPanel;
    protected JPanel m_DateTimeListPanel;
    private JPanel m_customPanel;
    protected int m_iCategoryListOffset;
    protected int m_iTimeListOffset;
    protected int m_iDateListOffset;
    protected int m_iDateTimeListOffset;
    protected JLabel m_typeLabelDate;
    protected JLabel m_typeLabelTime;
    protected JLabel m_typeLabelDateTime;
    protected JPanel m_rightPanel;
    protected String m_oldDateFormatString;
    protected String m_newDateFormatString;
    private JTextField m_customTypeTextField;
    private Vector m_customTypeVector;
    private JButton m_customDeleteButton;
    private JLabel m_customEditTypeLabel;
    private InsertButton m_customInsert;
    private JButton m_customAddButton;
    protected JLabel m_typeLabelCustom;
    protected JPanel m_customLabelPanel;
    protected int m_iCustomListOffset;
    protected JScrollPane m_categoryScrollPane;
    protected JScrollPane m_dateScrollPane;
    protected JScrollPane m_dateTimeScrollPane;
    protected JScrollPane m_timeScrollPane;
    protected String m_translatedText;
    protected String m_defaultDateFormat;
    protected String m_applicationName;
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh;
    protected int m_maxButtonWidth;
    protected int m_maxCategoryWidth;
    protected boolean m_clearSelection;
    private boolean m_bSuperCalled;
    public static final String PROPERTY_DATEPANEL_DATEFORMATCHANGED = "DateFormatChanged";
    public static final int CATEGORIES_OFFSET_NONE = 0;
    public static final int CATEGORIES_OFFSET_DEFAULT = 1;
    public static final int CATEGORIES_OFFSET_DATE = 2;
    public static final int CATEGORIES_OFFSET_TIME = 3;
    public static final int CATEGORIES_OFFSET_DATETIME = 4;
    public static final int CATEGORIES_OFFSET_CUSTOM = 5;
    public static final int CATEGORIES_OFFSET_NOTSPECIFIED = 7;
    private static final int DATE_OFFSET_0 = 0;
    private static final int DATE_OFFSET_1 = 1;
    private static final int DATE_OFFSET_2 = 2;
    private static final int DATE_OFFSET_3 = 3;
    private static final int DATE_OFFSET_4 = 4;
    private static final int DATE_OFFSET_5 = 5;
    private static final int DATE_OFFSET_6 = 6;
    private static final int DATE_OFFSET_7 = 7;
    private static final int DATE_OFFSET_8 = 8;
    private static final int DATE_OFFSET_9 = 9;
    private static final int DATE_OFFSET_10 = 10;
    private static final int DATE_OFFSET_11 = 11;
    private static final int DATE_OFFSET_12 = 12;
    private static final int DATE_OFFSET_13 = 13;
    private static final int DATE_OFFSET_14 = 14;
    private static final int DATE_OFFSET_15 = 15;
    private static final int DATE_OFFSET_16 = 16;
    private static final int DATE_OFFSET_17 = 17;
    private static final int DATE_OFFSET_18 = 18;
    private static final int DATE_OFFSET_19 = 19;
    private static final int DATE_OFFSET_20 = 20;
    private static final int DATE_OFFSET_21 = 21;
    private static final int TIME_OFFSET_0 = 0;
    private static final int TIME_OFFSET_1 = 1;
    private static final int TIME_OFFSET_2 = 2;
    private static final int DATETIME_OFFSET_0 = 0;
    private static final int DATETIME_OFFSET_1 = 1;
    private static final int DATETIME_OFFSET_2 = 2;
    private static final int DATETIME_OFFSET_3 = 3;
    private static final int DATETIME_OFFSET_4 = 4;
    private static final int DATETIME_OFFSET_5 = 5;
    private static final int DATETIME_OFFSET_6 = 6;
    private boolean m_dateFormatChanged;
    private int m_viewType;
    private boolean m_sentPropertyChangeEvent;

    public DatePanel(ViewFormat viewFormat) {
        this.$init$();
        this.m_bSuperCalled = true;
        this.m_viewFormat = viewFormat;
        this.constructPanel();
        this._init();
    }

    public DatePanel(ViewFormat viewFormat, Vector customListVector) {
        this.$init$();
        this.m_bSuperCalled = true;
        if (this.m_customTypeVector != null) {
            this.m_customTypeVector.removeAllElements();
            this.m_customTypeVector = customListVector;
        }
        this.m_viewFormat = viewFormat;
        this.constructPanel();
        this.m_sentPropertyChangeEvent = false;
        this._init();
        this.m_sentPropertyChangeEvent = true;
    }

    public DatePanel(ViewFormat viewFormat, Vector customListVector, String strDefaultDateFormat) {
        this.$init$();
        this.m_bSuperCalled = true;
        this.m_defaultDateFormat = strDefaultDateFormat;
        if (this.m_customTypeVector != null) {
            this.m_customTypeVector.removeAllElements();
            this.m_customTypeVector = customListVector;
        }
        this.m_viewFormat = viewFormat;
        this.constructPanel();
        this.m_sentPropertyChangeEvent = false;
        this._init();
        this.m_sentPropertyChangeEvent = true;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
        if (this.m_viewFormat != null) {
            this.m_viewFormat.setErrorHandler(this.m_eh);
        }
        this.m_tempViewFormat.setErrorHandler(this.m_eh);
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void valueChanged(ListSelectionEvent e) {
        this.m_dateFormatChanged = true;
        if (e.getSource() == this.m_customTypeList && this.m_customTypeList.getSelectedIndex() > -1 && this.m_sentPropertyChangeEvent) {
            this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, null, this.m_customTypeList.getSelectedValue());
            this.m_newDateFormatString = (String)this.m_customTypeList.getSelectedValue();
        }
        if (e.getSource() == this.m_CategoriesList) {
            this.processCategory(this.m_CategoriesList.getSelectionModel().getLeadSelectionIndex());
        } else if (e.getSource() == this.m_DateList) {
            this.processDateList(this.m_DateList.getSelectionModel().getLeadSelectionIndex());
        } else if (e.getSource() == this.m_DateTimeList) {
            this.processDateTimeList(this.m_DateTimeList.getSelectionModel().getLeadSelectionIndex());
        } else if (e.getSource() == this.m_TimeList) {
            this.processTimeList(this.m_TimeList.getSelectionModel().getLeadSelectionIndex());
        } else if (e.getSource() == this.m_customTypeList) {
            this.processCustomList(this.m_customTypeList.getSelectionModel().getLeadSelectionIndex());
        }
    }

    private void constructPanel() {
        String strDateTime;
        boolean bForceGregCal;
        if (this.m_locale == null) {
            this.m_locale = Locale.getDefault();
            super.setLocale(this.m_locale);
            this.updateResourceBundle(this.m_locale);
        } else {
            this.updateResourceBundle(this.m_locale);
        }
        this.removeAll();
        this.m_tempViewFormat = new ViewFormat();
        this.m_applicationName = this.rBundle.getString("DateFormatting");
        String translatedText = this.rBundle.getString("Delete");
        this.m_customDeleteButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_customDeleteButton.setName("DateCustomDelete");
        this.m_customDeleteButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        int iTempWidth = this.getToolkit().getFontMetrics(this.m_customDeleteButton.getFont()).stringWidth(this.m_customDeleteButton.getText());
        if ((iTempWidth += 22) > this.m_maxButtonWidth) {
            this.m_maxButtonWidth = iTempWidth;
        }
        translatedText = this.rBundle.getString("Add");
        this.m_customAddButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_customAddButton.setName("DateCustomAdd");
        this.m_customAddButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        iTempWidth = this.getToolkit().getFontMetrics(this.m_customAddButton.getFont()).stringWidth(this.m_customAddButton.getText());
        if ((iTempWidth += 22) > this.m_maxButtonWidth) {
            this.m_maxButtonWidth = iTempWidth;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2000, 2, 21, 15, 15);
        Date date = cal.getTime();
        this.setLayout(new BoxLayout(this, 1));
        int iWidth = Integer.parseInt(this.rBundle.getString("DatePanelWidth"));
        int iHeight = Integer.parseInt(this.rBundle.getString("DatePanelHeight"));
        this.setLayout(new BoxLayout(this, 0));
        this.setPreferredSize(new Dimension(iWidth, iHeight));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        int iPanelWidth = this.getPreferredSize().width;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.m_rightPanel = new JPanel();
        this.m_rightPanel.setLayout(new BoxLayout(this.m_rightPanel, 1));
        this.m_rightPanel.add(new JLabel(" "));
        String strWordWrap = this.rBundle.getString("None Description");
        WordWrapper wordWrapper = (WordWrapper)WordWrapper.getTextWrapper();
        MultiLineLabel lblDescription = new MultiLineLabel((TextWrapper)wordWrapper, strWordWrap);
        this.m_rightPanel.add((Component)lblDescription);
        this.getMaxCategoryWidth();
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.setPreferredSize(new Dimension(this.m_maxCategoryWidth + 22, this.getToolkit().getScreenSize().height - 20));
        this.m_rightPanel.setPreferredSize(new Dimension(iPanelWidth - leftPanel.getPreferredSize().width - 10 - 20, this.getPreferredSize().height - 20));
        this.m_translatedText = this.rBundle.getString("Categories");
        JLabel categoriesLabel = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        categoriesLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        String[] data = new String[]{this.rBundle.getString("NotSpecified"), this.rBundle.getString("None"), this.rBundle.getString("Default"), this.rBundle.getString("Date"), this.rBundle.getString("Time"), this.rBundle.getString("DateTime"), this.rBundle.getString("Custom")};
        this.m_CategoriesList = new JList<String>(data);
        this.m_CategoriesList.setName("DateCategories");
        this.m_CategoriesList.setSelectionMode(0);
        this.m_categoryScrollPane = new JScrollPane(this.m_CategoriesList);
        this.m_categoryScrollPane.setPreferredSize(leftPanel.getPreferredSize());
        this.m_categoryScrollPane.setVerticalScrollBarPolicy(20);
        categoriesLabel.setLabelFor(this.m_CategoriesList);
        GregorianCalendar gcal = null;
        boolean bl = bForceGregCal = this.m_locale.getLanguage().compareTo("th") == 0 && this.m_locale.getCountry().compareTo("TH") == 0;
        if (bForceGregCal) {
            gcal = new GregorianCalendar(this.m_locale);
        }
        this.m_translatedText = this.rBundle.getString("Type");
        this.m_typeLabelDate = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_typeLabelDate.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_DateListPanel = new JPanel();
        this.m_DateListPanel.setLayout(new BoxLayout(this.m_DateListPanel, 1));
        String[] dataDate = new String[22];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M/d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[0] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("M/d/yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[1] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("M/d/yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[2] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[3] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("M-d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[4] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("M-d-yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[5] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("M-d-yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[6] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[7] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMM-dd", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[8] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMM-dd-yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[9] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMM-dd-yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[10] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMMM d, yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[11] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d/M/yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[12] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d-M-yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[13] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d-MMM-yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[14] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d-MMM-yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[15] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d MMM yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[16] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d MMMM yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[17] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yyyy/M/d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[18] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yy/M/d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[19] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yyyy-M-d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[20] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yy-M-d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[21] = strDateTime = simpleDateFormat.format(date);
        this.m_DateList = new JList<String>(dataDate);
        this.m_DateList.setName("DateType");
        this.m_DateList.setSelectionMode(0);
        this.m_dateScrollPane = new JScrollPane(this.m_DateList);
        this.m_dateScrollPane.setPreferredSize(new Dimension(this.m_rightPanel.getPreferredSize().width, 226));
        this.m_dateScrollPane.setVerticalScrollBarPolicy(20);
        this.m_typeLabelDate.setLabelFor(this.m_DateList);
        this.m_DateListPanel.add(this.m_typeLabelDate);
        this.m_DateListPanel.add(this.m_dateScrollPane);
        this.m_dateScrollPane.setAlignmentX(0.0f);
        this.m_typeLabelDate.setAlignmentX(0.0f);
        this.m_DateList.addListSelectionListener(this);
        this.m_translatedText = this.rBundle.getString("Type");
        this.m_typeLabelDateTime = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_typeLabelDateTime.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_DateTimeListPanel = new JPanel();
        this.m_DateTimeListPanel.setLayout(new BoxLayout(this.m_DateTimeListPanel, 1));
        String[] dataDateTime = new String[7];
        simpleDateFormat = new SimpleDateFormat("M/d/yyyy h:mm a", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[0] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMM-d-yyyy h:mm a", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[1] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMMM d, yyyy h:mm a", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[2] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d-MMM-yyyy h:mm a", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[3] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d-MMM-yyyy H:mm", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[4] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yyyy/M/d H:mm", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[5] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yyyy-M-d H:mm", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[6] = strDateTime = simpleDateFormat.format(date);
        this.m_DateTimeList = new JList<String>(dataDateTime);
        this.m_DateTimeList.setName("DateAndTimeType");
        this.m_DateTimeList.setSelectionMode(0);
        this.m_dateTimeScrollPane = new JScrollPane(this.m_DateTimeList);
        this.m_dateTimeScrollPane.setPreferredSize(new Dimension(this.m_rightPanel.getPreferredSize().width, 226));
        this.m_dateTimeScrollPane.setVerticalScrollBarPolicy(20);
        this.m_typeLabelDateTime.setLabelFor(this.m_DateTimeList);
        this.m_DateTimeListPanel.add(this.m_typeLabelDateTime);
        this.m_DateTimeListPanel.add(this.m_dateTimeScrollPane);
        this.m_dateTimeScrollPane.setAlignmentX(0.0f);
        this.m_typeLabelDateTime.setAlignmentX(0.0f);
        this.m_DateTimeList.addListSelectionListener(this);
        this.m_translatedText = this.rBundle.getString("Type");
        this.m_typeLabelTime = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_typeLabelTime.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_TimeListPanel = new JPanel();
        this.m_TimeListPanel.setLayout(new BoxLayout(this.m_TimeListPanel, 1));
        String[] dataTime = new String[3];
        simpleDateFormat = new SimpleDateFormat("h:mm", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataTime[0] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("h:mm a", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataTime[1] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("H:mm", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataTime[2] = strDateTime = simpleDateFormat.format(date);
        this.m_TimeList = new JList<String>(dataTime);
        this.m_TimeList.setName("TimeType");
        this.m_TimeList.setSelectionMode(0);
        this.m_timeScrollPane = new JScrollPane(this.m_TimeList);
        this.m_timeScrollPane.setPreferredSize(new Dimension(this.m_rightPanel.getPreferredSize().width, 226));
        this.m_timeScrollPane.setVerticalScrollBarPolicy(20);
        this.m_typeLabelTime.setLabelFor(this.m_TimeList);
        this.m_TimeListPanel.add(this.m_typeLabelTime);
        this.m_TimeListPanel.add(this.m_timeScrollPane);
        this.m_timeScrollPane.setAlignmentX(0.0f);
        this.m_typeLabelTime.setAlignmentX(0.0f);
        this.m_TimeList.addListSelectionListener(this);
        int iCustomPanelWidth = this.getToolkit().getScreenSize().width - leftPanel.getPreferredSize().width - 10 - 20;
        int iCustomPanelHeight = this.getToolkit().getScreenSize().height - 20;
        this.m_customLabelPanel = new JPanel();
        this.m_customLabelPanel.setLayout(new BorderLayout());
        this.m_translatedText = this.rBundle.getString("Type");
        this.m_typeLabelCustom = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_typeLabelCustom.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_customLabelPanel.add((Component)this.m_typeLabelCustom, "West");
        this.m_customPanel = new JPanel();
        this.m_customPanel.setLayout(new BoxLayout(this.m_customPanel, 1));
        this.m_customPanel.setPreferredSize(new Dimension(iCustomPanelWidth, iCustomPanelHeight));
        JPanel customListPanel = new JPanel();
        customListPanel.setLayout(new BoxLayout(customListPanel, 0));
        this.m_customTypeList = new JList(this.m_customTypeVector);
        this.m_customTypeList.setName("DateCustomType");
        this.m_customTypeList.setSelectionMode(0);
        this.m_typeLabelCustom.setLabelFor(this.m_customTypeList);
        this.m_customTypeList.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.m_customTypeList);
        scrollPane.setPreferredSize(new Dimension(iCustomPanelWidth, iCustomPanelHeight - 7 - 24 - 16 - 24 - 7 - 22));
        scrollPane.setVerticalScrollBarPolicy(20);
        customListPanel.add(scrollPane);
        JPanel customDeletePanel = new JPanel();
        customDeletePanel.setLayout(new BoxLayout(customDeletePanel, 0));
        customDeletePanel.setPreferredSize(new Dimension(this.getPreferredSize().width - leftPanel.getPreferredSize().width - 20 - 10, 24));
        this.m_customDeleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_customDeleteButton.setPreferredSize(new Dimension(this.m_maxButtonWidth, this.m_customDeleteButton.getPreferredSize().height));
        this.m_customDeleteButton.setMinimumSize(this.m_customDeleteButton.getPreferredSize());
        this.m_customDeleteButton.setMaximumSize(this.m_customDeleteButton.getPreferredSize());
        this.m_customDeleteButton.addActionListener(this);
        JPanel delBtnPanel = new JPanel(new FlowLayout(2, 0, 0));
        delBtnPanel.add(this.m_customDeleteButton);
        customDeletePanel.add(delBtnPanel);
        JPanel customInsertPanel = new JPanel();
        customInsertPanel.setLayout(new BoxLayout(customInsertPanel, 0));
        customInsertPanel.setPreferredSize(new Dimension(this.getPreferredSize().width - leftPanel.getPreferredSize().width - 20 - 10, 24));
        translatedText = this.rBundle.getString("Edit Type");
        this.m_customEditTypeLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_customEditTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        JPanel insLblPanel = new JPanel(new FlowLayout(0, 0, 0));
        insLblPanel.add(this.m_customEditTypeLabel);
        customInsertPanel.add(insLblPanel);
        translatedText = this.rBundle.getString("Insert");
        Object[] tmpInsert = new Object[]{this.rBundle.getString("a.d."), this.rBundle.getString("a.m."), this.rBundle.getString("ad"), this.rBundle.getString("am"), this.rBundle.getString("b.c."), this.rBundle.getString("bc"), this.rBundle.getString("cc"), this.rBundle.getString("d"), this.rBundle.getString("day"), this.rBundle.getString("dd"), this.rBundle.getString("ddd"), this.rBundle.getString("dy"), this.rBundle.getString("E"), this.rBundle.getString("EE"), this.rBundle.getString("FM"), this.rBundle.getString("hh"), this.rBundle.getString("hh12"), this.rBundle.getString("hh24"), this.rBundle.getString("I"), this.rBundle.getString("iw"), this.rBundle.getString("iy"), this.rBundle.getString("IYY"), this.rBundle.getString("iyyy"), this.rBundle.getString("j"), this.rBundle.getString("mi"), this.rBundle.getString("mm"), this.rBundle.getString("mon"), this.rBundle.getString("month"), this.rBundle.getString("p.m."), this.rBundle.getString("pm"), this.rBundle.getString("q"), this.rBundle.getString("RM"), this.rBundle.getString("RR"), this.rBundle.getString("RRRR"), this.rBundle.getString("scc"), this.rBundle.getString("ss"), this.rBundle.getString("sssss"), this.rBundle.getString("sy, yyy"), this.rBundle.getString("syear"), this.rBundle.getString("syYYY"), this.rBundle.getString("W"), this.rBundle.getString("WW"), this.rBundle.getString("Y"), this.rBundle.getString("Y, YYY"), this.rBundle.getString("YEAR"), this.rBundle.getString("YY"), this.rBundle.getString("YYY"), this.rBundle.getString("YYYY")};
        this.m_customInsert = new InsertButton(tmpInsert);
        this.m_customInsert.setName("DateCustomInsert");
        if (this.m_viewFormat != null && this.m_viewFormat.getLocale() != null) {
            this.m_customInsert.setLocale(this.m_viewFormat.getLocale());
        } else {
            this.m_customInsert.setLocale(Locale.getDefault());
        }
        this.m_customInsert.setMaximumRowCount(4);
        this.m_customInsert.setMinimumSize(this.m_customInsert.getPreferredSize());
        this.m_customInsert.setMaximumSize(this.m_customInsert.getPreferredSize());
        this.m_customInsert.addActionListener((ActionListener)this);
        this.m_customAddButton.setPreferredSize(new Dimension(this.m_maxButtonWidth, this.m_customAddButton.getPreferredSize().height));
        this.m_customAddButton.setMinimumSize(this.m_customAddButton.getPreferredSize());
        this.m_customAddButton.setMaximumSize(this.m_customAddButton.getPreferredSize());
        this.m_customAddButton.addActionListener(this);
        JPanel insBtnPanel = new JPanel(new FlowLayout(2, 0, 0));
        insBtnPanel.add((Component)this.m_customInsert);
        insBtnPanel.add(Box.createHorizontalStrut(10));
        insBtnPanel.add(this.m_customAddButton);
        customInsertPanel.add(insLblPanel);
        customInsertPanel.add(insBtnPanel);
        JPanel textFieldPanel = new JPanel();
        textFieldPanel.setLayout(new BoxLayout(textFieldPanel, 0));
        textFieldPanel.setPreferredSize(new Dimension(iCustomPanelWidth, 22));
        textFieldPanel.setMinimumSize(textFieldPanel.getPreferredSize());
        textFieldPanel.setMaximumSize(textFieldPanel.getPreferredSize());
        this.m_customTypeTextField = new JTextField();
        this.m_customTypeTextField.setName("DateCustomEditType");
        this.m_customEditTypeLabel.setLabelFor(this.m_customTypeTextField);
        textFieldPanel.add(this.m_customTypeTextField);
        this.m_customPanel.add(this.m_customLabelPanel);
        this.m_customPanel.add(customListPanel);
        this.m_customPanel.add(Box.createVerticalStrut(7));
        this.m_customPanel.add(customDeletePanel);
        this.m_customPanel.add(Box.createVerticalStrut(16));
        this.m_customPanel.add(customInsertPanel);
        this.m_customPanel.add(Box.createVerticalStrut(7));
        this.m_customPanel.add(textFieldPanel);
        leftPanel.add(categoriesLabel);
        leftPanel.add(this.m_categoryScrollPane);
        categoriesLabel.setAlignmentX(0.0f);
        this.m_categoryScrollPane.setAlignmentX(0.0f);
        this.m_CategoriesList.addPropertyChangeListener(this);
        this.m_DateList.addPropertyChangeListener(this);
        this.m_TimeList.addPropertyChangeListener(this);
        this.m_DateTimeList.addPropertyChangeListener(this);
        this.add(leftPanel);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.m_rightPanel);
        this.setAlignmentX(0.0f);
        this.add(Box.createVerticalGlue());
        this.m_CategoriesList.addListSelectionListener(this);
    }

    protected void processCategory(int iSelection) {
        if (iSelection != 0 && this.m_viewFormat == null) {
            this.m_viewFormat = new ViewFormat();
        }
        if (iSelection == 0) {
            this.m_iCategoryListOffset = 7;
            this.m_rightPanel.removeAll();
            this.m_rightPanel.add(new JLabel(" "));
            String strWordWrap = this.m_viewType == 0 ? this.rBundle.getString("DateNotSpecifiedDesc") : this.rBundle.getString("DateNotSpecifiedDescTable");
            WordWrapper wordWrapper = (WordWrapper)WordWrapper.getTextWrapper();
            MultiLineLabel lblDescription = new MultiLineLabel((TextWrapper)wordWrapper, strWordWrap);
            this.m_rightPanel.add((Component)lblDescription);
            this.getAccessibleContext().setAccessibleName(strWordWrap);
            this.m_oldDateFormatString = this.m_newDateFormatString;
            this.m_newDateFormatString = this.convertOffsetsToString(7, 0);
            if (this.m_oldDateFormatString != this.m_newDateFormatString) {
                this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
            }
            this.m_iDateListOffset = -1;
            this.m_iTimeListOffset = -1;
            this.m_iDateTimeListOffset = -1;
            this.m_iCustomListOffset = -1;
            this.m_rightPanel.invalidate();
            this.m_rightPanel.validate();
            this.m_rightPanel.repaint();
            this.m_viewFormat = null;
        } else if (iSelection == 1) {
            this.m_iCategoryListOffset = 0;
            this.m_rightPanel.removeAll();
            this.m_rightPanel.add(new JLabel(" "));
            String strWordWrap = this.rBundle.getString("None Description");
            WordWrapper wordWrapper = (WordWrapper)WordWrapper.getTextWrapper();
            MultiLineLabel lblDescription = new MultiLineLabel((TextWrapper)wordWrapper, strWordWrap);
            this.m_rightPanel.add((Component)lblDescription);
            this.getAccessibleContext().setAccessibleName(this.rBundle.getString("None Description"));
            this.m_oldDateFormatString = this.m_newDateFormatString;
            this.m_newDateFormatString = this.convertOffsetsToString(0, 0);
            if (this.m_oldDateFormatString != this.m_newDateFormatString) {
                this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
            }
            this.m_iDateListOffset = -1;
            this.m_iTimeListOffset = -1;
            this.m_iDateTimeListOffset = -1;
            this.m_iCustomListOffset = -1;
            this.m_rightPanel.invalidate();
            this.m_rightPanel.validate();
            this.m_rightPanel.repaint();
        } else if (iSelection == 2) {
            this.m_iCategoryListOffset = 1;
            this.m_rightPanel.removeAll();
            this.m_rightPanel.add(new JLabel(" "));
            String strWordWrap = this.rBundle.getString("Default Description");
            WordWrapper wordWrapper = (WordWrapper)WordWrapper.getTextWrapper();
            MultiLineLabel lblDescription = new MultiLineLabel((TextWrapper)wordWrapper, strWordWrap);
            this.m_rightPanel.add((Component)lblDescription);
            this.getAccessibleContext().setAccessibleName(this.rBundle.getString("Default Description"));
            this.m_oldDateFormatString = this.m_newDateFormatString;
            this.m_newDateFormatString = this.convertOffsetsToString(1, 0);
            if (this.m_oldDateFormatString != this.m_newDateFormatString) {
                this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
            }
            this.m_iDateListOffset = -1;
            this.m_iTimeListOffset = -1;
            this.m_iDateTimeListOffset = -1;
            this.m_iCustomListOffset = -1;
            this.m_rightPanel.invalidate();
            this.m_rightPanel.validate();
            this.m_rightPanel.repaint();
        } else if (iSelection == 3) {
            this.m_iCategoryListOffset = 2;
            this.m_rightPanel.removeAll();
            this.m_rightPanel.add(this.m_typeLabelDate);
            this.m_rightPanel.add(this.m_DateListPanel);
            if (this.m_iDateListOffset == -1 && this.m_DateList.getFirstVisibleIndex() >= 0) {
                this.m_clearSelection = true;
                this.m_DateList.clearSelection();
                this.m_DateList.setSelectedIndex(2);
                this.m_oldDateFormatString = this.m_newDateFormatString;
                this.m_newDateFormatString = this.convertOffsetsToString(2, 2);
                if (this.m_oldDateFormatString != this.m_newDateFormatString) {
                    this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
                }
            }
            this.m_rightPanel.invalidate();
            this.m_rightPanel.validate();
            this.m_rightPanel.repaint();
        } else if (iSelection == 4) {
            this.m_iCategoryListOffset = 3;
            this.m_rightPanel.removeAll();
            this.m_rightPanel.add(this.m_typeLabelTime);
            this.m_rightPanel.add(this.m_TimeListPanel);
            if (this.m_iTimeListOffset == -1 && this.m_TimeList.getFirstVisibleIndex() >= 0) {
                this.m_clearSelection = true;
                this.m_TimeList.clearSelection();
                this.m_TimeList.setSelectedIndex(1);
                this.m_oldDateFormatString = this.m_newDateFormatString;
                this.m_newDateFormatString = this.convertOffsetsToString(3, 1);
                if (this.m_oldDateFormatString != this.m_newDateFormatString) {
                    this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
                }
            }
            this.m_rightPanel.invalidate();
            this.m_rightPanel.validate();
            this.m_rightPanel.repaint();
        } else if (iSelection == 5) {
            this.m_iCategoryListOffset = 4;
            this.m_rightPanel.removeAll();
            this.m_rightPanel.add(this.m_typeLabelDateTime);
            this.m_rightPanel.add(this.m_DateTimeListPanel);
            if (this.m_iDateTimeListOffset == -1 && this.m_DateTimeList.getFirstVisibleIndex() >= 0) {
                this.m_clearSelection = true;
                this.m_DateTimeList.clearSelection();
                this.m_DateTimeList.setSelectedIndex(0);
                this.m_oldDateFormatString = this.m_newDateFormatString;
                this.m_newDateFormatString = this.convertOffsetsToString(4, 0);
                if (this.m_oldDateFormatString != this.m_newDateFormatString) {
                    this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
                }
            }
            this.m_rightPanel.invalidate();
            this.m_rightPanel.validate();
            this.m_rightPanel.repaint();
        } else if (iSelection == 6) {
            this.m_iCategoryListOffset = 5;
            this.m_rightPanel.removeAll();
            this.m_rightPanel.add(this.m_customPanel);
            this.m_rightPanel.invalidate();
            this.m_rightPanel.validate();
            this.m_rightPanel.repaint();
            this.m_oldDateFormatString = this.m_newDateFormatString;
            int index = this.m_customTypeList.getSelectionModel().getLeadSelectionIndex();
            if (index >= 0) {
                this.m_newDateFormatString = this.convertOffsetsToString(5, index);
                if (this.m_oldDateFormatString != this.m_newDateFormatString) {
                    this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
                }
            }
        }
    }

    protected void processTimeList(int iSelection) {
        if (this.m_clearSelection) {
            this.m_clearSelection = false;
            return;
        }
        this.m_iTimeListOffset = iSelection;
        this.m_iDateListOffset = -1;
        this.m_iDateTimeListOffset = -1;
        this.m_iCustomListOffset = -1;
        this.m_oldDateFormatString = this.m_newDateFormatString;
        this.m_newDateFormatString = this.convertOffsetsToString(3, this.m_iTimeListOffset);
        if (this.m_oldDateFormatString != this.m_newDateFormatString) {
            this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
        }
    }

    protected void processDateList(int iSelection) {
        if (this.m_clearSelection) {
            this.m_clearSelection = false;
            return;
        }
        this.m_iDateListOffset = iSelection;
        this.m_iTimeListOffset = -1;
        this.m_iDateTimeListOffset = -1;
        this.m_iCustomListOffset = -1;
        this.m_oldDateFormatString = this.m_newDateFormatString;
        this.m_newDateFormatString = this.convertOffsetsToString(2, this.m_iDateListOffset);
        if (this.m_oldDateFormatString != this.m_newDateFormatString) {
            this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
        }
    }

    protected void processDateTimeList(int iSelection) {
        if (this.m_clearSelection) {
            this.m_clearSelection = false;
            return;
        }
        this.m_iDateTimeListOffset = iSelection;
        this.m_iDateListOffset = -1;
        this.m_iTimeListOffset = -1;
        this.m_iCustomListOffset = -1;
        this.m_oldDateFormatString = this.m_newDateFormatString;
        this.m_newDateFormatString = this.convertOffsetsToString(4, this.m_iDateTimeListOffset);
        if (this.m_oldDateFormatString != this.m_newDateFormatString) {
            this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
        }
    }

    protected void processCustomList(int iSelection) {
        if (this.m_clearSelection) {
            this.m_clearSelection = false;
            return;
        }
        this.m_iCustomListOffset = iSelection;
        this.m_iDateTimeListOffset = -1;
        this.m_iDateListOffset = -1;
        this.m_iTimeListOffset = -1;
        this.m_oldDateFormatString = this.m_newDateFormatString;
        this.m_newDateFormatString = this.getCustomStringFromOffset(this.m_iCustomListOffset);
        if (this.m_oldDateFormatString != this.m_newDateFormatString) {
            this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
        }
    }

    protected void getMaxCategoryWidth() {
        int iTempWidth = 0;
        this.m_translatedText = this.rBundle.getString("NotSpecified");
        JLabel tempLabel = new JLabel(this.m_translatedText);
        iTempWidth = this.getToolkit().getFontMetrics(tempLabel.getFont()).stringWidth(this.m_translatedText);
        if (iTempWidth > this.m_maxCategoryWidth) {
            this.m_maxCategoryWidth = iTempWidth;
        }
        this.m_translatedText = this.rBundle.getString("None");
        tempLabel = new JLabel(this.m_translatedText);
        iTempWidth = this.getToolkit().getFontMetrics(tempLabel.getFont()).stringWidth(this.m_translatedText);
        if (iTempWidth > this.m_maxCategoryWidth) {
            this.m_maxCategoryWidth = iTempWidth;
        }
        this.m_translatedText = this.rBundle.getString("Default");
        tempLabel = new JLabel(this.m_translatedText);
        iTempWidth = this.getToolkit().getFontMetrics(tempLabel.getFont()).stringWidth(this.m_translatedText);
        if (iTempWidth > this.m_maxCategoryWidth) {
            this.m_maxCategoryWidth = iTempWidth;
        }
        this.m_translatedText = this.rBundle.getString("Date");
        tempLabel = new JLabel(this.m_translatedText);
        iTempWidth = this.getToolkit().getFontMetrics(tempLabel.getFont()).stringWidth(this.m_translatedText);
        if (iTempWidth > this.m_maxCategoryWidth) {
            this.m_maxCategoryWidth = iTempWidth;
        }
        this.m_translatedText = this.rBundle.getString("Time");
        tempLabel = new JLabel(this.m_translatedText);
        iTempWidth = this.getToolkit().getFontMetrics(tempLabel.getFont()).stringWidth(this.m_translatedText);
        if (iTempWidth > this.m_maxCategoryWidth) {
            this.m_maxCategoryWidth = iTempWidth;
        }
        this.m_translatedText = this.rBundle.getString("DateTime");
        tempLabel = new JLabel(this.m_translatedText);
        iTempWidth = this.getToolkit().getFontMetrics(tempLabel.getFont()).stringWidth(this.m_translatedText);
        if (iTempWidth > this.m_maxCategoryWidth) {
            this.m_maxCategoryWidth = iTempWidth;
        }
        this.m_translatedText = this.rBundle.getString("Custom");
        tempLabel = new JLabel(this.m_translatedText);
        iTempWidth = this.getToolkit().getFontMetrics(tempLabel.getFont()).stringWidth(this.m_translatedText);
        if (iTempWidth > this.m_maxCategoryWidth) {
            this.m_maxCategoryWidth = iTempWidth;
        }
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setApplicationName(String name) {
        this.m_applicationName = name;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public void actionPerformed(ActionEvent e) {
        String strDateFormat = "";
        String strCompareFormat = "";
        if (e.getSource() == this.m_customInsert) {
            int offset = this.m_customTypeTextField.getCaretPosition();
            String insertString = null;
            switch (this.m_customInsert.getSelectedIndex()) {
                case 0: {
                    insertString = "a.d.";
                    break;
                }
                case 1: {
                    insertString = "a.m.";
                    break;
                }
                case 2: {
                    insertString = "ad";
                    break;
                }
                case 3: {
                    insertString = "am";
                    break;
                }
                case 4: {
                    insertString = "b.c.";
                    break;
                }
                case 5: {
                    insertString = "bc";
                    break;
                }
                case 6: {
                    insertString = "cc";
                    break;
                }
                case 7: {
                    insertString = "d";
                    break;
                }
                case 8: {
                    insertString = "day";
                    break;
                }
                case 9: {
                    insertString = "dd";
                    break;
                }
                case 10: {
                    insertString = "ddd";
                    break;
                }
                case 11: {
                    insertString = "dy";
                    break;
                }
                case 12: {
                    insertString = "E";
                    break;
                }
                case 13: {
                    insertString = "EE";
                    break;
                }
                case 14: {
                    insertString = "FM";
                    break;
                }
                case 15: {
                    insertString = "hh";
                    break;
                }
                case 16: {
                    insertString = "hh12";
                    break;
                }
                case 17: {
                    insertString = "hh24";
                    break;
                }
                case 18: {
                    insertString = "I";
                    break;
                }
                case 19: {
                    insertString = "iw";
                    break;
                }
                case 20: {
                    insertString = "iy";
                    break;
                }
                case 21: {
                    insertString = "IYY";
                    break;
                }
                case 22: {
                    insertString = "iyyy";
                    break;
                }
                case 23: {
                    insertString = "j";
                    break;
                }
                case 24: {
                    insertString = "mi";
                    break;
                }
                case 25: {
                    insertString = "mm";
                    break;
                }
                case 26: {
                    insertString = "mon";
                    break;
                }
                case 27: {
                    insertString = "month";
                    break;
                }
                case 28: {
                    insertString = "p.m.";
                    break;
                }
                case 29: {
                    insertString = "pm";
                    break;
                }
                case 30: {
                    insertString = "q";
                    break;
                }
                case 31: {
                    insertString = "RM";
                    break;
                }
                case 32: {
                    insertString = "RR";
                    break;
                }
                case 33: {
                    insertString = "RRRR";
                    break;
                }
                case 34: {
                    insertString = "scc";
                    break;
                }
                case 35: {
                    insertString = "ss";
                    break;
                }
                case 36: {
                    insertString = "sssss";
                    break;
                }
                case 37: {
                    insertString = "sy,yyy";
                    break;
                }
                case 38: {
                    insertString = "syear";
                    break;
                }
                case 39: {
                    insertString = "syYYY";
                    break;
                }
                case 40: {
                    insertString = "W";
                    break;
                }
                case 41: {
                    insertString = "WW";
                    break;
                }
                case 42: {
                    insertString = "Y";
                    break;
                }
                case 43: {
                    insertString = "Y,YYY";
                    break;
                }
                case 44: {
                    insertString = "YEAR";
                    break;
                }
                case 45: {
                    insertString = "YY";
                    break;
                }
                case 46: {
                    insertString = "YYY";
                    break;
                }
                case 47: {
                    insertString = "YYYY";
                    break;
                }
            }
            try {
                this.m_customTypeTextField.getDocument().insertString(offset, insertString, null);
            }
            catch (Exception insertException) {}
        } else if (e.getSource() == this.m_customAddButton) {
            strDateFormat = this.m_customTypeTextField.getText();
            this.m_tempViewFormat.setOracleDateFormat(strDateFormat);
            strCompareFormat = this.m_tempViewFormat.getOracleDateFormat();
            if (!strCompareFormat.equals(strDateFormat)) {
                this.displayErrorMessage("DateFormatError");
                this.m_customTypeTextField.requestFocus();
                return;
            }
            this.m_customTypeVector.addElement(this.m_customTypeTextField.getText());
            this.m_customTypeList.setListData(this.m_customTypeVector);
            this.m_customTypeList.repaint();
            this.m_customTypeList.ensureIndexIsVisible(this.m_customTypeVector.size() - 1);
            this.m_customTypeList.setSelectedIndex(this.m_customTypeVector.size() - 1);
            this.m_customTypeTextField.setText("");
        } else if (e.getSource() == this.m_customDeleteButton) {
            int iSaveIndex = 0;
            iSaveIndex = this.m_customTypeList.getSelectedIndex();
            if (this.m_customTypeList.getSelectedIndex() > -1 && this.m_customTypeVector.size() > 0) {
                this.m_customTypeVector.removeElementAt(this.m_customTypeList.getSelectedIndex());
                this.m_customTypeList.setListData(this.m_customTypeVector);
                this.m_customTypeList.repaint();
                if (iSaveIndex > this.m_customTypeVector.size() - 1) {
                    iSaveIndex = this.m_customTypeVector.size() - 1;
                }
                this.m_customTypeList.setSelectedIndex(iSaveIndex);
                this.m_newDateFormatString = (String)this.m_customTypeList.getSelectedValue();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    public void setDefaultDateFormatString(String strFormat) {
        this.m_defaultDateFormat = strFormat;
    }

    public String getDefaultDateFormatString() {
        return this.m_defaultDateFormat;
    }

    public boolean apply() {
        if (this.m_dateFormatChanged) {
            if (this.m_CategoriesList.getSelectedIndex() != 0) {
                String strDateFormat;
                ViewFormat viewFormat = new ViewFormat();
                viewFormat.setLocale(this.m_viewFormat.getLocale());
                if (this.m_CategoriesList.getSelectedIndex() == 6 && (strDateFormat = this.m_customTypeTextField.getText()) != null && strDateFormat.length() > 0) {
                    int index = this.m_customTypeVector.indexOf(strDateFormat);
                    if (index == -1) {
                        this.m_tempViewFormat.setOracleDateFormat(strDateFormat);
                        String strCompareFormat = this.m_tempViewFormat.getOracleDateFormat();
                        if (strCompareFormat.equals(strDateFormat)) {
                            this.m_customTypeVector.addElement(this.m_customTypeTextField.getText());
                            this.m_customTypeList.setListData(this.m_customTypeVector);
                            this.m_customTypeList.ensureIndexIsVisible(this.m_customTypeVector.size() - 1);
                            this.m_customTypeList.setSelectedIndex(this.m_customTypeVector.size() - 1);
                            index = this.m_customTypeVector.size() - 1;
                        }
                    } else {
                        this.m_customTypeList.setSelectedIndex(index);
                    }
                    this.m_newDateFormatString = this.getCustomStringFromOffset(this.m_customTypeList.getSelectedIndex());
                }
                viewFormat.setOracleDateFormat(this.m_newDateFormatString);
                this.m_viewFormat = viewFormat;
            } else {
                this.m_viewFormat = null;
            }
        }
        this.m_tempViewFormat = null;
        return true;
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.m_locale = loc;
        this.updateResourceBundle(loc);
        this.updateDateList();
        this.updateTimeList();
        this.updateDateTimeList();
        this.constructPanel();
        this._init();
    }

    public ViewFormat getViewFormat() {
        return this.m_viewFormat;
    }

    public void setCustomList(Vector strListVector) {
        if (strListVector == null) {
            return;
        }
        this.m_customTypeVector = strListVector;
        this.m_customTypeList.setListData(this.m_customTypeVector);
        if (this.m_viewFormat != null && this.m_viewFormat.getOracleDateFormat() != null) {
            String format = this.m_viewFormat.getOracleDateFormat();
            if (this.m_customTypeVector.contains(format)) {
                this.m_customTypeList.setSelectedValue(format, true);
            } else {
                this.m_customTypeVector.addElement(format);
                this.m_customTypeList.setListData(this.m_customTypeVector);
                this.m_customTypeList.setSelectedValue(format, true);
            }
        } else if (this.m_customTypeVector.size() > 0) {
            this.m_customTypeList.setSelectedIndex(0);
        }
        this.m_customTypeList.repaint();
    }

    public Vector getCustomList() {
        return this.m_customTypeVector;
    }

    public void addElementToCustomList(String strElement) {
        this.m_customTypeVector.addElement(strElement);
        this.m_customTypeList.setListData(this.m_customTypeVector);
        this.m_customTypeList.repaint();
        this.m_customTypeList.setSelectedIndex(this.m_customTypeVector.size() - 1);
    }

    public int getCategoryType() {
        return this.m_iCategoryListOffset;
    }

    public void setCategoryType(int iType) {
        if (iType == 7) {
            this.m_CategoriesList.setSelectedIndex(0);
        } else {
            this.m_CategoriesList.setSelectedIndex(iType + 1);
        }
    }

    public void cleanUp() {
    }

    private void updateDateList() {
        String strDateTime;
        boolean bForceGregCal;
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2000, 2, 21, 15, 15);
        Date date = cal.getTime();
        GregorianCalendar gcal = null;
        boolean bl = bForceGregCal = this.m_locale.getLanguage().compareTo("th") == 0 && this.m_locale.getCountry().compareTo("TH") == 0;
        if (bForceGregCal) {
            gcal = new GregorianCalendar(this.m_locale);
        }
        String[] dataDate = new String[22];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M/d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[0] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("M/d/yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[1] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("M/d/yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[2] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[3] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("M-d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[4] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("M-d-yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[5] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("M-d-yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[6] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[7] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMM-dd", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[8] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMM-dd-yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[9] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMM-dd-yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[10] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMMM d, yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[11] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d/M/yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[12] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d-M-yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[13] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d-MMM-yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[14] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d-MMM-yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[15] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d MMM yy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[16] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d MMMM yyyy", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[17] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yyyy/M/d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[18] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yy/M/d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[19] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yyyy-M-d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[20] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yy-M-d", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDate[21] = strDateTime = simpleDateFormat.format(date);
        this.m_DateList.removeAll();
        this.m_DateList.setListData(dataDate);
        this.m_DateList.repaint();
        this._init();
    }

    private void updateTimeList() {
        String strDateTime;
        boolean bForceGregCal;
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2000, 2, 21, 15, 15);
        Date date = cal.getTime();
        GregorianCalendar gcal = null;
        boolean bl = bForceGregCal = this.m_locale.getLanguage().compareTo("th") == 0 && this.m_locale.getCountry().compareTo("TH") == 0;
        if (bForceGregCal) {
            gcal = new GregorianCalendar(this.m_locale);
        }
        String[] dataTime = new String[3];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("h:mm", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataTime[0] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("h:mm a", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataTime[1] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("H:mm", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataTime[2] = strDateTime = simpleDateFormat.format(date);
        this.m_TimeList.removeAll();
        this.m_TimeList.setListData(dataTime);
        this.m_TimeList.repaint();
        this._init();
    }

    private void updateDateTimeList() {
        String strDateTime;
        boolean bForceGregCal;
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2000, 2, 21, 15, 15);
        Date date = cal.getTime();
        GregorianCalendar gcal = null;
        boolean bl = bForceGregCal = this.m_locale.getLanguage().compareTo("th") == 0 && this.m_locale.getCountry().compareTo("TH") == 0;
        if (bForceGregCal) {
            gcal = new GregorianCalendar(this.m_locale);
        }
        String[] dataDateTime = new String[7];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M/d/yyyy h:mm a", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[0] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMM-d-yyyy h:mm a", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[1] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MMMM d, yyyy h:mm a", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[2] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d-MMM-yyyy h:mm a", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[3] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("d-MMM-yyyy H:mm", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[4] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yyyy/M/d H:mm", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[5] = strDateTime = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yyyy-M-d H:mm", this.m_locale);
        if (bForceGregCal) {
            simpleDateFormat.setCalendar(gcal);
        }
        dataDateTime[6] = strDateTime = simpleDateFormat.format(date);
        this.m_DateTimeList.removeAll();
        this.m_DateTimeList.setListData(dataDateTime);
        this.m_DateTimeList.repaint();
        this._init();
    }

    private void displayErrorMessage(String strMessage) {
        JDialog tmpDialog = new JOptionPane(this.rBundle.getString(strMessage), 0, -1, new ImageIcon(ImageUtils.getImageResource(DatePanel.class, (String)"images/stop.gif"))).createDialog(this, this.m_applicationName);
        tmpDialog.show();
    }

    private void _init() {
        String strTemp = "";
        if (this.m_viewFormat != null) {
            strTemp = this.m_viewFormat.getOracleDateFormat();
        }
        this.m_newDateFormatString = strTemp;
        this.firePropertyChange(PROPERTY_DATEPANEL_DATEFORMATCHANGED, this.m_oldDateFormatString, this.m_newDateFormatString);
        if (this.m_viewFormat == null) {
            this.m_CategoriesList.setSelectedIndex(0);
        } else if (strTemp.equals("")) {
            this.m_CategoriesList.setSelectedIndex(1);
        } else if (strTemp.equals(this.m_defaultDateFormat)) {
            this.m_CategoriesList.setSelectedIndex(2);
        } else if (strTemp.equals("fmfxmm/dd")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(0);
            this.m_DateList.setSelectedIndex(0);
        } else if (strTemp.equals("fmfxmm/dd/YYYY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(1);
            this.m_DateList.setSelectedIndex(1);
        } else if (strTemp.equals("fmfxmm/dd/fmYY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(2);
            this.m_DateList.setSelectedIndex(2);
        } else if (strTemp.equals("mm/dd/YYYY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(3);
            this.m_DateList.setSelectedIndex(3);
        } else if (strTemp.equals("fmfxmm-dd")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(4);
            this.m_DateList.setSelectedIndex(4);
        } else if (strTemp.equals("fmfxmm-dd-fmYY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(5);
            this.m_DateList.setSelectedIndex(5);
        } else if (strTemp.equals("fmfxmm-dd-YYYY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(6);
            this.m_DateList.setSelectedIndex(6);
        } else if (strTemp.equals("mm-dd-YYYY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(7);
            this.m_DateList.setSelectedIndex(7);
        } else if (strTemp.equals("Mon-dd")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(8);
            this.m_DateList.setSelectedIndex(8);
        } else if (strTemp.equals("Mon-dd-YY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(9);
            this.m_DateList.setSelectedIndex(9);
        } else if (strTemp.equals("Mon-dd-YYYY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(10);
            this.m_DateList.setSelectedIndex(10);
        } else if (strTemp.equals("fmMonthfm dd, YYYY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(11);
            this.m_DateList.setSelectedIndex(11);
        } else if (strTemp.equals("dd/fmfxmm/fmYY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(12);
            this.m_DateList.setSelectedIndex(12);
        } else if (strTemp.equals("dd-fmfxmm-fmyy")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(13);
            this.m_DateList.setSelectedIndex(13);
        } else if (strTemp.equals("dd-Mon-YY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(14);
            this.m_DateList.setSelectedIndex(14);
        } else if (strTemp.equals("dd-Mon-YYYY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(15);
            this.m_DateList.setSelectedIndex(15);
        } else if (strTemp.equals("dd Mon YY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(16);
            this.m_DateList.setSelectedIndex(16);
        } else if (strTemp.equals("dd fmMonthfm YYYY")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(17);
            this.m_DateList.setSelectedIndex(17);
        } else if (strTemp.equals("YYYY/fmfxmm/dd")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(18);
            this.m_DateList.setSelectedIndex(18);
        } else if (strTemp.equals("YY/fmfxmm/dd")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(19);
            this.m_DateList.setSelectedIndex(19);
        } else if (strTemp.equals("YYYY-fmfxmm-dd")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(20);
            this.m_DateList.setSelectedIndex(20);
        } else if (strTemp.equals("YY-fmfxmm-dd")) {
            this.m_CategoriesList.setSelectedIndex(3);
            this.m_DateList.ensureIndexIsVisible(21);
            this.m_DateList.setSelectedIndex(21);
        } else if (strTemp.equals("hh:mi")) {
            this.m_CategoriesList.setSelectedIndex(4);
            this.m_TimeList.ensureIndexIsVisible(0);
            this.m_TimeList.setSelectedIndex(0);
        } else if (strTemp.equals("hh:mi AM")) {
            this.m_CategoriesList.setSelectedIndex(4);
            this.m_TimeList.ensureIndexIsVisible(1);
            this.m_TimeList.setSelectedIndex(1);
        } else if (strTemp.equals("hh24:mi")) {
            this.m_CategoriesList.setSelectedIndex(4);
            this.m_TimeList.ensureIndexIsVisible(2);
            this.m_TimeList.setSelectedIndex(2);
        } else if (strTemp.equals("fmfxmm/dd/YYYY fmfxhh:mi AM")) {
            this.m_CategoriesList.setSelectedIndex(5);
            this.m_DateTimeList.ensureIndexIsVisible(0);
            this.m_DateTimeList.setSelectedIndex(0);
        } else if (strTemp.equals("Mon-dd-YYYY hh:mi AM")) {
            this.m_CategoriesList.setSelectedIndex(5);
            this.m_DateTimeList.ensureIndexIsVisible(1);
            this.m_DateTimeList.setSelectedIndex(1);
        } else if (strTemp.equals("fmMonthfm dd, YYYY hh:mi AM")) {
            this.m_CategoriesList.setSelectedIndex(5);
            this.m_DateTimeList.ensureIndexIsVisible(2);
            this.m_DateTimeList.setSelectedIndex(2);
        } else if (strTemp.equals("dd-Mon-YYYY hh:mi AM")) {
            this.m_CategoriesList.setSelectedIndex(5);
            this.m_DateTimeList.ensureIndexIsVisible(3);
            this.m_DateTimeList.setSelectedIndex(3);
        } else if (strTemp.equals("dd-Mon-YYYY hh24:mi")) {
            this.m_CategoriesList.setSelectedIndex(5);
            this.m_DateTimeList.ensureIndexIsVisible(4);
            this.m_DateTimeList.setSelectedIndex(4);
        } else if (strTemp.equals("YYYY/fmfxmm/dd fmfxhh24:mi")) {
            this.m_CategoriesList.setSelectedIndex(5);
            this.m_DateTimeList.ensureIndexIsVisible(5);
            this.m_DateTimeList.setSelectedIndex(5);
        } else if (strTemp.equals("YYYY-fmfxmm-dd fmfxhh24:mi")) {
            this.m_CategoriesList.setSelectedIndex(5);
            this.m_DateTimeList.ensureIndexIsVisible(6);
            this.m_DateTimeList.setSelectedIndex(6);
        } else {
            if (this.m_customTypeVector.size() == 0) {
                this.addElementToCustomList(strTemp);
            }
            this.m_CategoriesList.setSelectedIndex(6);
            this.m_customTypeList.setSelectedIndex(this.getCustomStringOffset(this.m_newDateFormatString));
        }
        this.m_dateFormatChanged = false;
    }

    private int getCustomStringOffset(String strValue) {
        int iReturn = 0;
        if (this.m_customTypeVector != null) {
            if (this.m_customTypeVector.size() > 0) {
                iReturn = this.m_customTypeVector.indexOf(strValue);
            }
            if (iReturn == -1) {
                iReturn = 0;
            }
        }
        return iReturn;
    }

    private String getCustomStringFromOffset(int iOffset) {
        String strTemp = "";
        if (this.m_customTypeVector != null && this.m_customTypeVector.size() > 0) {
            if (iOffset > this.m_customTypeVector.size() - 1) {
                iOffset = this.m_customTypeVector.size() - 1;
            }
            strTemp = (String)this.m_customTypeVector.elementAt(iOffset);
        }
        return strTemp;
    }

    private String convertOffsetsToString(int iCategoryListOffset, int iTypeListOffset) {
        String strDateFormat = "";
        block0 : switch (iCategoryListOffset) {
            case 7: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                strDateFormat = this.m_defaultDateFormat;
                break;
            }
            case 2: {
                switch (iTypeListOffset) {
                    case 0: {
                        strDateFormat = "fmfxmm/dd";
                        break block0;
                    }
                    case 1: {
                        strDateFormat = "fmfxmm/dd/YYYY";
                        break block0;
                    }
                    case 2: {
                        strDateFormat = "fmfxmm/dd/fmYY";
                        break block0;
                    }
                    case 3: {
                        strDateFormat = "mm/dd/YYYY";
                        break block0;
                    }
                    case 4: {
                        strDateFormat = "fmfxmm-dd";
                        break block0;
                    }
                    case 5: {
                        strDateFormat = "fmfxmm-dd-fmYY";
                        break block0;
                    }
                    case 6: {
                        strDateFormat = "fmfxmm-dd-YYYY";
                        break block0;
                    }
                    case 7: {
                        strDateFormat = "mm-dd-YYYY";
                        break block0;
                    }
                    case 8: {
                        strDateFormat = "Mon-dd";
                        break block0;
                    }
                    case 9: {
                        strDateFormat = "Mon-dd-YY";
                        break block0;
                    }
                    case 10: {
                        strDateFormat = "Mon-dd-YYYY";
                        break block0;
                    }
                    case 11: {
                        strDateFormat = "fmMonthfm dd, YYYY";
                        break block0;
                    }
                    case 12: {
                        strDateFormat = "dd/fmfxmm/fmYY";
                        break block0;
                    }
                    case 13: {
                        strDateFormat = "dd-fmfxmm-fmyy";
                        break block0;
                    }
                    case 14: {
                        strDateFormat = "dd-Mon-YY";
                        break block0;
                    }
                    case 15: {
                        strDateFormat = "dd-Mon-YYYY";
                        break block0;
                    }
                    case 16: {
                        strDateFormat = "dd Mon YY";
                        break block0;
                    }
                    case 17: {
                        strDateFormat = "dd fmMonthfm YYYY";
                        break block0;
                    }
                    case 18: {
                        strDateFormat = "YYYY/fmfxmm/dd";
                        break block0;
                    }
                    case 19: {
                        strDateFormat = "YY/fmfxmm/dd";
                        break block0;
                    }
                    case 20: {
                        strDateFormat = "YYYY-fmfxmm-dd";
                        break block0;
                    }
                    case 21: {
                        strDateFormat = "YY-fmfxmm-dd";
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (iTypeListOffset) {
                    case 0: {
                        strDateFormat = "hh:mi";
                        break block0;
                    }
                    case 1: {
                        strDateFormat = "hh:mi AM";
                        break block0;
                    }
                    case 2: {
                        strDateFormat = "hh24:mi";
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (iTypeListOffset) {
                    case 0: {
                        strDateFormat = "fmfxmm/dd/YYYY fmfxhh:mi AM";
                        break block0;
                    }
                    case 1: {
                        strDateFormat = "Mon-dd-YYYY hh:mi AM";
                        break block0;
                    }
                    case 2: {
                        strDateFormat = "fmMonthfm dd, YYYY hh:mi AM";
                        break block0;
                    }
                    case 3: {
                        strDateFormat = "dd-Mon-YYYY hh:mi AM";
                        break block0;
                    }
                    case 4: {
                        strDateFormat = "dd-Mon-YYYY hh24:mi";
                        break block0;
                    }
                    case 5: {
                        strDateFormat = "YYYY/fmfxmm/dd fmfxhh24:mi";
                        break block0;
                    }
                    case 6: {
                        strDateFormat = "YYYY-fmfxmm-dd fmfxhh24:mi";
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                strDateFormat = this.getCustomStringFromOffset(iTypeListOffset);
                break;
            }
        }
        return strDateFormat;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    void setViewType(int type) {
        this.m_viewType = type;
    }

    private void $init$() {
        this.rBundle = null;
        this.m_locale = null;
        this.m_iTimeListOffset = -1;
        this.m_iDateListOffset = -1;
        this.m_iDateTimeListOffset = -1;
        this.m_oldDateFormatString = "-1";
        this.m_newDateFormatString = "-1";
        this.m_customTypeVector = new Vector();
        this.m_iCustomListOffset = -1;
        this.m_defaultDateFormat = "";
        this.m_eh = null;
        this.m_maxButtonWidth = 0;
        this.m_maxCategoryWidth = 0;
        this.m_clearSelection = false;
        this.m_bSuperCalled = false;
        this.m_dateFormatChanged = false;
        this.m_sentPropertyChangeEvent = true;
    }
}

