/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewFont;
import oracle.dss.dataView.DataviewFontAttribute;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.formattedTextArea.UIFormattedTextView;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;

public class FontColorTool
extends JToolBar
implements DataviewToolbarRollover,
DataviewTool,
PropertyChangeListener {
    public static final String PROPERTY_FONT_COLOR = "FontColor";
    protected ToolBar m_toolBar;
    protected Object m_selectedObject;
    protected ComponentHandle m_selectedComponentHandle;
    protected UIView m_currentDataview;
    protected boolean m_colorPaletteSet;
    protected NewColorChoice m_fontColor;
    private ResourceBundle rBundle;
    protected boolean m_enable;
    protected Color m_fnColor;
    protected boolean m_bPause;
    protected boolean m_bRolloverIconEnabled;
    private MouseListener m_mouseListener;
    private boolean m_bSuperCalled;

    public FontColorTool() {
        this.$init$();
        this.m_bSuperCalled = true;
        this.m_fontColor = new NewColorChoice();
        Icon icon = this.m_fontColor.getColorIcon();
        this.m_fontColor.setIcon(icon);
        this.m_fontColor.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_fontColor.getIcon()).getImage())));
        this.m_fontColor.setSelectedColor(new Color(153, 153, 153));
        this.m_fontColor.addPropertyChangeListener(this);
        this.m_fontColor.setEnabled(false);
        this.m_fontColor.setBorderPainted(false);
        this.add((Component)((Object)this.m_fontColor));
        this.setBorder(null);
        this.updateResourceBundle(Locale.getDefault());
        this.m_fontColor.setToolTipText(this.rBundle.getString(PROPERTY_FONT_COLOR));
        this.m_fontColor.getAccessibleContext().setAccessibleName(this.rBundle.getString("FontColorButton"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            if (this.m_fontColor.getBorder() != null && this.m_fontColor.getBorder() instanceof CompoundBorder) {
                this.m_fontColor.setBorder(new CompoundBorder(((CompoundBorder)this.m_fontColor.getBorder()).getOutsideBorder(), null));
            }
            this.m_fontColor.setPreferredSize(new Dimension(this.m_fontColor.getPreferredSize().width, 24));
            this.m_mouseListener = new 1();
            this.m_fontColor.addMouseListener(this.m_mouseListener);
        }
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this.m_fontColor.setToolTipText(this.rBundle.getString(PROPERTY_FONT_COLOR));
        this.m_fontColor.getAccessibleContext().setAccessibleName(this.rBundle.getString("FontColorButton"));
    }

    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        Object selectedObject = null;
        boolean selectedSeries = false;
        this.m_currentDataview = currentDataView;
        this.m_toolBar = toolBar;
        if (e == null) {
            return;
        }
        this.m_fontColor.setCustomColorsEnabled(currentDataView.isCustomColorsEnabled());
        ComponentHandle handle = e.getComponentHandle();
        if (handle == null || this.m_currentDataview instanceof GraphAttribute && handle.getComponent() == null) {
            this.m_selectedObject = null;
            this.m_fontColor.setEnabled(false);
            return;
        }
        selectedObject = handle.getComponent();
        this.m_enable = false;
        if (this.isEnabled(e.getComponentHandle())) {
            this.m_selectedObject = selectedObject;
            this.m_selectedComponentHandle = e.getComponentHandle();
            this.m_fontColor.setEnabled(true);
            Color color = this.getFontColor();
            if (!this.m_colorPaletteSet) {
                if (!NewColorChoice.isColorInPalette((TwoDModel)this.m_fontColor.getColorPalette(), (Color)color)) {
                    this.m_fontColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_fontColor.getColorPalette(), (Color)color, (boolean)this.m_colorPaletteSet));
                }
                this.m_fontColor.setSelectedColor(color);
            } else {
                this.m_fontColor.setSelectedColor(this.m_fontColor.getClosestColor(color));
            }
            this.m_fnColor = color;
            this.m_fontColor.updateIconColor();
        } else {
            this.m_fontColor.setEnabled(false);
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
        }
        this.m_enable = true;
    }

    public void setColorPalette(TwoDModel model) {
        this.m_colorPaletteSet = model != null;
        this.m_bPause = true;
        if (this.m_fnColor == null) {
            this.m_fontColor.setSelectedColor((Color)this.m_fontColor.getColorPalette().getData(0, 0));
        }
        if (this.m_fnColor != null) {
            Color fnColor = new Color(this.m_fnColor.getRGB());
            this.m_fontColor.setSelectedColor((Color)this.m_fontColor.getColorPalette().getData(0, 0));
            this.m_fontColor.setColorPalette(model);
            if (!this.m_colorPaletteSet) {
                if (!NewColorChoice.isColorInPalette((TwoDModel)this.m_fontColor.getColorPalette(), (Color)fnColor)) {
                    this.m_fontColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_fontColor.getColorPalette(), (Color)fnColor, (boolean)this.m_colorPaletteSet));
                }
                this.m_fontColor.setSelectedColor(fnColor);
            } else {
                this.m_fontColor.setSelectedColor(this.m_fontColor.getClosestColor(fnColor));
            }
        } else {
            this.m_fontColor.setColorPalette(model);
            this.m_fontColor.setSelectedColor(null);
        }
        this.m_bPause = false;
    }

    public TwoDModel getColorPalette() {
        return this.m_fontColor.getColorPalette();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (this.m_bPause) {
            return;
        }
        if (e == null || !this.m_enable) {
            return;
        }
        if (!e.getSource().equals((Object)this.m_fontColor) || !e.getPropertyName().equals("selectedColor")) {
            return;
        }
        if (this.m_selectedComponentHandle != null) {
            this.setFontColor(this.m_fontColor.getSelectedColor());
            this.firePropertyChange(PROPERTY_FONT_COLOR, e.getOldValue(), e.getNewValue());
        }
        this.m_fontColor.updateIconColor();
    }

    public void update() {
        this.m_fontColor.setEnabled(this.isEnabled() && this.m_fontColor.isEnabled());
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void cleanUp() {
        this.m_fontColor.dispose();
        this.m_fontColor.removeMouseListener(this.m_mouseListener);
        this.m_fontColor.removePropertyChangeListener(this);
        this.remove((Component)((Object)this.m_fontColor));
        this.m_fontColor._filter = null;
        this.m_fontColor = null;
        this.rBundle = null;
    }

    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
        if (bEnabled) {
            this.m_fontColor.updateIconColor();
        } else {
            this.m_fontColor.setIcon(this.m_fontColor.getColorIcon());
            this.m_fontColor.setRolloverIcon(null);
            this.m_fontColor.setRolloverSelectedIcon(null);
        }
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(ToolBar.class, (String)fileName));
    }

    private boolean isEnabled(ComponentHandle selectedComponentHandle) {
        if (selectedComponentHandle == null) {
            return false;
        }
        if (selectedComponentHandle.getID() == 6 || selectedComponentHandle.getID() == 7 || selectedComponentHandle.getID() == 8) {
            return true;
        }
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(selectedComponentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(selectedComponentHandle) != null) {
            return true;
        }
        if (selectedComponentHandle.getComponent() instanceof DataviewFontAttribute) {
            return true;
        }
        if (selectedComponentHandle.getComponent() instanceof UIFormattedTextView) {
            return ((UIFormattedTextView)selectedComponentHandle.getComponent()).isEditable();
        }
        return false;
    }

    private Color getFontColor() {
        UIFormattedTextView view;
        if (this.m_selectedObject instanceof UIFormattedTextView && (view = (UIFormattedTextView)this.m_selectedObject).isEditable() && !view.isCurrentAttributeChanging()) {
            return view.getFontColor();
        }
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            return ((DataviewTitles)this.m_selectedObject).getForeground();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getForeground();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getForeground();
        }
        if (this.m_selectedObject instanceof DataviewFontAttribute) {
            return ((DataviewFontAttribute)this.m_selectedObject).getDataviewFont().getGraphFontColor();
        }
        return Color.white;
    }

    private void setFontColor(Color color) {
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            ((DataviewTitles)this.m_selectedObject).setForeground(color);
        } else if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setForeground(color);
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
            if (!this.m_toolBar.hideAlertInFuture() && !((GridViewAttribute)((Object)this.m_currentDataview)).compareComponentViewStyle(this.m_selectedComponentHandle, viewStyle)) {
                this.m_toolBar.displayFormatAlert();
            }
        } else if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setForeground(color);
            ((GraphAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_selectedObject instanceof DataviewFontAttribute) {
            DataviewFont f = ((DataviewFontAttribute)this.m_selectedObject).getDataviewFont();
            f.setGraphFontColor(color);
        }
        if (this.m_selectedObject instanceof UIFormattedTextView) {
            ((UIFormattedTextView)this.m_selectedObject).setFontColor(color);
        }
    }

    private void $init$() {
        this.m_toolBar = null;
        this.m_selectedObject = null;
        this.m_selectedComponentHandle = null;
        this.m_currentDataview = null;
        this.m_colorPaletteSet = false;
        this.m_fontColor = null;
        this.rBundle = null;
        this.m_enable = true;
        this.m_fnColor = null;
        this.m_bPause = false;
        this.m_bRolloverIconEnabled = false;
        this.m_bSuperCalled = false;
    }

    final class 1
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            if (!FontColorTool.this.isRolloverIconEnabled()) {
                FontColorTool.this.m_fontColor.setBorderPainted(true);
            }
            if (!FontColorTool.this.m_fontColor.isEnabled()) {
                FontColorTool.this.m_fontColor.setBorderPainted(FontColorTool.this.m_fontColor.isSelected());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!FontColorTool.this.isRolloverIconEnabled() && FontColorTool.this.m_fontColor.isEnabled()) {
                FontColorTool.this.m_fontColor.setBorderPainted(FontColorTool.this.m_fontColor.isSelected());
            }
        }
    }

    class NewColorChoice
    extends BIColorChoice {
        Image image;
        protected Image m_fontColorImage;
        private Image m_fontColorImage1;
        private String imageName;
        protected Image newImage;
        protected Filter_Font _filter;
        protected Filter_Font _filter1;

        private void $init$() {
            this.image = null;
            this.m_fontColorImage = null;
            this.m_fontColorImage1 = null;
            this.newImage = null;
            this._filter = new Filter_Font();
            this._filter1 = new Filter_Font();
        }

        protected void updateIconColor() {
            this.setIcon(this.getColorIcon());
            this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
            this._filter1.setColor(this.getSelectedColor());
            Object image = null;
            this.m_fontColorImage1 = ImageUtils.getImageResource(ToolBar.class, (String)"images/l_fontcolorwitharrow.gif");
            FilteredImageSource prod = new FilteredImageSource(this.m_fontColorImage1.getSource(), this._filter1);
            this.newImage = Toolkit.getDefaultToolkit().createImage(prod);
            if (FontColorTool.this.isRolloverIconEnabled()) {
                this.setRolloverIcon(new ImageIcon(this.newImage));
                this.setRolloverSelectedIcon(new ImageIcon(this.newImage));
            }
        }

        protected Icon getColorIcon() {
            this._filter.setColor(this.getSelectedColor());
            Image image = null;
            String fileName = FontColorTool.this.isRolloverIconEnabled() ? "images/fontcolorwitharrow.gif" : "images/fontcolorwitharrow_18t.gif";
            if (fileName != this.imageName || this.m_fontColorImage == null) {
                this.m_fontColorImage = ImageUtils.getImageResource(NewColorChoice.class, (String)fileName);
                this.imageName = fileName;
            }
            image = this.m_fontColorImage;
            FilteredImageSource prod = new FilteredImageSource(image.getSource(), this._filter);
            this.newImage = Toolkit.getDefaultToolkit().createImage(prod);
            return new ImageIcon(this.newImage);
        }

        public Icon getDisabledIcon() {
            this._filter.setColor(new Color(153, 153, 153));
            Image image = null;
            image = this.m_fontColorImage;
            FilteredImageSource prod = new FilteredImageSource(image.getSource(), this._filter);
            this.newImage = Toolkit.getDefaultToolkit().createImage(prod);
            return new ImageIcon(this.newImage);
        }

        private ImageIcon makeImage(String fileName) {
            return new ImageIcon(ImageUtils.getImageResource(FontColorTool.class, (String)fileName));
        }

        NewColorChoice() {
            this.$init$();
        }
    }

    class Filter_Font
    extends RGBImageFilter {
        private int _color;
        private int _sCOLOR;

        public Filter_Font() {
            this.$init$();
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color c) {
            this._color = c == null ? 0 : c.getRGB();
        }

        public int filterRGB(int x, int y, int rgb) {
            if (rgb == this._sCOLOR) {
                return this._color;
            }
            return rgb;
        }

        private void $init$() {
            this._sCOLOR = new Color(0, 153, 153).getRGB();
        }
    }
}

