/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.formattedTextArea.UIFormattedTextView;
import oracle.dss.pagingControl.PageItemComponentHandle;

public class ItalicFontTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_FONT_ITALIC = "FontItalic";
    protected Object m_selectedObject;
    protected ComponentHandle m_selectedComponentHandle;
    protected UIView m_currentDataview;
    protected ToolBar m_toolBar;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    private boolean m_enable;
    private MouseListener m_mouseListener;
    protected boolean m_bRolloverIconEnabled;

    public ItalicFontTool() {
        this.$init$();
        this.setMargin(insets0);
        this.addActionListener(this);
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/italic_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("ItalicFont"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new 1();
            this.addMouseListener(this.m_mouseListener);
        }
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.setToolTipText(this.rBundle.getString("ItalicFont"));
    }

    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        if (currentDataView == null) {
            return;
        }
        this.m_currentDataview = currentDataView;
        this.m_toolBar = toolBar;
        if (e == null) {
            return;
        }
        if (e.getComponentHandle() == null || this.m_currentDataview instanceof GraphAttribute && e.getComponentHandle().getComponent() == null) {
            this.m_selectedObject = null;
            this.m_currentDataview = null;
            this.setEnabled(false);
            return;
        }
        Object selectedObject = e.getComponentHandle().getComponent();
        this.m_enable = false;
        if (this.isEnabled(e.getComponentHandle())) {
            this.m_selectedObject = selectedObject;
            this.m_selectedComponentHandle = e.getComponentHandle();
            this.setEnabled(true);
            if (this.getFontItalic()) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            this.setBorderPainted(this.isSelected());
        } else {
            this.setEnabled(false);
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
        }
        this.m_enable = true;
    }

    public void actionPerformed(ActionEvent e) {
        if (e == null || !this.m_enable) {
            return;
        }
        if (e.getSource() == this) {
            this.setFontItalic(this.isSelected());
            if (this.isSelected()) {
                this.setBorderPainted(true);
            } else {
                this.setBorderPainted(false);
            }
        }
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void update() {
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(ToolBar.class, (String)fileName));
    }

    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
    }

    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
        if (bEnabled) {
            this.setIcon(this.makeImage("images/italic.gif"));
            this.setRolloverIcon(this.makeImage("images/l_italic.gif"));
            this.setRolloverSelectedIcon(this.makeImage("images/l_italic.gif"));
        } else {
            this.setIcon(this.makeImage("images/italic_18t.gif"));
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isEnabled(ComponentHandle selectedComponentHandle) {
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(selectedComponentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(selectedComponentHandle) != null) {
            return true;
        }
        if (selectedComponentHandle.getComponent() instanceof FontAttribute) {
            return true;
        }
        if (selectedComponentHandle.getComponent() instanceof UIFormattedTextView) {
            return ((UIFormattedTextView)selectedComponentHandle.getComponent()).isEditable();
        }
        return false;
    }

    private boolean getFontItalic() {
        UIFormattedTextView view;
        if (this.m_selectedObject instanceof UIFormattedTextView && (view = (UIFormattedTextView)this.m_selectedObject).isEditable() && !view.isCurrentAttributeChanging()) {
            return view.getFontItalic();
        }
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            return ((DataviewTitles)this.m_selectedObject).getFont().isItalic();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.isFontItalic();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.isFontItalic();
        }
        if (this.m_selectedObject instanceof FontAttribute) {
            return ((FontAttribute)this.m_selectedObject).getFont().isItalic();
        }
        return false;
    }

    private void setFontItalic(boolean italic) {
        boolean oldStyle = this.getFontItalic();
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            Font f = ((DataviewTitles)this.m_selectedObject).getFont();
            int style = f.getStyle();
            style = italic ? (style |= 2) : (style &= 0xFFFFFFFD);
            ((DataviewTitles)this.m_selectedObject).setFont(new Font(f.getName(), style, f.getSize()));
        } else if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontItalic(italic);
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
            if (!this.m_toolBar.hideAlertInFuture() && !((GridViewAttribute)((Object)this.m_currentDataview)).compareComponentViewStyle(this.m_selectedComponentHandle, viewStyle)) {
                this.m_toolBar.displayFormatAlert();
            }
        } else if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontItalic(italic);
            ((GraphAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_selectedObject instanceof FontAttribute) {
            Font f = ((FontAttribute)this.m_selectedObject).getFont();
            int style = f.getStyle();
            style = italic ? (style |= 2) : (style &= 0xFFFFFFFD);
            ((FontAttribute)this.m_selectedObject).setFont(new Font(f.getName(), style, f.getSize()));
        }
        if (this.m_selectedObject instanceof UIFormattedTextView) {
            ((UIFormattedTextView)this.m_selectedObject).setFontItalic(italic);
        }
        this.firePropertyChange(PROPERTY_FONT_ITALIC, oldStyle, italic);
    }

    private void $init$() {
        this.m_selectedObject = null;
        this.m_selectedComponentHandle = null;
        this.m_currentDataview = null;
        this.m_toolBar = null;
        this.rBundle = null;
        this.m_enable = true;
        this.m_bRolloverIconEnabled = false;
    }

    final class 1
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            if (!ItalicFontTool.this.isRolloverIconEnabled()) {
                ItalicFontTool.this.setBorderPainted(true);
            }
            if (!ItalicFontTool.this.isEnabled()) {
                ItalicFontTool.this.setBorderPainted(ItalicFontTool.this.isSelected());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!ItalicFontTool.this.isRolloverIconEnabled()) {
                ItalicFontTool.this.setBorderPainted(ItalicFontTool.this.isSelected());
            }
        }
    }
}

