/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.gui.InsertButton;
import oracle.dss.util.help.HelpContext;

public class NumberFormatPanel
extends JPanel
implements ItemListener,
PropertyChangeListener,
ActionListener,
ChangeListener,
ListSelectionListener,
HelpContext {
    private int m_nCustomNumberFormatType;
    private ResourceBundle rBundle;
    private ResourceBundle rUtilBundle;
    private boolean isSetFocus;
    private String m_applicationName;
    private JLabel m_categoryLabel;
    protected JList m_typeList;
    protected JLabel m_decimalLabel;
    protected NumericSpinBox m_decimalSpinBox;
    private JCheckBox m_use1000SeperatorCheckBox;
    private JCheckBox m_currencySymbolCheckBox;
    private boolean m_use1000Seperator;
    private JComboBox m_dollarSignComboBox;
    private boolean m_useCurrencySymbol;
    protected JCheckBox m_scaleCheckBox;
    protected JComboBox m_scaleComboBox;
    protected JCheckBox m_defaultScaleMarkCheckBox;
    private JLabel m_negativeLabel;
    private JList m_negativeList;
    private JList m_negativeList1;
    private Vector m_negativeListVector;
    private Vector m_negativeListVectorForCur;
    private MultiLineLabel m_descriptionLabel;
    private JPanel m_nonePanel;
    private JPanel m_numberPanel;
    private JPanel m_rightPanel;
    private JPanel m_customPanel;
    private JLabel m_customTypeLabel;
    private JLabel m_customEditTypeLabel;
    private JList m_customTypeList;
    private JButton m_customDeleteButton;
    private JComboBox m_customInsertComboBox;
    private JButton m_customInsertButton;
    private InsertButton m_customInsert;
    private JButton m_customAddButton;
    private JTextField m_customTypeTextField;
    private Vector m_customTypeVector;
    private String m_defaultFormat;
    private JScrollPane m_scrollPane;
    private ViewFormat m_viewFormat;
    private int m_oldSelectedType;
    private int m_oldSelectedNegativeType;
    private boolean m_negativeRed;
    private int m_numberNegativeType;
    private int m_currencyNegativeType;
    private NegativeListCellRenderer m_negativeListCellRenderer;
    private JScrollPane m_scrollPaneType;
    private Vector m_vectorDollarSign;
    private Locale m_customCurrencyLocale;
    protected boolean m_sentPropertyChangeEvent;
    private boolean m_defaultFormatSet;
    private CaretListener m_caretListener;
    private boolean m_bSuperCalled;
    protected Vector typeList;
    protected Vector m_scaleVector;
    protected JPanel m_decimalPanel;
    public static String HEAD_CURR_DEFAULT_STR = "L999G999G999";
    public static String TAIL_CURR_DEFAULT_STR = "999G999G999L";
    private static String NegCur0 = "({0}123)";
    private static String NegCur1 = "-{0}123";
    private static String NegCur2 = "{0}-123";
    private static String NegCur3 = "{0}123-";
    private static String NegCur4 = "(123{0})";
    private static String NegCur5 = "-123{0}";
    private static String NegCur6 = "123-{0}";
    private static String NegCur7 = "123{0}-";
    private static String Neg0 = "-123";
    private static String Neg1 = "(123)";
    private static String Neg2 = "123-";
    private static String currencySymbol;
    private static String DollarSign0;
    private static String DollarSign00;
    private static String DollarSign1;
    private static String DollarSign2;
    private static String DollarSign3;
    private static String DollarSign33;
    private static String DollarSign4;
    private static String DollarSign5;
    private static String DollarSign6;
    private static String DollarSign7;
    private static String Dollar;
    private static String Pound;
    private static String Yen;
    private static String Euro;
    private static String USD;
    private static String JPY;
    private static String GBP;
    private static String EUR;
    private static final char EMPTY_CHARACTER = '\u0000';
    private int m_type;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh;
    protected String m_strHelpContextID;
    public static final String PROPERTY_TYPE_CHANGE = "TypeChange";
    public static final String PROPERTY_NEGATIVENUMBER_TYPE_CHANGE = "NegativeNumberTypeChange";
    public static final String PROPERTY_CUSTOM_TYPE_CHANGE = "CustomTypeChange";
    public static final String PROPERTY_DECIMAL_PLACES = "DecimalPlaces";
    public static final String PROPERTY_THOUSAND_SEPARATOR = "ThousandSeparator";
    public static final String PROPERTY_SCALE = "Scale";
    public static final String PROPERTY_SCALE_FACTOR = "ScaleFactor";
    public static final String PROPERTY_SCALE_SIGN = "ScaleSign";
    public static final String PROPERTY_NEGATIVE_FORMAT = "NegativeFormat";
    public static final String PROPERTY_DOLLAR_SIGN = "DollarSign";
    public static final String PROPERTY_POSITIVE_FORMAT = "PositiveFormat";
    public static final String PROPERTY_CURRENCY_SYMBOL_USED = "CurrencySymbolUsed";
    public static final int NUMBER_FORMAT_TYPE_NOT_SPECIFIED = 6;
    public static final int NUMBER_FORMAT_TYPE_NONE = 0;
    public static final int NUMBER_FORMAT_TYPE_DEFAULT = 1;
    public static final int NUMBER_FORMAT_TYPE_NUMBER = 2;
    public static final int NUMBER_FORMAT_TYPE_CURRENCY = 3;
    public static final int NUMBER_FORMAT_TYPE_PERCENT = 4;
    public static final int NUMBER_FORMAT_TYPE_CUSTOM = 5;

    public NumberFormatPanel(ViewFormat viewFormat) {
        this.$init$();
        this.m_bSuperCalled = true;
        this.initConstructor(viewFormat, 1);
    }

    public NumberFormatPanel(ViewFormat viewFormat, int nCustomNumberFormatType) {
        this.$init$();
        this.m_bSuperCalled = true;
        this.initConstructor(viewFormat, nCustomNumberFormatType);
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void setCustomNumberFormatType(int nCustomNumberFormatType) {
        this.m_nCustomNumberFormatType = nCustomNumberFormatType;
    }

    public int getCustomNumberFormatType() {
        return this.m_nCustomNumberFormatType;
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        if (this.m_viewFormat != null) {
            this.m_viewFormat.setLocale(loc);
        }
        if (!this.m_defaultFormatSet) {
            DecimalFormat numFmt = (DecimalFormat)NumberFormat.getCurrencyInstance(this.getLocale());
            String prefix = numFmt.getPositivePrefix().trim();
            String suffix = numFmt.getPositiveSuffix().trim();
            this.m_defaultFormat = prefix != null && prefix.length() > 0 ? HEAD_CURR_DEFAULT_STR : (suffix != null && suffix.length() > 0 ? TAIL_CURR_DEFAULT_STR : HEAD_CURR_DEFAULT_STR);
        }
        this.initialize(this.m_viewFormat);
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public ViewFormat apply() {
        int type;
        ViewFormat viewFormat = null;
        switch (this.getFormatType()) {
            case 6: {
                return null;
            }
            case 0: {
                viewFormat = new ViewFormat();
                viewFormat.setLocale(this.getLocale());
                viewFormat.setLeadingZeroUsed(true);
                viewFormat.setDecimalDigitUsed(true);
                viewFormat.setPosNumFmtUsed(true);
                viewFormat.setNegNumFmtUsed(true);
                viewFormat.setPosCurFmtUsed(true);
                viewFormat.setNegCurFmtUsed(true);
                viewFormat.setScaleFactorUsed(true);
                viewFormat.setThousandSeparatorUsed(true);
                viewFormat.setScaleDownBillionsUsed(true);
                viewFormat.setScaleDownMillionsUsed(true);
                viewFormat.setScaleDownQuadrillionsUsed(true);
                viewFormat.setScaleDownThousandsUsed(true);
                viewFormat.setNumberTypeUsed(true);
                break;
            }
            case 1: {
                viewFormat = this.createViewFormat();
                viewFormat.initWithString(this.getDefaultFormat(), 1);
                break;
            }
            case 5: {
                try {
                    String formatStr = this.m_customTypeTextField.getText();
                    boolean formatSet = false;
                    if (formatStr != null && formatStr.length() > 0) {
                        int index = this.m_customTypeVector.indexOf(formatStr);
                        if (index == -1) {
                            ViewFormat tmp = new ViewFormat();
                            boolean valid = tmp.validateFormatString(this.m_customTypeTextField.getText(), this.getCustomNumberFormatType());
                            if (valid) {
                                this.m_customTypeVector.addElement(formatStr);
                                this.m_customTypeList.setListData(this.m_customTypeVector);
                                this.m_customTypeList.setSelectedIndex(this.m_customTypeVector.size() - 1);
                            }
                        } else {
                            this.m_customTypeList.setSelectedIndex(index);
                        }
                    }
                    if (this.m_customTypeList.getSelectedValue() != null) {
                        viewFormat = this.createViewFormat();
                        viewFormat.initWithString(this.getCurrentCustomPatternString(), this.getCustomNumberFormatType());
                        break;
                    }
                    viewFormat = this.getViewFormat();
                }
                catch (Exception viewFormatException) {
                    viewFormat = null;
                }
                break;
            }
            case 4: {
                viewFormat = this.getPercentageFormat();
                break;
            }
            case 2: 
            case 3: {
                viewFormat = this.createViewFormat();
                this.setNumberFormat(viewFormat);
                break;
            }
        }
        if (viewFormat != null && (type = this.getFormatType()) > 1 && type < 5) {
            viewFormat.setNumberType(type - 2);
        }
        this.m_viewFormat = viewFormat;
        return viewFormat;
    }

    public Dimension getPreferredSize() {
        int width = Integer.parseInt(this.rBundle.getString("NumberFormatPanelWidth")) + 41;
        int height = Integer.parseInt(this.rBundle.getString("NumberFormatPanelHeight"));
        return new Dimension(width, height);
    }

    public void setApplicationName(String name) {
        this.m_applicationName = name;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.m_decimalSpinBox && this.m_sentPropertyChangeEvent) {
            this.firePropertyChange(PROPERTY_DECIMAL_PLACES, -1, this.m_decimalSpinBox.getIntValue());
        }
    }

    public void addCustomPatternString(String pattern) {
        this.m_customTypeVector.addElement(pattern);
        this.m_customTypeList.repaint();
    }

    public void setCurrentCustomPatternString(String pattern) {
        if (!this.m_customTypeVector.contains(pattern)) {
            this.m_customTypeVector.addElement(pattern);
            this.m_customTypeList.setListData(this.m_customTypeVector);
            this.m_customTypeList.setSelectedValue(pattern, true);
            this.m_customTypeList.repaint();
        } else {
            this.m_customTypeList.setSelectedValue(pattern, true);
        }
    }

    public void setCustomPatternStringList(Vector patternVector) {
        if (patternVector == null) {
            return;
        }
        this.m_customTypeVector = patternVector;
        this.m_customTypeList.setListData(this.m_customTypeVector);
        this.m_customTypeList.setSelectedIndex(0);
        this.m_customTypeList.repaint();
    }

    public Vector getCustomPatternStringList() {
        return this.m_customTypeVector;
    }

    protected String getScaleMarkString(int index) {
        String string = null;
        Object[] args = new String[1];
        switch (index) {
            case 1: {
                args[0] = this.rUtilBundle.getString("K");
                args[0] = "'" + args[0] + "'";
                string = this.rBundle.getString("Show 'K' for thousands");
                string = MessageFormat.format(string, args);
                break;
            }
            case 2: {
                args[0] = this.rUtilBundle.getString("M");
                args[0] = "'" + args[0] + "'";
                string = this.rBundle.getString("Show 'M' for millions");
                string = MessageFormat.format(string, args);
                break;
            }
            case 3: {
                args[0] = this.rUtilBundle.getString("B");
                args[0] = "'" + args[0] + "'";
                string = this.rBundle.getString("Show 'B' for billions");
                string = MessageFormat.format(string, args);
                break;
            }
            case 4: {
                args[0] = this.rUtilBundle.getString("T");
                args[0] = "'" + args[0] + "'";
                string = this.rBundle.getString("Show 'T' for trillions");
                string = MessageFormat.format(string, args);
                break;
            }
            case 5: {
                args[0] = this.rUtilBundle.getString("Q");
                args[0] = "'" + args[0] + "'";
                string = this.rBundle.getString("Show 'Q' for quadrillions");
                string = MessageFormat.format(string, args);
                break;
            }
        }
        return string;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_defaultScaleMarkCheckBox) {
            if (this.m_sentPropertyChangeEvent) {
                this.firePropertyChange(PROPERTY_SCALE_SIGN, this.m_defaultScaleMarkCheckBox.isSelected() ^ true, this.m_defaultScaleMarkCheckBox.isSelected());
            }
        } else if (e.getSource() == this.m_scaleComboBox) {
            String string = this.getScaleMarkString(this.m_scaleComboBox.getSelectedIndex() + 1);
            this.m_defaultScaleMarkCheckBox.setVisible(true);
            this.m_defaultScaleMarkCheckBox.setText(StringUtils.stripMnemonic((String)string));
            this.m_defaultScaleMarkCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_defaultScaleMarkCheckBox.setEnabled(true);
            if (this.m_sentPropertyChangeEvent) {
                this.firePropertyChange(PROPERTY_SCALE_FACTOR, -1, this.m_scaleComboBox.getSelectedIndex() + 1);
            }
        } else if (e.getSource() == this.m_scaleCheckBox) {
            if (this.m_scaleCheckBox.isSelected()) {
                this.m_scaleComboBox.setEnabled(true);
                this.m_defaultScaleMarkCheckBox.setEnabled(true);
            } else {
                this.m_scaleComboBox.setEnabled(false);
                this.m_defaultScaleMarkCheckBox.setEnabled(false);
            }
            if (this.m_sentPropertyChangeEvent) {
                this.firePropertyChange(PROPERTY_SCALE, this.m_scaleCheckBox.isSelected() ^ true, this.m_scaleCheckBox.isSelected());
            }
        } else if (e.getSource() == this.m_use1000SeperatorCheckBox) {
            this.m_use1000Seperator = this.m_use1000SeperatorCheckBox.isSelected();
            if (this.m_sentPropertyChangeEvent) {
                this.firePropertyChange(PROPERTY_THOUSAND_SEPARATOR, this.m_use1000SeperatorCheckBox.isSelected() ^ true, this.m_use1000SeperatorCheckBox.isSelected());
            }
        } else if (e.getSource() == this.m_currencySymbolCheckBox) {
            if (this.m_currencySymbolCheckBox.isSelected()) {
                this.m_dollarSignComboBox.setEnabled(true);
                this.m_dollarSignComboBox.setSelectedIndex(this.m_dollarSignComboBox.getSelectedIndex());
            } else {
                this.m_dollarSignComboBox.setEnabled(false);
            }
            this.m_useCurrencySymbol = this.m_currencySymbolCheckBox.isSelected();
            if (this.m_sentPropertyChangeEvent) {
                this.firePropertyChange(PROPERTY_CURRENCY_SYMBOL_USED, this.m_currencySymbolCheckBox.isSelected() ^ true, this.m_currencySymbolCheckBox.isSelected());
            }
        } else if (e.getSource() == this.m_dollarSignComboBox) {
            Object oldValue = null;
            Object[] argND = new String[1];
            boolean head = false;
            switch (this.m_dollarSignComboBox.getSelectedIndex()) {
                case 0: {
                    head = true;
                }
                case 1: {
                    argND[0] = Dollar;
                    break;
                }
                case 2: {
                    argND[0] = Pound;
                    head = true;
                    break;
                }
                case 3: {
                    argND[0] = Yen;
                    head = true;
                    break;
                }
                case 4: {
                    head = true;
                }
                case 5: {
                    argND[0] = Euro;
                    break;
                }
                case 6: {
                    argND[0] = USD;
                    break;
                }
                case 7: {
                    argND[0] = JPY;
                    break;
                }
                case 8: {
                    argND[0] = GBP;
                    break;
                }
                case 9: {
                    argND[0] = EUR;
                    break;
                }
                case 10: {
                    argND[0] = (String)this.m_dollarSignComboBox.getSelectedItem();
                    if (this.m_defaultFormat != HEAD_CURR_DEFAULT_STR) break;
                    head = true;
                    break;
                }
            }
            if (this.m_sentPropertyChangeEvent) {
                this.firePropertyChange(PROPERTY_POSITIVE_FORMAT, null, new Integer(this.getPositiveFormat(this.m_viewFormat, head)));
            }
            this.m_negativeListVectorForCur = new Vector();
            String translatedText = NegCur0;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur1;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur2;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur3;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur4;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur5;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur6;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur7;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            if (this.getCustomNumberFormatType() != 2) {
                translatedText = NegCur0;
                translatedText = MessageFormat.format(translatedText, argND);
                this.m_negativeListVectorForCur.addElement(translatedText);
                translatedText = NegCur1;
                translatedText = MessageFormat.format(translatedText, argND);
                this.m_negativeListVectorForCur.addElement(translatedText);
                translatedText = NegCur2;
                translatedText = MessageFormat.format(translatedText, argND);
                this.m_negativeListVectorForCur.addElement(translatedText);
                translatedText = NegCur3;
                translatedText = MessageFormat.format(translatedText, argND);
                this.m_negativeListVectorForCur.addElement(translatedText);
                translatedText = NegCur4;
                translatedText = MessageFormat.format(translatedText, argND);
                this.m_negativeListVectorForCur.addElement(translatedText);
                translatedText = NegCur5;
                translatedText = MessageFormat.format(translatedText, argND);
                this.m_negativeListVectorForCur.addElement(translatedText);
                translatedText = NegCur6;
                translatedText = MessageFormat.format(translatedText, argND);
                this.m_negativeListVectorForCur.addElement(translatedText);
                translatedText = NegCur7;
                translatedText = MessageFormat.format(translatedText, argND);
                this.m_negativeListVectorForCur.addElement(translatedText);
                this.m_negativeList.setListData(this.m_negativeListVectorForCur);
                this.m_negativeList.setSelectedIndex(this.m_currencyNegativeType);
            }
            if (this.m_sentPropertyChangeEvent) {
                this.firePropertyChange(PROPERTY_DOLLAR_SIGN, oldValue, argND[0]);
            }
        } else if (e.getSource() == this.m_customInsert) {
            int offset = this.m_customTypeTextField.getCaretPosition();
            String insertString = null;
            switch (this.m_customInsert.getSelectedIndex()) {
                case 0: {
                    insertString = ",";
                    break;
                }
                case 1: {
                    insertString = ".";
                    break;
                }
                case 2: {
                    insertString = "$";
                    break;
                }
                case 3: {
                    insertString = "0";
                    break;
                }
                case 4: {
                    insertString = "9";
                    break;
                }
                case 5: {
                    insertString = "D";
                    break;
                }
                case 6: {
                    insertString = "S";
                    break;
                }
                case 7: {
                    insertString = "G";
                    break;
                }
                case 8: {
                    insertString = "C";
                    break;
                }
                case 9: {
                    insertString = "L";
                    break;
                }
                case 10: {
                    insertString = "U";
                    break;
                }
            }
            try {
                this.m_customTypeTextField.getDocument().insertString(offset, insertString, null);
            }
            catch (Exception insertException) {}
        } else if (e.getSource() == this.m_customAddButton) {
            if (this.m_customTypeTextField.getText() != null) {
                ViewFormat tmp = new ViewFormat();
                boolean valid = tmp.validateFormatString(this.m_customTypeTextField.getText(), this.getCustomNumberFormatType());
                if (!valid) {
                    this.displayErrorMessage("NumberFormatError");
                    this.m_customTypeTextField.requestFocus();
                    return;
                }
                this.m_customTypeVector.addElement(this.m_customTypeTextField.getText());
                this.m_customTypeList.setListData(this.m_customTypeVector);
                this.m_customTypeList.setSelectedIndex(this.m_customTypeVector.size() - 1);
                this.m_customTypeTextField.setText("");
            }
        } else if (e.getSource() == this.m_customDeleteButton && this.m_customTypeList.getSelectedIndex() > -1) {
            int index = this.m_customTypeList.getSelectedIndex();
            this.m_customTypeVector.removeElementAt(this.m_customTypeList.getSelectedIndex());
            this.m_customTypeList.setListData(this.m_customTypeVector);
            if (index < this.m_customTypeVector.size()) {
                this.m_customTypeList.setSelectedIndex(index);
            } else if (index > 0) {
                this.m_customTypeList.setSelectedIndex(index - 1);
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.m_customTypeList && this.m_customTypeList.getSelectedIndex() > -1) {
            if (this.m_sentPropertyChangeEvent && this.m_customTypeList.getSelectedValue() != null) {
                this.firePropertyChange(PROPERTY_CUSTOM_TYPE_CHANGE, null, this.m_customTypeList.getSelectedValue());
            }
        } else if (e.getSource() == this.m_typeList) {
            this.processCategory(this.m_typeList.getSelectionModel().getLeadSelectionIndex());
        } else if (e.getSource() == this.m_negativeList) {
            if (this.m_negativeList.getSelectedIndex() == -1) {
                return;
            }
            int type = this.getFormatType();
            if (type == 2) {
                this.m_oldSelectedNegativeType = this.m_numberNegativeType;
                this.m_numberNegativeType = this.m_negativeList.getSelectedIndex();
                this.m_negativeRed = this.m_negativeList.getSelectedIndex() >= 3;
            } else if (type == 3) {
                this.m_oldSelectedNegativeType = this.m_currencyNegativeType;
                this.m_currencyNegativeType = this.m_negativeList.getSelectedIndex();
                this.m_negativeRed = this.m_negativeList.getSelectedIndex() >= 8;
            }
            this.typeChanged(PROPERTY_NEGATIVENUMBER_TYPE_CHANGE, this.m_negativeList.getSelectedIndex());
        }
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setDefaultFormat(String format) {
        this.m_defaultFormatSet = true;
        this.m_defaultFormat = format;
    }

    public String getDefaultFormat() {
        return this.m_defaultFormat;
    }

    public int getFormatType() {
        switch (this.m_typeList.getSelectedIndex()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
        }
        return 6;
    }

    public void setFormatType(int formatType) {
        switch (formatType) {
            case 0: {
                this.m_typeList.setSelectedIndex(1);
                break;
            }
            case 1: {
                this.m_typeList.setSelectedIndex(2);
                break;
            }
            case 2: {
                this.m_typeList.setSelectedIndex(3);
                break;
            }
            case 3: {
                this.m_typeList.setSelectedIndex(4);
                break;
            }
            case 4: {
                this.m_typeList.setSelectedIndex(5);
                break;
            }
            case 5: {
                this.m_typeList.setSelectedIndex(6);
                break;
            }
            case 6: {
                this.m_typeList.setSelectedIndex(0);
            }
            default: {
                this.m_typeList.setSelectedIndex(0);
            }
        }
    }

    public int getDecimalPlaces() {
        return this.m_decimalSpinBox.getIntValue();
    }

    public void setDecimalPlaces(int value) {
        this.m_decimalSpinBox.setIntValue(value);
    }

    public boolean isShowThousandSeparator() {
        return this.m_use1000Seperator;
    }

    public void setShowThousandSeparator(boolean show) {
        this.m_use1000Seperator = show;
        if (this.getFormatType() == 2 || this.getFormatType() == 3) {
            this.m_use1000SeperatorCheckBox.setSelected(show);
        }
    }

    public boolean isShowCurrencySymbol() {
        return this.m_useCurrencySymbol;
    }

    public void setShowCurrencySymbol(boolean show) {
        this.m_useCurrencySymbol = show;
        if (this.getFormatType() == 3) {
            this.m_currencySymbolCheckBox.setSelected(show);
        }
    }

    public void addDollarSign(String sign) {
        this.m_dollarSignComboBox.addItem(sign);
    }

    public void removeDollarSign(String sign) {
        this.m_dollarSignComboBox.removeItem(sign);
    }

    public String getDollarSign() {
        String cs = null;
        switch (this.m_dollarSignComboBox.getSelectedIndex()) {
            case 0: 
            case 1: {
                cs = Dollar;
                break;
            }
            case 2: {
                cs = Pound;
                break;
            }
            case 3: {
                cs = Yen;
                break;
            }
            case 4: 
            case 5: {
                cs = Euro;
                break;
            }
            case 6: {
                cs = USD;
                break;
            }
            case 7: {
                cs = JPY;
                break;
            }
            case 8: {
                cs = GBP;
                break;
            }
            case 9: {
                cs = EUR;
                break;
            }
            case 10: {
                cs = (String)this.m_dollarSignComboBox.getSelectedItem();
                break;
            }
        }
        return cs;
    }

    public void setDollarSign(String dollarSign) {
        this.m_dollarSignComboBox.setSelectedItem(dollarSign);
    }

    public boolean isScale() {
        return this.m_scaleCheckBox.isSelected();
    }

    public void setScale(boolean scale) {
        this.m_scaleCheckBox.setSelected(scale);
    }

    public void setScaleFactor(int factor) {
        if (factor != 0) {
            this.m_scaleComboBox.setSelectedIndex(factor - 1);
        }
    }

    public boolean isShowScaleMark() {
        return this.m_defaultScaleMarkCheckBox.isSelected();
    }

    public void setShowScaleMark(boolean show) {
        this.m_defaultScaleMarkCheckBox.setSelected(show);
    }

    public ViewFormat getViewFormat() {
        return this.m_viewFormat;
    }

    public void setViewFormat(ViewFormat viewFormat) {
        this.m_viewFormat = viewFormat;
        this.m_sentPropertyChangeEvent = false;
        this.init(viewFormat);
        this.m_sentPropertyChangeEvent = true;
    }

    public int getScaleFactor() {
        switch (this.m_scaleComboBox.getSelectedIndex()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 0;
    }

    public int getNegativeFormat() {
        if (this.m_negativeList.getSelectedIndex() >= this.m_negativeListCellRenderer.getRedIndex()) {
            return this.m_negativeList.getSelectedIndex() - this.m_negativeListCellRenderer.getRedIndex();
        }
        return this.m_negativeList.getSelectedIndex();
    }

    public boolean isNegativeRed() {
        return this.m_negativeRed;
    }

    public void setNegativeRed(boolean red) {
        this.m_negativeRed = red;
    }

    public void setNumberNegativeType(int type, boolean red) {
        this.m_numberNegativeType = red ? type + 3 : type;
        this.m_oldSelectedNegativeType = this.m_numberNegativeType;
    }

    public void setCurrencyNegativeType(int type, boolean red) {
        this.m_currencyNegativeType = red ? type + 8 : type;
        this.m_oldSelectedNegativeType = this.m_currencyNegativeType;
    }

    public String getCurrentCustomPatternString() {
        if (this.m_customTypeList.getSelectedValue() != null) {
            return (String)this.m_customTypeList.getSelectedValue();
        }
        return this.getDefaultFormat();
    }

    public void cleanUp() {
        this.m_typeList.removeListSelectionListener(this);
        this.m_customTypeList.removeListSelectionListener(this);
        this.m_customTypeTextField.removeCaretListener(this.m_caretListener);
        this.m_caretListener = null;
        this.m_negativeLabel.setLabelFor(null);
        this.m_scrollPane.setViewportView(null);
        this.m_negativeList.setCellRenderer(null);
        this.m_negativeListCellRenderer = null;
        this.m_negativeList = null;
    }

    protected void processCategory(int iSelection) {
        if (iSelection != 0 && this.m_viewFormat == null) {
            this.m_viewFormat = new ViewFormat();
        }
        switch (iSelection) {
            case 0: {
                this.m_rightPanel.removeAll();
                this.m_rightPanel.add(new JLabel("   "));
                if (this.m_type == 0) {
                    this.m_descriptionLabel.setText(this.rBundle.getString("NumberNotSpecifiedDesc"));
                } else {
                    this.m_descriptionLabel.setText(this.rBundle.getString("NumberNotSpecifiedDescTable"));
                }
                this.m_rightPanel.add(this.m_nonePanel);
                this.m_customTypeLabel.setVisible(false);
                this.m_nonePanel.validate();
                this.typeChanged(PROPERTY_TYPE_CHANGE, 6);
                this.m_rightPanel.invalidate();
                this.m_rightPanel.validate();
                this.m_rightPanel.repaint();
                this.m_negativeRed = false;
                break;
            }
            case 1: {
                this.m_rightPanel.removeAll();
                this.m_rightPanel.add(new JLabel("   "));
                this.m_descriptionLabel.setText(this.rBundle.getString("Number Nono description"));
                this.m_rightPanel.add(this.m_nonePanel);
                this.m_customTypeLabel.setVisible(false);
                this.m_nonePanel.invalidate();
                this.m_nonePanel.validate();
                this.m_nonePanel.repaint();
                this.typeChanged(PROPERTY_TYPE_CHANGE, 0);
                this.m_rightPanel.invalidate();
                this.m_rightPanel.validate();
                this.m_rightPanel.repaint();
                this.m_negativeRed = false;
                break;
            }
            case 2: {
                this.m_rightPanel.removeAll();
                this.m_rightPanel.add(new JLabel("   "));
                this.m_descriptionLabel.setText(this.rBundle.getString("Number Default description") + "\"" + this.m_defaultFormat + "\"");
                this.m_rightPanel.add(this.m_nonePanel);
                this.m_customTypeLabel.setVisible(false);
                this.m_nonePanel.invalidate();
                this.m_nonePanel.validate();
                this.m_nonePanel.repaint();
                this.typeChanged(PROPERTY_TYPE_CHANGE, 1);
                this.m_rightPanel.invalidate();
                this.m_rightPanel.validate();
                this.m_rightPanel.repaint();
                this.m_negativeRed = false;
                break;
            }
            case 3: {
                this.m_rightPanel.removeAll();
                this.m_rightPanel.add(new JLabel("   "));
                String translatedText = this.rBundle.getString("Separator");
                DecimalFormatSymbols decimalFormatSymbols1 = this.m_viewFormat != null && this.m_viewFormat.getLocale() != null ? new DecimalFormatSymbols(this.m_viewFormat.getLocale()) : new DecimalFormatSymbols();
                translatedText = translatedText + "(" + decimalFormatSymbols1.getGroupingSeparator() + ") ";
                this.m_use1000SeperatorCheckBox.setText(StringUtils.stripMnemonic((String)translatedText));
                this.m_use1000SeperatorCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                int width = this.getToolkit().getFontMetrics(this.m_use1000SeperatorCheckBox.getFont()).stringWidth(this.m_use1000SeperatorCheckBox.getText());
                this.m_use1000SeperatorCheckBox.setPreferredSize(new Dimension(width + 22, 22));
                this.m_use1000SeperatorCheckBox.setMinimumSize(this.m_use1000SeperatorCheckBox.getPreferredSize());
                this.m_use1000SeperatorCheckBox.setMaximumSize(this.m_use1000SeperatorCheckBox.getPreferredSize());
                this.m_use1000SeperatorCheckBox.setVisible(true);
                this.m_currencySymbolCheckBox.setVisible(false);
                this.m_customTypeLabel.setVisible(false);
                this.m_dollarSignComboBox.setVisible(false);
                this.m_scaleCheckBox.setVisible(true);
                this.m_scaleComboBox.setVisible(true);
                this.m_defaultScaleMarkCheckBox.setVisible(true);
                this.m_negativeLabel.setVisible(true);
                this.m_negativeList.setListData(this.m_negativeListVector);
                this.m_negativeListCellRenderer.setRedIndex(3);
                this.m_negativeList.setSelectedIndex(this.m_numberNegativeType);
                this.m_scrollPane.setVisible(true);
                this.m_negativeList.setVisible(true);
                this.m_use1000SeperatorCheckBox.setSelected(this.m_use1000Seperator);
                this.m_rightPanel.add(this.m_numberPanel);
                this.m_numberPanel.invalidate();
                this.m_numberPanel.validate();
                this.m_numberPanel.repaint();
                this.typeChanged(PROPERTY_TYPE_CHANGE, 2);
                this.m_rightPanel.invalidate();
                this.m_rightPanel.validate();
                this.m_rightPanel.repaint();
                break;
            }
            case 4: {
                this.m_rightPanel.removeAll();
                this.m_rightPanel.add(new JLabel("   "));
                String translatedText = this.rBundle.getString("Separator");
                DecimalFormatSymbols decimalFormatSymbols = this.m_viewFormat != null && this.m_viewFormat.getLocale() != null ? new DecimalFormatSymbols(this.m_viewFormat.getLocale()) : new DecimalFormatSymbols();
                translatedText = translatedText + "(" + decimalFormatSymbols.getGroupingSeparator() + ") ";
                this.m_use1000SeperatorCheckBox.setText(StringUtils.stripMnemonic((String)translatedText));
                this.m_use1000SeperatorCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                int width = this.getToolkit().getFontMetrics(this.m_use1000SeperatorCheckBox.getFont()).stringWidth(this.m_use1000SeperatorCheckBox.getText());
                this.m_use1000SeperatorCheckBox.setPreferredSize(new Dimension(width + 22, 22));
                this.m_use1000SeperatorCheckBox.setMinimumSize(this.m_use1000SeperatorCheckBox.getPreferredSize());
                this.m_use1000SeperatorCheckBox.setMaximumSize(this.m_use1000SeperatorCheckBox.getPreferredSize());
                this.m_use1000SeperatorCheckBox.setVisible(true);
                this.m_currencySymbolCheckBox.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Use currency symbol")));
                this.m_currencySymbolCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Use currency symbol")));
                width = this.getToolkit().getFontMetrics(this.m_use1000SeperatorCheckBox.getFont()).stringWidth(this.m_use1000SeperatorCheckBox.getText());
                this.m_currencySymbolCheckBox.setPreferredSize(new Dimension(width + 22, 22));
                this.m_currencySymbolCheckBox.setMinimumSize(this.m_use1000SeperatorCheckBox.getPreferredSize());
                this.m_currencySymbolCheckBox.setMaximumSize(this.m_use1000SeperatorCheckBox.getPreferredSize());
                this.m_dollarSignComboBox.setVisible(true);
                this.m_customTypeLabel.setVisible(false);
                this.m_currencySymbolCheckBox.setVisible(true);
                this.m_scaleCheckBox.setVisible(true);
                this.m_scaleComboBox.setVisible(true);
                this.m_defaultScaleMarkCheckBox.setVisible(true);
                this.m_negativeLabel.setVisible(true);
                this.m_negativeList.setVisible(true);
                this.m_negativeList.setListData(this.m_negativeListVectorForCur);
                this.m_negativeListCellRenderer.setRedIndex(8);
                this.m_negativeList.setSelectedIndex(this.m_currencyNegativeType);
                this.m_negativeList.repaint();
                this.m_scrollPane.setVisible(true);
                this.m_currencySymbolCheckBox.setSelected(this.m_useCurrencySymbol);
                this.m_dollarSignComboBox.setEnabled(this.m_currencySymbolCheckBox.isSelected());
                this.m_rightPanel.add(this.m_numberPanel);
                this.m_numberPanel.invalidate();
                this.m_numberPanel.validate();
                this.m_numberPanel.repaint();
                this.typeChanged(PROPERTY_TYPE_CHANGE, 3);
                this.m_rightPanel.invalidate();
                this.m_rightPanel.validate();
                this.m_rightPanel.repaint();
                break;
            }
            case 5: {
                this.m_rightPanel.removeAll();
                this.m_rightPanel.add(new JLabel("   "));
                this.m_dollarSignComboBox.setVisible(false);
                this.m_customTypeLabel.setVisible(false);
                this.m_use1000SeperatorCheckBox.setVisible(false);
                this.m_currencySymbolCheckBox.setVisible(false);
                this.m_scaleCheckBox.setVisible(false);
                this.m_scaleComboBox.setVisible(false);
                this.m_defaultScaleMarkCheckBox.setVisible(false);
                this.m_negativeLabel.setVisible(false);
                this.m_negativeList.setVisible(false);
                this.m_scrollPane.setVisible(false);
                this.m_rightPanel.add(this.m_numberPanel);
                this.m_numberPanel.invalidate();
                this.m_numberPanel.validate();
                this.m_numberPanel.repaint();
                this.typeChanged(PROPERTY_TYPE_CHANGE, 4);
                this.m_rightPanel.invalidate();
                this.m_rightPanel.validate();
                this.m_rightPanel.repaint();
                this.m_negativeRed = false;
                break;
            }
            case 6: {
                this.m_customTypeLabel.setVisible(true);
                this.m_rightPanel.removeAll();
                this.m_rightPanel.add(this.m_customPanel);
                this.m_customPanel.invalidate();
                this.m_customPanel.validate();
                this.m_customPanel.repaint();
                this.typeChanged(PROPERTY_TYPE_CHANGE, 5);
                this.m_rightPanel.invalidate();
                this.m_rightPanel.validate();
                this.m_rightPanel.repaint();
                this.m_negativeRed = false;
                break;
            }
        }
    }

    void setViewType(int type) {
        this.m_type = type;
    }

    public char getGroupSeparator() {
        if (this.m_viewFormat != null && this.m_viewFormat.getLocale() != null) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(this.m_viewFormat.getLocale());
            return decimalFormatSymbols.getGroupingSeparator();
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        return decimalFormatSymbols.getGroupingSeparator();
    }

    protected void typeChanged(String eventType, int currentType) {
        if (eventType.equals(PROPERTY_TYPE_CHANGE)) {
            if (this.m_oldSelectedType != currentType && this.m_oldSelectedType != -1 && this.m_sentPropertyChangeEvent) {
                this.firePropertyChange(PROPERTY_TYPE_CHANGE, this.m_oldSelectedType, currentType);
            }
            this.m_oldSelectedType = currentType;
        } else if (eventType.equals(PROPERTY_NEGATIVENUMBER_TYPE_CHANGE)) {
            if (this.m_oldSelectedNegativeType != currentType && this.m_oldSelectedNegativeType != -1 && this.m_sentPropertyChangeEvent) {
                this.firePropertyChange(PROPERTY_NEGATIVENUMBER_TYPE_CHANGE, this.m_oldSelectedNegativeType, currentType);
            }
            this.m_oldSelectedNegativeType = currentType;
        }
    }

    protected int getPositiveFormat(ViewFormat viewFormat, boolean head) {
        int position = 1;
        if (!head) {
            int oldPos = viewFormat.getPosCurFmtValue();
            switch (oldPos) {
                case 0: {
                    position = 1;
                    break;
                }
                case 2: {
                    position = 3;
                    break;
                }
                case 4: {
                    position = 6;
                    break;
                }
                case 5: {
                    position = 8;
                    break;
                }
                case 10: {
                    position = 9;
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: {
                    position = oldPos;
                    break;
                }
            }
        } else if (head) {
            position = 0;
            int oldPos = viewFormat.getPosCurFmtValue();
            switch (oldPos) {
                case 0: 
                case 2: 
                case 4: 
                case 5: 
                case 10: {
                    position = oldPos;
                    break;
                }
                case 1: {
                    position = 0;
                    break;
                }
                case 3: {
                    position = 2;
                    break;
                }
                case 6: {
                    position = 4;
                    break;
                }
                case 8: {
                    position = 5;
                    break;
                }
                case 7: 
                case 9: 
                case 11: {
                    position = 10;
                    break;
                }
            }
        }
        return position;
    }

    protected boolean setCurrencyIndex(ViewFormat viewFormat, String currSym) {
        if (currSym.equals(Dollar) || currSym.equals(Euro)) {
            boolean head = false;
            switch (viewFormat.getPosCurFmtValue()) {
                case 0: 
                case 2: 
                case 4: 
                case 5: 
                case 10: {
                    head = true;
                    break;
                }
            }
            if (currSym.equals(Dollar)) {
                if (head) {
                    this.m_dollarSignComboBox.setSelectedItem(DollarSign0);
                } else {
                    this.m_dollarSignComboBox.setSelectedItem(DollarSign00);
                }
            } else if (currSym.equals(Euro)) {
                if (head) {
                    this.m_dollarSignComboBox.setSelectedItem(DollarSign3);
                } else {
                    this.m_dollarSignComboBox.setSelectedItem(DollarSign33);
                }
            }
        } else if (currSym.equals(Pound)) {
            this.m_dollarSignComboBox.setSelectedItem(DollarSign1);
        } else if (currSym.equals(Yen)) {
            this.m_dollarSignComboBox.setSelectedItem(DollarSign2);
        } else if (currSym.equals(USD)) {
            this.m_dollarSignComboBox.setSelectedItem(DollarSign4);
        } else if (currSym.equals(JPY)) {
            this.m_dollarSignComboBox.setSelectedItem(DollarSign5);
        } else if (currSym.equals(GBP)) {
            this.m_dollarSignComboBox.setSelectedItem(DollarSign6);
        } else if (currSym.equals(EUR)) {
            this.m_dollarSignComboBox.setSelectedItem(DollarSign7);
        } else if (currSym.equals(viewFormat.getCurrencySymbol())) {
            this.m_dollarSignComboBox.setSelectedItem(viewFormat.getCurrencySymbol());
        } else {
            return false;
        }
        return true;
    }

    protected ViewFormat createViewFormat() {
        ViewFormat viewFormat = new ViewFormat();
        viewFormat.setLocale(this.getLocale());
        viewFormat.setLeadingZero(true);
        viewFormat.setDecimalDigit(this.m_decimalSpinBox.getIntValue());
        viewFormat.setScaleFactor(0);
        viewFormat.setNumberType(0);
        return viewFormat;
    }

    protected ViewFormat getPercentageFormat() {
        ViewFormat viewFormat = this.createViewFormat();
        viewFormat.setNumberType(2);
        return viewFormat;
    }

    protected Locale getCustomCurrencyLocale() {
        return this.m_customCurrencyLocale;
    }

    protected void setFormatType(ViewFormat viewFormat) {
        if (viewFormat != null) {
            int nNumberFormatType;
            int n = nNumberFormatType = viewFormat.isPercentUsed() ? 4 : viewFormat.getNumberType();
            if (viewFormat.getNumberType() == 1) {
                nNumberFormatType = 3;
            }
            this.m_typeList.setSelectedIndex(nNumberFormatType);
        } else {
            this.m_typeList.setSelectedIndex(0);
        }
    }

    public void setGraphFormatType() {
        int index = 0;
        if (this.m_viewFormat == null) {
            index = 0;
            System.out.println("null format");
        } else {
            switch (this.m_viewFormat.getNumberType()) {
                case 0: {
                    index = 0;
                    break;
                }
                case 1: {
                    index = 1;
                    break;
                }
                case 2: {
                    index = 2;
                    break;
                }
                default: {
                    index = 0;
                    break;
                }
            }
        }
        this.m_typeList.setSelectedIndex(index);
    }

    private void initConstructor(ViewFormat viewFormat, int nCustomNumberFormatType) {
        this.setCustomNumberFormatType(nCustomNumberFormatType);
        this.m_viewFormat = viewFormat;
        this.updateResourceBundle(null);
        this.initialize(viewFormat);
    }

    protected void initialize(ViewFormat viewFormat) {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        String translatedText = this.rBundle.getString("NumberCategories");
        this.m_categoryLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_categoryLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_categoryLabel.setAlignmentX(0.0f);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPreferredSize().height - 20));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.setAlignmentX(0.0f);
        int maxCategoryWidth = this.getToolkit().getFontMetrics(this.m_categoryLabel.getFont()).stringWidth(this.m_categoryLabel.getText());
        this.typeList = new Vector();
        translatedText = this.rBundle.getString("NotSpecified");
        maxCategoryWidth = Math.max(maxCategoryWidth, this.getToolkit().getFontMetrics(this.m_categoryLabel.getFont()).stringWidth(translatedText));
        this.typeList.addElement(translatedText);
        translatedText = this.rBundle.getString("None");
        maxCategoryWidth = Math.max(maxCategoryWidth, this.getToolkit().getFontMetrics(this.m_categoryLabel.getFont()).stringWidth(translatedText));
        this.typeList.addElement(translatedText);
        translatedText = this.rBundle.getString("Default");
        maxCategoryWidth = Math.max(maxCategoryWidth, this.getToolkit().getFontMetrics(this.m_categoryLabel.getFont()).stringWidth(translatedText));
        this.typeList.addElement(translatedText);
        translatedText = this.rBundle.getString("Number");
        maxCategoryWidth = Math.max(maxCategoryWidth, this.getToolkit().getFontMetrics(this.m_categoryLabel.getFont()).stringWidth(translatedText));
        this.typeList.addElement(translatedText);
        translatedText = this.rBundle.getString("Currency");
        maxCategoryWidth = Math.max(maxCategoryWidth, this.getToolkit().getFontMetrics(this.m_categoryLabel.getFont()).stringWidth(translatedText));
        this.typeList.addElement(translatedText);
        translatedText = this.rBundle.getString("Percent");
        maxCategoryWidth = Math.max(maxCategoryWidth, this.getToolkit().getFontMetrics(this.m_categoryLabel.getFont()).stringWidth(translatedText));
        this.typeList.addElement(translatedText);
        translatedText = this.rBundle.getString("Custom");
        maxCategoryWidth = Math.max(maxCategoryWidth, this.getToolkit().getFontMetrics(this.m_categoryLabel.getFont()).stringWidth(translatedText));
        this.typeList.addElement(translatedText);
        this.m_typeList = new JList(this.typeList);
        this.m_typeList.setName("NumberCategories");
        this.m_typeList.setSelectionMode(0);
        this.m_typeList.addListSelectionListener(this);
        this.m_typeList.setAlignmentX(0.0f);
        this.m_scrollPaneType = new JScrollPane(this.m_typeList);
        this.m_scrollPaneType.setVerticalScrollBarPolicy(20);
        this.m_scrollPaneType.setHorizontalScrollBarPolicy(30);
        this.m_scrollPaneType.setAlignmentX(0.0f);
        leftPanel.add(this.m_categoryLabel);
        leftPanel.add(Box.createVerticalStrut(3));
        leftPanel.add(this.m_scrollPaneType);
        this.m_categoryLabel.setLabelFor(this.m_typeList);
        leftPanel.setPreferredSize(new Dimension(maxCategoryWidth + 22, this.getToolkit().getScreenSize().height - 20));
        leftPanel.setMinimumSize(leftPanel.getPreferredSize());
        leftPanel.setMaximumSize(leftPanel.getPreferredSize());
        int width = this.getPreferredSize().width - leftPanel.getPreferredSize().width - 30;
        this.m_rightPanel = new JPanel();
        this.m_rightPanel.setLayout(new BoxLayout(this.m_rightPanel, 1));
        this.m_rightPanel.setPreferredSize(new Dimension(width, leftPanel.getPreferredSize().height));
        this.m_rightPanel.setAlignmentX(0.0f);
        this.m_nonePanel = new JPanel();
        this.m_nonePanel.setLayout(new BoxLayout(this.m_nonePanel, 1));
        translatedText = this.rBundle.getString("NumberNotSpecifiedDesc");
        this.m_descriptionLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), translatedText);
        this.m_nonePanel.add((Component)this.m_descriptionLabel);
        this.m_numberPanel = new JPanel();
        this.m_numberPanel.setLayout(new BoxLayout(this.m_numberPanel, 1));
        this.m_numberPanel.setPreferredSize(new Dimension(width, this.m_numberPanel.getPreferredSize().height));
        this.m_numberPanel.setAlignmentX(0.0f);
        this.m_decimalPanel = new JPanel();
        this.m_decimalPanel.setLayout(new BoxLayout(this.m_decimalPanel, 0));
        this.m_decimalPanel.setPreferredSize(new Dimension(width, 22));
        this.m_decimalPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Decimal Places:");
        this.m_decimalLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_decimalLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_decimalLabel.setAlignmentX(0.0f);
        this.m_decimalSpinBox = new NumericSpinBox(0, 50);
        this.m_decimalSpinBox.setName(PROPERTY_DECIMAL_PLACES);
        this.m_decimalSpinBox.setPreferredSize(new Dimension(50, 20));
        this.m_decimalSpinBox.setMinimumSize(this.m_decimalSpinBox.getPreferredSize());
        this.m_decimalSpinBox.setMaximumSize(this.m_decimalSpinBox.getPreferredSize());
        this.m_decimalSpinBox.setAlignmentX(0.0f);
        this.m_decimalLabel.setLabelFor((Component)this.m_decimalSpinBox);
        this.m_decimalPanel.add(this.m_decimalLabel);
        this.m_decimalPanel.add((Component)this.m_decimalSpinBox);
        JPanel separatorPanel = new JPanel();
        separatorPanel.setLayout(new BoxLayout(separatorPanel, 0));
        separatorPanel.setPreferredSize(new Dimension(width, 22));
        separatorPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Separator");
        DecimalFormatSymbols decimalFormatSymbols = this.m_viewFormat != null && this.m_viewFormat.getLocale() != null ? new DecimalFormatSymbols(this.m_viewFormat.getLocale()) : new DecimalFormatSymbols();
        translatedText = translatedText + "(" + decimalFormatSymbols.getGroupingSeparator() + ") ";
        this.m_use1000SeperatorCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_use1000SeperatorCheckBox.setName("Use1000Separator");
        this.m_use1000SeperatorCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        int separatorWidth = this.getToolkit().getFontMetrics(this.m_use1000SeperatorCheckBox.getFont()).stringWidth(this.m_use1000SeperatorCheckBox.getText());
        this.m_use1000SeperatorCheckBox.setPreferredSize(new Dimension(separatorWidth + 15, 22));
        this.m_use1000SeperatorCheckBox.setMinimumSize(this.m_use1000SeperatorCheckBox.getPreferredSize());
        this.m_use1000SeperatorCheckBox.setMaximumSize(this.m_use1000SeperatorCheckBox.getPreferredSize());
        this.m_use1000SeperatorCheckBox.setAlignmentX(0.0f);
        this.m_currencySymbolCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_currencySymbolCheckBox.setName("UseCurrencySymbol");
        this.m_currencySymbolCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        separatorWidth = this.getToolkit().getFontMetrics(this.m_currencySymbolCheckBox.getFont()).stringWidth(this.m_currencySymbolCheckBox.getText());
        this.m_currencySymbolCheckBox.setPreferredSize(new Dimension(separatorWidth + 15, 22));
        this.m_currencySymbolCheckBox.setMinimumSize(this.m_currencySymbolCheckBox.getPreferredSize());
        this.m_currencySymbolCheckBox.setMaximumSize(this.m_currencySymbolCheckBox.getPreferredSize());
        this.m_currencySymbolCheckBox.setAlignmentX(0.0f);
        currencySymbol = decimalFormatSymbols.getCurrencySymbol();
        this.m_vectorDollarSign = new Vector();
        this.m_vectorDollarSign.addElement(DollarSign0);
        this.m_vectorDollarSign.addElement(DollarSign00);
        this.m_vectorDollarSign.addElement(DollarSign1);
        this.m_vectorDollarSign.addElement(DollarSign2);
        this.m_vectorDollarSign.addElement(DollarSign3);
        this.m_vectorDollarSign.addElement(DollarSign33);
        this.m_vectorDollarSign.addElement(DollarSign4);
        this.m_vectorDollarSign.addElement(DollarSign5);
        this.m_vectorDollarSign.addElement(DollarSign6);
        this.m_vectorDollarSign.addElement(DollarSign7);
        if (!(currencySymbol.equals(Dollar) || currencySymbol.equals(Pound) || currencySymbol.equals(Yen) || currencySymbol.equals(Euro))) {
            this.m_vectorDollarSign.addElement(currencySymbol);
        }
        this.m_dollarSignComboBox = new JComboBox(this.m_vectorDollarSign);
        this.m_dollarSignComboBox.setName("CurrencySymbolCombo");
        this.m_dollarSignComboBox.setMinimumSize(this.m_dollarSignComboBox.getPreferredSize());
        this.m_dollarSignComboBox.setMaximumSize(this.m_dollarSignComboBox.getPreferredSize());
        this.m_dollarSignComboBox.setAlignmentX(0.0f);
        separatorPanel.add(this.m_currencySymbolCheckBox);
        separatorPanel.add(this.m_dollarSignComboBox);
        JPanel scalePanel = new JPanel();
        scalePanel.setLayout(new BoxLayout(scalePanel, 0));
        scalePanel.setPreferredSize(new Dimension(width, 22));
        scalePanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString(PROPERTY_SCALE);
        this.m_scaleCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_scaleCheckBox.setName("ScaleToCheckbox");
        this.m_scaleCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_scaleCheckBox.setAlignmentX(0.0f);
        this.m_scaleVector = new Vector();
        translatedText = this.rBundle.getString("Thousands");
        this.m_scaleVector.addElement(translatedText);
        translatedText = this.rBundle.getString("Millions");
        this.m_scaleVector.addElement(translatedText);
        translatedText = this.rBundle.getString("Billions");
        this.m_scaleVector.addElement(translatedText);
        translatedText = this.rBundle.getString("Trillions");
        this.m_scaleVector.addElement(translatedText);
        translatedText = this.rBundle.getString("Quadrillions");
        this.m_scaleVector.addElement(translatedText);
        this.m_scaleComboBox = new JComboBox(this.m_scaleVector);
        this.m_scaleComboBox.setName("ScaleToCombo");
        this.m_scaleComboBox.setPreferredSize(new Dimension(100, 22));
        this.m_scaleComboBox.setMinimumSize(new Dimension(100, 22));
        this.m_scaleComboBox.setMaximumSize(new Dimension(100, 22));
        scalePanel.add(this.m_scaleCheckBox);
        scalePanel.add(this.m_scaleComboBox);
        JPanel markPanel = new JPanel();
        markPanel.setLayout(new BoxLayout(markPanel, 0));
        markPanel.setPreferredSize(new Dimension(width, 22));
        markPanel.setAlignmentX(0.0f);
        Object[] arg = new String[]{this.rUtilBundle.getString("K")};
        arg[0] = "'" + arg[0] + "'";
        translatedText = this.rBundle.getString("Show 'K' for thousands");
        translatedText = MessageFormat.format(translatedText, arg);
        this.m_defaultScaleMarkCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_defaultScaleMarkCheckBox.setName("ShowDefaultScaleMark");
        this.m_defaultScaleMarkCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_defaultScaleMarkCheckBox.setAlignmentX(0.0f);
        markPanel.add(Box.createHorizontalStrut(17));
        markPanel.add(this.m_defaultScaleMarkCheckBox);
        JPanel negativePanel = new JPanel();
        negativePanel.setLayout(new BoxLayout(negativePanel, 0));
        negativePanel.setPreferredSize(new Dimension(width, 22));
        negativePanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Negative");
        this.m_negativeLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_negativeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_negativeLabel.setAlignmentX(0.0f);
        negativePanel.add(this.m_negativeLabel);
        JPanel negativeListPanel = new JPanel();
        negativeListPanel.setLayout(new BoxLayout(negativeListPanel, 0));
        negativeListPanel.setAlignmentX(0.0f);
        this.m_negativeListVector = new Vector();
        translatedText = Neg1;
        this.m_negativeListVector.addElement(translatedText);
        translatedText = Neg0;
        this.m_negativeListVector.addElement(translatedText);
        translatedText = Neg2;
        this.m_negativeListVector.addElement(translatedText);
        if (this.getCustomNumberFormatType() != 2) {
            translatedText = Neg1;
            this.m_negativeListVector.addElement(translatedText);
            translatedText = Neg0;
            this.m_negativeListVector.addElement(translatedText);
            translatedText = Neg2;
            this.m_negativeListVector.addElement(translatedText);
        }
        this.m_negativeListVectorForCur = new Vector();
        Object[] argND = new String[]{this.getDollarSign()};
        translatedText = NegCur0;
        translatedText = MessageFormat.format(translatedText, argND);
        this.m_negativeListVectorForCur.addElement(translatedText);
        translatedText = NegCur1;
        translatedText = MessageFormat.format(translatedText, argND);
        this.m_negativeListVectorForCur.addElement(translatedText);
        translatedText = NegCur2;
        translatedText = MessageFormat.format(translatedText, argND);
        this.m_negativeListVectorForCur.addElement(translatedText);
        translatedText = NegCur3;
        translatedText = MessageFormat.format(translatedText, argND);
        this.m_negativeListVectorForCur.addElement(translatedText);
        translatedText = NegCur4;
        translatedText = MessageFormat.format(translatedText, argND);
        this.m_negativeListVectorForCur.addElement(translatedText);
        translatedText = NegCur5;
        translatedText = MessageFormat.format(translatedText, argND);
        this.m_negativeListVectorForCur.addElement(translatedText);
        translatedText = NegCur6;
        translatedText = MessageFormat.format(translatedText, argND);
        this.m_negativeListVectorForCur.addElement(translatedText);
        translatedText = NegCur7;
        translatedText = MessageFormat.format(translatedText, argND);
        this.m_negativeListVectorForCur.addElement(translatedText);
        if (this.getCustomNumberFormatType() != 2) {
            translatedText = NegCur0;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur1;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur2;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur3;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur4;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur5;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur6;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
            translatedText = NegCur7;
            translatedText = MessageFormat.format(translatedText, argND);
            this.m_negativeListVectorForCur.addElement(translatedText);
        }
        this.m_negativeList = new JList(this.m_negativeListVector);
        this.m_negativeList.setName("NegativeNumbers");
        this.m_negativeListCellRenderer = new NegativeListCellRenderer();
        this.m_negativeList.setCellRenderer(this.m_negativeListCellRenderer);
        this.m_negativeList.setSelectionMode(0);
        this.m_negativeList.setBorder(BorderFactory.createEtchedBorder());
        this.m_negativeList.setSelectedIndex(0);
        this.m_negativeLabel.setLabelFor(this.m_negativeList);
        this.m_scrollPane = new JScrollPane(this.m_negativeList);
        this.m_scrollPane.setPreferredSize(new Dimension(140, 100));
        int minHeight = Math.min(this.m_negativeList.getMinimumSize().height, this.m_scrollPane.getPreferredSize().height);
        int maxHeight = Math.max(this.m_negativeList.getMaximumSize().height, this.m_scrollPane.getPreferredSize().height);
        this.m_scrollPane.setMinimumSize(new Dimension(this.m_scrollPane.getPreferredSize().width, minHeight));
        this.m_scrollPane.setMaximumSize(new Dimension(this.m_scrollPane.getPreferredSize().width, maxHeight));
        this.m_scrollPane.setVerticalScrollBarPolicy(20);
        if (this.m_scrollPane.getVerticalScrollBar() != null) {
            this.m_scrollPane.getVerticalScrollBar().setUnitIncrement(2);
        }
        negativeListPanel.add(this.m_scrollPane);
        this.m_numberPanel.add(this.m_decimalPanel);
        this.m_numberPanel.add(Box.createVerticalStrut(3));
        this.m_numberPanel.add(this.m_use1000SeperatorCheckBox);
        this.m_numberPanel.add(Box.createVerticalStrut(3));
        this.m_numberPanel.add(separatorPanel);
        this.m_numberPanel.add(Box.createVerticalStrut(3));
        this.m_numberPanel.add(scalePanel);
        this.m_numberPanel.add(markPanel);
        this.m_numberPanel.add(Box.createVerticalStrut(25));
        this.m_numberPanel.add(Box.createVerticalGlue());
        this.m_numberPanel.add(negativePanel);
        this.m_numberPanel.add(negativeListPanel);
        int iCustomPanelWidth = this.getToolkit().getScreenSize().width - leftPanel.getPreferredSize().width - 10 - 20;
        int iCustomPanelHeight = this.getToolkit().getScreenSize().height - 20;
        this.m_customPanel = new JPanel();
        this.m_customPanel.setLayout(new BoxLayout(this.m_customPanel, 1));
        this.m_customPanel.setPreferredSize(new Dimension(iCustomPanelWidth, iCustomPanelHeight));
        JPanel customListPanel = new JPanel();
        customListPanel.setLayout(new BoxLayout(customListPanel, 0));
        this.m_customTypeList = new JList(this.m_customTypeVector);
        this.m_customTypeList.setName("NumberCustomType");
        if (this.m_customTypeVector.size() == 0) {
            this.m_customTypeVector.addElement(this.getDefaultFormat());
        }
        this.m_customTypeList.setSelectionMode(0);
        this.m_customTypeList.setSelectedIndex(0);
        JScrollPane scrollPane = new JScrollPane(this.m_customTypeList);
        scrollPane.setPreferredSize(new Dimension(iCustomPanelWidth, iCustomPanelHeight - 7 - 24 - 16 - 24 - 7 - 22));
        scrollPane.setVerticalScrollBarPolicy(20);
        customListPanel.add(scrollPane);
        customListPanel.setAlignmentX(0.0f);
        JPanel customDeletePanel = new JPanel();
        customDeletePanel.setLayout(new BoxLayout(customDeletePanel, 0));
        translatedText = this.rBundle.getString("Delete");
        this.m_customDeleteButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_customDeleteButton.setName("NumberCustomDelete");
        this.m_customDeleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_customDeleteButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_customDeleteButton.addActionListener(this);
        JPanel delBtnPanel = new JPanel(new FlowLayout(2, 0, 0));
        delBtnPanel.add(this.m_customDeleteButton);
        customDeletePanel.add(delBtnPanel);
        customDeletePanel.setPreferredSize(new Dimension(this.m_rightPanel.getPreferredSize().width, this.m_customDeleteButton.getPreferredSize().height));
        customDeletePanel.setAlignmentX(0.0f);
        JPanel customInsertPanel = new JPanel();
        customInsertPanel.setLayout(new BoxLayout(customInsertPanel, 0));
        customInsertPanel.setPreferredSize(new Dimension(width, 24));
        translatedText = this.rBundle.getString("Edit Type");
        this.m_customEditTypeLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_customEditTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_customEditTypeLabel.setMinimumSize(this.m_customEditTypeLabel.getPreferredSize());
        this.m_customEditTypeLabel.setMaximumSize(this.m_customEditTypeLabel.getPreferredSize());
        this.m_customEditTypeLabel.setAlignmentX(0.0f);
        JPanel insLblPanel = new JPanel(new FlowLayout(0, 0, 0));
        insLblPanel.add(this.m_customEditTypeLabel);
        customInsertPanel.add(insLblPanel);
        translatedText = this.rBundle.getString("Insert");
        Object[] tmpInsert = new Object[]{this.rBundle.getString("comma"), this.rBundle.getString("."), this.rBundle.getString("$"), this.rBundle.getString("0"), this.rBundle.getString("9"), this.rBundle.getString("D"), this.rBundle.getString("S"), this.rBundle.getString("G"), this.rBundle.getString("C"), this.rBundle.getString("L"), this.rBundle.getString("U")};
        this.m_customInsert = new InsertButton(tmpInsert);
        this.m_customInsert.setName("NumberCustomInsert");
        if (this.m_viewFormat != null && this.m_viewFormat.getLocale() != null) {
            this.m_customInsert.setLocale(this.m_viewFormat.getLocale());
        } else {
            this.m_customInsert.setLocale(Locale.getDefault());
        }
        this.m_customInsert.setMaximumRowCount(4);
        this.m_customInsert.setPreferredSize(new Dimension(this.m_customInsert.getPreferredSize().width, this.m_customInsert.getPreferredSize().height));
        this.m_customInsert.setMinimumSize(this.m_customInsert.getPreferredSize());
        this.m_customInsert.setMaximumSize(this.m_customInsert.getPreferredSize());
        this.m_customInsert.addActionListener((ActionListener)this);
        translatedText = this.rBundle.getString("Add");
        this.m_customAddButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_customAddButton.setName("NumberCustomAdd");
        this.m_customAddButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        int bthWidth = Math.max(this.m_customAddButton.getPreferredSize().width, this.m_customDeleteButton.getPreferredSize().width) + 18;
        this.m_customAddButton.setPreferredSize(new Dimension(bthWidth, this.m_customAddButton.getPreferredSize().height));
        this.m_customAddButton.setMinimumSize(this.m_customAddButton.getPreferredSize());
        this.m_customAddButton.setMaximumSize(this.m_customAddButton.getPreferredSize());
        this.m_customDeleteButton.setPreferredSize(new Dimension(bthWidth, this.m_customDeleteButton.getPreferredSize().height));
        this.m_customDeleteButton.setMinimumSize(this.m_customDeleteButton.getPreferredSize());
        this.m_customDeleteButton.setMaximumSize(this.m_customDeleteButton.getPreferredSize());
        this.m_customAddButton.addActionListener(this);
        this.m_customAddButton.setEnabled(false);
        customInsertPanel.add(insLblPanel);
        JPanel insBtnPanel = new JPanel(new FlowLayout(2, 0, 0));
        insBtnPanel.add((Component)this.m_customInsert);
        insBtnPanel.add(Box.createHorizontalStrut(10));
        insBtnPanel.add(this.m_customAddButton);
        customInsertPanel.add(insBtnPanel);
        customInsertPanel.setAlignmentX(0.0f);
        JPanel textFieldPanel = new JPanel();
        textFieldPanel.setLayout(new BoxLayout(textFieldPanel, 0));
        textFieldPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width - leftPanel.getPreferredSize().width - 30, 22));
        textFieldPanel.setMinimumSize(textFieldPanel.getPreferredSize());
        textFieldPanel.setMaximumSize(textFieldPanel.getPreferredSize());
        this.m_customTypeTextField = new JTextField();
        this.m_customTypeTextField.setName("NumberCustomEditType");
        this.m_customTypeTextField.setPreferredSize(new Dimension(width, 22));
        this.m_customTypeTextField.setText("");
        this.m_customEditTypeLabel.setAlignmentX(0.0f);
        this.m_caretListener = new 1();
        this.m_customTypeTextField.addCaretListener(this.m_caretListener);
        textFieldPanel.add(this.m_customTypeTextField);
        textFieldPanel.setAlignmentX(0.0f);
        this.m_customEditTypeLabel.setLabelFor(this.m_customTypeTextField);
        translatedText = this.rBundle.getString("NumberType");
        this.m_customTypeLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_customTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_customTypeLabel.setAlignmentX(0.0f);
        this.m_customTypeLabel.setLabelFor(this.m_customTypeList);
        this.m_customPanel.add(this.m_customTypeLabel);
        this.m_customPanel.add(Box.createVerticalStrut(3));
        this.m_customPanel.add(customListPanel);
        this.m_customPanel.add(Box.createVerticalStrut(7));
        this.m_customPanel.add(customDeletePanel);
        this.m_customPanel.add(Box.createVerticalStrut(16));
        this.m_customPanel.add(customInsertPanel);
        this.m_customPanel.add(Box.createVerticalStrut(7));
        this.m_customPanel.add(textFieldPanel);
        this.m_customPanel.add(Box.createVerticalGlue());
        mainPanel.add(leftPanel);
        mainPanel.add(Box.createHorizontalStrut(10));
        this.m_rightPanel.add(new JLabel("   "));
        this.m_rightPanel.add(Box.createVerticalStrut(3));
        this.m_rightPanel.add(this.m_numberPanel);
        this.m_rightPanel.add(Box.createVerticalGlue());
        mainPanel.add(this.m_rightPanel);
        this.add(mainPanel);
        this.add(Box.createVerticalGlue());
        this.m_scaleComboBox.addActionListener(this);
        this.m_dollarSignComboBox.addActionListener(this);
        this.m_defaultScaleMarkCheckBox.addActionListener(this);
        this.m_decimalSpinBox.addChangeListener((ChangeListener)this);
        this.m_use1000SeperatorCheckBox.addActionListener(this);
        this.m_currencySymbolCheckBox.addActionListener(this);
        this.m_scaleCheckBox.addActionListener(this);
        this.m_customTypeList.addListSelectionListener(this);
        this.m_sentPropertyChangeEvent = false;
        this.init(viewFormat);
        this.m_sentPropertyChangeEvent = true;
        this.m_negativeList.addListSelectionListener(this);
    }

    private void displayErrorMessage(String strMessage) {
        JDialog tmpDialog = new JOptionPane(this.rBundle.getString(strMessage), 0, -1, new ImageIcon(ImageUtils.getImageResource(NumberFormatPanel.class, (String)"images/stop.gif"))).createDialog(this, this.m_applicationName);
        tmpDialog.show();
    }

    private void setThousandSeparator(ViewFormat viewFormat) {
        if (viewFormat == null) {
            return;
        }
        if (!this.m_use1000Seperator) {
            viewFormat.setThousandSeparator('\u0000');
        } else {
            viewFormat.setThousandSeparator('0');
        }
    }

    private void setCurrencySymbol(ViewFormat viewFormat) {
        if (viewFormat == null) {
            return;
        }
        if (!this.m_useCurrencySymbol) {
            viewFormat.setCurrencySymbol("");
        }
        boolean head = false;
        if (this.m_useCurrencySymbol) {
            String strCurrencySymbol = null;
            switch (this.m_dollarSignComboBox.getSelectedIndex()) {
                case 0: {
                    head = true;
                }
                case 1: {
                    strCurrencySymbol = Dollar;
                    break;
                }
                case 2: {
                    strCurrencySymbol = Pound;
                    head = true;
                    break;
                }
                case 3: {
                    strCurrencySymbol = Yen;
                    head = true;
                    break;
                }
                case 4: {
                    head = true;
                }
                case 5: {
                    strCurrencySymbol = Euro;
                    break;
                }
                case 6: {
                    strCurrencySymbol = USD;
                    break;
                }
                case 7: {
                    strCurrencySymbol = JPY;
                    break;
                }
                case 8: {
                    strCurrencySymbol = GBP;
                    break;
                }
                case 9: {
                    strCurrencySymbol = EUR;
                    break;
                }
                case 10: {
                    strCurrencySymbol = (String)this.m_dollarSignComboBox.getSelectedItem();
                    if (this.m_defaultFormat != HEAD_CURR_DEFAULT_STR) break;
                    head = true;
                    break;
                }
            }
            viewFormat.setPosCurFmt(this.getPositiveFormat(viewFormat, head));
            viewFormat.setCurrencySymbol(strCurrencySymbol);
        }
    }

    protected void setScaleFactor(ViewFormat viewFormat, int index) {
        if (viewFormat == null) {
            return;
        }
        if (this.m_scaleCheckBox.isSelected()) {
            viewFormat.setScaleFactor(index);
            switch (viewFormat.getScaleFactor()) {
                case 1: {
                    if (this.m_defaultScaleMarkCheckBox.isSelected()) {
                        viewFormat.setScaleDownThousands("__sym_locale__");
                        break;
                    }
                    viewFormat.setScaleDownThousands("");
                    break;
                }
                case 2: {
                    if (this.m_defaultScaleMarkCheckBox.isSelected()) {
                        viewFormat.setScaleDownMillions("__sym_locale__");
                        break;
                    }
                    viewFormat.setScaleDownMillions("");
                    break;
                }
                case 3: {
                    if (this.m_defaultScaleMarkCheckBox.isSelected()) {
                        viewFormat.setScaleDownBillions("__sym_locale__");
                        break;
                    }
                    viewFormat.setScaleDownBillions("");
                    break;
                }
                case 4: {
                    if (this.m_defaultScaleMarkCheckBox.isSelected()) {
                        viewFormat.setScaleDownTrillions("__sym_locale__");
                        break;
                    }
                    viewFormat.setScaleDownTrillions("");
                    break;
                }
                case 5: {
                    if (this.m_defaultScaleMarkCheckBox.isSelected()) {
                        viewFormat.setScaleDownQuadrillions("__sym_locale__");
                        break;
                    }
                    viewFormat.setScaleDownQuadrillions("");
                    break;
                }
            }
        } else if (viewFormat.isScaleFactorUsed()) {
            viewFormat.setScaleFactor(0);
        }
    }

    private void setNegativeNumberFormat(ViewFormat viewFormat) {
        if (viewFormat == null) {
            return;
        }
        if (this.m_negativeList.getSelectedIndex() >= this.m_negativeListCellRenderer.getRedIndex()) {
            viewFormat.setNegNumFmt(this.m_negativeList.getSelectedIndex() - this.m_negativeListCellRenderer.getRedIndex());
        } else {
            viewFormat.setNegNumFmt(this.m_negativeList.getSelectedIndex());
        }
    }

    protected void setDecimalDigit(ViewFormat viewFormat) {
        if (viewFormat == null) {
            return;
        }
        if (viewFormat.getDecimalDigit() != this.m_decimalSpinBox.getIntValue()) {
            viewFormat.setDecimalDigit(this.m_decimalSpinBox.getIntValue());
        }
    }

    protected void setNumberFormat(ViewFormat viewFormat) {
        if (viewFormat == null) {
            return;
        }
        this.setThousandSeparator(viewFormat);
        this.setScaleFactor(viewFormat, this.m_scaleComboBox.getSelectedIndex() + 1);
        this.setDecimalDigit(viewFormat);
        switch (this.getFormatType()) {
            case 3: {
                viewFormat.setNumberType(1);
                this.setCurrencySymbol(viewFormat);
                viewFormat.setNegCurFmt(this.getNegativeFormat());
                break;
            }
            case 2: {
                viewFormat.setNumberType(0);
                viewFormat.setNegNumFmt(this.getNegativeFormat());
                break;
            }
        }
    }

    protected void updateResourceBundle(Locale loc) {
        if (loc != null) {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc);
            this.rUtilBundle = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle", loc);
        } else {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
            this.rUtilBundle = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle");
        }
    }

    protected void init(ViewFormat viewFormat) {
        if (viewFormat == null) {
            this.m_typeList.setSelectedIndex(0);
            return;
        }
        if (viewFormat.getNumberType() == 0) {
            this.m_negativeList.setSelectedIndex(viewFormat.getNegNumFmtValue());
            this.m_negativeListCellRenderer.setRedIndex(3);
        } else if (viewFormat.getNumberType() == 1) {
            this.m_negativeList.setSelectedIndex(viewFormat.getNegCurFmtValue());
            this.m_negativeListCellRenderer.setRedIndex(8);
        }
        this.m_decimalSpinBox.setIntValue(viewFormat.getDecimalDigit());
        this.m_use1000Seperator = viewFormat.getThousandSeparator() != '\u0000';
        this.m_useCurrencySymbol = viewFormat.getCurrencySymbol() != "";
        this.m_viewFormat.setThousandSeparator(viewFormat.getThousandSeparator());
        if (viewFormat.getScaleFactor() == 0 || !viewFormat.isScaleFactorUsed()) {
            this.m_scaleCheckBox.setSelected(false);
        } else {
            this.m_scaleCheckBox.setSelected(true);
        }
        if (this.m_scaleCheckBox.isSelected()) {
            this.m_scaleComboBox.setEnabled(true);
            this.m_defaultScaleMarkCheckBox.setEnabled(true);
        } else {
            this.m_scaleComboBox.setEnabled(false);
            this.m_defaultScaleMarkCheckBox.setEnabled(false);
        }
        if (viewFormat.getScaleFactor() != 6 && viewFormat.getScaleFactor() != 0) {
            this.m_scaleComboBox.setSelectedIndex(viewFormat.getScaleFactor() - 1);
        }
        switch (viewFormat.getScaleFactor()) {
            case 0: {
                this.m_defaultScaleMarkCheckBox.setEnabled(false);
                break;
            }
            case 1: {
                if (!viewFormat.getScaleDownThousands().equals("")) {
                    this.m_defaultScaleMarkCheckBox.setSelected(true);
                    break;
                }
                this.m_defaultScaleMarkCheckBox.setSelected(false);
                break;
            }
            case 2: {
                if (!viewFormat.getScaleDownMillions().equals("")) {
                    this.m_defaultScaleMarkCheckBox.setSelected(true);
                    break;
                }
                this.m_defaultScaleMarkCheckBox.setSelected(false);
                break;
            }
            case 3: {
                if (viewFormat.getScaleDownBillions().equals("")) {
                    this.m_defaultScaleMarkCheckBox.setSelected(true);
                    break;
                }
                this.m_defaultScaleMarkCheckBox.setSelected(false);
                break;
            }
            case 4: {
                if (!viewFormat.getScaleDownTrillions().equals("")) {
                    this.m_defaultScaleMarkCheckBox.setSelected(true);
                    break;
                }
                this.m_defaultScaleMarkCheckBox.setSelected(false);
                break;
            }
            case 5: {
                if (!viewFormat.getScaleDownQuadrillions().equals("")) {
                    this.m_defaultScaleMarkCheckBox.setSelected(true);
                    break;
                }
                this.m_defaultScaleMarkCheckBox.setSelected(false);
                break;
            }
        }
        if (viewFormat.getCurrencySymbol().length() > 0) {
            String currSym = viewFormat.getCurrencySymbol();
            if (!this.setCurrencyIndex(viewFormat, currSym)) {
                this.m_customCurrencyLocale = viewFormat.getLocale();
                this.m_dollarSignComboBox.addItem(viewFormat.getCurrencySymbol());
                this.m_dollarSignComboBox.setSelectedItem(viewFormat.getCurrencySymbol());
            }
            if (viewFormat.getNumberType() == 1) {
                this.m_dollarSignComboBox.setEnabled(true);
                this.setShowCurrencySymbol(true);
            } else {
                this.m_dollarSignComboBox.setEnabled(false);
            }
        } else {
            DecimalFormatSymbols decFmtSym = this.m_viewFormat.getLocale() != null ? new DecimalFormatSymbols(viewFormat.getLocale()) : new DecimalFormatSymbols();
            String defCurrencySymbol = decFmtSym.getCurrencySymbol();
            if (!this.setCurrencyIndex(viewFormat, defCurrencySymbol)) {
                this.m_dollarSignComboBox.setSelectedItem(defCurrencySymbol);
                String currencySymbol = (String)this.m_dollarSignComboBox.getSelectedItem();
                if (!currencySymbol.equals(defCurrencySymbol)) {
                    this.m_customCurrencyLocale = viewFormat.getLocale();
                    this.m_dollarSignComboBox.addItem(defCurrencySymbol);
                    this.m_dollarSignComboBox.setSelectedItem(defCurrencySymbol);
                }
            }
            this.m_dollarSignComboBox.setEnabled(this.m_use1000SeperatorCheckBox.isSelected());
        }
        if (viewFormat.getNumberType() != 1) {
            if (viewFormat.isThousandSeparatorUsed() && viewFormat.getThousandSeparator() != '\u0000') {
                this.m_use1000SeperatorCheckBox.setSelected(true);
            } else {
                this.m_use1000SeperatorCheckBox.setSelected(false);
            }
        }
        if (viewFormat.getNumberType() == 1) {
            this.setCurrencyNegativeType(viewFormat.getNegCurFmtValue(), this.m_negativeRed);
            this.m_negativeList.setSelectedIndex(viewFormat.getNegCurFmtValue());
        } else if (viewFormat.getNumberType() == 0) {
            this.setNumberNegativeType(viewFormat.getNegNumFmtValue(), this.m_negativeRed);
            this.m_negativeList.setSelectedIndex(viewFormat.getNegNumFmtValue());
        }
        this.setFormatType(viewFormat);
    }

    private void $init$() {
        this.m_nCustomNumberFormatType = 1;
        this.rBundle = null;
        this.rUtilBundle = null;
        this.isSetFocus = true;
        this.m_defaultScaleMarkCheckBox = null;
        this.m_customTypeVector = new Vector();
        this.m_defaultFormat = HEAD_CURR_DEFAULT_STR;
        this.m_viewFormat = null;
        this.m_oldSelectedType = -1;
        this.m_oldSelectedNegativeType = -1;
        this.m_negativeRed = false;
        this.m_numberNegativeType = 0;
        this.m_currencyNegativeType = 0;
        this.m_customCurrencyLocale = null;
        this.m_sentPropertyChangeEvent = true;
        this.m_defaultFormatSet = false;
        this.m_bSuperCalled = false;
        this.m_eh = null;
    }

    static {
        DollarSign0 = "$ ($123)";
        DollarSign00 = "$ (123$)";
        DollarSign1 = "\u00a3 (\u00a3123)";
        DollarSign2 = "\u00a5 (\u00a5123)";
        DollarSign3 = "\u20ac (\u20ac123)";
        DollarSign33 = "\u20ac (123\u20ac)";
        DollarSign4 = "USD";
        DollarSign5 = "JPY";
        DollarSign6 = "GBP";
        DollarSign7 = "EUR";
        Dollar = "$";
        Pound = "\u00a3";
        Yen = "\uffe5";
        Euro = "\u20ac";
        USD = "USD";
        JPY = "JPY";
        GBP = "GBP";
        EUR = "EUR";
    }

    static JTextField ra$m_customTypeTextField(NumberFormatPanel numberFormatPanel) {
        return numberFormatPanel.m_customTypeTextField;
    }

    static JButton ra$m_customAddButton(NumberFormatPanel numberFormatPanel) {
        return numberFormatPanel.m_customAddButton;
    }

    final class 1
    implements CaretListener {
        public void caretUpdate(CaretEvent e) {
            if (NumberFormatPanel.ra$m_customTypeTextField(NumberFormatPanel.this).getText().trim().equals("")) {
                NumberFormatPanel.ra$m_customAddButton(NumberFormatPanel.this).setEnabled(false);
            } else {
                NumberFormatPanel.ra$m_customAddButton(NumberFormatPanel.this).setEnabled(true);
            }
        }
    }

    class NegativeListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private int m_redIndex;
        private JLabel m_label;

        public NegativeListCellRenderer() {
            this.$init$();
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.m_label);
        }

        public void setRedIndex(int redIndex) {
            this.m_redIndex = redIndex;
        }

        public int getRedIndex() {
            return this.m_redIndex;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index >= this.m_redIndex) {
                this.m_label.setForeground(Color.red);
            } else {
                this.m_label.setForeground(list.getForeground());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                if (index < this.m_redIndex) {
                    this.m_label.setForeground(list.getSelectionForeground());
                }
            } else {
                this.setBackground(list.getBackground());
            }
            this.m_label.setText((String)value);
            this.getAccessibleContext().setAccessibleName((String)value);
            return this;
        }

        private void $init$() {
            this.m_redIndex = 0;
            this.m_label = new JLabel();
        }
    }
}

