/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.DataviewDialogBarLayout;
import oracle.dss.dataView.gui.PageSetupGeneralPanel;
import oracle.dss.dataView.gui.PageSetupGraphPanel;
import oracle.dss.dataView.gui.PageSetupGridViewPanel;
import oracle.dss.dataView.gui.PageSetupHeaderFooterPanel;
import oracle.dss.dataView.gui.PageSetupMarginsPanel;
import oracle.dss.dataView.gui.PageSetupSheetPanel;
import oracle.dss.dataView.gui.PreviewDialogProvider;
import oracle.dss.util.help.HelpContext;

public class PageSetupDialog
extends JDialog
implements PropertyChangeListener,
FocusListener,
ActionListener,
HelpContext {
    protected ResourceBundle rBundle;
    protected Locale m_locale;
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    protected String m_applicationName;
    protected PushButton m_PageSetupHelpButton;
    protected PushButton m_PageSetupPrintPreviewButton;
    protected PushButton m_PageSetupOKButton;
    protected PushButton m_PageSetupCancelButton;
    protected String m_translatedText;
    protected JTabbedPane m_tabbedPane;
    protected JPanel m_buttonPanel;
    protected UIViewPrinter[] m_viewPrinter;
    protected PageSetupMarginsPanel m_PageSetupMarginsPanel;
    protected PageSetupGeneralPanel m_PageSetupGeneralPanel;
    private boolean m_inD4O;
    private boolean m_D4OWksheetTitleVisible;
    private boolean m_D4OWksheetTextVisible;
    private ComponentAdapter m_componentAdapter;
    protected PageSetupGridViewPanel m_PageSetupGridViewPanel;
    protected PageSetupGraphPanel m_PageSetupGraphPanel;
    protected PageSetupHeaderFooterPanel m_PageSetupHeaderFooterPanel;
    protected JTabbedPane m_TabbedPane;
    protected PreviewDialogProvider m_PreviewDialogProvider;
    protected Frame m_Frame;
    protected JPanel m_mainPanel;
    private final Border _sBorderButtons;

    public PageSetupDialog(Frame parentFrame, String title, boolean bHelpEnabled, ViewPrinter[] printer, PreviewDialogProvider previewDialogProvider) {
        super(parentFrame);
        this.$init$();
        this.constructDialog(parentFrame, title, bHelpEnabled, printer, previewDialogProvider);
    }

    public PageSetupDialog(Frame parentFrame, String title, boolean bHelpEnabled, UIViewPrinter printer, PreviewDialogProvider previewDialogProvider) {
        super(parentFrame);
        this.$init$();
        UIViewPrinter[] printers = new UIViewPrinter[]{printer};
        this.constructDialog(parentFrame, title, bHelpEnabled, printers, previewDialogProvider);
    }

    public PageSetupDialog(Frame parentFrame, String title, boolean bHelpEnabled, UIViewPrinter printer, PreviewDialogProvider previewDialogProvider, boolean inD4O, boolean D4OWksheetTitleVisible, boolean D4OWksheetTextVisible) {
        super(parentFrame);
        this.$init$();
        this.m_inD4O = inD4O;
        this.m_D4OWksheetTitleVisible = D4OWksheetTitleVisible;
        this.m_D4OWksheetTextVisible = D4OWksheetTextVisible;
        UIViewPrinter[] printers = new UIViewPrinter[]{printer};
        this.constructDialog(parentFrame, title, bHelpEnabled, printers, previewDialogProvider);
    }

    public PageSetupDialog(Frame parentFrame, String title, boolean bHelpEnabled, ViewPrinter printer, PreviewDialogProvider previewDialogProvider) {
        super(parentFrame);
        this.$init$();
        UIViewPrinter[] printers = new ViewPrinter[]{printer};
        this.constructDialog(parentFrame, title, bHelpEnabled, printers, previewDialogProvider);
    }

    public PageSetupDialog(Frame parentFrame, String title, boolean bHelpEnabled, ViewPrinter[] printer, PreviewDialogProvider previewDialogProvider, PageSetupGeneralPanel pageSetupGeneralPanel, PageSetupMarginsPanel pageSetupMarginsPanel, PageSetupHeaderFooterPanel pageSetupHeaderFooterPanel, PageSetupSheetPanel pageSetupSheetPanel) {
        this(parentFrame, title, bHelpEnabled, printer, previewDialogProvider, pageSetupGeneralPanel, pageSetupMarginsPanel, pageSetupHeaderFooterPanel, new PageSetupGridViewPanel(printer), new PageSetupGraphPanel(printer));
    }

    public PageSetupDialog(Frame parentFrame, String title, boolean bHelpEnabled, UIViewPrinter[] printer, PreviewDialogProvider previewDialogProvider, PageSetupGeneralPanel pageSetupGeneralPanel, PageSetupMarginsPanel pageSetupMarginsPanel, PageSetupHeaderFooterPanel pageSetupHeaderFooterPanel, PageSetupGridViewPanel pageSetupGridViewPanel, PageSetupGraphPanel pageSetupGraphPanel) {
        super(parentFrame);
        this.$init$();
        this.m_PageSetupGeneralPanel = pageSetupGeneralPanel;
        this.m_PageSetupMarginsPanel = pageSetupMarginsPanel;
        this.m_PageSetupHeaderFooterPanel = pageSetupHeaderFooterPanel;
        this.m_PageSetupGraphPanel = pageSetupGraphPanel;
        this.m_PageSetupGridViewPanel = pageSetupGridViewPanel;
        this.constructDialog(parentFrame, title, bHelpEnabled, printer, previewDialogProvider);
    }

    private void constructDialog(Frame parentFrame, String title, boolean bHelpEnabled, UIViewPrinter[] printer, PreviewDialogProvider previewDialogProvider) {
        this.m_locale = printer[0].getLocale();
        super.setLocale(this.m_locale);
        this.updateResourceBundle(this.m_locale);
        this.m_Frame = parentFrame;
        this.m_bHelpEnabled = bHelpEnabled;
        this.m_viewPrinter = printer;
        this.m_PreviewDialogProvider = previewDialogProvider;
        this.setTitle(title);
        this.setModal(true);
        this.setResizable(true);
        this.m_componentAdapter = new 1();
        this.addComponentListener(this.m_componentAdapter);
        this.setLocationRelativeTo(this.m_Frame);
        this.m_mainPanel = new JPanel();
        if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            this.m_mainPanel.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
        }
        this.m_mainPanel.setLayout(new BorderLayout());
        this.m_mainPanel.setBorder(new EmptyBorder(6, 6, 8, 6));
        this.getContentPane().add(this.m_mainPanel);
        this._initiate();
        this.pack();
    }

    private void _initiate() {
        this.m_mainPanel.removeAll();
        if (this.m_tabbedPane == null) {
            this.m_tabbedPane = this.createTabbedPane();
        }
        this.m_buttonPanel = this.createButtonPanel();
        this.m_mainPanel.add((Component)this.m_tabbedPane, "Center");
        this.m_mainPanel.add((Component)this.m_buttonPanel, "South");
        this._init();
        this.validate();
        this.repaint();
    }

    private void _init() {
        this.getRootPane().setDefaultButton((JButton)this.m_PageSetupOKButton);
        this.m_PageSetupCancelButton.registerKeyboardAction((ActionListener)this, KeyStroke.getKeyStroke(27, 0), 2);
        this.m_PageSetupHelpButton.registerKeyboardAction((ActionListener)this, KeyStroke.getKeyStroke(112, 0), 2);
    }

    protected JPanel createButtonPanel() {
        this.m_translatedText = this.rBundle.getString("help");
        this.m_PageSetupHelpButton = new PushButton(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_PageSetupHelpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_PageSetupHelpButton.addActionListener((ActionListener)this);
        this.m_PageSetupHelpButton.addFocusListener((FocusListener)this);
        this.m_PageSetupHelpButton.setLeftmost(true);
        this.m_PageSetupHelpButton.setRightmost(true);
        this.m_translatedText = this.rBundle.getString("Print Prev");
        this.m_PageSetupPrintPreviewButton = new PushButton(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_PageSetupPrintPreviewButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_PageSetupPrintPreviewButton.addActionListener((ActionListener)this);
        this.m_PageSetupPrintPreviewButton.addFocusListener((FocusListener)this);
        this.m_PageSetupPrintPreviewButton.setLeftmost(true);
        this.m_PageSetupPrintPreviewButton.setRightmost(true);
        this.m_translatedText = this.rBundle.getString("OK");
        this.m_PageSetupOKButton = new PushButton(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_PageSetupOKButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_PageSetupOKButton.addActionListener((ActionListener)this);
        this.m_PageSetupOKButton.addFocusListener((FocusListener)this);
        this.m_PageSetupOKButton.setLeftmost(true);
        this.m_PageSetupOKButton.setRightmost(true);
        this.m_translatedText = this.rBundle.getString("cancel");
        this.m_PageSetupCancelButton = new PushButton(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_PageSetupCancelButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_PageSetupCancelButton.addActionListener((ActionListener)this);
        this.m_PageSetupCancelButton.addFocusListener((FocusListener)this);
        this.m_PageSetupCancelButton.setLeftmost(true);
        this.m_PageSetupCancelButton.setRightmost(true);
        JPanel buttonBar = new JPanel();
        buttonBar.setBorder(new EmptyBorder(8, 0, 0, 0));
        buttonBar.setLayout(new DataviewDialogBarLayout(buttonBar));
        buttonBar.add((Component)this.m_PageSetupHelpButton, DialogButtonBar.CONSTRAINT_HELP);
        buttonBar.add((Component)this.m_PageSetupPrintPreviewButton, DialogButtonBar.CONSTRAINT_NULL);
        buttonBar.add((Component)this.m_PageSetupOKButton, DialogButtonBar.CONSTRAINT_YES);
        buttonBar.add((Component)this.m_PageSetupCancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        return buttonBar;
    }

    protected JTabbedPane createTabbedPane() {
        int type;
        JTabbedPane tmpTabbedPane = new JTabbedPane();
        if (this.m_PageSetupMarginsPanel == null) {
            this.m_PageSetupMarginsPanel = new PageSetupMarginsPanel(this.m_viewPrinter);
        }
        if (this.m_PageSetupGeneralPanel == null) {
            this.m_PageSetupGeneralPanel = this.m_inD4O ? new PageSetupGeneralPanel(this.m_viewPrinter, this.m_inD4O, this.m_D4OWksheetTitleVisible, this.m_D4OWksheetTextVisible) : new PageSetupGeneralPanel(this.m_viewPrinter);
        }
        if (this.m_PageSetupHeaderFooterPanel == null) {
            this.m_PageSetupHeaderFooterPanel = new PageSetupHeaderFooterPanel(this.m_viewPrinter);
        }
        this.m_translatedText = (type = this.m_viewPrinter[0].getViewPrinterType()) == 4 || type == 3 || type == 5 || type == 6 || type == 7 ? this.rBundle.getString("Worksheet") : this.rBundle.getString("Sheet");
        tmpTabbedPane.add(this.m_translatedText, this.m_PageSetupGeneralPanel);
        if (type == 0 || type == 4 || type == 1 || type == 3) {
            this.m_translatedText = type == 0 || type == 4 ? this.rBundle.getString("Crosstab") : this.rBundle.getString("Table");
            if (this.m_PageSetupGridViewPanel == null) {
                this.m_PageSetupGridViewPanel = new PageSetupGridViewPanel(this.m_viewPrinter);
            }
            tmpTabbedPane.add(this.m_translatedText, this.m_PageSetupGridViewPanel);
        } else if (type == 2 || type == 5) {
            this.m_translatedText = this.rBundle.getString("Graph");
            if (this.m_PageSetupGraphPanel == null) {
                this.m_PageSetupGraphPanel = new PageSetupGraphPanel(this.m_viewPrinter);
            }
            tmpTabbedPane.add(this.m_translatedText, this.m_PageSetupGraphPanel);
        } else if (type == 6 || type == 7) {
            this.m_translatedText = type == 6 ? this.rBundle.getString("Crosstab") : this.rBundle.getString("Table");
            if (this.m_PageSetupGridViewPanel == null) {
                this.m_PageSetupGridViewPanel = new PageSetupGridViewPanel(this.m_viewPrinter);
            }
            tmpTabbedPane.add(this.m_translatedText, this.m_PageSetupGridViewPanel);
            this.m_translatedText = this.rBundle.getString("Graph");
            if (this.m_PageSetupGraphPanel == null) {
                this.m_PageSetupGraphPanel = new PageSetupGraphPanel(this.m_viewPrinter);
            }
            tmpTabbedPane.add(this.m_translatedText, this.m_PageSetupGraphPanel);
        }
        this.m_translatedText = this.rBundle.getString("Margins");
        tmpTabbedPane.add(this.m_translatedText, this.m_PageSetupMarginsPanel);
        this.m_translatedText = this.rBundle.getString("Header/Footer");
        tmpTabbedPane.add(this.m_translatedText, this.m_PageSetupHeaderFooterPanel);
        return tmpTabbedPane;
    }

    public void focusGained(FocusEvent e) {
        if (this.m_PageSetupHeaderFooterPanel != null) {
            this.m_PageSetupHeaderFooterPanel.disableButtons();
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public String getHelpContextID() {
        String strTemp = "";
        if (this.m_tabbedPane.getSelectedIndex() == 0) {
            strTemp = this.m_viewPrinter[0].getViewPrinterType() == 2 || this.m_viewPrinter[0].getViewPrinterType() == 0 || this.m_viewPrinter[0].getViewPrinterType() == 1 ? "oracle.dss.dataView.gui.PageSetupGeneralPanel" : "oracle.dss.dataView.gui.PageSetupGeneralPanel_Worksheet";
        } else if (this.m_tabbedPane.getSelectedComponent() instanceof PageSetupGridViewPanel) {
            strTemp = "oracle.dss.dataView.gui.PageSetupGridViewPanel";
        } else if (this.m_tabbedPane.getSelectedComponent() instanceof PageSetupGraphPanel) {
            strTemp = "oracle.dss.dataView.gui.PageSetupGraphPanel";
        } else if (this.m_tabbedPane.getSelectedComponent() instanceof PageSetupMarginsPanel) {
            strTemp = "oracle.dss.dataView.gui.PageSetupMarginsPanel";
        } else if (this.m_tabbedPane.getSelectedComponent() instanceof PageSetupHeaderFooterPanel) {
            strTemp = "oracle.dss.dataView.gui.PageSetupHeaderFooterPanel";
        }
        return strTemp;
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        if (this.m_PageSetupHeaderFooterPanel != null) {
            this.m_PageSetupHeaderFooterPanel.setHelpProvider(this.m_helpProvider);
        }
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setApplicationName(String name) {
        this.m_applicationName = name;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public void actionPerformed(ActionEvent e) {
        boolean i = false;
        if (e.getSource() == this.m_PageSetupHelpButton) {
            if (this.getHelpProvider() == null) {
                return;
            }
            try {
                if (this.getHelpProvider() != null) {
                    this.getHelpProvider().showHelp((Component)this);
                } else if (HelpUtils.getDefaultHelpProvider() != null) {
                    HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                }
            }
            catch (HelpUnavailableException e1) {}
        } else if (e.getSource() == this.m_PageSetupPrintPreviewButton) {
            if (this.m_PreviewDialogProvider == null) {
                return;
            }
            this.apply();
            this.setVisible(false);
            this.m_PreviewDialogProvider.showPreviewDialog(this.m_Frame);
        } else if (e.getSource() == this.m_PageSetupOKButton) {
            this.apply();
            this.setVisible(false);
            this.cleanUp();
        } else if (e.getSource() == this.m_PageSetupCancelButton) {
            this.setVisible(false);
            this.cleanUp();
            this.getParent().repaint();
        }
    }

    public void cleanUp() {
        this.m_PageSetupHelpButton.removeActionListener((ActionListener)this);
        this.m_PageSetupHelpButton.removeFocusListener((FocusListener)this);
        this.m_PageSetupPrintPreviewButton.removeActionListener((ActionListener)this);
        this.m_PageSetupPrintPreviewButton.removeFocusListener((FocusListener)this);
        this.m_PageSetupOKButton.removeActionListener((ActionListener)this);
        this.m_PageSetupOKButton.removeFocusListener((FocusListener)this);
        this.m_PageSetupCancelButton.removeActionListener((ActionListener)this);
        this.m_PageSetupCancelButton.removeFocusListener((FocusListener)this);
        this.removeComponentListener(this.m_componentAdapter);
        this.m_componentAdapter = null;
        this.rBundle = null;
        this.m_locale = null;
        this.m_strHelpContextID = null;
        this.m_helpProvider = null;
        this.m_applicationName = null;
        this.m_PageSetupHelpButton = null;
        this.m_PageSetupPrintPreviewButton = null;
        this.m_PageSetupOKButton = null;
        this.m_PageSetupCancelButton = null;
        this.m_translatedText = null;
        this.m_tabbedPane.removeAll();
        this.m_tabbedPane = null;
        this.m_buttonPanel.removeAll();
        this.m_buttonPanel = null;
        this.m_viewPrinter = null;
        this.m_PageSetupMarginsPanel.cleanUp();
        this.m_PageSetupMarginsPanel = null;
        this.m_PageSetupGeneralPanel.cleanUp();
        this.m_PageSetupGeneralPanel = null;
        if (this.m_PageSetupGridViewPanel != null) {
            this.m_PageSetupGridViewPanel.cleanUp();
        }
        this.m_PageSetupGridViewPanel = null;
        if (this.m_PageSetupGraphPanel != null) {
            this.m_PageSetupGraphPanel.cleanUp();
        }
        this.m_PageSetupGraphPanel = null;
        this.m_PageSetupHeaderFooterPanel.cleanUp();
        this.m_PageSetupHeaderFooterPanel = null;
        this.m_TabbedPane = null;
        this.m_PreviewDialogProvider = null;
        this.m_Frame = null;
        this.m_mainPanel.removeAll();
        this.m_mainPanel = null;
        super.removeAll();
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    public boolean apply() {
        boolean bReturn = true;
        this.m_PageSetupMarginsPanel.apply();
        this.m_PageSetupGeneralPanel.apply();
        if (this.m_PageSetupGridViewPanel != null) {
            this.m_PageSetupGridViewPanel.apply();
        }
        if (this.m_PageSetupGraphPanel != null) {
            this.m_PageSetupGraphPanel.apply();
        }
        this.m_PageSetupHeaderFooterPanel.apply();
        return bReturn;
    }

    public void setLocale(Locale loc) {
        this.m_locale = loc;
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    protected void displayErrorMessage(String strMessage) {
        JDialog tmpDialog = new JOptionPane(this.rBundle.getString(strMessage), 0, -1, new ImageIcon(ImageUtils.getImageResource(PageSetupHeaderFooterPanel.class, (String)"images/stop.gif"))).createDialog(this, this.m_applicationName);
        tmpDialog.show();
    }

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    private void $init$() {
        this.rBundle = null;
        this.m_locale = null;
        this.m_tabbedPane = null;
        this.m_PageSetupMarginsPanel = null;
        this.m_PageSetupGeneralPanel = null;
        this.m_inD4O = false;
        this.m_D4OWksheetTitleVisible = false;
        this.m_D4OWksheetTextVisible = false;
        this.m_componentAdapter = null;
        this.m_PageSetupGridViewPanel = null;
        this.m_PageSetupGraphPanel = null;
        this.m_PageSetupHeaderFooterPanel = null;
        this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
    }

    final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            int preferredW = PageSetupDialog.this.getPreferredSize().width;
            int preferredH = PageSetupDialog.this.getPreferredSize().height;
            int currentW = PageSetupDialog.this.getWidth();
            int currentH = PageSetupDialog.this.getHeight();
            if (currentH < preferredH || currentW < preferredW) {
                if (currentH < preferredH) {
                    currentH = preferredH;
                }
                if (currentW < preferredW) {
                    currentW = preferredW;
                }
                PageSetupDialog.this.setSize(new Dimension(currentW, currentH));
            }
            PageSetupDialog.this.validate();
        }
    }
}

