/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.spinBox.SpinBox;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.spinBox.SpinButtonEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.util.ErrorHandler;

public class PageSetupMarginsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    protected UIViewPrinter[] m_viewPrinter;
    protected JPanel m_marginsPanel;
    protected JLabel m_marginsLabel;
    protected JPanel m_centerOnPagePanel;
    protected JLabel m_centerOnPageLabel;
    protected JComboBox m_unitsComboBox;
    protected JLabel m_unitsLabel;
    protected MyNumericSpinBox m_topNumericSpinBox;
    protected JLabel m_topLabel;
    protected MyNumericSpinBox m_leftNumericSpinBox;
    protected JLabel m_leftLabel;
    protected MyNumericSpinBox m_bottomNumericSpinBox;
    protected JLabel m_bottomLabel;
    protected MyNumericSpinBox m_rightNumericSpinBox;
    protected JLabel m_rightLabel;
    protected MyNumericSpinBox m_headerNumericSpinBox;
    protected JLabel m_headerLabel;
    protected MyNumericSpinBox m_footerNumericSpinBox;
    protected JLabel m_footerLabel;
    protected JCheckBox m_horizontallyCheckBox;
    protected JCheckBox m_verticallyCheckBox;
    protected JPanel m_leftPanel;
    protected JPanel m_rightPanel;
    protected JPanel m_mainPanel;
    protected JLabel m_previewLabel;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh;
    protected String m_strHelpContextID;
    private double paperWidth;
    private double paperHeight;
    private boolean isVersionSupportOrientation;
    private ResourceBundle rBundle;
    private Locale m_locale;
    private int m_units;
    private float _top;
    private float _left;
    private float _bottom;
    private float _right;
    private float _header;
    private float _footer;
    private boolean m_bSuperCalled;

    public PageSetupMarginsPanel(ViewPrinter[] viewPrinter) {
        this((UIViewPrinter[])viewPrinter);
    }

    public PageSetupMarginsPanel(UIViewPrinter[] viewPrinter) {
        this.$init$();
        this.m_bSuperCalled = true;
        if (viewPrinter == null) {
            return;
        }
        this.m_viewPrinter = viewPrinter;
        this.m_locale = this.m_viewPrinter[0].getLocale();
        this.updateResourceBundle(this.m_locale);
        this.setLayout(new BoxLayout(this, 1));
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 0));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int width = Integer.parseInt(this.rBundle.getString("PageSetupMarginsPanelWidth"));
        int height = Integer.parseInt(this.rBundle.getString("PageSetupMarginsPanelHeight"));
        this.m_mainPanel.setPreferredSize(new Dimension(width, height));
        this.m_mainPanel.setMinimumSize(this.m_mainPanel.getPreferredSize());
        this.m_mainPanel.setMaximumSize(this.m_mainPanel.getPreferredSize());
        this.add(this.m_mainPanel);
        this._init();
    }

    private void _init() {
        this.m_mainPanel.removeAll();
        this.m_rightPanel = new JPanel();
        this.m_rightPanel.setLayout(new BoxLayout(this.m_rightPanel, 1));
        this.m_rightPanel.setPreferredSize(this.getPreferredSize());
        this.m_rightPanel.setMinimumSize(this.m_rightPanel.getPreferredSize());
        this.m_rightPanel.setMaximumSize(this.m_rightPanel.getPreferredSize());
        this.m_leftPanel = new JPanel();
        this.m_leftPanel.setLayout(new BoxLayout(this.m_leftPanel, 1));
        this.m_leftPanel.setPreferredSize(this.getPreferredSize());
        this.m_leftPanel.setMinimumSize(this.m_leftPanel.getPreferredSize());
        this.m_leftPanel.setMaximumSize(this.m_leftPanel.getPreferredSize());
        this.m_marginsPanel = new JPanel();
        this.m_marginsPanel.setLayout(new BoxLayout(this.m_marginsPanel, 1));
        this.m_marginsPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 180));
        this.m_marginsPanel.setMinimumSize(this.m_marginsPanel.getPreferredSize());
        this.m_marginsPanel.setMaximumSize(this.m_marginsPanel.getPreferredSize());
        JPanel tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 10));
        tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
        tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
        this.m_marginsPanel.add(tmpPanel);
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 40));
        tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
        tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
        String translatedText = this.rBundle.getString("Units");
        this.m_unitsLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_unitsLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_unitsLabel.setAlignmentX(0.0f);
        int labelWidth = this.getToolkit().getFontMetrics(this.m_unitsLabel.getFont()).stringWidth(this.m_unitsLabel.getText());
        this.m_unitsLabel.setPreferredSize(new Dimension(labelWidth + 5, this.m_unitsLabel.getPreferredSize().height));
        this.m_unitsLabel.setMinimumSize(this.m_unitsLabel.getPreferredSize());
        this.m_unitsLabel.setMaximumSize(this.m_unitsLabel.getPreferredSize());
        tmpPanel.add(this.m_unitsLabel);
        this.m_unitsComboBox = new JComboBox();
        translatedText = this.rBundle.getString("Pixels");
        this.m_unitsComboBox.addItem(translatedText);
        translatedText = this.rBundle.getString("Inches");
        this.m_unitsComboBox.addItem(translatedText);
        translatedText = this.rBundle.getString("cm");
        this.m_unitsComboBox.addItem(translatedText);
        this.m_unitsComboBox.setOpaque(true);
        this.m_unitsComboBox.setPreferredSize(new Dimension(60, 22));
        this.m_unitsComboBox.setMinimumSize(this.m_unitsComboBox.getPreferredSize());
        this.m_unitsComboBox.setMaximumSize(this.m_unitsComboBox.getPreferredSize());
        this.m_unitsLabel.setLabelFor(this.m_unitsComboBox);
        this.m_unitsLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("UnitsADA"));
        tmpPanel.add(this.m_unitsComboBox);
        this.m_marginsPanel.add(tmpPanel);
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 30));
        tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
        tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
        translatedText = this.rBundle.getString("Top");
        this.m_topLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_topLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_topLabel.setAlignmentX(0.0f);
        this.m_topNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_topNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_topNumericSpinBox.setMinimumSize(this.m_topNumericSpinBox.getPreferredSize());
        this.m_topNumericSpinBox.setMaximumSize(this.m_topNumericSpinBox.getPreferredSize());
        this.m_topLabel.setLabelFor((Component)((Object)this.m_topNumericSpinBox));
        translatedText = this.rBundle.getString("Left");
        this.m_leftLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_leftLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_leftLabel.setAlignmentX(0.0f);
        this.m_leftNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_leftNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_leftNumericSpinBox.setMinimumSize(this.m_leftNumericSpinBox.getPreferredSize());
        this.m_leftNumericSpinBox.setMaximumSize(this.m_leftNumericSpinBox.getPreferredSize());
        this.m_leftLabel.setLabelFor((Component)((Object)this.m_leftNumericSpinBox));
        tmpPanel.add(this.m_topLabel);
        tmpPanel.add((Component)((Object)this.m_topNumericSpinBox));
        tmpPanel.add(Box.createHorizontalStrut(26));
        tmpPanel.add(this.m_leftLabel);
        tmpPanel.add((Component)((Object)this.m_leftNumericSpinBox));
        this.m_marginsPanel.add(tmpPanel);
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 40));
        tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
        tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
        translatedText = this.rBundle.getString("Bottom");
        this.m_bottomLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_bottomLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_bottomLabel.setAlignmentX(0.0f);
        this.m_bottomNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_bottomNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_bottomNumericSpinBox.setMinimumSize(this.m_bottomNumericSpinBox.getPreferredSize());
        this.m_bottomNumericSpinBox.setMaximumSize(this.m_bottomNumericSpinBox.getPreferredSize());
        this.m_bottomLabel.setLabelFor((Component)((Object)this.m_bottomNumericSpinBox));
        translatedText = this.rBundle.getString("Right");
        this.m_rightLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_rightLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_rightLabel.setAlignmentX(0.0f);
        this.m_rightNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_rightNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_rightNumericSpinBox.setMinimumSize(this.m_rightNumericSpinBox.getPreferredSize());
        this.m_rightNumericSpinBox.setMaximumSize(this.m_rightNumericSpinBox.getPreferredSize());
        this.m_rightLabel.setLabelFor((Component)((Object)this.m_rightNumericSpinBox));
        tmpPanel.add(this.m_bottomLabel);
        tmpPanel.add((Component)((Object)this.m_bottomNumericSpinBox));
        tmpPanel.add(Box.createHorizontalStrut(26));
        tmpPanel.add(this.m_rightLabel);
        tmpPanel.add((Component)((Object)this.m_rightNumericSpinBox));
        this.m_marginsPanel.add(tmpPanel);
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 30));
        tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
        tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
        translatedText = this.rBundle.getString("Header");
        this.m_headerLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_headerLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_headerLabel.setAlignmentX(0.0f);
        this.m_headerNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_headerNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_headerNumericSpinBox.setMinimumSize(this.m_headerNumericSpinBox.getPreferredSize());
        this.m_headerNumericSpinBox.setMaximumSize(this.m_headerNumericSpinBox.getPreferredSize());
        this.m_headerLabel.setLabelFor((Component)((Object)this.m_headerNumericSpinBox));
        tmpPanel.add(this.m_headerLabel);
        tmpPanel.add((Component)((Object)this.m_headerNumericSpinBox));
        this.m_marginsPanel.add(tmpPanel);
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 30));
        tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
        tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
        translatedText = this.rBundle.getString("Footer");
        this.m_footerLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_footerLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_footerLabel.setAlignmentX(0.0f);
        this.m_footerNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_footerNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_footerNumericSpinBox.setMinimumSize(this.m_footerNumericSpinBox.getPreferredSize());
        this.m_footerNumericSpinBox.setMaximumSize(this.m_footerNumericSpinBox.getPreferredSize());
        this.m_footerLabel.setLabelFor((Component)((Object)this.m_footerNumericSpinBox));
        tmpPanel.add(this.m_footerLabel);
        tmpPanel.add((Component)((Object)this.m_footerNumericSpinBox));
        this.m_marginsPanel.add(tmpPanel);
        this.m_leftPanel.add(this.m_marginsPanel);
        this.m_mainPanel.add(this.m_leftPanel);
        this.m_mainPanel.add(Box.createHorizontalGlue());
        this.m_mainPanel.add(Box.createHorizontalStrut(12));
        this.m_mainPanel.add(this.m_rightPanel);
        this.m_mainPanel.add(Box.createHorizontalStrut(20));
        this.add(Box.createVerticalGlue());
        this.setAlignmentX(0.0f);
        this.m_mainPanel.setAlignmentX(0.0f);
        int firstLabelWidth = this.m_topLabel.getPreferredSize().width;
        if (firstLabelWidth < this.m_bottomLabel.getPreferredSize().width) {
            firstLabelWidth = this.m_bottomLabel.getPreferredSize().width;
        }
        if (firstLabelWidth < this.m_headerLabel.getPreferredSize().width) {
            firstLabelWidth = this.m_headerLabel.getPreferredSize().width;
        }
        if (firstLabelWidth < this.m_unitsLabel.getPreferredSize().width) {
            firstLabelWidth = this.m_unitsLabel.getPreferredSize().width;
        }
        if (firstLabelWidth < this.m_footerLabel.getPreferredSize().width) {
            firstLabelWidth = this.m_footerLabel.getPreferredSize().width;
        }
        this.m_topLabel.setPreferredSize(new Dimension(firstLabelWidth += 4, this.m_topLabel.getPreferredSize().height));
        this.m_topLabel.setMinimumSize(this.m_topLabel.getPreferredSize());
        this.m_topLabel.setMaximumSize(this.m_topLabel.getPreferredSize());
        this.m_bottomLabel.setPreferredSize(new Dimension(firstLabelWidth, this.m_bottomLabel.getPreferredSize().height));
        this.m_bottomLabel.setMinimumSize(this.m_bottomLabel.getPreferredSize());
        this.m_bottomLabel.setMaximumSize(this.m_bottomLabel.getPreferredSize());
        this.m_headerLabel.setPreferredSize(new Dimension(firstLabelWidth, this.m_headerLabel.getPreferredSize().height));
        this.m_headerLabel.setMinimumSize(this.m_headerLabel.getPreferredSize());
        this.m_headerLabel.setMaximumSize(this.m_headerLabel.getPreferredSize());
        this.m_unitsLabel.setPreferredSize(new Dimension(firstLabelWidth, this.m_unitsLabel.getPreferredSize().height));
        this.m_unitsLabel.setMinimumSize(this.m_unitsLabel.getPreferredSize());
        this.m_unitsLabel.setMaximumSize(this.m_unitsLabel.getPreferredSize());
        this.m_footerLabel.setPreferredSize(new Dimension(firstLabelWidth, this.m_footerLabel.getPreferredSize().height));
        this.m_footerLabel.setMinimumSize(this.m_footerLabel.getPreferredSize());
        this.m_footerLabel.setMaximumSize(this.m_footerLabel.getPreferredSize());
        int seconeLabelWidth = this.m_leftLabel.getPreferredSize().width;
        if (seconeLabelWidth < this.m_rightLabel.getPreferredSize().width) {
            seconeLabelWidth = this.m_rightLabel.getPreferredSize().width;
        }
        this.m_leftLabel.setPreferredSize(new Dimension(seconeLabelWidth += 4, this.m_leftLabel.getPreferredSize().height));
        this.m_leftLabel.setMinimumSize(this.m_leftLabel.getPreferredSize());
        this.m_leftLabel.setMaximumSize(this.m_leftLabel.getPreferredSize());
        this.m_rightLabel.setPreferredSize(new Dimension(seconeLabelWidth, this.m_rightLabel.getPreferredSize().height));
        this.m_rightLabel.setMinimumSize(this.m_rightLabel.getPreferredSize());
        this.m_rightLabel.setMaximumSize(this.m_rightLabel.getPreferredSize());
        this.m_unitsComboBox.addActionListener(this);
        this.m_topNumericSpinBox.addPropertyChangeListener(this);
        this.m_leftNumericSpinBox.addPropertyChangeListener(this);
        this.m_bottomNumericSpinBox.addPropertyChangeListener(this);
        this.m_rightNumericSpinBox.addPropertyChangeListener(this);
        this.m_headerNumericSpinBox.addPropertyChangeListener(this);
        this.m_footerNumericSpinBox.addPropertyChangeListener(this);
        this._initiate();
    }

    private void _initiate() {
        this.m_footerNumericSpinBox.setModel(new MySecondSpinBoxModel());
        this.m_headerNumericSpinBox.setModel(new MySecondSpinBoxModel());
        this.m_topNumericSpinBox.setModel(new MySecondSpinBoxModel());
        this.m_leftNumericSpinBox.setModel(new MySecondSpinBoxModel());
        this.m_rightNumericSpinBox.setModel(new MySecondSpinBoxModel());
        this.m_bottomNumericSpinBox.setModel(new MySecondSpinBoxModel());
        this.m_headerNumericSpinBox.setValue(this.m_viewPrinter[0].getHeaderMargin());
        this.m_footerNumericSpinBox.setValue(this.m_viewPrinter[0].getFooterMargin());
        this.m_topNumericSpinBox.setValue(this.m_viewPrinter[0].getTopMargin());
        this.m_leftNumericSpinBox.setValue(this.m_viewPrinter[0].getLeftMargin());
        this.m_rightNumericSpinBox.setValue(this.m_viewPrinter[0].getRightMargin());
        this.m_bottomNumericSpinBox.setValue(this.m_viewPrinter[0].getBottomMargin());
        this._header = this.m_viewPrinter[0].getHeaderMargin();
        this._footer = this.m_viewPrinter[0].getFooterMargin();
        this._top = this.m_viewPrinter[0].getTopMargin();
        this._left = this.m_viewPrinter[0].getLeftMargin();
        this._bottom = this.m_viewPrinter[0].getBottomMargin();
        this._right = this.m_viewPrinter[0].getRightMargin();
        this.m_unitsComboBox.setSelectedIndex(this.m_viewPrinter[0].getUnits());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.m_topNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._top = ((Double)this.m_topNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._top = this.getPixels((Double)this.m_topNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._top = this.getPixels(this.getInchesFromCM(((Double)this.m_topNumericSpinBox.getValue()).floatValue()));
                    break;
                }
            }
        } else if (e.getSource() == this.m_leftNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._left = ((Double)this.m_leftNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._left = this.getPixels((Double)this.m_leftNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._left = this.getPixels(this.getInchesFromCM(((Double)this.m_leftNumericSpinBox.getValue()).floatValue()));
                    break;
                }
            }
        } else if (e.getSource() == this.m_rightNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._right = ((Double)this.m_rightNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._right = this.getPixels((Double)this.m_rightNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._right = this.getPixels(this.getInchesFromCM(((Double)this.m_rightNumericSpinBox.getValue()).floatValue()));
                    break;
                }
            }
        } else if (e.getSource() == this.m_bottomNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._bottom = ((Double)this.m_bottomNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._bottom = this.getPixels((Double)this.m_bottomNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._bottom = this.getPixels(this.getInchesFromCM(((Double)this.m_bottomNumericSpinBox.getValue()).floatValue()));
                    break;
                }
            }
        } else if (e.getSource() == this.m_headerNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._header = ((Double)this.m_headerNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._header = this.getPixels((Double)this.m_headerNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._header = this.getPixels(this.getInchesFromCM(((Double)this.m_headerNumericSpinBox.getValue()).floatValue()));
                    break;
                }
            }
        } else if (e.getSource() == this.m_footerNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._footer = ((Double)this.m_footerNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._footer = this.getPixels((Double)this.m_footerNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._footer = this.getPixels(this.getInchesFromCM(((Double)this.m_footerNumericSpinBox.getValue()).floatValue()));
                    break;
                }
            }
        }
    }

    private int getPixels(double inch) {
        double tmp = (double)((int)(inch * 100.0)) / 100.0;
        return (int)(tmp * 72.0 + 0.5);
    }

    private double getInches(float pixel) {
        return (double)pixel / 72.0 + 0.005;
    }

    private double getCM(double inch) {
        double tmp = (double)((int)(inch * 100.0)) / 100.0;
        return tmp * 2.54 + 0.005;
    }

    private double getInchesFromCM(double cm) {
        return cm / 2.54 + 0.005;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        float val = ((Double)this.m_topNumericSpinBox.getValue()).floatValue();
        this.m_topNumericSpinBox.setDecimalSeparator(decimalSeparator);
        this.m_topNumericSpinBox.setValue(val);
        val = ((Double)this.m_leftNumericSpinBox.getValue()).floatValue();
        this.m_leftNumericSpinBox.setDecimalSeparator(decimalSeparator);
        this.m_leftNumericSpinBox.setValue(val);
        val = ((Double)this.m_bottomNumericSpinBox.getValue()).floatValue();
        this.m_bottomNumericSpinBox.setDecimalSeparator(decimalSeparator);
        this.m_bottomNumericSpinBox.setValue(val);
        val = ((Double)this.m_rightNumericSpinBox.getValue()).floatValue();
        this.m_rightNumericSpinBox.setDecimalSeparator(decimalSeparator);
        this.m_rightNumericSpinBox.setValue(val);
        val = ((Double)this.m_headerNumericSpinBox.getValue()).floatValue();
        this.m_headerNumericSpinBox.setDecimalSeparator(decimalSeparator);
        this.m_headerNumericSpinBox.setValue(val);
        val = ((Double)this.m_footerNumericSpinBox.getValue()).floatValue();
        this.m_footerNumericSpinBox.setDecimalSeparator(decimalSeparator);
        this.m_footerNumericSpinBox.setValue(val);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_unitsComboBox && this.m_units != this.m_unitsComboBox.getSelectedIndex()) {
            int oldUnits = this.m_units;
            this._footer = ((Double)this.m_footerNumericSpinBox.getValue()).floatValue();
            this._header = ((Double)this.m_headerNumericSpinBox.getValue()).floatValue();
            this._top = ((Double)this.m_topNumericSpinBox.getValue()).floatValue();
            this._left = ((Double)this.m_leftNumericSpinBox.getValue()).floatValue();
            this._right = ((Double)this.m_rightNumericSpinBox.getValue()).floatValue();
            this._bottom = ((Double)this.m_bottomNumericSpinBox.getValue()).floatValue();
            if (oldUnits == 1) {
                this._footer = this.getPixels(this._footer);
                this._header = this.getPixels(this._header);
                this._top = this.getPixels(this._top);
                this._left = this.getPixels(this._left);
                this._right = this.getPixels(this._right);
                this._bottom = this.getPixels(this._bottom);
            } else if (oldUnits == 2) {
                this._footer = this.getPixels(this.getInchesFromCM(this._footer));
                this._header = this.getPixels(this.getInchesFromCM(this._header));
                this._top = this.getPixels(this.getInchesFromCM(this._top));
                this._left = this.getPixels(this.getInchesFromCM(this._left));
                this._right = this.getPixels(this.getInchesFromCM(this._right));
                this._bottom = this.getPixels(this.getInchesFromCM(this._bottom));
            }
            this.m_units = this.m_unitsComboBox.getSelectedIndex();
            if (this.m_units == 0) {
                this.m_footerNumericSpinBox.setModel(new MySecondSpinBoxModel());
                this.m_headerNumericSpinBox.setModel(new MySecondSpinBoxModel());
                this.m_topNumericSpinBox.setModel(new MySecondSpinBoxModel());
                this.m_leftNumericSpinBox.setModel(new MySecondSpinBoxModel());
                this.m_rightNumericSpinBox.setModel(new MySecondSpinBoxModel());
                this.m_bottomNumericSpinBox.setModel(new MySecondSpinBoxModel());
                this.m_footerNumericSpinBox.setValue(this._footer);
                this.m_headerNumericSpinBox.setValue(this._header);
                this.m_topNumericSpinBox.setValue(this._top);
                this.m_leftNumericSpinBox.setValue(this._left);
                this.m_rightNumericSpinBox.setValue(this._right);
                this.m_bottomNumericSpinBox.setValue(this._bottom);
                this.m_unitsComboBox.requestFocus();
            } else if (this.m_units == 1) {
                this.m_footerNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_headerNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_topNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_leftNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_rightNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_bottomNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_footerNumericSpinBox.setValue((float)this.getInches(this._footer));
                this.m_headerNumericSpinBox.setValue((float)this.getInches(this._header));
                this.m_topNumericSpinBox.setValue((float)this.getInches(this._top));
                this.m_leftNumericSpinBox.setValue((float)this.getInches(this._left));
                this.m_rightNumericSpinBox.setValue((float)this.getInches(this._right));
                this.m_bottomNumericSpinBox.setValue((float)this.getInches(this._bottom));
                this.m_unitsComboBox.requestFocus();
            } else {
                this.m_footerNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_headerNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_topNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_leftNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_rightNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_bottomNumericSpinBox.setModel(new MySpinBoxModel());
                this.m_footerNumericSpinBox.setValue((float)this.getCM(this.getInches(this._footer)));
                this.m_headerNumericSpinBox.setValue((float)this.getCM(this.getInches(this._header)));
                this.m_topNumericSpinBox.setValue((float)this.getCM(this.getInches(this._top)));
                this.m_leftNumericSpinBox.setValue((float)this.getCM(this.getInches(this._left)));
                this.m_rightNumericSpinBox.setValue((float)this.getCM(this.getInches(this._right)));
                this.m_bottomNumericSpinBox.setValue((float)this.getCM(this.getInches(this._bottom)));
                this.m_unitsComboBox.requestFocus();
            }
        }
    }

    public void apply() {
        int oldUnits = this.m_unitsComboBox.getSelectedIndex();
        this._footer = ((Double)this.m_footerNumericSpinBox.getValue()).floatValue();
        this._header = ((Double)this.m_headerNumericSpinBox.getValue()).floatValue();
        this._top = ((Double)this.m_topNumericSpinBox.getValue()).floatValue();
        this._left = ((Double)this.m_leftNumericSpinBox.getValue()).floatValue();
        this._right = ((Double)this.m_rightNumericSpinBox.getValue()).floatValue();
        this._bottom = ((Double)this.m_bottomNumericSpinBox.getValue()).floatValue();
        if (oldUnits == 1) {
            this._footer = this.getPixels(this._footer);
            this._header = this.getPixels(this._header);
            this._top = this.getPixels(this._top);
            this._left = this.getPixels(this._left);
            this._right = this.getPixels(this._right);
            this._bottom = this.getPixels(this._bottom);
        } else if (oldUnits == 2) {
            this._footer = this.getPixels(this.getInchesFromCM(this._footer));
            this._header = this.getPixels(this.getInchesFromCM(this._header));
            this._top = this.getPixels(this.getInchesFromCM(this._top));
            this._left = this.getPixels(this.getInchesFromCM(this._left));
            this._right = this.getPixels(this.getInchesFromCM(this._right));
            this._bottom = this.getPixels(this.getInchesFromCM(this._bottom));
        }
        int i = 0;
        while (i < this.m_viewPrinter.length) {
            this.m_viewPrinter[i].setTopMargin((int)this._top);
            this.m_viewPrinter[i].setLeftMargin((int)this._left);
            this.m_viewPrinter[i].setRightMargin((int)this._right);
            this.m_viewPrinter[i].setBottomMargin((int)this._bottom);
            this.m_viewPrinter[i].setHeaderMargin((int)this._header);
            this.m_viewPrinter[i].setFooterMargin((int)this._footer);
            this.m_viewPrinter[i].setUnits(this.m_units);
            ++i;
        }
        this.setPaperSize();
    }

    public Dimension getPreferredSize() {
        int width = Integer.parseInt(this.rBundle.getString("PageSetupMarginsPanelWidth"));
        int height = Integer.parseInt(this.rBundle.getString("PageSetupMarginsPanelHeight"));
        return new Dimension(width, height);
    }

    public void setViewPrinter(ViewPrinter[] viewPrinter) {
        if (viewPrinter != null) {
            this.m_viewPrinter = viewPrinter;
        }
        this._init();
    }

    public void setFocusComponent() {
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.m_locale = loc;
        this.updateResourceBundle(loc);
        this._init();
    }

    public void setPaperWidth(double width) {
        this.paperWidth = width;
    }

    public double getPaperWidth() {
        return this.paperWidth;
    }

    public void setPaperHeight(double height) {
        this.paperHeight = height;
    }

    public double getPaperHeight() {
        return this.paperHeight;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void cleanUp() {
        super.removeAll();
        this.removeAll();
        this.m_unitsComboBox.removeActionListener(this);
        this.m_topNumericSpinBox.removePropertyChangeListener(this);
        this.m_leftNumericSpinBox.removePropertyChangeListener(this);
        this.m_bottomNumericSpinBox.removePropertyChangeListener(this);
        this.m_rightNumericSpinBox.removePropertyChangeListener(this);
        this.m_headerNumericSpinBox.removePropertyChangeListener(this);
        this.m_footerNumericSpinBox.removePropertyChangeListener(this);
        this.m_topNumericSpinBox.cleanUp();
        this.m_leftNumericSpinBox.cleanUp();
        this.m_bottomNumericSpinBox.cleanUp();
        this.m_rightNumericSpinBox.cleanUp();
        this.m_headerNumericSpinBox.cleanUp();
        this.m_footerNumericSpinBox.cleanUp();
        this.m_topNumericSpinBox = null;
        this.m_leftNumericSpinBox = null;
        this.m_bottomNumericSpinBox = null;
        this.m_rightNumericSpinBox = null;
        this.m_headerNumericSpinBox = null;
        this.m_footerNumericSpinBox = null;
        this.m_viewPrinter = null;
        this.m_marginsPanel.removeAll();
        this.m_marginsPanel = null;
        this.m_marginsLabel = null;
        this.m_centerOnPagePanel = null;
        this.m_centerOnPageLabel = null;
        this.m_unitsComboBox.removeAll();
        this.m_unitsComboBox = null;
        this.m_unitsLabel = null;
        this.m_topLabel = null;
        this.m_leftLabel = null;
        this.m_bottomLabel = null;
        this.m_rightLabel = null;
        this.m_headerLabel = null;
        this.m_footerLabel = null;
        this.m_horizontallyCheckBox = null;
        this.m_verticallyCheckBox = null;
        this.m_leftPanel.removeAll();
        this.m_leftPanel = null;
        this.m_rightPanel.removeAll();
        this.m_rightPanel = null;
        this.m_mainPanel.removeAll();
        this.m_mainPanel = null;
        this.m_previewLabel = null;
        this.m_eh = null;
        this.m_strHelpContextID = null;
        this.rBundle = null;
        this.m_locale = null;
    }

    private void setPaperSize() {
        PageFormat pageFormat = this.m_viewPrinter[0].getPageFormat();
        float width = (float)pageFormat.getPaper().getWidth();
        float height = (float)pageFormat.getPaper().getHeight();
        float topMargin = this.m_viewPrinter[0].getTopMargin();
        float leftMargin = this.m_viewPrinter[0].getLeftMargin();
        float bottomMargin = this.m_viewPrinter[0].getBottomMargin();
        float rightMargin = this.m_viewPrinter[0].getRightMargin();
        Paper paper = new Paper();
        if (pageFormat.getOrientation() == 0) {
            paper.setSize(height, width);
            paper.setImageableArea(topMargin, leftMargin, height - (leftMargin + rightMargin), width - (topMargin + bottomMargin));
        } else {
            paper.setSize(width, height);
            paper.setImageableArea(topMargin, leftMargin, width - (leftMargin + rightMargin), height - (topMargin + bottomMargin));
        }
        pageFormat.setPaper(paper);
    }

    private void $init$() {
        this.m_eh = null;
        this.paperWidth = 8.27;
        this.paperHeight = 11.69;
        this.isVersionSupportOrientation = false;
        this.rBundle = null;
        this.m_locale = Locale.US;
        this.m_units = 0;
        this._top = 0.0f;
        this._left = 0.0f;
        this._bottom = 0.0f;
        this._right = 0.0f;
        this._header = 0.0f;
        this._footer = 0.0f;
        this.m_bSuperCalled = false;
    }

    static Locale ra$m_locale(PageSetupMarginsPanel pageSetupMarginsPanel) {
        return pageSetupMarginsPanel.m_locale;
    }

    class MyNumericSpinBox
    extends SpinBox {
        private MySpinBuddy mySpinBuddy;
        private MySpinBoxModel mySpinBoxModel;

        MyNumericSpinBox(int par1, int par2) {
            this.$init$();
            this.mySpinBuddy = new MySpinBuddy(this);
            this.setSpinBuddy(this.mySpinBuddy);
            this.setModel(this.mySpinBoxModel);
        }

        public void cleanUp() {
            this.mySpinBuddy.removeFocusListener(this.mySpinBuddy);
            this.mySpinBuddy = null;
            this.mySpinBoxModel = null;
        }

        public void setDecimalSeparator(char decimalSeparator) {
            NumberLocaleDocument m_numberLocaleDocument = this.mySpinBuddy.getNumberLocaleDocument();
            m_numberLocaleDocument.setDecimalSeparator(decimalSeparator);
        }

        public Object getValue() {
            if (this.mySpinBoxModel == null) {
                return new Integer(10);
            }
            if (this.getModel() instanceof MySpinBoxModel) {
                return new Double(((MySpinBoxModel)this.getModel()).getValue());
            }
            if (this.getModel() instanceof MySecondSpinBoxModel) {
                return new Double(((MySecondSpinBoxModel)this.getModel()).getValue());
            }
            return new Double(this.mySpinBoxModel.getValue());
        }

        public void setValue(float value) {
            if (this.mySpinBoxModel == null) {
                return;
            }
            if (this.getModel() instanceof MySpinBoxModel) {
                ((MySpinBoxModel)this.getModel()).setValue(value);
            } else if (this.getModel() instanceof MySecondSpinBoxModel) {
                ((MySecondSpinBoxModel)this.getModel()).setValue(value);
            } else {
                this.mySpinBoxModel.setValue(value);
            }
            super.spinButtonSpinning(new SpinButtonEvent((Object)this, 1, 2));
            super.spinButtonSpinning(new SpinButtonEvent((Object)this, 1, 1));
        }

        public void setValue(float value, boolean flag) {
            if (this.mySpinBoxModel == null) {
                return;
            }
            if (this.getModel() instanceof MySpinBoxModel) {
                ((MySpinBoxModel)this.getModel()).setValue(value);
            } else if (this.getModel() instanceof MySecondSpinBoxModel) {
                ((MySecondSpinBoxModel)this.getModel()).setValue(value);
            } else {
                this.mySpinBoxModel.setValue(value);
            }
        }

        public void spinButtonSpinning(SpinButtonEvent event) {
            String str = this.mySpinBuddy.getText();
            if (str.endsWith("\"")) {
                str = str.substring(0, str.length() - 1);
            }
            Float tmpFloat = null;
            try {
                tmpFloat = this.mySpinBuddy.parseAsFloat(str);
            }
            catch (Exception eee) {
                // empty catch block
            }
            if (tmpFloat != null) {
                this.setValue(tmpFloat.floatValue());
            }
            super.spinButtonSpinning(event);
            this.firePropertyChange("change", 0, 1);
        }

        private void $init$() {
            this.mySpinBuddy = null;
            this.mySpinBoxModel = new MySpinBoxModel();
        }
    }

    class MySpinBoxModel
    implements SpinBoxModel {
        float m_value;
        boolean m_forward;

        public final Object nextElement() {
            if (this.m_forward) {
                this.m_value = (float)((double)this.m_value + 0.011);
            } else {
                this.m_value = (float)((double)this.m_value - 0.009);
                if (this.m_value < 0.0f) {
                    this.m_value = 0.0f;
                }
            }
            int tmp = (int)(this.m_value * 100.0f);
            this.m_value = (float)((double)tmp / 100.0);
            return new Float(this.m_value);
        }

        public boolean hasMoreElements() {
            return this.m_forward || this.m_value != 0.0f;
        }

        public void setIteratingForward(boolean forward) {
            this.m_forward = forward;
        }

        public boolean isIteratingForward() {
            return this.m_forward;
        }

        public Object skip(int count) {
            if (this.m_forward) {
                this.m_value = (float)((double)this.m_value + 0.01 * (double)count);
                return new Float(this.m_value);
            }
            this.m_value = (float)((double)this.m_value - 0.01 * (double)count);
            if (this.m_value < 0.0f) {
                this.m_value = 0.0f;
            }
            return new Float(this.m_value);
        }

        public int remainingElements(int desired) {
            return (int)((double)((float)desired - this.m_value) / 0.01);
        }

        public void setValue(float value) {
            this.m_value = value;
        }

        public float getValue() {
            return this.m_value;
        }

        private void $init$() {
            this.m_value = 0.0f;
            this.m_forward = true;
        }

        MySpinBoxModel() {
            this.$init$();
        }
    }

    class MySecondSpinBoxModel
    implements SpinBoxModel {
        int m_value;
        boolean m_forward;

        public final Object nextElement() {
            if (this.m_forward) {
                this.m_value = (int)((double)this.m_value + 1.1);
            } else {
                this.m_value = (int)((double)this.m_value - 0.9);
                if (this.m_value < 0) {
                    this.m_value = 0;
                }
            }
            return new Integer(this.m_value);
        }

        public boolean hasMoreElements() {
            return this.m_forward || this.m_value != 0;
        }

        public void setIteratingForward(boolean forward) {
            this.m_forward = forward;
        }

        public boolean isIteratingForward() {
            return this.m_forward;
        }

        public Object skip(int count) {
            if (this.m_forward) {
                this.m_value += count;
                return new Float(this.m_value);
            }
            this.m_value -= count;
            if (this.m_value < 0) {
                this.m_value = 0;
            }
            return new Float(this.m_value);
        }

        public int remainingElements(int desired) {
            return desired - this.m_value;
        }

        public void setValue(float value) {
            this.m_value = (int)value;
        }

        public float getValue() {
            return this.m_value;
        }

        private void $init$() {
            this.m_value = 0;
            this.m_forward = true;
        }

        MySecondSpinBoxModel() {
            this.$init$();
        }
    }

    class MySpinBuddy
    extends JTextField
    implements SpinBuddy,
    FocusListener {
        int p;
        MyNumericSpinBox m_myNumericSpinBox;
        NumberLocaleDocument m_numberLocaleDocument;

        private void $init$() {
            this.p = 0;
            this.m_myNumericSpinBox = null;
            this.m_numberLocaleDocument = new NumberLocaleDocument(this, PageSetupMarginsPanel.ra$m_locale(PageSetupMarginsPanel.this));
        }

        MySpinBuddy(MyNumericSpinBox myNumericSpinBox) {
            this.$init$();
            this.setBorder(null);
            this.setDocument(this.m_numberLocaleDocument);
            this.m_myNumericSpinBox = myNumericSpinBox;
            this.addFocusListener(this);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (this.getText() == null || this.getText().length() == 0) {
                return;
            }
            try {
                Float num = this.parseAsFloat(this.getText());
                if (num != null) {
                    this.m_myNumericSpinBox.setValue(num.floatValue(), false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void processKeyEvent(KeyEvent e) {
            Float num;
            if (this.m_myNumericSpinBox != PageSetupMarginsPanel.this.m_topNumericSpinBox) {
                if (e.getKeyCode() == 38 && e.getID() == 401) {
                    Float num2 = this.parseAsFloat(this.getText());
                    if (num2 != null) {
                        this.m_myNumericSpinBox.setValue(num2.floatValue(), false);
                    }
                    this.selectAll();
                } else if (e.getKeyCode() == 40 && e.getID() == 401) {
                    Float num3 = this.parseAsFloat(this.getText());
                    if (num3 != null) {
                        this.m_myNumericSpinBox.setValue(num3.floatValue(), false);
                    }
                    this.selectAll();
                }
            }
            if (e.getKeyCode() == 10 && (num = this.parseAsFloat(this.getText())) != null) {
                this.m_myNumericSpinBox.setValue(num.floatValue(), false);
            }
            super.processKeyEvent(e);
        }

        public void setValue(Object val) {
            try {
                this.m_numberLocaleDocument.remove(0, this.m_numberLocaleDocument.getLength());
                this.m_numberLocaleDocument.insertString(val);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected Float parseAsFloat(String text) {
            return this.m_numberLocaleDocument.parseAsFloat(text);
        }

        public NumberLocaleDocument getNumberLocaleDocument() {
            return this.m_numberLocaleDocument;
        }
    }

    class NumberLocaleDocument
    extends PlainDocument {
        private DecimalFormat m_format;
        private char m_decimalSeparator;
        private JTextField m_text;
        private char Minus;
        private char Dec;

        public NumberLocaleDocument(JTextField text, Locale loc) {
            this.m_text = text;
            this.m_format = (DecimalFormat)NumberFormat.getNumberInstance(loc);
            this.Minus = this.m_format.getDecimalFormatSymbols().getMinusSign();
            this.Dec = this.m_format.getDecimalFormatSymbols().getDecimalSeparator();
            this.m_format.setGroupingUsed(false);
        }

        public void setDecimalSeparator(char decimalSeparator) {
            this.m_decimalSeparator = decimalSeparator;
            DecimalFormatSymbols formatSymbols = this.m_format.getDecimalFormatSymbols();
            formatSymbols.setDecimalSeparator(this.m_decimalSeparator);
            this.m_format.setDecimalFormatSymbols(formatSymbols);
        }

        protected void insertString(Object value) throws BadLocationException {
            String valString = null;
            if (value instanceof Double) {
                double dVal = (Double)value;
                valString = this.m_format.format(dVal);
            } else if (value instanceof Float) {
                double dVal = ((Float)value).doubleValue();
                valString = this.m_format.format(dVal);
            } else {
                valString = value.toString();
            }
            this.insertString(0, valString, null);
        }

        protected Float parseAsFloat(String text) {
            Number num;
            block3: {
                num = null;
                try {
                    num = this.m_format.parse(text);
                }
                catch (ParseException pe) {
                    if (PageSetupMarginsPanel.this.m_eh == null) break block3;
                    PageSetupMarginsPanel.this.m_eh.log("ParseException while parsing String as Number", this.getClass().getName(), "Float parseAsFloat(String text)");
                }
            }
            if (num != null) {
                return new Float(num.floatValue());
            }
            return null;
        }

        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            try {
                StringBuffer oldText = new StringBuffer(this.m_text.getText());
                if (str.charAt(0) == this.Dec && this.m_decimalSeparator != this.Dec) {
                    return;
                }
                oldText.insert(offset, str);
                ParsePosition pos = new ParsePosition(0);
                Number result = this.m_format.parse(oldText.toString(), pos);
                String decSep = new Character(this.Dec).toString();
                if (pos.getIndex() != oldText.length()) {
                    if (pos.getIndex() == oldText.length() - 1 && str.equals(decSep) && this.m_text.getText().indexOf(this.Dec) == -1) {
                        super.insertString(offset, str, a);
                    }
                    return;
                }
                super.insertString(offset, str, a);
            }
            catch (Exception eNumber) {
                return;
            }
        }
    }
}

