/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBox;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.spinBox.SpinButtonEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.util.ErrorHandler;

public class PageSetupSheetPanel
extends JPanel
implements ActionListener {
    protected UIViewPrinter[] m_viewPrinter;
    protected JPanel m_pageOrderPanel;
    protected JLabel m_pageOrderLabel;
    protected JPanel m_mainPanel;
    protected JCheckBox m_repeatHeaderCheckBox;
    protected JCheckBox m_repeatTitleCheckBox;
    protected JRadioButton m_downRadionButton;
    protected JRadioButton m_acrossRadionButton;
    protected JLabel m_downLabel;
    protected JLabel m_acrossLabel;
    protected JPanel m_scalePanel;
    protected JLabel m_scaleLabel;
    protected JRadioButton m_actualSizeRadioButton;
    protected JRadioButton m_graphFitToRadioButton;
    protected JCheckBox m_pRatioCheckBox;
    protected JCheckBox m_pFontSizeCheckBox;
    protected JRadioButton m_zoomRadioButton;
    protected JRadioButton m_fullFitRadioButton;
    protected MyNumericSpinBox m_zoomNumericSpinBox;
    protected JLabel m_zoomLabel;
    protected NumericSpinBox m_widthNumericSpinBox;
    protected JLabel m_widthLabel;
    protected NumericSpinBox m_heightNumericSpinBox;
    protected JLabel m_heightLabel;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh;
    protected String m_strHelpContextID;
    private ResourceBundle rBundle;
    private boolean m_bSuperCalled;
    private int m_viewType;

    public PageSetupSheetPanel(ViewPrinter[] viewPrinter) {
        this((UIViewPrinter[])viewPrinter);
    }

    public PageSetupSheetPanel(UIViewPrinter[] viewPrinter) {
        this.$init$();
        this.m_bSuperCalled = true;
        if (viewPrinter == null) {
            return;
        }
        this.m_viewPrinter = viewPrinter;
        this.updateResourceBundle(this.m_viewPrinter[0].getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.m_viewType = viewPrinter[0].getViewPrinterType();
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.m_mainPanel);
        this._init();
    }

    private void _init() {
        this.m_mainPanel.removeAll();
        if (this.m_viewType != 2) {
            this.m_pageOrderPanel = new JPanel();
            this.m_pageOrderPanel.setAlignmentX(0.0f);
            this.m_pageOrderPanel.setLayout(new BoxLayout(this.m_pageOrderPanel, 1));
            String translatedText = this.m_viewType == 0 ? this.rBundle.getString("Crosstab Page Order") : this.rBundle.getString("Table Page Order");
            this.m_pageOrderLabel = new JLabel(translatedText);
            this.m_pageOrderLabel.setAlignmentX(0.0f);
            this.m_pageOrderLabel.setMinimumSize(this.m_pageOrderLabel.getPreferredSize());
            this.m_pageOrderLabel.setMaximumSize(this.m_pageOrderLabel.getPreferredSize());
            this.m_pageOrderPanel.add(this.m_pageOrderLabel);
            JPanel tmpPanel = new JPanel();
            tmpPanel.setAlignmentX(0.0f);
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            translatedText = this.rBundle.getString("Across, then Down");
            this.m_acrossRadionButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_acrossRadionButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_acrossRadionButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("AcrossThenDownADA"));
            this.m_acrossRadionButton.setAlignmentX(0.0f);
            this.m_acrossLabel = new JLabel();
            this.m_acrossLabel.setAlignmentX(0.0f);
            this.m_acrossLabel.setIcon(new ImageIcon(ImageUtils.getImageResource(PageSetupSheetPanel.class, (String)"images/across_down.gif")));
            tmpPanel.add(this.m_acrossRadionButton);
            tmpPanel.add(this.m_acrossLabel);
            tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
            tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
            this.m_pageOrderPanel.add(tmpPanel);
            tmpPanel = new JPanel();
            tmpPanel.setAlignmentX(0.0f);
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            translatedText = this.rBundle.getString("Down, then Across");
            this.m_downRadionButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_downRadionButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_downRadionButton.setAlignmentX(0.0f);
            this.m_downRadionButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("DownThenAcrossADA"));
            this.m_downLabel = new JLabel();
            this.m_downLabel.setAlignmentX(0.0f);
            this.m_downLabel.setIcon(new ImageIcon(ImageUtils.getImageResource(PageSetupSheetPanel.class, (String)"images/down_across.gif")));
            tmpPanel.add(this.m_downRadionButton);
            tmpPanel.add(this.m_downLabel);
            tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
            tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
            this.m_pageOrderPanel.add(tmpPanel);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_downRadionButton);
            buttonGroup.add(this.m_acrossRadionButton);
            tmpPanel = new JPanel();
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 1));
            translatedText = this.rBundle.getString("Repeat headers on every page");
            this.m_repeatHeaderCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
            this.m_repeatHeaderCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_repeatHeaderCheckBox.addActionListener(this);
            this.m_repeatHeaderCheckBox.setAlignmentX(0.0f);
            tmpPanel.add(this.m_repeatHeaderCheckBox);
            translatedText = this.m_viewType == 0 ? this.rBundle.getString("Repeat crosstab title on every page") : this.rBundle.getString("Repeat table title on every page");
            this.m_repeatTitleCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
            this.m_repeatTitleCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_repeatTitleCheckBox.addActionListener(this);
            this.m_repeatTitleCheckBox.setAlignmentX(0.0f);
            tmpPanel.add(this.m_repeatTitleCheckBox);
            tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
            tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
            this.m_pageOrderPanel.add(tmpPanel);
            this.m_pageOrderPanel.setMinimumSize(this.m_pageOrderPanel.getPreferredSize());
            this.m_pageOrderPanel.setMaximumSize(this.m_pageOrderPanel.getPreferredSize());
            this.m_mainPanel.add(this.m_pageOrderPanel);
            this.m_mainPanel.add(Box.createVerticalStrut(15));
            this.m_scalePanel = new JPanel();
            this.m_scalePanel.setAlignmentX(0.0f);
            this.m_scalePanel.setLayout(new BoxLayout(this.m_scalePanel, 1));
            translatedText = this.m_viewType == 0 ? this.rBundle.getString("Crosstab Scaling") : this.rBundle.getString("Table Scaling");
            this.m_scaleLabel = new JLabel(translatedText);
            this.m_scaleLabel.setAlignmentX(0.0f);
            this.m_scaleLabel.setMinimumSize(this.m_scaleLabel.getPreferredSize());
            this.m_scaleLabel.setMaximumSize(this.m_scaleLabel.getPreferredSize());
            this.m_scalePanel.add(this.m_scaleLabel);
            this.m_scalePanel.add(Box.createVerticalStrut(5));
            tmpPanel = new JPanel();
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            tmpPanel.setAlignmentX(0.0f);
            translatedText = this.rBundle.getString("Adjust to");
            this.m_zoomRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_zoomRadioButton.setMinimumSize(this.m_zoomRadioButton.getPreferredSize());
            this.m_zoomRadioButton.setMaximumSize(this.m_zoomRadioButton.getPreferredSize());
            this.m_zoomRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_zoomRadioButton.setSelected(true);
            this.m_zoomRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("AdjustToADA"));
            this.m_zoomNumericSpinBox = new MyNumericSpinBox(1, 9999);
            this.m_zoomNumericSpinBox.setPreferredSize(new Dimension(50, 22));
            this.m_zoomNumericSpinBox.setMinimumSize(this.m_zoomNumericSpinBox.getPreferredSize());
            this.m_zoomNumericSpinBox.setMaximumSize(this.m_zoomNumericSpinBox.getPreferredSize());
            this.m_zoomNumericSpinBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("AdjustToADA"));
            tmpPanel.add(this.m_zoomRadioButton);
            tmpPanel.add((Component)((Object)this.m_zoomNumericSpinBox));
            this.m_scalePanel.add(tmpPanel);
            translatedText = this.rBundle.getString("Fit to");
            this.m_fullFitRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_fullFitRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_fullFitRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("Fit to"));
            this.m_fullFitRadioButton.setMinimumSize(this.m_fullFitRadioButton.getPreferredSize());
            this.m_fullFitRadioButton.setMaximumSize(this.m_fullFitRadioButton.getPreferredSize());
            this.m_scalePanel.add(this.m_fullFitRadioButton);
            tmpPanel = new JPanel();
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            tmpPanel.setAlignmentX(0.0f);
            this.m_widthNumericSpinBox = new NumericSpinBox(1, 9999);
            this.m_widthNumericSpinBox.setPreferredSize(new Dimension(50, 22));
            this.m_widthNumericSpinBox.setMinimumSize(this.m_widthNumericSpinBox.getPreferredSize());
            this.m_widthNumericSpinBox.setMaximumSize(this.m_widthNumericSpinBox.getPreferredSize());
            this.m_widthNumericSpinBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("FitToPagesWideADA"));
            translatedText = this.rBundle.getString("Pages Wide");
            this.m_widthLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
            this.m_widthLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_widthLabel.setAlignmentX(0.0f);
            tmpPanel.add(Box.createHorizontalStrut(20));
            tmpPanel.add(this.m_widthLabel);
            tmpPanel.add((Component)this.m_widthNumericSpinBox);
            this.m_scalePanel.add(tmpPanel);
            this.m_scalePanel.add(Box.createVerticalStrut(3));
            tmpPanel = new JPanel();
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            tmpPanel.setAlignmentX(0.0f);
            translatedText = this.rBundle.getString("Pages Tall");
            this.m_heightLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
            this.m_heightLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_heightLabel.setAlignmentX(0.0f);
            this.m_heightNumericSpinBox = new NumericSpinBox(1, 9999);
            this.m_heightNumericSpinBox.setPreferredSize(new Dimension(50, 22));
            this.m_heightNumericSpinBox.setMinimumSize(this.m_heightNumericSpinBox.getPreferredSize());
            this.m_heightNumericSpinBox.setMaximumSize(this.m_heightNumericSpinBox.getPreferredSize());
            this.m_heightLabel.setLabelFor((Component)this.m_heightNumericSpinBox);
            this.m_heightNumericSpinBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("ByPagesTallADA"));
            tmpPanel.add(Box.createHorizontalStrut(20));
            tmpPanel.add(this.m_heightLabel);
            tmpPanel.add((Component)this.m_heightNumericSpinBox);
            this.m_scalePanel.add(tmpPanel);
            int width = Math.max(this.getToolkit().getFontMetrics(this.m_widthLabel.getFont()).stringWidth(this.m_widthLabel.getText()), this.getToolkit().getFontMetrics(this.m_heightLabel.getFont()).stringWidth(this.m_heightLabel.getText()));
            this.m_widthLabel.setPreferredSize(new Dimension(width, this.m_widthLabel.getPreferredSize().height));
            this.m_widthLabel.setMinimumSize(this.m_widthLabel.getPreferredSize());
            this.m_widthLabel.setMaximumSize(this.m_widthLabel.getPreferredSize());
            this.m_heightLabel.setPreferredSize(new Dimension(width, this.m_heightLabel.getPreferredSize().height));
            this.m_heightLabel.setMinimumSize(this.m_heightLabel.getPreferredSize());
            this.m_heightLabel.setMaximumSize(this.m_heightLabel.getPreferredSize());
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2.add(this.m_zoomRadioButton);
            buttonGroup2.add(this.m_fullFitRadioButton);
            this.m_scalePanel.setMinimumSize(this.m_scalePanel.getPreferredSize());
            this.m_scalePanel.setMaximumSize(this.m_scalePanel.getPreferredSize());
            this.m_mainPanel.add(this.m_scalePanel);
            this.m_zoomRadioButton.addActionListener(this);
            this.m_fullFitRadioButton.addActionListener(this);
        } else {
            String translatedText = this.rBundle.getString("Graph Scaling");
            this.m_scaleLabel = new JLabel(translatedText);
            this.m_scaleLabel.setAlignmentX(0.0f);
            this.m_scaleLabel.setMinimumSize(this.m_scaleLabel.getPreferredSize());
            this.m_scaleLabel.setMaximumSize(this.m_scaleLabel.getPreferredSize());
            this.m_mainPanel.add(this.m_scaleLabel);
            translatedText = this.rBundle.getString("Actual size(100%)");
            this.m_actualSizeRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_actualSizeRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_actualSizeRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("ActualSizeADA"));
            this.m_actualSizeRadioButton.setAlignmentX(0.0f);
            this.m_mainPanel.add(this.m_actualSizeRadioButton);
            translatedText = this.rBundle.getString("Fit to page");
            this.m_graphFitToRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_graphFitToRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_graphFitToRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("FitToPageADA"));
            this.m_graphFitToRadioButton.setAlignmentX(0.0f);
            this.m_mainPanel.add(this.m_graphFitToRadioButton);
            ButtonGroup buttonGroup1 = new ButtonGroup();
            buttonGroup1.add(this.m_actualSizeRadioButton);
            buttonGroup1.add(this.m_graphFitToRadioButton);
            JPanel tmpPanel = new JPanel();
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            tmpPanel.setAlignmentX(0.0f);
            translatedText = this.rBundle.getString("Preserve the ratio of height and width");
            this.m_pRatioCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
            this.m_pRatioCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_pRatioCheckBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("PreserveTheRatioADA"));
            this.m_pRatioCheckBox.setAlignmentX(0.0f);
            tmpPanel.add(Box.createHorizontalStrut(25));
            tmpPanel.add(this.m_pRatioCheckBox);
            this.m_mainPanel.add(tmpPanel);
            tmpPanel = new JPanel();
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            tmpPanel.setAlignmentX(0.0f);
            translatedText = this.rBundle.getString("Preserve the actual font size");
            this.m_pFontSizeCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
            this.m_pFontSizeCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_pFontSizeCheckBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("PreserveTheActualADA"));
            this.m_pFontSizeCheckBox.setAlignmentX(0.0f);
            tmpPanel.add(Box.createHorizontalStrut(25));
            tmpPanel.add(this.m_pFontSizeCheckBox);
            this.m_mainPanel.add(tmpPanel);
            this.m_mainPanel.setMinimumSize(this.m_mainPanel.getPreferredSize());
            this.m_mainPanel.setMaximumSize(this.m_mainPanel.getPreferredSize());
            this.m_graphFitToRadioButton.addActionListener(this);
            this.m_actualSizeRadioButton.addActionListener(this);
        }
        this.setAlignmentX(0.0f);
        this.m_mainPanel.setAlignmentX(0.0f);
        this._initiate();
    }

    private void _initiate() {
        if (this.m_viewType != 2) {
            if (this.m_viewPrinter[0].isPrintByColumns()) {
                this.m_acrossRadionButton.setSelected(true);
            } else {
                this.m_downRadionButton.setSelected(true);
            }
            if (this.m_viewPrinter[0].isRepeatComponent(1)) {
                this.m_repeatHeaderCheckBox.setSelected(true);
            } else {
                this.m_repeatHeaderCheckBox.setSelected(false);
            }
            if (this.m_viewPrinter[0].isDataviewTitleVisible() && this.m_viewPrinter[0].isRepeatComponent(8) || this.m_viewPrinter[0].isDataviewSubtitleVisible() && this.m_viewPrinter[0].isRepeatComponent(16) || this.m_viewPrinter[0].isDataviewFootnoteVisible() && this.m_viewPrinter[0].isRepeatComponent(32) || this.m_viewPrinter[0].isRepeatComponent(8)) {
                this.m_repeatTitleCheckBox.setSelected(true);
            } else {
                this.m_repeatTitleCheckBox.setSelected(false);
            }
            this.m_zoomNumericSpinBox.setIntValue(this.m_viewPrinter[0].getPrintZoomFactor());
            if (this.m_viewPrinter[0].getFitToNumPagesTall() > 0) {
                this.m_heightNumericSpinBox.setIntValue(this.m_viewPrinter[0].getFitToNumPagesTall());
            } else {
                this.m_heightNumericSpinBox.setIntValue(1);
            }
            if (this.m_viewPrinter[0].getFitToNumPagesWide() > 0) {
                this.m_widthNumericSpinBox.setIntValue(this.m_viewPrinter[0].getFitToNumPagesWide());
            } else {
                this.m_widthNumericSpinBox.setIntValue(1);
            }
            switch (this.m_viewPrinter[0].getGridViewPrintScaleType()) {
                case 0: {
                    this.m_zoomRadioButton.setSelected(true);
                    this.m_zoomNumericSpinBox.setEnabled(true);
                    this.m_zoomNumericSpinBox.setIntValue(100);
                    this.m_fullFitRadioButton.setSelected(false);
                    break;
                }
                case 2: {
                    this.m_fullFitRadioButton.setSelected(true);
                    this.m_widthNumericSpinBox.setEnabled(true);
                    this.m_heightNumericSpinBox.setEnabled(true);
                    break;
                }
                case 1: {
                    this.m_zoomRadioButton.setSelected(true);
                    this.m_zoomNumericSpinBox.setEnabled(true);
                    break;
                }
            }
        } else {
            switch (this.m_viewPrinter[0].getGraphPrintScaleType()) {
                case 0: {
                    this.m_actualSizeRadioButton.setSelected(true);
                    this.m_graphFitToRadioButton.setSelected(false);
                    this.m_pRatioCheckBox.setEnabled(false);
                    this.m_pFontSizeCheckBox.setEnabled(false);
                    break;
                }
                case 3: {
                    this.m_graphFitToRadioButton.setSelected(true);
                    break;
                }
                case 4: {
                    this.m_graphFitToRadioButton.setSelected(true);
                    this.m_pRatioCheckBox.setSelected(true);
                    this.m_pRatioCheckBox.setEnabled(true);
                    this.m_pFontSizeCheckBox.setEnabled(true);
                    break;
                }
            }
            if (this.m_viewPrinter[0].getScaleFontSize() == -1) {
                this.m_pFontSizeCheckBox.setSelected(true);
            } else {
                this.m_pFontSizeCheckBox.setSelected(false);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_zoomRadioButton) {
            if (this.m_zoomRadioButton.isSelected()) {
                this.m_zoomNumericSpinBox.setEnabled(true);
                this.m_widthNumericSpinBox.setEnabled(false);
                this.m_heightNumericSpinBox.setEnabled(false);
            }
        } else if (e.getSource() == this.m_fullFitRadioButton) {
            if (this.m_fullFitRadioButton.isSelected()) {
                this.m_widthNumericSpinBox.setEnabled(true);
                this.m_heightNumericSpinBox.setEnabled(true);
                this.m_zoomNumericSpinBox.setEnabled(false);
            }
        } else if (e.getSource() == this.m_graphFitToRadioButton) {
            this.m_pRatioCheckBox.setEnabled(this.m_graphFitToRadioButton.isSelected());
            this.m_pFontSizeCheckBox.setEnabled(this.m_graphFitToRadioButton.isSelected());
        } else if (e.getSource() == this.m_actualSizeRadioButton) {
            this.m_pRatioCheckBox.setEnabled(this.m_actualSizeRadioButton.isSelected() ^ true);
            this.m_pFontSizeCheckBox.setEnabled(this.m_actualSizeRadioButton.isSelected() ^ true);
        }
    }

    public void apply() {
        int i = 0;
        while (i < this.m_viewPrinter.length) {
            this.m_viewPrinter[i].setPrintByColumns(this.m_acrossRadionButton.isSelected());
            if (this.m_viewType == 2) {
                if (this.m_actualSizeRadioButton.isSelected()) {
                    this.m_viewPrinter[i].setGraphPrintScaleType(0);
                } else if (this.m_graphFitToRadioButton.isSelected()) {
                    if (this.m_pRatioCheckBox.isSelected()) {
                        this.m_viewPrinter[i].setGraphPrintScaleType(4);
                    } else {
                        this.m_viewPrinter[i].setGraphPrintScaleType(3);
                    }
                }
            } else {
                this.m_viewPrinter[i].setRepeatComponent(1, this.m_repeatHeaderCheckBox.isSelected());
                this.m_viewPrinter[i].setRepeatComponent(2, this.m_repeatHeaderCheckBox.isSelected());
                this.m_viewPrinter[i].setRepeatComponent(4, this.m_repeatHeaderCheckBox.isSelected());
                this.m_viewPrinter[i].setRepeatComponent(8, this.m_repeatTitleCheckBox.isSelected());
                this.m_viewPrinter[i].setRepeatComponent(16, this.m_repeatTitleCheckBox.isSelected());
                this.m_viewPrinter[i].setRepeatComponent(32, this.m_repeatTitleCheckBox.isSelected());
                if (this.m_zoomRadioButton.isSelected()) {
                    if (this.m_zoomNumericSpinBox.getIntValue() == 100) {
                        this.m_viewPrinter[i].setGridViewPrintScaleType(0);
                    } else {
                        this.m_viewPrinter[i].setGridViewPrintScaleType(1);
                        int pzf = this.m_zoomNumericSpinBox.getIntValue();
                        if (pzf < 10) {
                            pzf = 10;
                        }
                        this.m_viewPrinter[i].setPrintZoomFactor(pzf);
                    }
                } else if (this.m_fullFitRadioButton.isSelected()) {
                    this.m_viewPrinter[i].setGridViewPrintScaleType(2);
                    this.m_viewPrinter[i].setFitToNumPagesTall(this.m_heightNumericSpinBox.getIntValue());
                    this.m_viewPrinter[i].setFitToNumPagesWide(this.m_widthNumericSpinBox.getIntValue());
                }
            }
            ++i;
        }
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public void setViewPrinter(ViewPrinter[] viewPrinter) {
        if (viewPrinter != null) {
            this.m_viewPrinter = viewPrinter;
        }
        this._init();
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this._init();
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    private void $init$() {
        this.m_eh = null;
        this.rBundle = null;
        this.m_bSuperCalled = false;
    }

    class MyNumericSpinBox
    extends SpinBox {
        private MySpinBuddy mySpinBuddy;
        private MySpinBoxModel mySpinBoxModel;

        MyNumericSpinBox(int par1, int par2) {
            this.$init$();
            this.mySpinBuddy = new MySpinBuddy(this);
            this.setSpinBuddy(this.mySpinBuddy);
            this.setModel(this.mySpinBoxModel);
        }

        public int getIntValue() {
            String str = this.mySpinBuddy.getText();
            if (str.endsWith("%")) {
                str = str.substring(0, str.length() - 1);
            }
            return new Integer(str);
        }

        public void setIntValue(int value) {
            if (this.mySpinBoxModel == null) {
                return;
            }
            if (this.getModel() instanceof MySpinBoxModel) {
                ((MySpinBoxModel)this.getModel()).setValue(value);
            } else {
                this.mySpinBoxModel.setValue(value);
            }
            super.spinButtonSpinning(new SpinButtonEvent((Object)this, 1, 2));
            super.spinButtonSpinning(new SpinButtonEvent((Object)this, 1, 1));
        }

        public void spinButtonSpinning(SpinButtonEvent event) {
            String str = this.mySpinBuddy.getText();
            if (str.endsWith("%")) {
                str = str.substring(0, str.length() - 1);
            }
            Integer tmpFloat = null;
            try {
                tmpFloat = new Integer(str);
            }
            catch (Exception eee) {
                // empty catch block
            }
            if (tmpFloat != null) {
                this.setIntValue(tmpFloat);
            }
            super.spinButtonSpinning(event);
        }

        private void $init$() {
            this.mySpinBuddy = null;
            this.mySpinBoxModel = new MySpinBoxModel();
        }
    }

    class MySpinBoxModel
    implements SpinBoxModel {
        int m_value;
        boolean m_forward;

        public final Object nextElement() {
            if (this.m_forward) {
                ++this.m_value;
                if (this.m_value > 999) {
                    this.m_value = 999;
                }
            } else {
                --this.m_value;
                if (this.m_value < 0) {
                    this.m_value = 0;
                }
            }
            return new Integer(this.m_value);
        }

        public boolean hasMoreElements() {
            return this.m_forward || this.m_value != 10;
        }

        public void setIteratingForward(boolean forward) {
            this.m_forward = forward;
        }

        public boolean isIteratingForward() {
            return this.m_forward;
        }

        public Object skip(int count) {
            if (this.m_forward) {
                this.m_value += 1 * count;
                return new Integer(this.m_value);
            }
            this.m_value -= 1 * count;
            if (this.m_value < 0) {
                this.m_value = 0;
            }
            return new Integer(this.m_value);
        }

        public int remainingElements(int desired) {
            return desired - this.m_value;
        }

        public void setValue(int value) {
            this.m_value = value;
        }

        public int getValue() {
            return this.m_value;
        }

        private void $init$() {
            this.m_value = 0;
            this.m_forward = true;
        }

        MySpinBoxModel() {
            this.$init$();
        }
    }

    class MySpinBuddy
    extends JTextField
    implements SpinBuddy {
        int p;
        MyNumericSpinBox m_myNumericSpinBox;
        NumberLocaleDocument m_numberLocaleDocument;

        private void $init$() {
            this.p = 0;
            this.m_myNumericSpinBox = null;
            this.m_numberLocaleDocument = new NumberLocaleDocument(this, Locale.getDefault());
        }

        MySpinBuddy(MyNumericSpinBox myNumericSpinBox) {
            this.$init$();
            this.setBorder(null);
            this.setDocument(this.m_numberLocaleDocument);
            this.m_myNumericSpinBox = myNumericSpinBox;
            this.addKeyListener(new 1());
        }

        public void setValue(Object val) {
            try {
                this.m_numberLocaleDocument.remove(0, this.m_numberLocaleDocument.getLength());
                this.m_numberLocaleDocument.insertString(0, val.toString(), null);
                this.m_numberLocaleDocument.insertString(this.m_numberLocaleDocument.getLength(), "%", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        final class 1
        extends KeyAdapter {
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    try {
                        MySpinBuddy.this.m_numberLocaleDocument.insertString(MySpinBuddy.this.m_numberLocaleDocument.getLength(), "%", null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class NumberLocaleDocument
    extends PlainDocument {
        private DecimalFormat m_format;
        private JTextField m_text;
        private char Minus;
        private char Dec;

        public NumberLocaleDocument(JTextField text, Locale loc) {
            this.m_text = text;
            this.m_format = (DecimalFormat)NumberFormat.getNumberInstance(loc);
            this.Minus = this.m_format.getDecimalFormatSymbols().getMinusSign();
            this.Dec = this.m_format.getDecimalFormatSymbols().getDecimalSeparator();
            this.m_format.setGroupingUsed(false);
        }

        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            try {
                StringBuffer oldText = new StringBuffer(this.m_text.getText());
                if (oldText.length() == 4) {
                    return;
                }
                if (oldText.length() == 3 && !str.equals("%")) {
                    return;
                }
                if (this.m_text.getText().endsWith("%")) {
                    oldText = new StringBuffer(this.m_text.getText().substring(0, this.m_text.getText().length() - 1));
                }
                if (!this.m_text.getText().endsWith("%") && str.equals("%")) {
                    super.insertString(offset, str, a);
                    return;
                }
                oldText.insert(offset, str);
                ParsePosition pos = new ParsePosition(0);
                Number result = this.m_format.parse(oldText.toString(), pos);
                if (pos.getIndex() != oldText.length() || str.equals(".") || str.equals("-")) {
                    return;
                }
                super.insertString(offset, str, a);
            }
            catch (Exception eNumber) {
                return;
            }
        }
    }
}

