/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.DefaultDialog;
import oracle.dss.dataView.gui.PageSetupDialog;
import oracle.dss.dataView.gui.PreviewDialog;
import oracle.dss.dataView.gui.PrintDialogsAdapter;
import oracle.dss.dataView.gui.PrintDialogsProvider;
import oracle.dss.dataView.gui.PrintPanel;
import oracle.dss.util.help.HelpContext;

public class PrintDialog
extends DefaultDialog
implements HelpContext {
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    protected boolean m_sysPrintDialog;
    protected HelpProvider m_helpProvider;
    private PrinterJob m_printerJob;
    private ViewPrinter _printer;
    private Frame _frame;
    private PrintDialogsAdapter m_adapter;
    private PageSetupDialog pageSetup;
    private PrintPanel m_printPanel;
    private Locale m_locale;
    ResourceBundle dvStrings;

    public PrintDialog(Frame dialogFrame, ViewPrinter printer) {
        super(dialogFrame, true, printer.getDataview().getLocale());
        this.$init$();
        this.constructPanel(printer);
        this.m_printerJob = PrinterJob.getPrinterJob();
        if (this._printer.getPageFormat() == null) {
            this._printer.setPageFormat(this.m_printerJob.defaultPage());
        }
        this.m_adapter = new PrintDialogsAdapter(printer, this, this.m_printerJob);
    }

    public PrintDialog(Frame dialogFrame, ViewPrinter printer, PrinterJob job) {
        super(dialogFrame, true, printer.getDataview().getLocale());
        this.$init$();
        this.m_printerJob = job;
        this.constructPanel(printer);
        this.m_adapter = new PrintDialogsAdapter(printer, this, job);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.previewButton)) {
            if (this.m_printPanel.apply()) {
                Frame frame = WindowUtils.parentFrame((Component)this);
                ViewPrinter[] vp = new ViewPrinter[]{this._printer};
                PreviewDialog dialog = new PreviewDialog(frame, this.getIntlString("Print Preview"), vp, (PrintDialogsProvider)this.m_adapter);
                dialog.setHelpProvider(this.getHelpProvider());
                dialog.setVisible(true);
            }
            return;
        }
        if (e.getSource().equals(this.helpButton)) {
            if (this.getHelpProvider() == null) {
                return;
            }
            try {
                if (this.getHelpProvider() != null) {
                    this.getHelpProvider().showHelp((Component)this);
                }
            }
            catch (HelpUnavailableException e1) {}
        } else {
            if (e.getSource().equals(this.okButton)) {
                if (!this.m_printPanel.apply()) {
                    return;
                }
                if (this.m_sysPrintDialog && !this.m_printerJob.printDialog()) {
                    return;
                }
                if (this._printer.startPrint(false)) {
                    try {
                        try {
                            this.m_printerJob.setPrintable(this._printer, this._printer.getPageFormat());
                            this.m_printerJob.print();
                        }
                        catch (PrinterException pe) {
                            this._printer.getDataview().getErrorHandler().log("java.awt.print.PrinterException", this.getClass().getName(), "actionPerformed(ActionEvent e)");
                        }
                    }
                    finally {
                        this.setVisible(false);
                        this._printer.endPrint();
                    }
                } else {
                    this.setVisible(false);
                }
                return;
            }
            if (e.getSource().equals(this.cancelButton)) {
                // empty if block
            }
        }
        super.actionPerformed(e);
    }

    public String getIntlString(String key) {
        return this.getIntlString(key, this.dvStrings);
    }

    public String getIntlString(String key, ResourceBundle rBundle) {
        String strTemp;
        if (rBundle == null) {
            return key;
        }
        try {
            strTemp = rBundle.getString(key);
        }
        catch (MissingResourceException e) {
            String string = key;
            return string;
        }
        return strTemp;
    }

    public void setLocale(Locale loc) {
        this.m_locale = loc;
        super.setLocale(this.m_locale);
        this.updateResourceBundle(loc);
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        if (this.m_adapter != null) {
            this.m_adapter.setHelpProvider(this.m_helpProvider);
        }
        if (this.m_printPanel != null) {
            this.m_printPanel.setHelpProvider(this.m_helpProvider);
        }
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setSystemPrintDialogDisplayed(boolean display) {
        this.m_sysPrintDialog = display;
    }

    public boolean isSystemPrintDialogDisplayed() {
        return this.m_sysPrintDialog;
    }

    protected void updateResourceBundle(Locale loc) {
        try {
            this.dvStrings = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
        }
        catch (MissingResourceException e) {
            this.dvStrings = null;
        }
    }

    private void constructPanel(ViewPrinter printer) {
        this.addComponentListener(new 1());
        this._printer = printer;
        this.updateResourceBundle(printer.getDataview().getLocale());
        this.setTitle(this.getIntlString("title"));
        this.setResizable(true);
        this.m_printPanel = new PrintPanel(printer);
        this.m_printPanel.setPrintDialog(this);
        this.m_printPanel.setPrinterJob(this.m_printerJob);
        GrayPane gp = new GrayPane((Component)this.m_printPanel);
        this.getContentPane().add((Component)gp, "Center");
        this.pack();
        WindowUtils.centerWindow((Window)this, (Component)WindowUtils.parentFrame((Component)printer.getDataview()));
    }

    private void $init$() {
        this.m_sysPrintDialog = true;
        this.m_printerJob = null;
        this._printer = null;
        this._frame = null;
        this.m_adapter = null;
        this.pageSetup = null;
        this.m_printPanel = null;
        this.m_locale = null;
        this.dvStrings = null;
    }

    final class 1
    extends ComponentAdapter {
        public void componentShown(ComponentEvent e) {
            PrintDialog.this.cancelButton.transferFocus();
        }
    }
}

